/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_StateTest_part2
extends ReplicationRun {
    public ReplicationRun_Local_StateTest_part2(String testcaseName) {
        super(testcaseName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_StateTest_part2 Suite");
        suite.addTestSuite(ReplicationRun_Local_StateTest_part2.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_StateTest_part2() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        Connection mConn = this.getConnection(masterServerHost, masterServerPort, masterDatabasePath, masterDbSubPath, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this._testPreStoppedSlave(mConn);
        this.shutdownDb(jvmVersion, slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath, replicatedDb, testClientHost);
        this._testPostStoppedSlave();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this._testPostStoppedSlaveServer();
        this.shutdownDb(jvmVersion, masterServerHost, masterServerPort, masterDatabasePath + FS + masterDbSubPath, replicatedDb, testClientHost);
        this._testPostStoppedMaster();
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
        this._testPostStoppedServer();
    }

    private void _testPreStoppedSlave(Connection mConn) throws SQLException {
        this.util.DEBUG("_testPreStoppedSlave");
        this.assertException(this.startSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, slaveReplPort), "XRE09");
        this.assertException(this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, slaveReplPort), "XRE40");
        this.assertException(this.failOver(slaveServerHost, slaveServerPort, slaveDatabasePath, slaveDbSubPath, replicatedDb), "XRE07");
        this.assertException(this.startMaster(masterServerHost, masterServerPort, masterDatabasePath, replicatedDb, slaveServerHost, slaveReplPort), "XRE04");
        this.assertException(this.failOver(masterServerHost, masterServerPort, masterDatabasePath, masterDbSubPath, replicatedDb), "XRE07");
        this.assertException(this.executeQuery(mConn, "select count(*) from SYS.SYSTABLES"), "08006");
        this.assertException(this.executeQuery(mConn, "select count(*) from SYS.SYSTABLES"), "08003");
        Connection sConn = this.getConnection(slaveServerHost, slaveServerPort, slaveDatabasePath, slaveDbSubPath, replicatedDb);
        this.assertException(this.executeQuery(sConn, "select count(*) from SYS.SYSTABLES"), null);
        sConn.close();
    }

    private void _testPostStoppedSlave() {
        this.util.DEBUG("_testPostStoppedSlave");
        this.util.DEBUG("_testPostStoppedSlaveServer Not yet implemented");
    }

    private void _testPostStoppedSlaveServer() {
        this.util.DEBUG("_testPostStoppedSlave Not yet implemented");
    }

    private void _testPostStoppedMaster() {
        this.util.DEBUG("_testPostStoppedMaster Not yet implemented");
    }

    private void _testPostStoppedServer() {
        this.util.DEBUG("_testPostStoppedServer Not yet implemented");
    }

    void assertException(SQLException se, String expectedSqlState) {
        if (se == null) {
            this.util.DEBUG("Got 'null' exception, expected '" + expectedSqlState + "'");
            ReplicationRun_Local_StateTest_part2.assertTrue((String)("Expected exception " + expectedSqlState), (expectedSqlState == null ? 1 : 0) != 0);
            return;
        }
        int ec = se.getErrorCode();
        String ss = se.getSQLState();
        String msg = "Got " + ec + " " + ss + " " + se.getMessage() + ". Expected " + expectedSqlState;
        this.util.DEBUG(msg);
        if (expectedSqlState != null) {
            ReplicationRun_Local_StateTest_part2.assertTrue((String)msg, (boolean)ss.equals(expectedSqlState));
        } else {
            ReplicationRun_Local_StateTest_part2.assertTrue((String)msg, (boolean)false);
        }
    }

    SQLException startSlave(String slaveServerHost, int slaveServerPort, String slaveDatabasePath, String replicatedDb, int slaveReplPort) {
        String db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";startSlave=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG(connectionURL);
        try {
            Connection conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("startSlave Unexpectedly connected as: " + connectionURL);
            return new SQLException("startSlave Unexpectedly connected");
        }
        catch (SQLException se) {
            return se;
        }
    }

    SQLException stopSlave(String slaveServerHost, int slaveServerPort, String slaveDatabasePath, String replicatedDb, int slaveReplPort) {
        String db = slaveDatabasePath + FS + ReplicationRun.slaveDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";stopSlave=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG(connectionURL);
        try {
            Connection conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("stopSlave Unexpectedly connected as: " + connectionURL);
            return new SQLException("stopSlave Unexpectedly connected");
        }
        catch (SQLException se) {
            return se;
        }
    }

    SQLException failOver(String serverHost, int serverPort, String databasePath, String dbSubPath, String replicatedDb) {
        String db = databasePath + FS + dbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/" + db + ";failover=true";
        this.util.DEBUG(connectionURL);
        try {
            Connection conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("failOver Unexpectedly connected as: " + connectionURL);
            return new SQLException("failOver Unexpectedly connected");
        }
        catch (SQLException se) {
            return se;
        }
    }

    SQLException startMaster(String masterServerHost, int masterServerPort, String databasePath, String replicatedDb, String slaveServerHost, int slaveReplPort) {
        String db = databasePath + FS + ReplicationRun.masterDbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";startMaster=true" + ";slaveHost=" + slaveServerHost + ";slavePort=" + slaveReplPort;
        this.util.DEBUG(connectionURL);
        try {
            Connection conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("startMaster Unexpectedly connected as: " + connectionURL);
            return new SQLException("startMaster Unexpectedly connected");
        }
        catch (SQLException se) {
            return se;
        }
    }

    Connection getConnection(String serverHost, int serverPort, String databasePath, String dbSubPath, String replicatedDb) throws SQLException {
        String db = databasePath + FS + dbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/" + db;
        this.util.DEBUG(connectionURL);
        return DriverManager.getConnection(connectionURL);
    }

    SQLException connectTo(String serverHost, int serverPort, String databasePath, String dbSubPath, String replicatedDb) {
        String db = databasePath + FS + dbSubPath + FS + replicatedDb;
        String connectionURL = "jdbc:derby://" + serverHost + ":" + serverPort + "/" + db;
        this.util.DEBUG(connectionURL);
        try {
            Connection conn = DriverManager.getConnection(connectionURL);
            this.util.DEBUG("connectTo Unexpectedly connected as: " + connectionURL);
            return new SQLException("connectTo Unexpectedly connected");
        }
        catch (SQLException se) {
            return se;
        }
    }

    SQLException executeQuery(Connection conn, String query) {
        this.util.DEBUG("executeQuery: " + query);
        try {
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery(query);
            return null;
        }
        catch (SQLException se) {
            return se;
        }
    }
}

