/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import com.pivotal.gemfirexd.internal.jdbc.ClientDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_1
extends ReplicationRun {
    private final int noTuplesToInsert = 10000;

    public ReplicationRun_Local_1(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_1 Suite");
        suite.addTestSuite(ReplicationRun_Local_1.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_1() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        String dbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._testInsertUpdateDeleteOnMaster(masterServerHost, masterServerPort, dbPath);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        dbPath = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, dbPath);
        dbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, dbPath);
    }

    private void _testInsertUpdateDeleteOnMaster(String serverHost, int serverPort, String dbPath) throws SQLException {
        this.util.DEBUG("_testInsertUpdateDeleteOnMaster: " + serverHost + ":" + serverPort + "/" + dbPath);
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        Connection conn = ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("create table t(i integer primary key, s varchar(64))");
        ps.execute();
        ps = conn.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 10000; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "dilldall" + i);
            ps.execute();
            if (i % 10000 != 0) continue;
            conn.commit();
        }
        this._verify(conn);
        conn.close();
    }

    private void _verifyDatabase(String serverHost, int serverPort, String dbPath) throws SQLException {
        this.util.DEBUG("_verifyDatabase: " + serverHost + ":" + serverPort + "/" + dbPath);
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        Connection conn = ds.getConnection();
        this._verify(conn);
        conn.close();
    }

    private void _verify(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        rs = s.executeQuery("select max(i) from t");
        rs.next();
        int max = rs.getInt(1);
        this.util.DEBUG("_verify: " + count + "/" + 10000 + " " + max + "/" + 9999);
        ReplicationRun_Local_1.assertEquals((String)("Expected 10000 tuples, got " + count + "."), (int)10000, (int)count);
        ReplicationRun_Local_1.assertEquals((String)("Expected 9999 max, got " + max + "."), (int)9999, (int)max);
    }
}

