/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Distributed
extends ReplicationRun {
    public ReplicationRun_Distributed(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Distributed Suite");
        suite.addTestSuite(ReplicationRun_Distributed.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.masterServer = this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.slaveServer = this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    @Override
    void initEnvironment() throws IOException {
        System.out.println("*** Properties -----------------------------------------");
        userDir = System.getProperty("user.dir");
        System.out.println("user.dir:          " + userDir);
        System.out.println("gemfirexd.system.home: " + System.getProperty("gemfirexd.system.home"));
        String realPropertyFile = "replicationtest.properties";
        System.out.println("realPropertyFile: " + realPropertyFile);
        FileInputStream isCp = new FileInputStream(userDir + FS + realPropertyFile);
        Properties cp = new Properties();
        cp.load(isCp);
        this.util.printDebug = cp.getProperty("test.printDebug", "false").equalsIgnoreCase("true");
        System.out.println("printDebug: " + this.util.printDebug);
        showSysinfo = cp.getProperty("test.showSysinfo", "false").equalsIgnoreCase("true");
        System.out.println("showSysinfo: " + showSysinfo);
        testUser = cp.getProperty("test.testUser", "false");
        System.out.println("testUser: " + testUser);
        masterServerHost = cp.getProperty("test.masterServerHost", masterServerHost);
        System.out.println("masterServerHost: " + masterServerHost);
        masterServerPort = Integer.parseInt(cp.getProperty("test.masterServerPort", "" + masterServerPort));
        System.out.println("masterServerPort: " + masterServerPort);
        slaveServerHost = cp.getProperty("test.slaveServerHost", slaveServerHost);
        System.out.println("slaveServerHost: " + slaveServerHost);
        slaveServerPort = Integer.parseInt(cp.getProperty("test.slaveServerPort", "" + slaveServerPort));
        System.out.println("slaveServerPort: " + slaveServerPort);
        slaveReplPort = Integer.parseInt(cp.getProperty("test.slaveReplPort", "" + slaveReplPort));
        System.out.println("slaveReplPort: " + slaveReplPort);
        testClientHost = cp.getProperty("test.testClientHost", testClientHost);
        System.out.println("testClientHost: " + testClientHost);
        masterDatabasePath = cp.getProperty("test.master.databasepath");
        System.out.println("masterDatabasePath: " + masterDatabasePath);
        slaveDatabasePath = cp.getProperty("test.slave.databasepath");
        System.out.println("slaveDatabasePath: " + slaveDatabasePath);
        replicatedDb = cp.getProperty("test.databaseName", "test");
        System.out.println("replicatedDb: " + replicatedDb);
        bootLoad = cp.getProperty("test.bootLoad");
        System.out.println("bootLoad: " + bootLoad);
        freezeDB = cp.getProperty("test.freezeDB");
        System.out.println("freezeDB: " + freezeDB);
        unFreezeDB = cp.getProperty("test.unFreezeDB");
        System.out.println("unFreezeDB: " + unFreezeDB);
        replicationTest = cp.getProperty("test.replicationTest");
        System.out.println("replicationTest: " + replicationTest);
        replicationVerify = cp.getProperty("test.replicationVerify");
        System.out.println("replicationVerify: " + replicationVerify);
        sqlLoadInit = cp.getProperty("test.sqlLoadInit");
        System.out.println("sqlLoadInit: " + sqlLoadInit);
        specialTestingJar = cp.getProperty("test.derbyTestingJar", null);
        System.out.println("specialTestingJar: " + specialTestingJar);
        jvmVersion = cp.getProperty("jvm.version");
        System.out.println("jvmVersion: " + jvmVersion);
        masterJvmVersion = cp.getProperty("jvm.masterversion");
        if (masterJvmVersion == null) {
            masterJvmVersion = jvmVersion;
        }
        System.out.println("masterJvmVersion: " + masterJvmVersion);
        slaveJvmVersion = cp.getProperty("jvm.slaveversion");
        if (slaveJvmVersion == null) {
            slaveJvmVersion = jvmVersion;
        }
        System.out.println("slaveJvmVersion: " + slaveJvmVersion);
        derbyVersion = cp.getProperty("gemfirexd.version");
        System.out.println("derbyVersion: " + derbyVersion);
        derbyMasterVersion = cp.getProperty("gemfirexd.masterversion");
        if (derbyMasterVersion == null) {
            derbyMasterVersion = derbyVersion;
        }
        System.out.println("derbyMasterVersion: " + derbyMasterVersion);
        derbySlaveVersion = cp.getProperty("gemfirexd.slaveversion");
        if (derbySlaveVersion == null) {
            derbySlaveVersion = derbyVersion;
        }
        System.out.println("derbySlaveVersion: " + derbySlaveVersion);
        String derbyTestingJar = derbyVersion + FS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            derbyTestingJar = specialTestingJar;
        }
        System.out.println("derbyTestingJar: " + derbyTestingJar);
        junit_jar = cp.getProperty("junit_jar");
        System.out.println("junit_jar: " + junit_jar);
        test_jars = derbyTestingJar + ":" + junit_jar;
        System.out.println("test_jars: " + test_jars);
        sleepTime = Integer.parseInt(cp.getProperty("test.sleepTime", "15000"));
        System.out.println("sleepTime: " + sleepTime);
        runUnReplicated = cp.getProperty("test.runUnReplicated", "false").equalsIgnoreCase("true");
        System.out.println("runUnReplicated: " + runUnReplicated);
        localEnv = cp.getProperty("test.localEnvironment", "false").equalsIgnoreCase("true");
        System.out.println("localEnv: " + localEnv);
        derbyProperties = "gemfirexd.infolog.append=true" + LF + "gemfirexd.drda.logConnections=true" + LF + "gemfirexd.drda.traceAll=true" + LF;
        System.out.println("--------------------------------------------------------");
        masterPreRepl = new ReplicationRun.Load(this, "masterPreRepl", cp);
        masterPostRepl = new ReplicationRun.Load(this, "masterPostRepl", cp);
        slavePreSlave = new ReplicationRun.Load(this, "slavePreSlave", cp);
        masterPostSlave = new ReplicationRun.Load(this, "masterPostSlave", cp);
        slavePostSlave = new ReplicationRun.Load(this, "slavePostSlave", cp);
        System.out.println("--------------------------------------------------------");
        tuplesToInsert = Integer.parseInt(cp.getProperty("test.inserts", "10000"));
        commitFreq = Integer.parseInt(cp.getProperty("test.commitFreq", "0"));
        System.out.println("--------------------------------------------------------");
        this.state.initEnvironment(cp);
        System.out.println("--------------------------------------------------------");
    }
}

