/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class ConnectionHandlingJunit
extends BaseJDBCTestCase {
    public ConnectionHandlingJunit(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConnectionHandlingJUnit");
        if (JDBC.vmSupportsJDBC2()) {
            ConnectionHandlingJunit nonExistentDbTest = new ConnectionHandlingJunit("driverMgrTestConnectionsToNonexistentDb");
            suite.addTest((Test)nonExistentDbTest);
        }
        return suite;
    }

    public void driverMgrTestConnectionsToNonexistentDb() throws SQLException {
        Connection myInvalidConn = null;
        String url = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        this.loadDriver(url);
        Runtime runtime = Runtime.getRuntime();
        int maxCount = 130000;
        int count = 0;
        ConnectionHandlingJunit.println("Trying " + maxCount + " connection attempts...");
        try {
            while (count < maxCount) {
                try {
                    myInvalidConn = DriverManager.getConnection(url);
                    ConnectionHandlingJunit.fail((String)"Got connection to a DB that should not exist");
                }
                catch (SQLException e) {
                    String expectedState;
                    if (this.getTestConfiguration().getJDBCClient().isEmbedded()) {
                        expectedState = "XJ004";
                        if (e.getSQLState().equals("08004") && e.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + count + " connection attempts to a " + "non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(e);
                        }
                    } else {
                        expectedState = "08004";
                        if (e.getSQLState().equals("XJ001") && e.getMessage().matches(".*OutOfMemoryError.*")) {
                            ConnectionHandlingJunit.alarm("OutOfMemoryError after " + count + " connection attempts to a " + "non-existing database!");
                            ConnectionHandlingJunit.printStackTrace(e);
                        }
                    }
                    ConnectionHandlingJunit.assertSQLState("Wrong SQLState for non-existent database", expectedState, e);
                }
                if (!this.getTestConfiguration().isVerbose() || ++count % 1000 != 0) continue;
                double memTotalNow = (double)runtime.totalMemory() / 1048576.0;
                ConnectionHandlingJunit.println("Iteration: " + count + "\tTotal memory (MB): " + memTotalNow);
            }
        }
        catch (OutOfMemoryError oome) {
            ConnectionHandlingJunit.alarm("OutOfMemory after " + count + " connection attempts!");
            ConnectionHandlingJunit.alarm(oome.getMessage());
            throw oome;
        }
    }

    private void loadDriver(String url) throws SQLException {
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            ConnectionHandlingJunit.assertSQLState("Unexpected SQLState from getDriver().", "08001", e);
            ConnectionHandlingJunit.assertEquals((String)"Unexpected exception message from getDriver(), ", (String)"No suitable driver", (String)e.getMessage());
            String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            ConnectionHandlingJunit.println("Loading JDBC driver " + driverClass);
            try {
                Class.forName(driverClass).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', ClassNotFoundException: " + cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', IllegalAccessException: " + iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', InstantiationException: " + ie.getMessage());
            }
        }
    }
}

