/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.Reader;
import java.util.Random;

class RandomCharReader
extends Reader {
    private long length;
    private long numTrailingSpaces;
    private Random dpr;

    RandomCharReader(Random dpr, long length) {
        this.length = length;
        this.dpr = dpr;
        this.numTrailingSpaces = 0L;
    }

    RandomCharReader(Random dpr, long length, long numTrailingSpaces) {
        this.length = length;
        this.dpr = dpr;
        this.numTrailingSpaces = numTrailingSpaces;
    }

    private int randomInt(int min, int max) {
        return this.dpr.nextInt(max - min) + min;
    }

    private char getChar() {
        if (this.length <= this.numTrailingSpaces) {
            return ' ';
        }
        double drand = this.dpr.nextDouble();
        int c = 97;
        if (drand < 0.25) {
            c = (char)this.randomInt(65, 90);
        } else if (drand < 0.5) {
            switch (this.randomInt(1, 10)) {
                case 1: {
                    c = 192;
                    break;
                }
                case 2: {
                    c = 193;
                    break;
                }
                case 3: {
                    c = 194;
                    break;
                }
                case 4: {
                    c = 202;
                    break;
                }
                case 5: {
                    c = 203;
                    break;
                }
                case 6: {
                    c = 212;
                    break;
                }
                case 7: {
                    c = 216;
                    break;
                }
                case 8: {
                    c = 209;
                    break;
                }
                case 9: {
                    c = 205;
                    break;
                }
                default: {
                    c = 220;
                    break;
                }
            }
        } else if (drand < 0.75) {
            c = (char)this.randomInt(97, 122);
        } else if (drand < 1.0) {
            switch (this.randomInt(1, 10)) {
                case 1: {
                    c = 226;
                    break;
                }
                case 2: {
                    c = 228;
                    break;
                }
                case 3: {
                    c = 231;
                    break;
                }
                case 4: {
                    c = 232;
                    break;
                }
                case 5: {
                    c = 236;
                    break;
                }
                case 6: {
                    c = 239;
                    break;
                }
                case 7: {
                    c = 246;
                    break;
                }
                case 8: {
                    c = 249;
                    break;
                }
                case 9: {
                    c = 252;
                    break;
                }
                default: {
                    c = 229;
                }
            }
        }
        return (char)c;
    }

    @Override
    public int read() {
        if (this.length <= 0L) {
            return -1;
        }
        --this.length;
        return this.getChar();
    }

    @Override
    public int read(char[] data, int off, int len) {
        if (this.length <= 0L) {
            return -1;
        }
        if ((long)len > this.length) {
            len = (int)this.length;
        }
        for (int i = 0; i < len; ++i) {
            data[off + i] = this.getChar();
            --this.length;
        }
        return len;
    }

    @Override
    public void close() {
    }
}

