/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class simpleThread
implements Runnable {
    private static Connection _connection = null;
    private static boolean _inUse = false;
    private static Object _lock = new Object();
    private long _wait = 0L;
    private long _myCount = 0L;
    private static int _count = 0;
    private String _query;

    private static synchronized int getCount() {
        return _count++;
    }

    public simpleThread(String query, long waitTime) {
        this._wait = waitTime;
        this._myCount = simpleThread.getCount();
        this._query = query;
        new Thread(this).start();
    }

    @Override
    public void run() {
        int rows = 0;
        boolean caught = false;
        try {
            Thread.currentThread();
            Thread.sleep(this._wait);
            Connection conn = simpleThread.GetConnection();
            Statement stmt = conn.createStatement();
            String query = this._query;
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                ++rows;
            }
            stmt.close();
            simpleThread.ReturnConnection(conn);
        }
        catch (Exception ex) {
            caught = true;
        }
        if (rows != 3 && !caught) {
            System.out.println("FAIL: thread " + this._myCount + " only got " + rows + " rows and caught was " + caught);
        }
    }

    public simpleThread(String[] argv) throws Exception {
        ij.getPropertyArg((String[])argv);
        _connection = ij.startJBMS();
        Connection conn = simpleThread.GetConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table people(name varchar(255), address varchar(255), phone varchar(64))");
        stmt.execute("insert into people VALUES ('mike', 'mikes address', '123-456-7890')");
        stmt.execute("insert into people VALUES ('adam', 'adams address', '123-456-1234')");
        stmt.execute("insert into people VALUES ('steve', 'steves address', '123-456-4321')");
        stmt.close();
        simpleThread.ReturnConnection(conn);
        String query = "SELECT * from people ORDER by name";
        try {
            String[] retval = new String[4];
            new simpleThread(query, 0L);
            new simpleThread(query, 10000L);
            new simpleThread(query, 10100L);
            new simpleThread(query, 20000L);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection GetConnection() {
        Object object = _lock;
        synchronized (object) {
            _inUse = true;
        }
        return _connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ReturnConnection(Connection c) {
        Object object = _lock;
        synchronized (object) {
            _inUse = false;
            _lock.notifyAll();
        }
    }
}

