/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class longStringColumn {
    public static PreparedStatement psSet;
    public static PreparedStatement psGet;

    public static void main(String[] args) {
        System.out.println("Test longStringColumn starting");
        StringBuilder buff = new StringBuilder("... ");
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            Statement st2 = conn.createStatement();
            st2.execute("CREATE TABLE TEST(id bigint, body clob(65K))");
            psSet = conn.prepareStatement("insert into test values(?,?)");
            psGet = conn.prepareStatement("select body from test where id=?");
            for (long i = 0L; i < 65560L; ++i) {
                if (i % 10L == 0L) {
                    buff.append(" ");
                } else {
                    buff.append("x");
                }
                if (i % 10000L == 0L) {
                    System.out.println("... " + i);
                }
                if (buff.length() <= 65525) continue;
                System.out.println("i = " + i + ", testing length: " + buff.length());
                String longText = buff.toString();
                longStringColumn.setBody(i, longText);
                String res = longStringColumn.getBody(i);
                if (res.equals(longText)) continue;
                System.out.println("FAIL -- string fetched is incorrect, length is " + buff.length() + ", expecting string: " + longText + ", instead got the following: " + res);
                break;
            }
            conn.close();
        }
        catch (SQLException e) {
            longStringColumn.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:" + e.toString());
        }
        System.out.println("Test longStringColumn finished");
    }

    private static void setBody(long key, String body) {
        try {
            psSet.setLong(1, key);
            psSet.setString(2, body);
            psSet.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.out.println("FAIL -- unexpected exception");
            System.exit(-1);
        }
    }

    private static String getBody(long key) {
        String result = "NO RESULT";
        try {
            psGet.setLong(1, key);
            ResultSet rs = psGet.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception: " + se.toString());
        while (se != null) {
            System.out.print("SQLSTATE(" + se.getSQLState() + "):");
            se = se.getNextException();
        }
    }
}

