/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class holdCursorJavaReflection {
    private static Class[] PREP_STMT_PARAM = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static Object[] PREP_STMT_ARG = new Object[]{"select * from t1  where c12 = ?", new Integer(1003), new Integer(1007), new Integer(1)};
    private static Object[] PREP_STMT_ERROR_ARG = new Object[]{"select * from t1NotThere  where c12 = ?", new Integer(1003), new Integer(1007), new Integer(1)};
    private static Class[] STMT_PARAM = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static Object[] STMT_ARG = new Object[]{new Integer(1003), new Integer(1007), new Integer(1)};

    public static void main(String[] args) {
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            holdCursorJavaReflection.dropTable(conn);
            holdCursorJavaReflection.createAndPopulateTable(conn);
            conn.setAutoCommit(false);
            holdCursorJavaReflection.testHoldability(conn);
            holdCursorJavaReflection.testPreparedStatement(conn);
            holdCursorJavaReflection.testCallableStatement(conn);
            conn.rollback();
            conn.setAutoCommit(true);
            holdCursorJavaReflection.dropTable(conn);
            conn.close();
        }
        catch (Exception e) {
            System.out.println("FAIL -- unexpected exception " + e);
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)e);
            e.printStackTrace();
        }
    }

    private static void createAndPopulateTable(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        System.out.println("Creating table...");
        stmt.executeUpdate("CREATE TABLE T1 (c11 int, c12 int)");
        stmt.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        stmt.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        System.out.println("done creating table and inserting data.");
        stmt.close();
    }

    private static void dropTable(Connection conn) {
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("DROP TABLE T1");
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void testCallableStatement(Connection conn) throws Exception {
        System.out.println("Start hold cursor for callable statements test");
        Method sh = conn.getClass().getMethod("prepareCall", PREP_STMT_PARAM);
        CallableStatement cs = (CallableStatement)sh.invoke((Object)conn, PREP_STMT_ARG);
        cs.setInt(1, 1);
        ResultSet rs = cs.executeQuery();
        System.out.println("do next() before commit");
        rs.next();
        System.out.println("look at first column's value: " + rs.getInt(1));
        conn.commit();
        System.out.println("After commit, look at first column's value: " + rs.getInt(1));
        System.out.println("do next() after commit. Should be at the end of resultset");
        rs.next();
        System.out.println("one more next() here will give no more rows");
        rs.next();
        System.out.println("Holdable cursor after commit for callable statements test over");
        rs.close();
    }

    private static void testHoldability(Connection conn) throws Exception {
        System.out.println("Start holdable cursor after commit test");
        Method sh = conn.getClass().getMethod("createStatement", STMT_PARAM);
        Statement s = (Statement)sh.invoke((Object)conn, STMT_ARG);
        ResultSet rs = s.executeQuery("select * from t1");
        System.out.println("do next() before commit");
        rs.next();
        System.out.println("look at first column's value: " + rs.getInt(1));
        conn.commit();
        System.out.println("After commit, look at first column's value: " + rs.getInt(1));
        System.out.println("do next() after commit. Should be at the end of resultset");
        rs.next();
        System.out.println("one more next() here will give no more rows");
        rs.next();
        System.out.println("Holdable cursor after commit test over");
        rs.close();
    }

    private static void testPreparedStatement(Connection conn) throws Exception {
        System.out.println("Start hold cursor for prepared statements test");
        Method sh = conn.getClass().getMethod("prepareStatement", PREP_STMT_PARAM);
        PreparedStatement ps = (PreparedStatement)sh.invoke((Object)conn, PREP_STMT_ARG);
        ps.setInt(1, 1);
        ResultSet rs = ps.executeQuery();
        System.out.println("do next() before commit");
        rs.next();
        System.out.println("look at first column's value: " + rs.getInt(1));
        conn.commit();
        System.out.println("After commit, look at first column's value: " + rs.getInt(1));
        System.out.println("do next() after commit. Should be at the end of resultset");
        rs.next();
        System.out.println("one more next() here will give no more rows");
        rs.next();
        System.out.println("Holdable cursor after commit for prepared statements test over");
        rs.close();
        sh = conn.getClass().getMethod("prepareStatement", PREP_STMT_PARAM);
        try {
            ps = (PreparedStatement)sh.invoke((Object)conn, PREP_STMT_ERROR_ARG);
            ps.setInt(1, 1);
            rs = ps.executeQuery();
        }
        catch (SQLException se) {
            System.out.println("Expected Exception:" + se.getMessage());
        }
        catch (InvocationTargetException itex) {
            Throwable e = itex.getTargetException();
            if (e instanceof SQLException) {
                SQLException se = (SQLException)e;
                System.out.println("Expected Exception:" + se.getMessage());
            }
            throw itex;
        }
        conn.commit();
    }
}

