/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class deadlockMode {
    private static final int THREAD_COUNT = 20;
    private static boolean passed = false;
    private Object syncObject = new Object();
    private int doneCount;
    private int startedCount;

    private deadlockMode() {
    }

    public static void main(String[] args) {
        System.out.println("Test deadlockMode starting");
        deadlockMode tester = new deadlockMode();
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            deadlockMode.setup(conn, true);
            passed = true;
            tester.runtest();
            deadlockMode.teardown(conn);
            conn.close();
        }
        catch (Throwable e) {
            System.out.println("FAIL: exception thrown:");
            passed = false;
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)e);
            e.printStackTrace();
        }
        if (passed) {
            System.out.println("PASS");
        }
        System.out.println("Test cursor finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runtest() throws InterruptedException {
        Thread[] t = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            t[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    deadlockMode.this.startnew();
                }
            });
            t[i].start();
        }
        boolean notdone = true;
        while (notdone) {
            Object object = this.syncObject;
            synchronized (object) {
                if (this.doneCount == 20) {
                    notdone = false;
                } else {
                    this.syncObject.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        System.out.println("Done Thread");
        Object object = this.syncObject;
        synchronized (object) {
            ++this.doneCount;
            this.syncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startnew() {
        Connection conn = null;
        try {
            conn = ij.startJBMS();
            System.out.println("Starting thread");
            Object object = this.syncObject;
            synchronized (object) {
                ++this.startedCount;
                this.syncObject.notifyAll();
                while (this.startedCount < 20) {
                    this.syncObject.wait();
                }
            }
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("update t set i = 456 where i = 456");
            conn.setAutoCommit(false);
            stmt.execute("set isolation rr");
            for (int i = 0; i < 100; ++i) {
                stmt.executeUpdate("update t set i = 456 where i = 456");
                conn.commit();
            }
            this.done();
        }
        catch (Throwable e) {
            Object object = this.syncObject;
            synchronized (object) {
                System.out.println("FAIL: exception thrown:");
                passed = false;
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)e);
                e.printStackTrace();
                this.done();
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.rollback();
                    conn.close();
                }
            }
            catch (SQLException sqle) {
                System.out.println("FAIL: exception thrown:");
                passed = false;
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sqle);
                sqle.printStackTrace();
            }
        }
    }

    static void setup(Connection conn, boolean first) throws SQLException {
        Statement stmt = conn.createStatement();
        if (first) {
            deadlockMode.verifyCount(stmt.executeUpdate("create table t (i int)"), 0);
        } else {
            deadlockMode.verifyBoolean(stmt.execute("delete from t"), false);
        }
        deadlockMode.verifyCount(stmt.executeUpdate("insert into t values (1956)"), 1);
        deadlockMode.verifyCount(stmt.executeUpdate("insert into t values (456)"), 1);
        deadlockMode.verifyCount(stmt.executeUpdate("insert into t values (180)"), 1);
        deadlockMode.verifyCount(stmt.executeUpdate("insert into t values (3)"), 1);
        stmt.close();
        System.out.println("PASS: setup complete");
    }

    static void teardown(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        deadlockMode.verifyCount(stmt.executeUpdate("drop table t"), 0);
        stmt.close();
        System.out.println("PASS: teardown complete");
    }

    static void verifyCount(int count, int expect) throws SQLException {
        if (count != expect) {
            System.out.println("FAIL: Expected " + expect + " got " + count + " rows");
            throw new SQLException("Wrong number of rows returned");
        }
        System.out.println("PASS: expected and got " + count + (count == 1 ? " row" : " rows"));
    }

    static void verifyBoolean(boolean got, boolean expect) throws SQLException {
        if (got != expect) {
            System.out.println("FAIL: Expected " + expect + " got " + got);
            throw new SQLException("Wrong boolean returned");
        }
        System.out.println("PASS: expected and got " + got);
    }
}

