/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class closed
implements Runnable {
    private static boolean jsr169_test = false;
    private Connection cc;
    private String sql;
    String result;

    public static void main(String[] args) {
        System.out.println("Test closed starting");
        boolean passed = true;
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            passed = closed.testDerby62(conn) && passed;
            passed = closed.testStatement(conn) && passed;
            passed = closed.testPreparedStatement(conn) && passed;
            passed = closed.testResultSet(conn) && passed;
            boolean bl = passed = closed.testConnection(conn) && passed;
            if (!conn.isClosed()) {
                passed = false;
                System.out.println("FAIL -- connection not closed by test");
                conn.close();
            }
            System.out.println("Test database shutdown ...");
            passed = closed.shutdownTest("wombat", "shutdown=true");
            System.out.println("Test system shutdown ...");
            passed = closed.shutdownTest("", "shutdown=true");
        }
        catch (Throwable e) {
            passed = false;
            System.out.println("FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)e);
        }
        if (passed) {
            System.out.println("PASS");
        }
        System.out.println("Test closed finished");
    }

    static boolean shutdownTest(String databaseName, String shutdownString) throws SQLException {
        boolean passed = true;
        Connection c1 = TestUtil.getConnection("wombat", null);
        Connection c2 = TestUtil.getConnection("wombat", null);
        Connection c3a = TestUtil.getConnection("wombat", null);
        Connection c3b = TestUtil.getConnection("wombat", null);
        try {
            c3a.createStatement().execute("DROP TABLE CLOSED.LOCKME");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            c3a.createStatement().execute("DROP PROCEDURE SLEEP");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        c3a.createStatement().execute("CREATE TABLE CLOSED.LOCKME(i int)");
        c3a.createStatement().execute("create procedure sleep(t INTEGER) dynamic result sets 0 language java external name 'java.lang.Thread.sleep' parameter style java");
        c3a.setAutoCommit(false);
        c3a.createStatement().execute("LOCK TABLE CLOSED.LOCKME IN SHARE MODE");
        closed r2 = new closed(c2, "CALL sleep(10000)");
        closed r3 = new closed(c3b, "LOCK TABLE CLOSED.LOCKME IN EXCLUSIVE MODE");
        Thread t22 = new Thread(r2);
        t22.start();
        Thread t3 = new Thread(r3);
        t3.start();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            System.out.println(ie);
        }
        SQLException s = null;
        try {
            TestUtil.getConnection(databaseName, shutdownString);
        }
        catch (SQLException sqle) {
            s = sqle;
        }
        try {
            t22.join();
        }
        catch (InterruptedException ie) {
            System.out.println(ie);
        }
        try {
            t3.join();
        }
        catch (InterruptedException ie) {
            System.out.println(ie);
        }
        System.out.println(r2.result);
        System.out.println(r3.result);
        if (s != null) {
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)s);
        }
        if (!c1.isClosed()) {
            passed = false;
            System.out.println("FAIL -- connection not shutdown " + databaseName + ";" + shutdownString);
            c1.close();
        }
        if (!c2.isClosed()) {
            passed = false;
            System.out.println("FAIL -- active connection not shutdown " + databaseName + ";" + shutdownString);
            c2.close();
        }
        System.out.println("Shutdown test completed.");
        return passed;
    }

    private closed(Connection cc, String sql) {
        this.cc = cc;
        this.sql = sql;
    }

    @Override
    public void run() {
        try {
            this.cc.createStatement().execute(this.sql);
            this.result = "Sleep thread completed " + this.sql;
        }
        catch (SQLException sqle) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.sql);
            sb.append(" - ");
            sb.append(sqle.getSQLState());
            while (sqle != null) {
                if (sqle != null) {
                    sb.append(", ");
                    sb.append(sqle.getSQLState());
                    sb.append(" -- ");
                    if (sqle.getMessage().indexOf("InterruptedException") != -1) {
                        sb.append("InterruptedException");
                    } else {
                        sb.append(sqle.getMessage());
                        sqle.printStackTrace(System.out);
                    }
                } else {
                    sb.append(sqle.getMessage());
                }
                sqle = sqle.getNextException();
            }
            this.result = sb.toString();
        }
    }

    static boolean testStatement(Connection conn) throws SQLException {
        boolean passed = true;
        Statement s = conn.createStatement();
        s.execute("create table t (i int)");
        s.execute("create table s (i int)");
        try {
            s.execute("create table u (i int)");
        }
        catch (SQLException se) {
            passed = false;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on execute of closed statement");
        }
        return passed;
    }

    static boolean testPreparedStatement(Connection conn) throws SQLException {
        boolean passed = true;
        PreparedStatement ps = conn.prepareStatement("insert into t values (1)");
        ps.execute();
        ps.execute();
        ps.close();
        try {
            passed = false;
            ps.execute();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on execute of closed prepared statement");
        }
        return passed;
    }

    static boolean testResultSet(Connection conn) throws SQLException {
        boolean passed = true;
        PreparedStatement ps = conn.prepareStatement("insert into s values (1)");
        ps.execute();
        ps.execute();
        ps.execute();
        ps.execute();
        ps.execute();
        ps.close();
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from s");
        rs.next();
        rs.next();
        rs.close();
        try {
            passed = false;
            rs.next();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on next of closed result set");
        }
        rs = s.executeQuery("select * from s");
        rs.next();
        rs.next();
        s.close();
        try {
            passed = false;
            rs.next();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on next of result set with closed statement");
        }
        return passed;
    }

    static boolean testConnection(Connection conn) throws SQLException {
        boolean passed = true;
        DatabaseMetaData dmd = conn.getMetaData();
        Statement s = conn.createStatement();
        PreparedStatement ps = conn.prepareStatement("create table w (i int)");
        ResultSet rs = dmd.getTables("%", "%", "%", null);
        conn.close();
        try {
            passed = false;
            s.execute("create table x (i int)");
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on statement execute after connection close");
        }
        try {
            passed = false;
            ps.execute();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on prepared statement execute after connection close");
        }
        try {
            passed = false;
            s = conn.createStatement();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on statement creation after connection close");
        }
        try {
            passed = false;
            ps = conn.prepareStatement("create table z (i int)");
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on statement preparation after connection close");
        }
        try {
            passed = false;
            rs.next();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on metadata reading after connection close");
        }
        try {
            passed = false;
            rs = dmd.getColumns("%", "%", "%", "%");
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on metadata collecting after connection close");
        }
        try {
            passed = false;
            dmd = conn.getMetaData();
        }
        catch (SQLException se) {
            passed = true;
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)se);
        }
        if (!passed) {
            System.out.println("FAIL -- no error on getting metadata after connection close");
        }
        return passed;
    }

    static boolean testDerby62(Connection conn) throws SQLException {
        System.out.println("Test case for Derby-62 - serialization error with SQLException");
        try {
            conn.createStatement().execute("DROP TABLE APP.DERBY62_DAIN_SUNDSTROM");
            return false;
        }
        catch (SQLException sqle) {
            boolean passed = true;
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream(1024));
                oos.writeObject(sqle);
                oos.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException " + ioe.getMessage());
                passed = false;
            }
            System.out.println(sqle.getMessage());
            return passed;
        }
    }
}

