/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derbyTesting.functionTests.tests.lang.WISCInsert;
import org.apache.derbyTesting.functionTests.tests.lang.WiscMetaData;

public class WiscVTI
extends VTITemplate {
    int numrows;
    int prime;
    int generator;
    int rowsReturned = 0;
    int unique1;
    int unique2;
    int two;
    int four;
    int ten;
    int twenty;
    int onePercent;
    int tenPercent;
    int twentyPercent;
    int fiftyPercent;
    int unique3;
    int evenOnePercent;
    int oddOnePercent;
    String stringu1;
    String stringu2;
    String string4;
    int seed;
    static final String[] cyclicStrings = new String[]{"AAAAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "HHHHxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "OOOOxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "VVVVxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"};
    boolean closed = false;
    static final WiscMetaData metaData = new WiscMetaData();
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public WiscVTI(int numrows) throws SQLException {
        this.numrows = numrows;
        if (numrows <= 1000) {
            this.generator = 279;
            this.prime = 1009;
        } else if (numrows <= 10000) {
            this.generator = 2969;
            this.prime = 10007;
        } else if (numrows <= 100000) {
            this.generator = 21395;
            this.prime = 100003;
        } else if (numrows <= 1000000) {
            this.generator = 2107;
            this.prime = 1000003;
        } else if (numrows <= 10000000) {
            this.generator = 211;
            this.prime = 10000019;
        } else if (numrows <= 100000000) {
            this.generator = 21;
            this.prime = 100000007;
        } else {
            throw new SQLException("Too many rows - maximum is 100000000, " + numrows + " requested.");
        }
        this.seed = this.generator;
    }

    public ResultSetMetaData getMetaData() {
        return metaData;
    }

    public boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("next() call on a closed result set");
        }
        if (this.rowsReturned >= this.numrows) {
            return false;
        }
        this.seed = this.rand(this.seed, this.numrows);
        this.unique1 = this.seed - 1;
        this.unique2 = this.rowsReturned;
        this.two = this.unique1 % 2;
        this.four = this.unique1 % 4;
        this.ten = this.unique1 % 10;
        this.twenty = this.unique1 % 20;
        this.onePercent = this.unique1 % 100;
        this.tenPercent = this.unique1 % 10;
        this.twentyPercent = this.unique1 % 5;
        this.fiftyPercent = this.unique1 % 2;
        this.unique3 = this.unique1;
        this.evenOnePercent = this.onePercent * 2;
        this.oddOnePercent = this.evenOnePercent + 1;
        this.stringu1 = this.uniqueString(this.unique1);
        this.stringu2 = this.uniqueString(this.unique2);
        this.string4 = cyclicStrings[this.rowsReturned % cyclicStrings.length];
        ++this.rowsReturned;
        return true;
    }

    public int getInt(int columnIndex) throws SQLException {
        if (this.closed) {
            throw new SQLException("getInt() call on a closed result set");
        }
        switch (columnIndex) {
            case 1: {
                return this.unique1;
            }
            case 2: {
                return this.unique2;
            }
            case 3: {
                return this.two;
            }
            case 4: {
                return this.four;
            }
            case 5: {
                return this.ten;
            }
            case 6: {
                return this.twenty;
            }
            case 7: {
                return this.onePercent;
            }
            case 8: {
                return this.tenPercent;
            }
            case 9: {
                return this.twentyPercent;
            }
            case 10: {
                return this.fiftyPercent;
            }
            case 11: {
                return this.unique3;
            }
            case 12: {
                return this.evenOnePercent;
            }
            case 13: {
                return this.oddOnePercent;
            }
        }
        throw new SQLException("getInt() invalid for column " + columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        if (this.closed) {
            throw new SQLException("getString() call on a closed result set");
        }
        switch (columnIndex) {
            case 14: {
                return this.stringu1;
            }
            case 15: {
                return this.stringu2;
            }
            case 16: {
                return this.string4;
            }
        }
        throw new SQLException("getString() invalid for column " + columnIndex);
    }

    public void close() {
        this.closed = true;
    }

    private int rand(int seed, int limit) {
        while ((seed = this.generator * seed % this.prime) > limit) {
        }
        return seed;
    }

    private String uniqueString(int unique) {
        int i;
        char[] retval = new char[52];
        for (i = 0; i < 7; ++i) {
            retval[i] = 65;
        }
        for (i = 7; i < retval.length; ++i) {
            retval[i] = 120;
        }
        i = 6;
        while (unique > 0) {
            int rem = unique % 26;
            retval[i] = chars[rem];
            unique /= 26;
            --i;
        }
        return new String(retval);
    }

    public static void WISCInsertWOConnection(int numrows, String tableName) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        WISCInsert wi = new WISCInsert();
        wi.doWISCInsert(numrows, tableName, conn);
    }
}

