/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class VTITest
extends BaseJDBCTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("VTITest");
        if (JDBC.vmSupportsJDBC2()) {
            suite.addTest((Test)new VTITest("bulkInsertVtiTest"));
        }
        return suite;
    }

    public VTITest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("CREATE TABLE warehouse (id int)");
        stmt.close();
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
        Statement stmt = this.createStatement();
        stmt.execute("DROP TABLE warehouse");
        stmt.close();
        super.tearDown();
    }

    public void bulkInsertVtiTest() throws SQLException {
        int expectedRows = 10;
        Statement stmt = this.createStatement();
        stmt.execute("call  SYSCS_UTIL.BULK_INSERT('APP','WAREHOUSE','org.apache.derbyTesting.functionTests.tests.lang.WarehouseVTI','" + expectedRows + "')");
        stmt.close();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) from warehouse");
        rs.next();
        VTITest.assertEquals((int)expectedRows, (int)rs.getInt(1));
        rs.close();
        stmt.close();
    }
}

