/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class UpdateCursorTest
extends BaseJDBCTestCase {
    private static final int SIZE_OF_T1 = 250;
    private static final int MAX_CAP_OF_HASH_TABLE = 100;
    private static final String EXPECTED_SQL_CODE = "02000";
    private static final String UNEXPECTED_MSG = "No row was found for FETCH, UPDATE or DELETE";

    public UpdateCursorTest(String name) {
        super(name);
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        Properties props = new Properties();
        props.setProperty("gemfirexd.language.maxMemoryPerTable", "1");
        return new DatabasePropertyTestSetup((Test)new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup((Test)new TestSuite(UpdateCursorTest.class, "UpdateCursorTest")){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                StringBuilder sb = new StringBuilder(1000);
                BaseJDBCTestCase.assertUpdateCount(s, 0, "create table T1 (  c1\tint,  c2\tchar(50),  c3\tint,  c4   char(50),  c5   int,  c6   varchar(1000))");
                BaseJDBCTestCase.assertUpdateCount(s, 0, "create index I11 on T1(c3, c1, c5)");
                BaseJDBCTestCase.assertUpdateCount(s, 0, "create table T2(  c1 \tint)");
                BaseJDBCTestCase.assertUpdateCount(s, 0, "create table T3(  c1\tchar(20) not null primary key)");
                BaseJDBCTestCase.assertUpdateCount(s, 0, "create table T4(  c1 \tchar(20) references T3(c1) on delete cascade)");
                for (i = 0; i < 1000; ++i) {
                    sb.append('a');
                }
                PreparedStatement pstmt = s.getConnection().prepareStatement("insert into T1 values (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?), (?, ?, ?, ?, ?, ?)");
                String largeString = new String(sb);
                for (i = 246; i > 0; i -= 5) {
                    int k = 0;
                    for (int j = 0; j < 5; ++j) {
                        pstmt.setInt(1 + k, i + (4 - j));
                        pstmt.setString(2 + k, new Integer(i).toString());
                        pstmt.setInt(3 + k, i + j);
                        pstmt.setString(4 + k, new Integer(i).toString());
                        pstmt.setInt(5 + k, i);
                        pstmt.setString(6 + k, largeString);
                        k += 6;
                    }
                    BaseJDBCTestCase.assertUpdateCount(pstmt, 5);
                }
                s.executeUpdate("insert into t2 values (1)");
                pstmt.close();
            }
        }, props), props, true);
    }

    public void testVirtualMemoryHeap() throws SQLException {
        int i;
        PreparedStatement select = this.prepareStatement("select c1, c3 from t1 where c3 > 1 and c1 > 0 for update");
        Statement update = this.createStatement();
        int expectedValue = 1;
        UpdateCursorTest.assertUpdateCount(update, 0, "drop index I11");
        UpdateCursorTest.assertUpdateCount(update, 0, "create index I11 on T1 (c3, c1, c5)");
        ResultSet cursor = select.executeQuery();
        String cursorName = cursor.getCursorName();
        for (i = 0; i < 249; ++i) {
            if (i < 101) {
                ++expectedValue;
            } else if (i > 100 && i <= 200) {
                expectedValue = i == 101 ? 202 : --expectedValue;
            } else if (i > 200) {
                expectedValue = i == 201 ? 203 : ++expectedValue;
            }
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
            UpdateCursorTest.assertEquals((String)"Virtual memory heap test failed! Got unexpected value.", (int)expectedValue, (int)cursor.getInt(2));
            update.execute("update t1 set c3 = c3 + 250 where current of " + cursorName);
        }
        UpdateCursorTest.assertFalse((String)"Update with virtual memory heap failed! Still got rows.", (boolean)cursor.next());
        cursor.close();
        update.close();
        select = this.prepareStatement("select c1, c3 from t1");
        cursor = select.executeQuery();
        for (i = 0; i < 250; ++i) {
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update with virtual memory heeap failed! Got more rows.", (boolean)cursor.next());
        select.close();
        cursor.close();
        this.rollback();
    }

    public void testNonCoveringIndex() throws SQLException {
        int i;
        Statement update = this.createStatement();
        PreparedStatement select = this.prepareStatement("select c3, c2 from t1 where c3 > 125 and c1 > 0 for update");
        ResultSet cursor = select.executeQuery();
        String cursorName = cursor.getCursorName();
        for (i = 0; i < 125; ++i) {
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
            update.execute("update t1 set c3 = c3 + 25 where current of " + cursorName);
        }
        UpdateCursorTest.assertFalse((String)"Update using noncovering index failed! Still got rows.", (boolean)cursor.next());
        cursor.close();
        select.close();
        select = this.prepareStatement("select c1, c3 from t1");
        cursor = select.executeQuery();
        for (i = 0; i < 250; ++i) {
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update using noncovering index failed! Got more rows.", (boolean)cursor.next());
        select.close();
        cursor.close();
        this.rollback();
    }

    public void testDescendingIndex() throws SQLException {
        int i;
        Statement update = this.createStatement();
        UpdateCursorTest.assertUpdateCount(update, 0, "drop index I11");
        UpdateCursorTest.assertUpdateCount(update, 0, "create index I11 on T1 (c3 desc, c1, c5 desc)");
        this.commit();
        update = this.createStatement();
        PreparedStatement select = this.prepareStatement("select c3, c1 from t1 where c3 > 125 and c1 > 0 for update");
        ResultSet cursor = select.executeQuery();
        for (i = 0; i < 125; ++i) {
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
            if (i % 2 == 0) {
                update.execute("update t1 set c3 = c3 + 1 where current of " + cursor.getCursorName());
                continue;
            }
            update.execute("update t1 set c3 = c3 - 1 where current of " + cursor.getCursorName());
        }
        UpdateCursorTest.assertFalse((String)"Update using desc index failed! Got more rows.", (boolean)cursor.next());
        cursor.close();
        select.close();
        select = this.prepareStatement("select c3, c2 from t1");
        cursor = select.executeQuery();
        for (i = 0; i < 250; ++i) {
            UpdateCursorTest.assertEquals((boolean)cursor.next(), (boolean)true);
        }
        UpdateCursorTest.assertFalse((String)"Update using desc index failed! Got more rows.", (boolean)cursor.next());
        select.close();
        cursor.close();
        this.rollback();
    }

    public void testUpdateDeleteWarning() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("update t2 set c1 = 2 where c1 = 1");
        SQLWarning sw = stmt.getWarnings();
        UpdateCursorTest.assertNull((String)"The update should not return a warning.", (Object)sw);
        stmt.executeUpdate("update t2 set c1 = 2 where c1 = 1");
        sw = stmt.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The update should return a warning.", (Object)sw);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sw.getSQLState());
        stmt.executeUpdate("delete from t2 where c1 = 2");
        sw = stmt.getWarnings();
        UpdateCursorTest.assertNull((String)"The delete should not return a warning.", (Object)sw);
        stmt.executeUpdate("delete from t2 where c1 = 2");
        sw = stmt.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The delete should return a warning.", (Object)sw);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sw.getSQLState());
        stmt.executeUpdate("delete from t3");
        sw = stmt.getWarnings();
        UpdateCursorTest.assertNotNull((String)"The delete cascade should return a warning.", (Object)sw);
        UpdateCursorTest.assertEquals((String)"Wrong sql state.", (String)EXPECTED_SQL_CODE, (String)sw.getSQLState());
        stmt.close();
        this.rollback();
    }
}

