/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UnarySimpleTest
extends BaseJDBCTestCase {
    public UnarySimpleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UnarySimpleTest.class);
    }

    protected void setUp() throws SQLException {
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
        super.tearDown();
    }

    public void testSimpleUnaryPlus() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t (c1 int)");
        s.execute("insert into t values (222),(11),(-55)");
        Object[][] expectedRows = new Integer[][]{{322}, {111}, {45}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select c1+100 from t"), expectedRows, false);
        s.executeUpdate("drop table t");
        s.close();
    }

    public void testSimpleUnaryMinus() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table t (c1 int)");
        s.execute("insert into t values (222),(11),(-55)");
        Object[][] expectedRows = new Integer[][]{{122}, {-89}, {-155}};
        JDBC.assertUnorderedResultSet(s.executeQuery("select c1-100 from t"), expectedRows, false);
        s.executeUpdate("drop table t");
        s.close();
    }
}

