/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.util.streams.ReadOnceByteArrayInputStream;
import org.apache.derbyTesting.functionTests.util.streams.StringReaderWithLength;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class TriggerTest
extends BaseJDBCTestCase {
    private static ThreadLocal TRIGGER_INFO = new ThreadLocal();

    public TriggerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(TriggerTest.class));
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    protected void setUp() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE PROCEDURE TRIGGER_LOG_INFO(O VARCHAR(255)) NO SQL PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".logTriggerInfo'");
        s.close();
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
        TRIGGER_INFO.set(null);
        JDBC.dropSchema(this.getConnection().getMetaData(), this.getTestConfiguration().getUserName());
        super.tearDown();
    }

    public void testFiringOrder() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T(ID INT)");
        int triggerCount = this.createRandomTriggers()[0];
        ArrayList info = new ArrayList();
        TRIGGER_INFO.set(info);
        s.execute("INSERT INTO T VALUES 1");
        this.commit();
        int fireCount = this.assertFiringOrder("INSERT", 1);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 1);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        info.clear();
        TriggerTest.assertEquals((String)"All triggers fired?", (int)triggerCount, (int)(fireCount += this.assertFiringOrder("DELETE", 1)));
        s.execute("INSERT INTO T VALUES 1,2,3");
        this.commit();
        fireCount = this.assertFiringOrder("INSERT", 3);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 3);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        info.clear();
        TriggerTest.assertTrue((String)"Sufficient triggers fired?", ((fireCount += this.assertFiringOrder("DELETE", 3)) >= triggerCount ? 1 : 0) != 0);
        this.assertTableRowCount("T", 0);
        s.execute("INSERT INTO T SELECT ID FROM T");
        this.commit();
        fireCount = this.assertFiringOrder("INSERT", 0);
        info.clear();
        s.execute("UPDATE T SET ID = 2");
        this.commit();
        fireCount += this.assertFiringOrder("UPDATE", 0);
        info.clear();
        s.execute("DELETE FROM T");
        this.commit();
        fireCount += this.assertFiringOrder("DELETE", 0);
        info.clear();
        s.close();
    }

    private int[] createRandomTriggers() throws SQLException {
        Statement s = this.createStatement();
        int beforeCount = 0;
        int afterCount = 0;
        Random r = new Random();
        int triggerCount = r.nextInt(45) + 45;
        for (int i = 0; i < triggerCount; ++i) {
            String before;
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TRIGGER TR");
            sb.append(i);
            sb.append(" ");
            if (r.nextInt(2) == 0) {
                before = "NO CASCADE BEFORE";
                ++beforeCount;
            } else {
                before = "AFTER";
                ++afterCount;
            }
            sb.append(before);
            sb.append(" ");
            int type = r.nextInt(3);
            String iud = type == 0 ? "INSERT" : (type == 1 ? "UPDATE" : "DELETE");
            sb.append(iud);
            sb.append(" ON T FOR EACH ");
            String row = r.nextInt(2) == 0 ? "ROW" : "STATEMENT";
            sb.append(row);
            sb.append(" ");
            sb.append("CALL TRIGGER_LOG_INFO('");
            sb.append(i);
            sb.append(",");
            sb.append(before);
            sb.append(",");
            sb.append(iud);
            sb.append(",");
            sb.append(row);
            sb.append("')");
            s.execute(sb.toString());
        }
        this.commit();
        s.close();
        return new int[]{triggerCount, beforeCount, afterCount};
    }

    public void testFiringConstraintOrder() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE T (I INT PRIMARY KEY,U INT NOT NULL UNIQUE, C INT CHECK (C < 20))");
        s.execute("INSERT INTO T VALUES(1,5,10)");
        s.execute("INSERT INTO T VALUES(11,19,3)");
        s.execute("CREATE TABLE TCHILD (I INT, FOREIGN KEY (I) REFERENCES T)");
        s.execute("INSERT INTO TCHILD VALUES 1");
        this.commit();
        int beforeCount = this.createRandomTriggers()[1];
        ArrayList info = new ArrayList();
        TRIGGER_INFO.set(info);
        TriggerTest.assertStatementError("23505", s, "INSERT INTO T VALUES (1,6,10)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23505", s, "UPDATE T SET I=1 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError("23505", s, "INSERT INTO T VALUES (2,5,10)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23505", s, "UPDATE T SET U=5 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError("23513", s, "INSERT INTO T VALUES (2,6,22)");
        this.assertFiringOrder("INSERT", 1, true);
        info.clear();
        TriggerTest.assertStatementError("23513", s, "UPDATE T SET C=C+40 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        info.clear();
        this.rollback();
        TriggerTest.assertStatementError("23503", s, "DELETE FROM T WHERE I = 1");
        this.assertFiringOrder("DELETE", 1, true);
        s.close();
        this.commit();
    }

    private int assertFiringOrder(String iud, int modifiedRowCount) {
        return this.assertFiringOrder(iud, modifiedRowCount, false);
    }

    private int assertFiringOrder(String iud, int modifiedRowCount, boolean noAfter) {
        List fires = (List)TRIGGER_INFO.get();
        int lastOrder = -1;
        String lastBefore = null;
        Iterator i = fires.iterator();
        while (i.hasNext()) {
            String info = i.next().toString();
            StringTokenizer st = new StringTokenizer(info, ",");
            TriggerTest.assertEquals((int)4, (int)st.countTokens());
            st.hasMoreTokens();
            int order = Integer.valueOf(st.nextToken());
            st.hasMoreTokens();
            String before = st.nextToken();
            st.hasMoreTokens();
            String fiud = st.nextToken();
            st.hasMoreTokens();
            String row = st.nextToken();
            TriggerTest.assertEquals((String)("Incorrect trigger firing:" + info), (String)iud, (String)fiud);
            if (modifiedRowCount == 0) {
                TriggerTest.assertEquals((String)"Row trigger firing on no rows", (String)"STATEMENT", (String)row);
            }
            if (noAfter) {
                TriggerTest.assertFalse((String)"No AFTER triggers", (boolean)"AFTER".equals(before));
            }
            if (lastOrder == -1) {
                lastOrder = order;
                lastBefore = before;
                continue;
            }
            if (lastBefore.equals(before)) {
                boolean orderOk = modifiedRowCount > 1 ? order >= lastOrder : order > lastOrder;
                TriggerTest.assertTrue((String)("matching triggers need to be fired in order creation:" + info), (boolean)orderOk);
                lastOrder = order;
                continue;
            }
            TriggerTest.assertEquals((String)("BEFORE before AFTER:" + info), (String)"NO CASCADE BEFORE", (String)lastBefore);
            TriggerTest.assertEquals((String)("then AFTER:" + info), (String)"AFTER", (String)before);
            lastBefore = before;
            lastOrder = order;
        }
        return fires.size();
    }

    public static void logTriggerInfo(String info) {
        ((List)TRIGGER_INFO.get()).add(info);
    }

    public void testNPEinTriggerFire() throws SQLException {
        Statement s = this.createStatement();
        String sql = " CREATE TABLE TRADE(ID INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY (START WITH 1000), BUYID INT NOT NULL,QTY FLOAT(2) NOT NULL)";
        s.executeUpdate(sql);
        sql = "CREATE TABLE TOTAL(BUYID INT NOT NULL, TOTALQTY FLOAT(2) NOT NULL)";
        s.executeUpdate(sql);
        sql = "CREATE TRIGGER TRADE_INSERT AFTER INSERT ON TRADE REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL UPDATE TOTAL SET TOTALQTY = NEWROW.QTY WHERE BUYID = NEWROW.BUYID";
        s.executeUpdate(sql);
        s.executeUpdate("INSERT INTO TOTAL VALUES (1, 0)");
        s.executeUpdate("INSERT INTO TRADE VALUES(1, 1, 10)");
        this.commit();
    }

    public void testClobInTriggerTable() throws SQLException, IOException {
        this.testClobInTriggerTable(1024);
        this.testClobInTriggerTable(16384);
        this.testClobInTriggerTable(Short.MAX_VALUE);
        this.testClobInTriggerTable(32768);
        this.testClobInTriggerTable(32769);
        this.testClobInTriggerTable(65535);
        this.testClobInTriggerTable(65536);
        this.testClobInTriggerTable(65537);
    }

    private void testClobInTriggerTable(int clobSize) throws SQLException, IOException {
        String trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement s = this.createStatement();
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, clobSize + "");
        char[] arr = this.makeArray(clobSize, 'a');
        ps.setCharacterStream(2, (Reader)new CharArrayReader(arr), clobSize);
        ps.execute();
        this.commit();
        s.executeUpdate("update LOB1 set str1 = str1 || ' '");
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of c_lob on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.c_lob, new.c_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, clobSize + "");
        ps.setCharacterStream(2, (Reader)new CharArrayReader(arr), clobSize);
        ps.execute();
        this.commit();
        ps = this.prepareStatement("update LOB1 set c_lob = ?");
        char[] updArr = this.makeArray(clobSize, 'b');
        ps.setCharacterStream(1, (Reader)new CharArrayReader(updArr), clobSize);
        ps.execute();
        this.commit();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of c_lob on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.c_lob, new.c_lob, old.c_lob, new.c_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), oldvalue_again CLOB(50M), newvalue_again CLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, clobSize + "");
        ps.setCharacterStream(2, (Reader)new CharArrayReader(arr), clobSize);
        ps.execute();
        this.commit();
        ps = this.prepareStatement("update LOB1 set c_lob = ?");
        ps.setCharacterStream(1, (Reader)new CharArrayReader(updArr), clobSize);
        ps.execute();
        this.commit();
        ResultSet rs = s.executeQuery("SELECT * from t_lob1_log");
        rs.next();
        Reader r = rs.getCharacterStream(1);
        this.assertReaderContents(r, clobSize, 'a');
        r = rs.getCharacterStream(2);
        this.assertReaderContents(r, clobSize, 'b');
        r = rs.getCharacterStream(3);
        this.assertReaderContents(r, clobSize, 'a');
        r = rs.getCharacterStream(4);
        this.assertReaderContents(r, clobSize, 'b');
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    private char[] makeArray(int size, char c) {
        char[] arr = new char[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = c;
        }
        return arr;
    }

    private byte[] makeArray(int size, byte b) {
        byte[] arr = new byte[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = b;
        }
        return arr;
    }

    public void testBlobInTriggerTable() throws SQLException, IOException {
        this.testBlobInTriggerTable(1024);
        this.testBlobInTriggerTable(16384);
        this.testBlobInTriggerTable(Short.MAX_VALUE);
        this.testBlobInTriggerTable(32768);
        this.testBlobInTriggerTable(32769);
        this.testBlobInTriggerTable(65535);
        this.testBlobInTriggerTable(65536);
        this.testBlobInTriggerTable(65537);
        this.testBlobInTriggerTable(0x700000);
    }

    private void testBlobInTriggerTable(int blobSize) throws SQLException, IOException {
        String trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement s = this.createStatement();
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M), b_lob2 BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?, ?)");
        ps.setString(1, blobSize + "");
        byte[] arr = this.makeArray(blobSize, (byte)8);
        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(arr), blobSize);
        ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(arr), blobSize);
        ps.execute();
        this.commit();
        s.executeUpdate("update LOB1 set str1 = str1 || ' '");
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of b_lob on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.b_lob, new.b_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, blobSize + "");
        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(arr), blobSize);
        ps.execute();
        this.commit();
        ps = this.prepareStatement("update LOB1 set b_lob = ?");
        byte[] updArr = this.makeArray(blobSize, (byte)9);
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(updArr), blobSize);
        ps.execute();
        this.commit();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
        trig = " create trigger t_lob1 after update of b_lob on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.b_lob, new.b_lob, old.b_lob, new.b_lob)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), oldvalue_again BLOB(50M), newvalue_again BLOB(50M), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        this.commit();
        ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        ps.setString(1, blobSize + "");
        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(arr), blobSize);
        ps.execute();
        this.commit();
        ps = this.prepareStatement("update LOB1 set b_lob = ?");
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(updArr), blobSize);
        ps.execute();
        this.commit();
        ResultSet rs = s.executeQuery("SELECT * from t_lob1_log");
        rs.next();
        InputStream is = rs.getBinaryStream(1);
        this.assertInputStreamContents(is, blobSize, (byte)8);
        is = rs.getBinaryStream(2);
        this.assertInputStreamContents(is, blobSize, (byte)9);
        is = rs.getBinaryStream(3);
        this.assertInputStreamContents(is, blobSize, (byte)8);
        is = rs.getBinaryStream(4);
        this.assertInputStreamContents(is, blobSize, (byte)9);
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    private void assertInputStreamContents(InputStream is, int size, byte expectedValue) throws IOException {
        int b;
        int count = 0;
        do {
            if ((b = is.read()) == -1) continue;
            ++count;
            TriggerTest.assertEquals((int)expectedValue, (int)b);
        } while (b != -1);
        TriggerTest.assertEquals((int)size, (int)count);
    }

    public void testUpdateTriggerOnClobColumn() throws SQLException, IOException {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        String trig = " create trigger t_lob1 after update of str1 on lob1 ";
        trig = trig + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        trig = trig + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        s.executeUpdate("create table LOB1 (str1 Varchar(80), C_lob CLOB(50M))");
        s.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        s.executeUpdate(trig);
        conn.commit();
        PreparedStatement ps = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        int clobSize = 65537;
        ps.setString(1, clobSize + "");
        ps.setCharacterStream(2, (Reader)this.makeCharArrayReader('a', clobSize), clobSize);
        ps.execute();
        conn.commit();
        PreparedStatement ps2 = this.prepareStatement("update LOB1 set c_lob = ? where str1 = '" + clobSize + "'");
        ps2.setCharacterStream(1, (Reader)this.makeCharArrayReader('b', clobSize), clobSize);
        ps2.executeUpdate();
        conn.commit();
        ResultSet rs = s.executeQuery("SELECT * FROM LOB1 where str1 = '" + clobSize + "'");
        rs.next();
        Reader r = rs.getCharacterStream(2);
        char expectedCharValue = 'b';
        this.assertReaderContents(r, clobSize, expectedCharValue);
        rs.close();
        s.executeUpdate("drop table lob1");
        s.executeUpdate("drop table t_lob1_log");
    }

    private void assertReaderContents(Reader r, int size, char expectedCharValue) throws IOException {
        int c;
        int count = 0;
        do {
            if ((c = r.read()) == -1) continue;
            ++count;
            TriggerTest.assertEquals((int)expectedCharValue, (int)c);
        } while (c != -1);
        TriggerTest.assertEquals((int)size, (int)count);
    }

    private CharArrayReader makeCharArrayReader(char c, int size) {
        char[] arr = new char[size];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = c;
        }
        return new CharArrayReader(arr);
    }

    public void testTypesInActionStatement() throws SQLException, IOException {
        Iterator i;
        List types = DatabaseMetaDataTest.getSQLTypes(this.getConnection());
        if (!XML.classpathMeetsXMLReqs()) {
            types.remove("XML");
        }
        if (!JDBC.vmSupportsJDBC3()) {
            i = types.iterator();
            while (i.hasNext()) {
                String type = i.next().toString();
                if (!type.startsWith("DECIMAL") && !type.startsWith("NUMERIC")) continue;
                i.remove();
            }
        }
        i = types.iterator();
        while (i.hasNext()) {
            this.actionTypeTest(i.next().toString());
        }
    }

    private void actionTypeTest(String type) throws SQLException, IOException {
        TriggerTest.println("actionTypeTest:" + type);
        Statement s = this.createStatement();
        this.actionTypesSetup(type);
        this.actionTypesInsertTest(type);
        this.actionTypesUpdateTest(type);
        this.actionTypesDeleteTest(type);
        s.executeUpdate("DROP TABLE T_MAIN");
        s.executeUpdate("DROP TABLE T_ACTION_ROW");
        s.executeUpdate("DROP TABLE T_ACTION_STATEMENT");
        s.close();
        this.commit();
    }

    private void actionTypesSetup(String type) throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V " + type + " )");
        s.executeUpdate("CREATE TABLE T_ACTION_ROW(ID INT, A CHAR(1), V1 " + type + ", V2 " + type + " )");
        s.executeUpdate("CREATE TABLE T_ACTION_STATEMENT(ID INT, A CHAR(1), V1 " + type + ", V2 " + type + " )");
        s.executeUpdate("CREATE TRIGGER AIR AFTER INSERT ON T_MAIN REFERENCING NEW AS N FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('I', N.V, N.ID, N.V)");
        s.executeUpdate("CREATE TRIGGER AIS AFTER INSERT ON T_MAIN REFERENCING NEW TABLE AS N FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'I', V, ID, V FROM N");
        s.executeUpdate("CREATE TRIGGER AUR AFTER UPDATE OF V ON T_MAIN REFERENCING NEW AS N OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('U', N.V, N.ID, O.V)");
        s.executeUpdate("CREATE TRIGGER AUS AFTER UPDATE OF V ON T_MAIN REFERENCING NEW TABLE AS N OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'U', N.V, N.ID, O.V FROM N,O WHERE O.ID = N.ID");
        s.executeUpdate("CREATE TRIGGER ADR AFTER DELETE ON T_MAIN REFERENCING OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('D', O.V, O.ID, O.V)");
        s.executeUpdate("CREATE TRIGGER ADS AFTER DELETE ON T_MAIN REFERENCING OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'D', O.V, O.ID, O.V FROM O");
        s.close();
        this.commit();
    }

    private void actionTypesInsertTest(String type) throws SQLException, IOException {
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO T_MAIN(V) VALUES NULL");
        s.close();
        this.actionTypesCompareMainToAction(1, type);
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Random r = new Random();
        String ins1 = "INSERT INTO T_MAIN(V) VALUES (?)";
        String ins3 = "INSERT INTO T_MAIN(V) VALUES (?), (?), (?)";
        if (jdbcType == 2009) {
            ins1 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
            ins3 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
        }
        PreparedStatement ps = this.prepareStatement(ins1);
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(2, type);
        ps = this.prepareStatement(ins3);
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        TriggerTest.setRandomValue(r, ps, 2, jdbcType, precision);
        TriggerTest.setRandomValue(r, ps, 3, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(5, type);
    }

    private void actionTypesUpdateTest(String type) throws SQLException, IOException {
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Statement s = this.createStatement();
        s.executeUpdate("UPDATE T_MAIN SET V = NULL WHERE ID = 2");
        s.close();
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 2);
        Random r = new Random();
        PreparedStatement ps = this.prepareStatement((jdbcType == 2009 ? "UPDATE T_MAIN SET V = XMLPARSE(DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)" : "UPDATE T_MAIN SET V = ?") + " WHERE ID >= ? AND ID <= ?");
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.setInt(2, 3);
        ps.setInt(3, 3);
        TriggerTest.assertUpdateCount(ps, 1);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 3);
        switch (jdbcType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                ps.close();
                return;
            }
        }
        TriggerTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.setInt(2, 4);
        ps.setInt(3, 5);
        TriggerTest.assertUpdateCount(ps, 2);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(type, 4);
        this.actionTypesCompareMainToActionForUpdate(type, 5);
        ps.close();
    }

    private void actionTypesCompareMainToActionForUpdate(String type, int id) throws SQLException, IOException {
        String sqlMain = "SELECT M.V, R.V1 FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
        String sqlRow = "SELECT V1, V2 FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
        String sqlStmt = "SELECT V1, V2 FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        if ("XML".equals(type)) {
            sqlMain = "SELECT XMLSERIALIZE(M.V AS CLOB), XMLSERIALIZE(R.V1 AS CLOB) FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
            sqlRow = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
            sqlStmt = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        }
        PreparedStatement psMain = this.prepareStatement(sqlMain);
        PreparedStatement psActionRow = this.prepareStatement(sqlRow);
        PreparedStatement psActionStmt = this.prepareStatement(sqlStmt);
        psMain.setInt(1, id);
        psActionRow.setInt(1, id);
        psActionStmt.setInt(1, id);
        JDBC.assertSameContents(psMain.executeQuery(), psActionRow.executeQuery());
        JDBC.assertSameContents(psMain.executeQuery(), psActionStmt.executeQuery());
        psMain.close();
        psActionRow.close();
        psActionStmt.close();
        this.commit();
    }

    private void actionTypesDeleteTest(String type) throws SQLException, IOException {
        int jdbcType = DatabaseMetaDataTest.getJDBCType(type);
        int precision = DatabaseMetaDataTest.getPrecision(jdbcType, type);
        if (jdbcType == 2004) {
            return;
        }
        Statement s = this.createStatement();
        TriggerTest.assertUpdateCount(s, 1, "DELETE FROM T_MAIN WHERE ID = 3");
        this.commit();
        TriggerTest.assertUpdateCount(s, 4, "DELETE FROM T_MAIN");
        this.commit();
        s.close();
    }

    private void actionTypesCompareMainToAction(int actionCount, String type) throws SQLException, IOException {
        Statement s1 = this.createStatement();
        Statement s2 = this.createStatement();
        String sqlMain = "SELECT ID, V, V FROM T_MAIN ORDER BY 1";
        String sqlActionRow = "SELECT ID, V1, V2 FROM T_ACTION_ROW ORDER BY 1";
        String sqlActionStatement = "SELECT ID, V1, V2 FROM T_ACTION_STATEMENT ORDER BY 1";
        if ("XML".equals(type)) {
            sqlMain = "SELECT ID, XMLSERIALIZE(V AS CLOB), XMLSERIALIZE(V AS CLOB) FROM T_MAIN ORDER BY 1";
            sqlActionRow = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW ORDER BY 1";
            sqlActionStatement = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT ORDER BY 1";
        }
        ResultSet rsMain = s1.executeQuery(sqlMain);
        ResultSet rsAction = s2.executeQuery(sqlActionRow);
        JDBC.assertSameContents(rsMain, rsAction);
        rsMain = s1.executeQuery(sqlMain);
        rsAction = s2.executeQuery(sqlActionStatement);
        JDBC.assertSameContents(rsMain, rsAction);
        this.assertTableRowCount("T_ACTION_ROW", actionCount);
        this.assertTableRowCount("T_ACTION_STATEMENT", actionCount);
        s1.close();
        s2.close();
    }

    public static void setRandomValue(Random r, PreparedStatement ps, int column, int jdbcType, int precision) throws SQLException, IOException {
        Object val = TriggerTest.getRandomValue(r, jdbcType, precision);
        if (val instanceof StringReaderWithLength) {
            StringReaderWithLength rd = (StringReaderWithLength)val;
            ps.setCharacterStream(column, (Reader)rd, rd.getLength());
        } else if (val instanceof InputStream) {
            InputStream in = (InputStream)val;
            ps.setBinaryStream(column, in, in.available());
        } else {
            ps.setObject(column, val, jdbcType);
        }
    }

    public static Object getRandomValue(Random r, int jdbcType, int precision) throws IOException {
        switch (jdbcType) {
            case 5: {
                return new Integer((short)r.nextInt());
            }
            case 4: {
                return new Integer(r.nextInt());
            }
            case -5: {
                return new Long(r.nextLong());
            }
            case 6: 
            case 7: {
                return new Float(r.nextFloat());
            }
            case 8: {
                return new Double(r.nextDouble());
            }
            case 91: {
                long d = r.nextLong();
                if (d < 0L) {
                    d = -d;
                }
                d /= 86400000L;
                d %= 1460000L;
                return new Date(d *= 86400000L);
            }
            case 92: {
                long t = r.nextLong();
                if (t < 0L) {
                    t = -t;
                }
                return new Time(t % 86400000L);
            }
            case 93: {
                long ts = r.nextLong();
                if (ts < 0L) {
                    ts = -ts;
                }
                return new Timestamp(ts %= 126144000000000L);
            }
            case 1: 
            case 12: {
                return TriggerTest.randomString(r, r.nextInt(precision + 1));
            }
            case -1: {
                return new StringReaderWithLength(TriggerTest.randomString(r, r.nextInt(32701)));
            }
            case 2005: {
                if (precision > 262144) {
                    precision = 262144;
                }
                return new StringReaderWithLength(TriggerTest.randomString(r, r.nextInt(precision)));
            }
            case -3: 
            case -2: {
                return TriggerTest.randomBinary(r, r.nextInt(precision + 1));
            }
            case -4: {
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(r, r.nextInt(32701)));
            }
            case 2004: {
                if (precision > 262144) {
                    precision = 262144;
                }
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(r, r.nextInt(precision)));
            }
            case 2009: {
                return new StringReaderWithLength("<a><b>text</b></a>");
            }
        }
        return null;
    }

    private static byte[] randomBinary(Random r, int len) {
        byte[] bb = new byte[len];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = (byte)r.nextInt();
        }
        return bb;
    }

    private static String randomString(Random r, int len) {
        char[] cb = new char[len];
        for (int i = 0; i < cb.length; ++i) {
            cb[i] = (char)r.nextInt(65535);
        }
        return new String(cb);
    }
}

