/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;

public abstract class StringColumnVTI
extends VTITemplate {
    private String[] _columnNames;
    private boolean _lastColumnWasNull;

    protected abstract String getRawColumn(int var1) throws SQLException;

    public StringColumnVTI(String[] columnNames) {
        this._columnNames = columnNames;
    }

    public boolean wasNull() throws SQLException {
        return this._lastColumnWasNull;
    }

    public int findColumn(String columnName) throws SQLException {
        int count = this._columnNames.length;
        for (int i = 0; i < count; ++i) {
            if (!this._columnNames[i].equals(columnName)) continue;
            return i + 1;
        }
        throw new SQLException("Unknown column name.");
    }

    public String getString(int columnIndex) throws SQLException {
        String columnValue = this.getRawColumn(columnIndex);
        this.checkNull(columnValue);
        return columnValue;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return false;
        }
        return Boolean.valueOf(columnValue);
    }

    public byte getByte(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Byte.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Short.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Integer.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0L;
        }
        try {
            return Long.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(columnValue).floatValue();
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        try {
            return new BigDecimal(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        try {
            return columnValue.getBytes("UTF-8");
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Date(this.parseDateTime(columnValue));
    }

    public Time getTime(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Time(this.parseDateTime(columnValue));
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Timestamp(this.parseDateTime(columnValue));
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        return this.getEncodedStream(columnValue, "US-ASCII");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getBytes(columnIndex));
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new SimpleBlob(this.getBytes(columnIndex));
    }

    public Clob getClob(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new SimpleClob(this.getString(columnIndex));
    }

    private void checkNull(String columnValue) {
        this._lastColumnWasNull = columnValue == null;
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage());
    }

    private long parseDateTime(String columnValue) throws SQLException {
        try {
            DateFormat df = DateFormat.getDateTimeInstance();
            java.util.Date rawDate = df.parse(columnValue);
            return rawDate.getTime();
        }
        catch (ParseException e) {
            throw this.wrap(e);
        }
    }

    private InputStream getEncodedStream(String columnValue, String encoding) throws SQLException {
        if (columnValue == null) {
            return null;
        }
        try {
            byte[] rawBytes = columnValue.getBytes(encoding);
            return new ByteArrayInputStream(rawBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw this.wrap(e);
        }
    }

    public static final class SimpleClob
    implements Clob {
        private String _contents;

        public SimpleClob(String contents) {
            this._contents = contents;
        }

        @Override
        public InputStream getAsciiStream() {
            try {
                return new ByteArrayInputStream(this._contents.getBytes("UTF-8"));
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Reader getCharacterStream() {
            return new CharArrayReader(this._contents.toCharArray());
        }

        @Override
        public String getSubString(long position, int length) {
            return this._contents.substring((int)position, length);
        }

        @Override
        public long length() {
            if (this._contents == null) {
                return 0L;
            }
            return this._contents.length();
        }

        @Override
        public long position(Clob searchstr, long start) {
            return 0L;
        }

        @Override
        public long position(String searchstr, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Clob)) {
                return false;
            }
            Clob that = (Clob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getAsciiStream();
                InputStream thatStream = that.getAsciiStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        @Override
        public int setString(long arg0, String arg1) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public int setString(long arg0, String arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public OutputStream setAsciiStream(long arg0) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public Writer setCharacterStream(long arg0) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public void free() throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }

    public static final class SimpleBlob
    implements Blob {
        private byte[] _bytes;

        public SimpleBlob(byte[] bytes) {
            this._bytes = bytes;
        }

        @Override
        public InputStream getBinaryStream() {
            return new ByteArrayInputStream(this._bytes);
        }

        @Override
        public byte[] getBytes(long position, int length) {
            return this._bytes;
        }

        @Override
        public long length() {
            if (this._bytes == null) {
                return 0L;
            }
            return this._bytes.length;
        }

        @Override
        public long position(Blob pattern, long start) {
            return 0L;
        }

        @Override
        public long position(byte[] pattern, long start) {
            return 0L;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Blob)) {
                return false;
            }
            Blob that = (Blob)other;
            try {
                int nextByte;
                if (this.length() != that.length()) {
                    return false;
                }
                InputStream thisStream = this.getBinaryStream();
                InputStream thatStream = that.getBinaryStream();
                while ((nextByte = thisStream.read()) >= 0) {
                    if (nextByte == thatStream.read()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
            return true;
        }

        @Override
        public int setBytes(long arg0, byte[] arg1) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public OutputStream setBinaryStream(long arg0) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public void truncate(long arg0) throws SQLException {
            throw new SQLException("not implemented");
        }

        @Override
        public void free() throws SQLException {
            throw new SQLException("not implemented for this test");
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            throw new SQLException("not implemented for this test");
        }
    }
}

