/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class ShutdownDatabase {
    public static void main(String[] args) {
        try {
            ShutdownDatabase.testShutDownWithCommitedTransaction();
            ShutdownDatabase.testShutDownWithRollbackedTransaction();
            ShutdownDatabase.testShutDownWithLeftTransaction();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void testShutDownWithCommitedTransaction() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ShutdownDatabase.testOnlyTransactionWasCommited();
        ShutdownDatabase.testTwiceCommited();
        ShutdownDatabase.testOnceRollbackedAndCommited();
    }

    private static void testShutDownWithRollbackedTransaction() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ShutdownDatabase.testOnlyTransactionWasRollbacked();
        ShutdownDatabase.testOnceCommitedAndRollbacked();
        ShutdownDatabase.testTwiceRollbacked();
    }

    private static void testShutDownWithLeftTransaction() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ShutdownDatabase.testOnlyTransactionWasLeft();
        ShutdownDatabase.testOnceCommitedAndLeft();
        ShutdownDatabase.testOnceRollbackedAndLeft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnlyTransactionWasCommited() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnlyTransactionWasCommitedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnlyTransactionWasCommitedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.commit();
            ShutdownDatabase.shutdownDatabase("testOnlyTransactionWasCommitedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnlyTransactionWasCommitedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testTwiceCommited() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testTwiceCommitedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testTwiceCommitedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.commit();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            conn.commit();
            ShutdownDatabase.shutdownDatabase("testTwiceCommitedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testTwiceCommitedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnceRollbackedAndCommited() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnceRollbackedAndCommitedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnceRollbackedAndCommitedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.rollback();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            conn.commit();
            ShutdownDatabase.shutdownDatabase("testOnceRollbackedAndCommitedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnceRollbackedAndCommitedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnlyTransactionWasRollbacked() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnlyTransactionWasRollbackedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnlyTransactionWasRollbackedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.rollback();
            ShutdownDatabase.shutdownDatabase("testOnlyTransactionWasRollbackedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnlyTransactionWasRollbackedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnceCommitedAndRollbacked() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnceCommitedAndRollbackedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnceCommitedAndRollbackedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.commit();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            conn.rollback();
            ShutdownDatabase.shutdownDatabase("testOnceCommitedAndRollbackedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnceCommitedAndRollbackedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testTwiceRollbacked() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testTwiceRollbackedDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testTwiceRollbackedDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.rollback();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            conn.rollback();
            ShutdownDatabase.shutdownDatabase("testTwiceRollbackedDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testTwiceRollbackedDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnlyTransactionWasLeft() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnlyTransactionWasLeftDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnlyTransactionWasLeftDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            ShutdownDatabase.shutdownDatabase("testOnlyTransactionWasLeftDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnlyTransactionWasLeftDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnceCommitedAndLeft() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnceCommitedAndLeftDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnceCommitedAndLeftDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.commit();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            ShutdownDatabase.shutdownDatabase("testOnceCommitedAndLeftDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnceCommitedAndLeftDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testOnceRollbackedAndLeft() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String dbname = "testOnceRollbackedAndLeftDB";
        Connection conn = null;
        try {
            conn = ShutdownDatabase.openConnectionToNewDatabase("testOnceRollbackedAndLeftDB");
            ShutdownDatabase.createTestTable(conn);
            conn.setAutoCommit(false);
            ShutdownDatabase.insertIntoTestTable(conn, 1, 1000);
            conn.rollback();
            ShutdownDatabase.insertIntoTestTable(conn, 1001, 999);
            ShutdownDatabase.shutdownDatabase("testOnceRollbackedAndLeftDB");
        }
        catch (SQLException e) {
            ShutdownDatabase.verifyShutdownError(e);
        }
        conn = null;
        try {
            conn = ShutdownDatabase.reopenConnectionToDatabase("testOnceRollbackedAndLeftDB");
            ShutdownDatabase.countRowInTestTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }

    private static Connection openConnectionToNewDatabase(String databaseName) throws SQLException {
        Connection conn = TestUtil.getConnection(databaseName, "create=true");
        System.out.println("A connection to " + databaseName + " was opened.");
        return conn;
    }

    private static Connection reopenConnectionToDatabase(String databaseName) throws SQLException {
        return TestUtil.getConnection(databaseName, null);
    }

    private static void shutdownDatabase(String databaseName) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestUtil.getConnection(databaseName, "shutdown=true");
        System.out.println(databaseName + " was shut down.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTestTable(Connection conn) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("create table TEST_TABLE ( TEST_COL integer )");
        }
        finally {
            if (st != null) {
                st.close();
                st = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertIntoTestTable(Connection conn, int val) throws SQLException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement("insert into TEST_TABLE ( TEST_COL ) values( ? )");
            st.setInt(1, val);
            st.execute();
        }
        finally {
            if (st != null) {
                st.close();
                st = null;
            }
        }
    }

    private static void insertIntoTestTable(Connection conn, int initialval, int count) throws SQLException {
        for (int i = initialval; i < initialval + count; ++i) {
            ShutdownDatabase.insertIntoTestTable(conn, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void countRowInTestTable(Connection conn) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("select count(*) from TEST_TABLE ");
            rs.next();
            System.out.println(rs.getInt(1));
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (st != null) {
                st.close();
                st = null;
            }
        }
    }

    private static void verifyShutdownError(SQLException e) throws SQLException {
        if (!ShutdownDatabase.isShutdownError(e)) {
            throw e;
        }
        System.out.println("SQLException of shutting down was found.");
    }

    private static boolean isShutdownError(SQLException e) {
        return e.getSQLState().equals(StandardException.getSQLStateFromIdentifier((String)"08006.D"));
    }
}

