/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SecurityPolicyReloadingTest
extends BaseJDBCTestCase {
    private static final String RELOADABLE_INITIAL_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.initial.policy";
    private static final String RELOADABLE_MODIFIED_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.modified.policy";
    private static final String UNRELOADABLE_SOURCE_POLICY = "functionTests/tests/lang/SecurityPolicyReloadingTest.unreloadable.policy";
    private static final String TARGET_POLICY = "server.policy";
    private static final String NON_DBO_USER = "NON_DBO_USER";
    private static final String PASSWORD_TOKEN = "PASSWORD_TOKEN";

    public SecurityPolicyReloadingTest() {
        super("testPolicyReloading");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SecurityPolicyReloadingTest");
        if (!TestConfiguration.loadingFromJars()) {
            return suite;
        }
        suite.addTest(SecurityPolicyReloadingTest.decorateTest());
        return suite;
    }

    private static Test decorateTest() {
        SecurityPolicyReloadingTest undecoratedTest;
        Object test = undecoratedTest = new SecurityPolicyReloadingTest();
        test = new SecurityManagerSetup((Test)test, undecoratedTest.makeServerPolicyName());
        test = TestConfiguration.sqlAuthorizationDecorator((Test)test, new String[]{NON_DBO_USER}, PASSWORD_TOKEN);
        test = new SupportFilesSetup((Test)test, null, new String[]{undecoratedTest.getSourcePolicy()}, null, new String[]{undecoratedTest.makeTargetPolicyStub()});
        test = SecurityManagerSetup.noSecurityManager((Test)test);
        return test;
    }

    public void testPolicyReloading() throws Exception {
        this.doPolicyReloadingIsGranted();
        this.doPolicyReloadingIsNotGranted();
    }

    private void doPolicyReloadingIsGranted() throws Exception {
        this.dbaTest();
        this.nonDbaTest();
    }

    private void dbaTest() throws Exception {
        Connection conn = this.openUserConnection("TEST_DBO");
        SecurityPolicyReloadingTest.assertTrue((String)"Initially, should be able to read property.", (boolean)this.canReadProperty());
        this.changePolicyFile(conn, RELOADABLE_MODIFIED_SOURCE_POLICY, true, null);
        SecurityPolicyReloadingTest.assertFalse((String)"Policy file changed. Should not be able to read the property.", (boolean)this.canReadProperty());
        this.changePolicyFile(conn, RELOADABLE_INITIAL_SOURCE_POLICY, true, null);
        SecurityPolicyReloadingTest.assertTrue((String)"Reverted to initial policy. Should be able to read the property again.", (boolean)this.canReadProperty());
        conn.close();
    }

    private void nonDbaTest() throws Exception {
        String reservedToDBO = "42504";
        Connection conn = this.openUserConnection(NON_DBO_USER);
        SecurityPolicyReloadingTest.assertTrue((String)"Initially, should be able to read property.", (boolean)this.canReadProperty());
        this.changePolicyFile(conn, RELOADABLE_MODIFIED_SOURCE_POLICY, false, reservedToDBO);
        SecurityPolicyReloadingTest.assertTrue((String)"Policy file not changed. Should still be able to read the property.", (boolean)this.canReadProperty());
        this.changePolicyFile(conn, RELOADABLE_INITIAL_SOURCE_POLICY, false, reservedToDBO);
        SecurityPolicyReloadingTest.assertTrue((String)"Reverted to initial policy. Should still be able to read the property again.", (boolean)this.canReadProperty());
        conn.close();
    }

    private void doPolicyReloadingIsNotGranted() throws Exception {
        String insufficientPrivilege = "XK000";
        Connection conn = this.openUserConnection("TEST_DBO");
        this.changePolicyFile(conn, UNRELOADABLE_SOURCE_POLICY, true, null);
        this.changePolicyFile(conn, RELOADABLE_INITIAL_SOURCE_POLICY, false, insufficientPrivilege);
        conn.close();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SecurityPolicyReloadingTest( ");
        buffer.append(" )");
        return buffer.toString();
    }

    private boolean canReadProperty() throws Exception {
        try {
            String propValue = SecurityPolicyReloadingTest.readProperty("SecurityPolicyReloadingTest.property");
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    public static String readProperty(String propName) throws Exception {
        PropReadingAction action = new PropReadingAction(propName);
        return (String)AccessController.doPrivileged(action);
    }

    public static void sleep(long numberOfSeconds) throws Exception {
        Thread.currentThread();
        Thread.sleep(numberOfSeconds * 1000L);
    }

    private void changePolicyFile(Connection conn, String newPolicyFileName, boolean shouldSucceed, String expectedSQLState) throws Exception {
        boolean reloaded = true;
        this.writePolicyFile(newPolicyFileName);
        CallableStatement cs = conn.prepareCall("call SYSCS_UTIL.RELOAD_SECURITY_POLICY()");
        try {
            cs.execute();
        }
        catch (SQLException se) {
            reloaded = false;
            SecurityPolicyReloadingTest.assertSQLState(expectedSQLState, se);
        }
        SecurityPolicyReloadingTest.assertEquals((boolean)shouldSucceed, (boolean)reloaded);
    }

    private void writePolicyFile(String newPolicyFileName) throws Exception {
        SupportFilesSetup.privCopyFiles("extinout", new String[]{newPolicyFileName}, new String[]{this.makeTargetPolicyStub()});
    }

    private String makeServerPolicyName() {
        try {
            String userDir = SecurityPolicyReloadingTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + this.makeTargetPolicyStub();
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught by makeServerPolicyName(): " + e);
            return null;
        }
    }

    private String makeTargetPolicyStub() {
        return TARGET_POLICY;
    }

    private String getSourcePolicy() {
        return RELOADABLE_INITIAL_SOURCE_POLICY;
    }

    public static class PropReadingAction
    implements PrivilegedExceptionAction {
        private final String _propName;

        public PropReadingAction(String propName) {
            this._propName = propName;
        }

        public Object run() throws Exception {
            return System.getProperty(this._propName);
        }
    }
}

