/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollCursors1Test
extends BaseJDBCTestCase {
    public ScrollCursors1Test(String name) {
        super(name);
    }

    public void testForwardOnlyNegative() throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement ps_c1 = conn.prepareStatement("select i from t1");
        ResultSet rs = ps_c1.executeQuery();
        try {
            rs.getRow();
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.fail((String)"getRow succeeded on forward only cursor");
            }
        }
        catch (SQLException se) {
            ScrollCursors1Test.assertSQLState("XJ061", se);
        }
        try {
            rs.first();
            ScrollCursors1Test.fail((String)"first() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.last();
            ScrollCursors1Test.fail((String)"last() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.previous();
            ScrollCursors1Test.fail((String)"previous() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.beforeFirst();
            ScrollCursors1Test.fail((String)"beforeFirst() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.afterLast();
            ScrollCursors1Test.fail((String)"afterLast() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.absolute(1);
            ScrollCursors1Test.fail((String)"absolute() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        try {
            rs.relative(1);
            ScrollCursors1Test.fail((String)"relative() not allowed on forward only result set");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("XJ061", se);
            }
            ScrollCursors1Test.assertSQLState("XJ125", se);
        }
        rs.close();
        ps_c1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScrollInsensitive() throws SQLException {
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(2);
            PreparedStatement ps_c1 = conn.prepareStatement("select * from t1 order by c50", 1004, 1007);
            ResultSet rs = ps_c1.executeQuery();
            rs.absolute(0);
            this.assertNoCurrentRow(rs);
            rs.close();
            rs = ps_c1.executeQuery();
            rs.relative(0);
            this.assertNoCurrentRow(rs);
            rs.close();
            rs = ps_c1.executeQuery();
            rs.relative(2);
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            rs.close();
            rs = ps_c1.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.first();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"d", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)4, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getRow());
            rs.first();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.afterLast();
            this.assertNoCurrentRow(rs);
            ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
            ScrollCursors1Test.assertFalse((boolean)rs.next());
            this.assertNoCurrentRow(rs);
            ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"l", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)11, (int)rs.getRow());
            rs.last();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.beforeFirst();
            this.assertNoCurrentRow(rs);
            ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.absolute(12);
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.absolute(-11);
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.absolute(13);
            this.assertNoCurrentRow(rs);
            ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
            rs.absolute(-1);
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.last();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            ScrollCursors1Test.assertFalse((boolean)rs.next());
            this.assertNoCurrentRow(rs);
            rs.last();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"l", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)11, (int)rs.getRow());
            rs.first();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.next();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.afterLast();
            this.assertNoCurrentRow(rs);
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"l", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)11, (int)rs.getRow());
            rs.close();
            ps_c1.close();
            ps_c1 = conn.prepareStatement("select * from t1 where i >=11 order by c50", 1004, 1007);
            rs = ps_c1.executeQuery();
            rs.next();
            ScrollCursors1Test.assertEquals((String)"k", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)11, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.next();
            ScrollCursors1Test.assertEquals((String)"l", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.last();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getRow());
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"l", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getRow());
            rs.afterLast();
            this.assertNoCurrentRow(rs);
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.afterLast();
            this.assertNoCurrentRow(rs);
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getRow());
            rs.close();
            ps_c1.close();
            ps_c1 = conn.prepareStatement("select i from t1 order by c50", 1004, 1007);
            rs = ps_c1.executeQuery();
            rs.absolute(5);
            ScrollCursors1Test.assertEquals((int)6, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)5, (int)rs.getRow());
            rs.absolute(-5);
            ScrollCursors1Test.assertEquals((int)9, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)8, (int)rs.getRow());
            rs.absolute(5);
            ScrollCursors1Test.assertEquals((int)6, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)5, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.absolute(13);
            this.assertNoCurrentRow(rs);
            rs.previous();
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.absolute(-13);
            this.assertNoCurrentRow(rs);
            rs.next();
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.relative(11);
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.relative(1);
            this.assertNoCurrentRow(rs);
            rs.last();
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)12, (int)rs.getRow());
            rs.relative(-11);
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getRow());
            rs.close();
            ps_c1.close();
            conn.commit();
            ps_c1 = conn.prepareStatement("Select i from t1 order by c50", 1005, 1007);
            rs = ps_c1.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            rs.next();
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(1));
            Statement s = conn.createStatement();
            s.executeUpdate("update t1 set i = 666 where i = 2");
            rs.first();
            conn.rollback();
            rs.close();
            ps_c1 = conn.prepareStatement("select i from t1 order by c50", 1004, 1007);
            rs = ps_c1.executeQuery();
            PreparedStatement ps_c2 = conn.prepareStatement("select i from t1 order by c50");
            ResultSet rs2 = ps_c2.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            rs2.next();
            ScrollCursors1Test.assertEquals((int)2, (int)rs2.getInt(1));
            try {
                rs2.first();
                ScrollCursors1Test.fail((String)"first() not allowed on forward only result set");
            }
            catch (SQLException se) {
                if (ScrollCursors1Test.usingEmbedded()) {
                    ScrollCursors1Test.assertSQLState("XJ061", se);
                }
                ScrollCursors1Test.assertSQLState("XJ125", se);
            }
            rs.close();
            rs2.close();
            ps_c1.close();
            ps_c1.close();
            ps_c1 = conn.prepareStatement("select i from t1 where 1=0", 1004, 1007);
            rs = ps_c1.executeQuery();
            rs.first();
            this.assertNoCurrentRow(rs);
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.next();
            this.assertNoCurrentRow(rs);
            rs.last();
            this.assertNoCurrentRow(rs);
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.absolute(1);
            this.assertNoCurrentRow(rs);
            rs.absolute(-1);
            this.assertNoCurrentRow(rs);
            ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
            rs.close();
            rs = ps_c1.executeQuery();
            rs.afterLast();
            this.assertNoCurrentRow(rs);
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.beforeFirst();
            this.assertNoCurrentRow(rs);
            rs.next();
            this.assertNoCurrentRow(rs);
            rs.close();
            rs = ps_c1.executeQuery();
            rs.absolute(1);
            this.assertNoCurrentRow(rs);
            rs.absolute(-1);
            this.assertNoCurrentRow(rs);
            rs.close();
            rs = ps_c1.executeQuery();
            rs.absolute(-1);
            this.assertNoCurrentRow(rs);
            rs.absolute(1);
            this.assertNoCurrentRow(rs);
            rs.close();
            conn.setAutoCommit(false);
            rs = ps_c1.executeQuery();
            rs = ps_c1.executeQuery();
            rs.first();
            this.assertNoCurrentRow(rs);
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.next();
            this.assertNoCurrentRow(rs);
            rs.last();
            this.assertNoCurrentRow(rs);
            rs.previous();
            this.assertNoCurrentRow(rs);
            rs.absolute(1);
            this.assertNoCurrentRow(rs);
            rs.absolute(-1);
            this.assertNoCurrentRow(rs);
            rs.next();
            this.assertNoCurrentRow(rs);
            rs.next();
            this.assertNoCurrentRow(rs);
            rs.close();
            ps_c1.close();
            ps_c1 = conn.prepareStatement("select * from t1 order by i desc", 1004, 1007);
            rs = ps_c1.executeQuery();
            rs.last();
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            rs.first();
            ScrollCursors1Test.assertEquals((String)"m", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)13, (int)rs.getInt(2));
            rs.relative(11);
            ScrollCursors1Test.assertEquals((String)"b", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
            rs.previous();
            ScrollCursors1Test.assertEquals((String)"c", (String)rs.getString(1).trim());
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(2));
            rs.close();
            ps_c1.close();
        }
        finally {
            conn.commit();
            conn.close();
        }
    }

    public void testNoHoldScrollableResults() throws SQLException {
        Connection conn = this.getConnection();
        conn.setHoldability(2);
        conn.setTransactionIsolation(2);
        Statement s = this.createStatement();
        s.executeUpdate("create table big(a int generated always as identity)");
        for (int i = 0; i < 10; ++i) {
            s.executeUpdate("insert into big values(default)");
        }
        PreparedStatement ps_c1 = conn.prepareStatement("select * from big b1 left outer join  big b2 on b1.a = b2.a left outer join  big b3 on b2.a = b3.a left outer join big b4 on b3.a = b4.a left outer join (big b5 left outer join (big b6 left outer join (big b7 left outer join big b8 on b7.a = b8.a) on b6.a=b7.a) on b5.a = b6.a) on b4.a = b5.a");
        ResultSet rs = ps_c1.executeQuery();
        rs.close();
        conn.commit();
        s.executeUpdate("drop table big");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleScrollCursors() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        try {
            s.executeUpdate("create table t (a int)");
            PreparedStatement ps = conn.prepareStatement("insert into t values (?)");
            for (int i = 1; i <= 5; ++i) {
                ps.setInt(1, i);
                ps.executeUpdate();
            }
            ps.close();
            PreparedStatement ps_c1 = conn.prepareStatement("select * from t order by a", 1004, 1007);
            ResultSet rs = ps_c1.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
            rs.next();
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            rs.previous();
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
            rs.last();
            ScrollCursors1Test.assertEquals((int)5, (int)rs.getInt(1));
            rs.absolute(2);
            ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(1));
            rs.relative(2);
            ScrollCursors1Test.assertEquals((int)4, (int)rs.getInt(1));
            rs.close();
            rs = ps_c1.executeQuery();
            rs.next();
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
            rs.close();
            rs = ps_c1.executeQuery();
            rs.last();
            ScrollCursors1Test.assertEquals((int)5, (int)rs.getInt(1));
            rs.close();
            rs = ps_c1.executeQuery();
            rs.absolute(3);
            ScrollCursors1Test.assertEquals((int)3, (int)rs.getInt(1));
            rs.next();
            ScrollCursors1Test.assertEquals((int)4, (int)rs.getInt(1));
            rs.close();
            ps_c1.close();
            s.executeUpdate("create table tab1 (a int)");
            PreparedStatement is = conn.prepareStatement("insert into tab1 values (?)");
            for (int i = 1; i <= 70; ++i) {
                is.setInt(1, i);
                is.executeUpdate();
            }
            ps_c1 = conn.prepareStatement("select * from tab1 order by a", 1004, 1007);
            rs = ps_c1.executeQuery();
            rs.first();
            ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
            rs.last();
            ScrollCursors1Test.assertEquals((int)70, (int)rs.getInt(1));
            rs.absolute(65);
            ScrollCursors1Test.assertEquals((int)65, (int)rs.getInt(1));
            rs.absolute(-1);
            ScrollCursors1Test.assertEquals((int)70, (int)rs.getInt(1));
            rs.close();
            ps_c1.close();
            ps_c1 = conn.prepareStatement("select * from t1 order by c50", 1005, 1007);
            rs = ps_c1.executeQuery();
            rs.close();
            ps_c1.close();
            rs.close();
            s.executeUpdate("drop table tab1");
            s.executeUpdate("create table tab1(i1 bigint not null, c1 varchar(64) not null)");
            s.executeUpdate("create table tab2 (i2 bigint not null, c2 varchar(64) not null)");
            s.executeUpdate("insert into tab1 values (1, 'String 1')");
            s.executeUpdate("insert into tab1 values (2, 'String 2')");
            s.executeUpdate("insert into tab2 values (1, 'String 1')");
            s.executeUpdate("insert into tab2 values (3, 'String 3')");
            rs = s.executeQuery("select c1 from tab1 right outer join tab2 on (i1=i2)");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"String 1"}, {null}});
            rs = s.executeQuery("select c2 from tab1 right outer join tab2 on (i1=i2)");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"String 1"}, {"String 3"}});
            rs = s.executeQuery("select c1 from tab1 left outer join tab2 on (i1=i2)");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"String 1"}, {"String 2"}});
            rs = s.executeQuery("select c2 from tab1 left outer join tab2 on (i1=i2)");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"String 1"}, {null}});
            s.executeUpdate("drop table t");
            s.executeUpdate("drop table tab1");
            s.executeUpdate("drop table tab2");
        }
        finally {
            s.close();
            conn.close();
        }
    }

    public void testScrollCursors3() throws SQLException {
        Connection conn = this.getConnection();
        Connection conn2 = this.openDefaultConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table u1.t1(c1 int, c2 int)");
        s.executeUpdate("insert into u1.t1 values (1, 2), (3, 4), (5, 6), (7, 8), (9, 10)");
        PreparedStatement ps_c1 = conn.prepareStatement("select * from u1.t1 order by c1", 1004, 1007);
        ResultSet rs = ps_c1.executeQuery();
        PreparedStatement ps_c2 = conn2.prepareStatement("select * from u1.t1 order by c1", 1004, 1007);
        ResultSet rs2 = ps_c2.executeQuery();
        rs.next();
        ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
        rs2.next();
        ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
        rs.last();
        ScrollCursors1Test.assertEquals((int)9, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)10, (int)rs.getInt(2));
        rs2.last();
        ScrollCursors1Test.assertEquals((int)9, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)10, (int)rs.getInt(2));
        rs.previous();
        ScrollCursors1Test.assertEquals((int)7, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)8, (int)rs.getInt(2));
        rs2.close();
        rs.first();
        ScrollCursors1Test.assertEquals((int)1, (int)rs.getInt(1));
        ScrollCursors1Test.assertEquals((int)2, (int)rs.getInt(2));
        rs.close();
        s.executeUpdate("drop table u1.t1");
        s.close();
        ps_c1.close();
        ps_c2.close();
    }

    private void assertNoCurrentRow(ResultSet rs) throws SQLException {
        try {
            rs.getString(1);
            ScrollCursors1Test.fail((String)"getString not allowed after beforeFirst()");
        }
        catch (SQLException se) {
            if (ScrollCursors1Test.usingEmbedded()) {
                ScrollCursors1Test.assertSQLState("24000", se);
            }
            ScrollCursors1Test.assertSQLState("XJ121", se);
        }
        ScrollCursors1Test.assertEquals((int)0, (int)rs.getRow());
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(ScrollCursors1Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create table t1(c50 char(50), i int)");
                s.executeUpdate(" create table t2(c50 char(50), i int)");
                s.executeUpdate("insert into t1 values ('b', 2), ('c', 3), ('d', 4), ('e', 5),                   ('f', 6), ('g', 7), ('h', 8), ('i', 9),                   ('j', 10), ('k', 11), ('l', 12), ('m', 13)");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ScrollCursors1");
        suite.addTest(ScrollCursors1Test.baseSuite("ScrollCursors1:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ScrollCursors1Test.baseSuite("ScrollCursors1:client")));
        return suite;
    }
}

