/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RoutineSecurityTest
extends BaseJDBCTestCase {
    public RoutineSecurityTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(RoutineSecurityTest.class);
        return new CleanDatabaseTestSetup(suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("CREATE FUNCTION GET_SYS_PROP(PROPERTY_KEY VARCHAR(60)) RETURNS VARCHAR(255) EXTERNAL NAME 'java.lang.System.getProperty' LANGUAGE JAVA PARAMETER STYLE JAVA");
                s.executeUpdate("CREATE PROCEDURE DENIAL_OF_SERVICE(RC INT) EXTERNAL NAME 'java.lang.System.exit' LANGUAGE JAVA PARAMETER STYLE JAVA");
                s.executeUpdate("CREATE PROCEDURE FORCEGC() EXTERNAL NAME 'java.lang.System.gc' LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
        };
    }

    public void testGetSystemProperty() throws SQLException {
        if (this.isAvoidGFXDBugs()) {
            RoutineSecurityTest.fail((String)"Fast-failing test because gemfirexd does not use a security manager");
        }
        PreparedStatement ps = this.prepareStatement("VALUES GET_SYS_PROP(?)");
        String[] restricted = new String[]{"gemfirexd.system.home", "user.dir", "java.class.path", "java.home", "derbyRoutineSecurityTest.no", "derbyTesting.fred"};
        for (int i = 0; i < restricted.length; ++i) {
            ps.setString(1, restricted[i]);
            try {
                ResultSet rs = ps.executeQuery();
                rs.next();
                RoutineSecurityTest.fail((String)("Succeeded reading " + restricted[i] + rs.getString(1)));
                continue;
            }
            catch (SQLException e) {
                this.assertSecurityException(e);
            }
        }
        String[] notRestrictedAndGranted = new String[]{"java.version", "java.specification.name", "derbyRoutineSecurityTest.yes"};
        for (int i = 0; i < notRestrictedAndGranted.length; ++i) {
            ps.setString(1, notRestrictedAndGranted[i]);
            ResultSet rs = ps.executeQuery();
            rs.next();
            rs.getString(1);
            rs.close();
        }
        ps.close();
    }

    public void _DISABLED_testSystemExit() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL DENIAL_OF_SERVICE(?)");
        cs.setInt(1, -1);
        try {
            cs.executeUpdate();
            RoutineSecurityTest.fail((String)"Tough to get here since exit would have been called.");
        }
        catch (SQLException e) {
            this.assertSecurityException(e);
        }
        cs.setInt(1, 0);
        try {
            cs.executeUpdate();
            RoutineSecurityTest.fail((String)"Tough to get here since exit would have been called.");
        }
        catch (SQLException e) {
            this.assertSecurityException(e);
        }
        cs.close();
    }

    public void testSystemGC() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL FORCEGC()");
        cs.executeUpdate();
        cs.close();
    }

    public void testInternalClass() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE FUNCTION HACK_DERBY(PROPERTY_KEY VARCHAR(60)) RETURNS VARCHAR(60) EXTERNAL NAME 'com.pivotal.gemfirexd.internal.catalog.SystemProcedures.GET_DATABASE_PROPERTY' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE PROCEDURE HACK_DERBY_2() EXTERNAL NAME 'com.pivotal.gemfirexd.internal.catalog.SystemProcedures.UNFREEZE_DATABASE' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.executeUpdate("CREATE PROCEDURE HACK_DERBY_3() EXTERNAL NAME 'com.pivotal.gemfirexd.internal.any.clazz.method' LANGUAGE JAVA PARAMETER STYLE JAVA");
        s.close();
        this.assertCompileError("42X51", "VALUES HACK_DERBY(?)");
        this.assertCompileError("42X51", "CALL HACK_DERBY_2()");
        this.assertCompileError("42X51", "CALL HACK_DERBY_3()");
    }

    private void assertSecurityException(SQLException e) {
        RoutineSecurityTest.assertSQLState("38000", e);
        e = e.getNextException();
        RoutineSecurityTest.assertNotNull((Object)e);
        RoutineSecurityTest.assertSQLState("XJ001", e);
    }
}

