/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProcedureInTriggerTest
extends BaseJDBCTestCase {
    private static int zeroArgCount = 0;
    private static int getConnectionProcCount = 0;
    private static int selectRowsCount = 0;

    public ProcedureInTriggerTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        Statement s = this.createStatement();
        s.execute("delete from t1");
        s.execute("delete from t2");
        s.close();
    }

    public void testTriggerNoSql() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement();
        s.execute("create trigger after_stmt_trig_no_sql AFTER insert on t2 for each STATEMENT call proc_no_sql()");
        zeroArgCount = 0;
        s.execute("insert into t2 values (1,2), (2,4)");
        this.checkAndResetZeroArgCount(1);
        ResultSet rs = s.executeQuery("SELECT * FROM T2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop procedure proc_no_sql");
        ProcedureInTriggerTest.assertStatementError("42Y03", s, "insert into t2 values (1,2), (2,4)");
        s.execute("create procedure proc_no_sql() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
        s.execute("insert into t2 values (3,6)");
        this.checkAndResetZeroArgCount(1);
        rs = s.executeQuery("SELECT * FROM T2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}, {"3", "6"}});
        s.execute("create trigger after_row_trig_no_sql AFTER delete on t2 for each ROW call proc_no_sql()");
        s.execute("delete from t2");
        this.checkAndResetZeroArgCount(3);
        rs = s.executeQuery("select * from t2");
        JDBC.assertEmpty(rs);
        s.execute("drop trigger after_stmt_trig_no_sql");
        s.execute("drop trigger after_row_trig_no_sql");
        s.execute("create trigger before_stmt_trig_no_sql no cascade BEFORE insert on t2 for each STATEMENT call proc_no_sql()");
        s.execute("insert into t2 values (1,2), (2,4)");
        this.checkAndResetZeroArgCount(1);
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop procedure proc_no_sql");
        ProcedureInTriggerTest.assertStatementError("42Y03", s, "insert into t2 values (1,2), (2,4)");
        s.execute("create procedure proc_no_sql() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
        s.execute("insert into t2 values (3,6)");
        this.checkAndResetZeroArgCount(1);
        rs = s.executeQuery("SELECT * FROM T2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}, {"3", "6"}});
        s.execute("create trigger before_row_trig_no_sql no cascade BEFORE delete on t2 for each ROW call proc_no_sql()");
        s.execute("delete from t2");
        this.checkAndResetZeroArgCount(3);
        rs = s.executeQuery("select * from t2");
        JDBC.assertEmpty(rs);
        s.execute("drop trigger before_stmt_trig_no_sql");
        s.execute("drop trigger before_row_trig_no_sql");
        s.execute("insert into t2 values (1,2), (2,4)");
        s.close();
    }

    public void testBeforeTriggerExceptionRollback() throws SQLException {
        this.doTriggerExceptionRollback("no cascade before");
    }

    public void testAfterTriggerExceptionRollback() throws SQLException {
        this.doTriggerExceptionRollback("after");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTriggerExceptionRollback(String beforeOrAfter) throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement();
        s.execute("create trigger trig_exceptional " + beforeOrAfter + " insert on t2 for each STATEMENT call proc_exceptional()");
        try {
            s.execute("insert into t2 values (1,2), (2,4)");
            ProcedureInTriggerTest.fail((String)"no exception occurred from trigger trig_exceptional");
        }
        catch (SQLException sqle) {
            if (!sqle.getMessage().contains("FOOException")) {
                ProcedureInTriggerTest.fail((String)("got wrong exception: " + sqle.getMessage()));
            }
            ResultSet rs = s.executeQuery("SELECT * FROM T2");
            JDBC.assertEmpty(rs);
            rs.close();
        }
        finally {
            s.execute("drop trigger trig_exceptional");
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTriggerContainsSql() throws SQLException {
        if (this.isAvoidGFXDBugs()) {
            ProcedureInTriggerTest.fail((String)"Statement triggers not supported yet");
        }
        Statement s = this.createStatement();
        s.execute("insert into t2 values (1,2), (2,4)");
        try {
            s.execute("create trigger after_row_trig_contains_sql AFTER update on t2 for each ROW call proc_contains_sql()");
            s.execute("update t2 set x = x*2");
            this.checkAndResetGetConnectionProcCount(2);
            ResultSet rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"2", "2"}, {"4", "4"}});
            s.execute("create trigger before_stmt_trig_contains_sql no cascade BEFORE delete on t2 for each STATEMENT call proc_contains_sql()");
            s.execute("delete from t2");
            this.checkAndResetGetConnectionProcCount(1);
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
        }
        finally {
            s.execute("drop trigger after_row_trig_contains_sql");
            s.execute("drop trigger before_stmt_trig_contains_sql");
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTriggerReadsSql() throws SQLException {
        if (this.isAvoidGFXDBugs()) {
            ProcedureInTriggerTest.fail((String)"Statement triggers not supported yet");
        }
        Statement s = this.createStatement();
        s.execute("insert into t1 values (1, 'one')");
        try {
            s.execute("create trigger after_stmt_trig_reads_sql AFTER insert on t2 for each STATEMENT call proc_reads_sql(1)");
            selectRowsCount = 0;
            s.execute("insert into t2 values (1,2), (2,4)");
            this.checkAndResetSelectRowsCount(1);
            ResultSet rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
            s.execute("drop trigger after_stmt_trig_reads_sql");
            s.execute("create trigger before_row_trig_reads_sql no cascade BEFORE delete on t2 for each ROW call proc_reads_sql(1)");
            s.execute("delete from t2");
            this.checkAndResetSelectRowsCount(2);
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
        }
        finally {
            s.execute("drop trigger before_row_trig_reads_sql");
            s.execute("delete from t1");
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifiesSql() throws SQLException {
        if (this.isAvoidGFXDBugs()) {
            ProcedureInTriggerTest.fail((String)"Statement triggers not supported yet");
        }
        Statement s = this.createStatement();
        try {
            s.execute("create trigger after_stmt_trig_modifies_sql_insert_op AFTER insert on t2 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
            s.execute("insert into t2 values (1,2), (2,4)");
            ResultSet rs = s.executeQuery("select * from t1");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "one"}});
            rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
            s.execute("create trigger after_row_trig_modifies_sql_update_op AFTER update of x on t2 for each ROW call proc_modifies_sql_update_op(2)");
            s.execute("update t2 set x=x*2");
            rs = s.executeQuery("select * from t1");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"5", "one"}});
            rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"2", "2"}, {"4", "4"}});
            s.execute("create trigger after_stmt_trig_modifies_sql_delete_op AFTER delete on t2 for each STATEMENT call proc_modifies_sql_delete_op(5)");
            s.execute("delete from t2");
            rs = s.executeQuery("select * from t1");
            JDBC.assertEmpty(rs);
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
            s.execute("drop trigger after_stmt_trig_modifies_sql_insert_op");
            s.execute("drop trigger after_row_trig_modifies_sql_update_op");
            s.execute("drop trigger after_stmt_trig_modifies_sql_delete_op");
            s.execute("create trigger refer_new_row_trig AFTER insert on t2 REFERENCING NEW as new for each ROW call proc_modifies_sql_insert_op(new.x, 'new')");
            s.execute("insert into t2 values (25, 50)");
            rs = s.executeQuery("select * from t1");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"25", "new"}});
            rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"25", "50"}});
            s.execute("create trigger refer_old_row_trig AFTER delete on t2 REFERENCING OLD as old for each ROW call proc_modifies_sql_delete_op(old.x)");
            s.execute("delete from t2 where x=25");
            rs = s.executeQuery("select * from t1");
            JDBC.assertEmpty(rs);
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
            s.execute("drop trigger refer_new_row_trig");
            s.execute("drop trigger refer_old_row_trig");
            ProcedureInTriggerTest.assertStatementError("42Z9D", s, "create trigger before_trig_modifies_sql no cascade BEFORE insert on t2 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
            s.execute("create trigger bad_before_trig no cascade BEFORE insert on t2 for each STATEMENT call proc_wrongly_defined_as_no_sql(50, 'fifty')");
            try {
                s.execute("insert into t2 values (1,2), (2,4)");
            }
            catch (SQLException se) {
                ProcedureInTriggerTest.assertSQLState("38000", se);
                se = se.getNextException();
                ProcedureInTriggerTest.assertSQLState("38001", se);
            }
            rs = s.executeQuery("select * from t1");
            JDBC.assertEmpty(rs);
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
            s.execute("drop trigger bad_before_trig");
            s.execute("create trigger insert_trig AFTER update on t1 for each STATEMENT call proc_modifies_sql_insert_op(1, 'one')");
            s.execute("insert into t1 values(2, 'two')");
            s.execute("update t1 set i=i+1");
            rs = s.executeQuery("select * from t1");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"3", "two"}, {"1", "one"}});
            s.execute("drop trigger insert_trig");
            s.execute("create trigger update_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_update_op(2)");
            s.execute("insert into t1 values (4,'four')");
            rs = s.executeQuery("select * from t1");
            String[][] expectedRows = new String[][]{{"5", "two            "}, {"3", "one            "}, {"6", "four           "}};
            JDBC.assertUnorderedResultSet(rs, expectedRows);
            s.execute("drop trigger update_trig");
            s.execute("create trigger delete_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_delete_op(3)");
            s.execute("insert into t1 values (8,'eight')");
            rs = s.executeQuery("select * from t1");
            expectedRows = new String[][]{{"5", "two            "}, {"6", "four           "}, {"8", "eight          "}};
            JDBC.assertUnorderedResultSet(rs, expectedRows);
            s.execute("drop trigger delete_trig");
            s.execute("create trigger call_proc_in_default_schema AFTER insert on t2 for each STATEMENT call APP.proc_no_sql()");
            s.execute("insert into t2 values (1,2), (2,4)");
            rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
            s.execute("drop trigger call_proc_in_default_schema");
            s.execute("create trigger call_proc_in_default_schema no cascade BEFORE delete on t2 for each ROW call APP.proc_no_sql()");
            s.execute("delete from t2");
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
            s.execute("drop trigger call_proc_in_default_schema");
            s.execute("create trigger call_proc_in_new_schema no cascade BEFORE insert on t2 for each STATEMENT call new_schema.proc_in_new_schema()");
            s.execute("insert into t2 values (1,2), (2,4)");
            rs = s.executeQuery("select * from t2");
            JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
            s.execute("drop trigger call_proc_in_new_schema");
            s.execute("create trigger call_proc_in_new_schema AFTER delete on t2 for each ROW call new_schema.proc_in_new_schema()");
            s.execute("delete from t2");
            rs = s.executeQuery("select * from t2");
            JDBC.assertEmpty(rs);
        }
        finally {
            s.execute("drop table t1");
            s.execute("drop table t2");
            s.execute("create table t1 (i int primary key, b char(15))");
            s.execute("create table t2 (x integer, y integer)");
            s.close();
        }
    }

    public void testTriggerNegative() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement();
        ProcedureInTriggerTest.assertStatementError("42Y03", s, "create trigger call_non_existent_proc1 AFTER insert on t2 for each ROW call non_existent_proc()");
        ResultSet rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC1'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y03", s, "create trigger call_proc_with_non_existent_proc2 AFTER insert on t2 for each ROW call new_schema.non_existent_proc()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC2'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y07", s, "create trigger call_proc_in_non_existent_schema AFTER insert on t2 for each ROW call non_existent_schema.non_existent_proc()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_IN_NON_EXISTENT_SCHEMA'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42X50", s, "create trigger call_proc_using_non_existent_method AFTER insert on t2 for each ROW call proc_using_non_existent_method()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername as VARCHAR(128))='CALL_PROC_WITH_NON_EXISTENT_METHOD'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y03", s, "create trigger call_non_existent_proc1 no cascade BEFORE insert on t2 for each ROW call non_existent_proc()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_NON_EXISTENT_PROC1'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y07", s, "create trigger call_proc_in_non_existent_schema no cascade BEFORE insert on t2 for each ROW call non_existent_schema.non_existent_proc()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_IN_NON_EXISTENT_SCHEMA'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42X50", s, "create trigger call_proc_using_non_existent_method no cascade BEFORE insert on t2 for each ROW call proc_using_non_existent_method()");
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='CALL_PROC_WITH_NON_EXISTENT_METHOD'");
        JDBC.assertFullResultSet(rs, new String[][]{{"0"}});
        ProcedureInTriggerTest.assertStatementError("42Y27", s, "create trigger update_trig AFTER insert on t1 for each STATEMENT call proc_modifies_sql_update_op(?)");
        s.execute("insert into t2 values (1,2), (2,4)");
        s.execute("create trigger commit_trig AFTER delete on t2 for each STATEMENT call commit_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger commit_trig");
        s.execute("create trigger commit_trig no cascade BEFORE delete on t2 for each STATEMENT call commit_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger commit_trig");
        s.execute("create trigger rollback_trig AFTER delete on t2 for each STATEMENT call rollback_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger rollback_trig");
        s.execute("create trigger rollback_trig no cascade BEFORE delete on t2 for each STATEMENT call rollback_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger rollback_trig");
        s.execute("create trigger set_isolation_trig AFTER delete on t2 for each STATEMENT call set_isolation_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger set_isolation_trig");
        s.execute("create trigger set_isolation_trig no cascade BEFORE delete on t2 for each STATEMENT call set_isolation_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger set_isolation_trig");
        s.execute("create trigger select_from_trig_table AFTER insert on t1 for each STATEMENT call proc_reads_sql(1)");
        s.execute("insert into t1 values (10, 'ten')");
        rs = s.executeQuery("select * from t1");
        String[][] expectedRows = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}, {"10", "ten"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        s.execute("drop trigger select_from_trig_table");
        s.execute("create trigger select_from_trig_table no cascade before delete on t1 for each STATEMENT call proc_reads_sql(1)");
        s.execute("delete from t1 where i=10");
        rs = s.executeQuery("select * from t1");
        expectedRows = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        s.execute("drop trigger select_from_trig_table");
        s.execute("create trigger alter_table_trig AFTER delete on t1 for each STATEMENT call alter_table_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t1");
        rs = s.executeQuery("select * from t1");
        expectedRows = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        s.execute("create trigger drop_table_trig AFTER delete on t2 for each STATEMENT call drop_table_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        s.execute("drop trigger drop_table_trig");
        s.execute("create trigger create_trigger_trig AFTER delete on t1 for each STATEMENT call create_trigger_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t1");
        rs = s.executeQuery("select * from t1");
        expectedRows = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where  CAST(triggername AS VARCHAR(128))='TEST_TRIG'");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"0"}});
        s.execute("drop trigger create_trigger_trig");
        s.execute("create trigger test_trig AFTER delete on t1 for each STATEMENT insert into  t1 values(20, 'twenty')");
        s.execute("create trigger drop_trigger_trig AFTER delete on t2 for each STATEMENT call drop_trigger_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        rs = s.executeQuery("select count(*) from SYS.SYSTRIGGERS where CAST(triggername AS VARCHAR(128))='TEST_TRIG'");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1"}});
        s.execute("drop trigger drop_trigger_trig");
        s.execute("create trigger create_index_trig AFTER delete on t2 for each STATEMENT call create_index_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t2");
        rs = s.executeQuery("select * from t2");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1", "2"}, {"2", "4"}});
        rs = s.executeQuery("select count(*) from SYS.SYSCONGLOMERATES where CAST(CONGLOMERATENAME AS VARCHAR(128))='IX' and ISINDEX=1");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"0"}});
        s.execute("drop trigger create_index_trig");
        s.execute("create index ix on t1(i,b)");
        s.execute("create trigger drop_index_trig AFTER delete on t1 for each STATEMENT call drop_index_proc()");
        ProcedureInTriggerTest.assertStatementError("38000", s, "delete from t1");
        rs = s.executeQuery("select * from t1");
        expectedRows = new String[][]{{"5", "two"}, {"6", "four"}, {"8", "eight"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select count(*) from SYS.SYSCONGLOMERATES where CAST(CONGLOMERATENAME AS VARCHAR(128))='IX' and ISINDEX=1");
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"1"}});
        s.close();
    }

    private static Test basesuite() {
        TestSuite basesuite = new TestSuite(ProcedureInTriggerTest.class);
        CleanDatabaseTestSetup clean = new CleanDatabaseTestSetup((Test)basesuite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t1 (i int primary key, b char(15))");
                s.execute("create table t2 (x integer, y integer)");
                s.execute("create procedure proc_exceptional() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.exceptionMaker'");
                s.execute("create procedure proc_no_sql() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
                s.execute("create procedure proc_contains_sql() parameter style java language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.getConnectionProc'");
                s.execute("create procedure proc_reads_sql(i integer) parameter style java language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.selectRows' dynamic result sets 1");
                s.execute("create procedure proc_modifies_sql_insert_op(p1 int, p2 char(10)) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.insertRow'");
                s.execute("create procedure proc_modifies_sql_update_op(p1 int) parameter style java language java  MODIFIES SQL DATA  external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.updateRow'");
                s.execute("create procedure proc_modifies_sql_delete_op(p1 int) parameter style java language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.deleteRow'");
                s.execute("create procedure alter_table_proc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.alterTable'");
                s.execute("create procedure drop_table_proc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropTable'");
                s.execute("create procedure commit_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnCommit'");
                s.execute("create procedure rollback_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnRollback'");
                s.execute("create procedure set_isolation_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.doConnectionSetIsolation'");
                s.execute("create procedure create_index_proc() parameter style java dynamic result sets 0 language java  contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.createIndex'");
                s.execute("create procedure drop_index_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropIndex'");
                s.execute("create procedure create_trigger_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.createTrigger'");
                s.execute(" create procedure drop_trigger_proc() parameter style java dynamic result sets 0 language java contains sql external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.dropTrigger'");
                s.execute("create procedure proc_wrongly_defined_as_no_sql(p1 int, p2 char(10)) parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.insertRow'");
                s.execute("create schema new_schema");
                s.execute("create procedure new_schema.proc_in_new_schema() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.zeroArg'");
                s.execute("create procedure proc_using_non_existent_method() parameter style java language java NO SQL external name 'org.apache.derbyTesting.functionTests.tests.lang.ProcedureInTriggerTest.nonexistentMethod'");
            }
        };
        return clean;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        if (!JDBC.vmSupportsJSR169()) {
            suite.addTest(ProcedureInTriggerTest.basesuite());
            suite.addTest(TestConfiguration.clientServerDecorator(ProcedureInTriggerTest.basesuite()));
        }
        return suite;
    }

    private void checkAndResetZeroArgCount(int count) {
        ProcedureInTriggerTest.assertEquals((int)count, (int)zeroArgCount);
        zeroArgCount = 0;
    }

    public static void zeroArg() {
        ++zeroArgCount;
    }

    public static void exceptionMaker() throws SQLException {
        throw new SQLException("FOOException");
    }

    private void checkAndResetGetConnectionProcCount(int count) {
        ProcedureInTriggerTest.assertEquals((int)count, (int)getConnectionProcCount);
        getConnectionProcCount = 0;
    }

    public static void getConnectionProc() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement s = conn.createStatement();
        conn.close();
        ++getConnectionProcCount;
    }

    private void checkAndResetSelectRowsCount(int count) {
        ProcedureInTriggerTest.assertEquals((int)count, (int)selectRowsCount);
        selectRowsCount = 0;
    }

    public static void selectRows(int p1, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select * from t1 where i = ?");
        ps.setInt(1, p1);
        data[0] = ps.executeQuery();
        conn.close();
        ++selectRowsCount;
    }

    public static void selectRows(int p1, int p2, ResultSet[] data1, ResultSet[] data2) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("select * from t1 where i = ?");
        ps.setInt(1, p1);
        data1[0] = ps.executeQuery();
        ps = conn.prepareStatement("select * from t1 where i >= ?");
        ps.setInt(1, p2);
        data2[0] = ps.executeQuery();
        if (p2 == 99) {
            data2[0].close();
        }
        if (p2 == 199) {
            data1[0].close();
            data1[0] = null;
            data2[0].close();
            data2[0] = null;
        }
        if (p2 == 299) {
            ResultSet rs = data1[0];
            data1[0] = data2[0];
            data2[0] = rs;
        }
        conn.close();
        ++selectRowsCount;
    }

    public static void selectRows(String table, ResultSet[] rs) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = conn.createStatement();
        rs[0] = stmt.executeQuery("SELECT * FROM " + table);
        conn.close();
        ++selectRowsCount;
    }

    public static void insertRow(int p1) throws SQLException {
        ProcedureInTriggerTest.insertRow(p1, "int");
    }

    public static void insertRow(int p1, String p2) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        ps.setInt(1, p1);
        ps.setString(2, p2);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void updateRow(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("update t1 set i=i+?");
        ps.setInt(1, p1);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void deleteRow(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("delete from t1 where i=?");
        ps.setInt(1, p1);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void alterTable() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("alter table t1 add column test integer");
        ps.execute();
        ps.close();
        conn.close();
    }

    public static void dropTable() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("drop table t1");
        ps.execute();
        ps.close();
        conn.close();
    }

    public static int doConnCommitInt() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
        return 1;
    }

    public static void doConnCommit() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
    }

    public static void doConnRollback() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.rollback();
    }

    public static void doConnectionSetIsolation() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(8);
    }

    public static void createIndex() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("create index ix on t1(i,b)");
        ps.execute();
        ps.close();
        conn.close();
    }

    public static void dropIndex() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("drop index ix");
        ps.execute();
        ps.close();
        conn.close();
    }

    public static void createTrigger() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("create trigger test_trig AFTER delete on t1 for each STATEMENT insert into t1 values(20, 'twenty')");
        ps.execute();
        ps.close();
        conn.close();
    }

    public static void dropTrigger() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement("drop trigger test_trig");
        ps.execute();
        ps.close();
        conn.close();
    }
}

