/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class Price
implements Externalizable {
    private static final int FIRST_VERSION = 0;
    private static final int TIMESTAMPED_VERSION = 1;
    private static final Timestamp DEFAULT_TIMESTAMP = new Timestamp(0L);
    private static Price _savedPrice;
    public String currencyCode;
    public BigDecimal amount;
    public Timestamp timeInstant;

    public static Price makePrice() {
        return new Price("USD", new BigDecimal(1), DEFAULT_TIMESTAMP);
    }

    public static Price makePrice(String currencyCode, BigDecimal amount, Timestamp timeInstant) {
        return new Price(currencyCode, amount, timeInstant);
    }

    public static String getCurrencyCode(Price price) {
        return price.currencyCode;
    }

    public static BigDecimal getAmount(Price price) {
        return price.amount;
    }

    public static Timestamp getTimeInstant(Price price) {
        return price.timeInstant;
    }

    public static void savePrice(Price price) {
        _savedPrice = price;
    }

    public static Price getSavedPrice() {
        return _savedPrice;
    }

    public Price() {
    }

    public Price(String currencyCode, BigDecimal amount, Timestamp timeInstant) {
        this.currencyCode = currencyCode;
        this.amount = amount;
        this.timeInstant = timeInstant;
    }

    public String toString() {
        return "Price( " + this.currencyCode + ", " + this.amount + ", " + this.timeInstant + " )";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Price)) {
            return false;
        }
        Price that = (Price)other;
        return this.toString().equals(that.toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.currencyCode);
        out.writeObject(this.amount);
        out.writeObject(this.timeInstant);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int oldVersion = in.readInt();
        if (oldVersion < 0) {
            throw new IOException("Corrupt data stream.");
        }
        if (oldVersion > 1) {
            throw new IOException("Can't deserialize from the future.");
        }
        this.currencyCode = (String)in.readObject();
        this.amount = (BigDecimal)in.readObject();
        this.timeInstant = oldVersion >= 1 ? (Timestamp)in.readObject() : DEFAULT_TIMESTAMP;
    }
}

