/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OffsetFetchNextTest
extends BaseJDBCTestCase {
    private static final String LANG_FORMAT_EXCEPTION = "22018";
    private static final String LANG_INTEGER_LITERAL_EXPECTED = "42X20";
    private static final String LANG_INVALID_ROW_COUNT_FIRST = "2201W";
    private static final String LANG_INVALID_ROW_COUNT_OFFSET = "2201X";
    private static final String LANG_MISSING_PARMS = "07000";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL = "2201Z";

    public OffsetFetchNextTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OffsetFetchNextTest");
        suite.addTest(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:client")));
        return suite;
    }

    public static Test baseSuite(String suiteName) {
        return new CleanDatabaseTestSetup((Test)new TestSuite(OffsetFetchNextTest.class, suiteName)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                OffsetFetchNextTest.createSchemaObjects(s);
            }
        };
    }

    private static void createSchemaObjects(Statement st) throws SQLException {
        st.executeUpdate("create table t1 (a int, b bigint)");
        st.executeUpdate("insert into t1 (a, b) values (1,1), (1,2), (1,3), (1,4), (1,5)");
        st.executeUpdate("create table t2 (a int primary key, b bigint)");
        st.executeUpdate("insert into t2 (a, b) values (1,1), (2,1), (3,1), (4,1), (5,1)");
        st.executeUpdate("create table t3 (a int primary key,                  b bigint unique)");
        st.executeUpdate("insert into t3 (a, b) values (1,1), (2,2), (3,3), (4,4), (5,5)");
    }

    public void testErrors() throws Exception {
        Statement st = this.createStatement();
        OffsetFetchNextTest.assertStatementError(LANG_INVALID_ROW_COUNT_OFFSET, st, "select * from t1 offset -1 rows");
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, st, "select * from t1 offset -? rows");
        OffsetFetchNextTest.assertStatementError(LANG_INVALID_ROW_COUNT_FIRST, st, "select * from t1 fetch first 0 rows only");
        OffsetFetchNextTest.assertStatementError(LANG_INVALID_ROW_COUNT_FIRST, st, "select * from t1 fetch first -1 rows only");
        OffsetFetchNextTest.assertStatementError(LANG_INTEGER_LITERAL_EXPECTED, st, "select * from t1 fetch first 3.14 rows only");
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, st, "select * from t1 fetch first 0 rows only offset 0 rows");
    }

    public void testNewKeywordNonReserved() throws Exception {
        this.setAutoCommit(false);
        this.prepareStatement("select a,b as offset from t1 offset 0 rows");
        this.prepareStatement("select a,b from t1 as offset");
        this.prepareStatement("select a,b offset from t1 offset");
        this.prepareStatement("select a,b offset from t1 offset +2 rows");
        this.prepareStatement("select a offset,b from t1 offset ? rows");
        this.prepareStatement("select offset.a, offset.b offset from t1 as offset offset ? rows");
        Statement s = this.createStatement();
        s.executeUpdate("create table t4562(i int, offset int)");
        ResultSet rs = s.executeQuery("select * from t4562 where i > 0 and offset + i < 0 offset 2 rows");
        rs.next();
        rs = s.executeQuery("select * from t4562 where i > 0 and offset - i < 0 offset 2 rows");
        rs.next();
        rs = s.executeQuery("select * from t4562 where i > 0 and offset * i < 0 offset 2 rows");
        rs.next();
        rs.close();
        this.rollback();
    }

    public void testOffsetFetchFirstReadOnlyForwardOnlyRS() throws Exception {
        Statement stm = this.createStatement();
        this.queryAndCheck(stm, "select a,b from t1 order by b offset 0 rows", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a offset 0 rows", new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3  order by b offset 0 rows", new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1  order by b offset 1 rows", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a offset 1 rows", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by b offset 1 rows", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b offset 4 rows", new String[][]{{"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a offset 4 rows", new String[][]{{"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by b offset 4 rows", new String[][]{{"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b offset 1 row fetch next 1 rows only", new String[][]{{"1", "2"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a offset 1 row fetch next 1 rows only", new String[][]{{"2", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by b offset 1 row  fetch next 1 rows only", new String[][]{{"2", "2"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b offset 1 rows fetch first 10 row only", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a offset 1 rows fetch first 10 row only", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by b offset 1 rows  fetch first 10 row only", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t2 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t3 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t1 order by b fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by b fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b asc fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b desc fetch first row only", new String[][]{{"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a desc fetch next row only", new String[][]{{"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a desc fetch next row only", new String[][]{{"5", "5"}});
        this.queryAndCheck(stm, "select max(a) from t1 group by b fetch first row only", new String[][]{{"1"}});
        this.queryAndCheck(stm, "select max(a) from t2 group by b offset 0 rows", new String[][]{{"5"}});
        this.queryAndCheck(stm, "select max(a) from t3 group by b     order by max(a) fetch next 2 rows only", new String[][]{{"1"}, {"2"}});
        this.queryAndCheck(stm, "select * from t1 union all select * from t1   order by a fetch first 2 row only", new String[][]{{"1", "1"}, {"1", "2"}});
        this.queryAndCheck(stm, "select t2.b, t3.b from t2,t3 where t2.a=t3.a   order by t2.a fetch first 2 row only", new String[][]{{"1", "1"}, {"1", "2"}});
        stm.close();
    }

    public void DISABLED_testOffsetFetchFirstUpdatableForwardOnlyRS() throws Exception {
        Statement stm = this.createStatement(1003, 1008);
        this.setAutoCommit(false);
        ResultSet rs = stm.executeQuery("select * from t1 offset 0 rows for update of a, b");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 offset 1 rows");
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        stm.close();
    }

    public void testOffsetFetchFirstReadOnlyScrollableRS() throws Exception {
        Statement stm = this.createStatement(1004, 1007);
        ResultSet rs = stm.executeQuery("select * from t1 order by b offset 0 rows");
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
        rs.close();
        rs = stm.executeQuery("select * from t1 order by b offset 1 rows fetch next 3 rows only");
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 3 ? 1 : 0) != 0);
        rs.previous();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
        rs.previous();
        OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
        rs.next();
        rs.next();
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
        stm.close();
    }

    public void testOffsetFetchFirstUpdatableScrollableRS() throws Exception {
        Statement stm;
        try {
            stm = this.createStatement(1004, 1008);
            OffsetFetchNextTest.fail((String)"Revert back to orginal code once we start supporting updatable scrollable / forward only resultsets");
        }
        catch (SQLException sqle) {
            if (!"0A000.S.22".startsWith(sqle.getSQLState())) {
                throw sqle;
            }
            return;
        }
        this.setAutoCommit(false);
        ResultSet rs = stm.executeQuery("select * from t1  offset 0 rows for update");
        rs = stm.executeQuery("select * from t1  offset 0 rows for update");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 offset 1 rows fetch next 3 rows only");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.previous();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.previous();
        OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
        rs.next();
        rs.next();
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
        rs.moveToInsertRow();
        rs.updateInt(1, 42);
        rs.updateInt(2, 42);
        rs.insertRow();
        rs.previous();
        rs.deleteRow();
        rs.previous();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.rowDeleted());
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"-1", "3"}, {"1", "5"}, {"42", "42"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 where a + 1 < b offset 1 rows");
        rs.absolute(2);
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
        rs.updateInt(2, -5);
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "-5"}});
        this.rollback();
        stm.close();
    }

    public void testValues() throws SQLException {
        Statement stm = this.createStatement();
        this.queryAndCheck(stm, "values 4    fetch first 2 row only", new String[][]{{"4"}});
        this.queryAndCheck(stm, "values 4    offset 1 row", new String[0][]);
        stm.close();
    }

    public void testMetadata() throws SQLException {
        Statement stm = this.createStatement();
        ResultSet rs = stm.executeQuery("select * from t1 offset 1 rows");
        ResultSetMetaData rsmd = rs.getMetaData();
        int cnt = rsmd.getColumnCount();
        String[] cols = new String[]{"A", "B"};
        int[] types = new int[]{4, -5};
        for (int i = 1; i <= cnt; ++i) {
            String name = rsmd.getColumnName(i);
            int type = rsmd.getColumnType(i);
            OffsetFetchNextTest.assertTrue((boolean)name.equals(cols[i - 1]));
            OffsetFetchNextTest.assertTrue((type == types[i - 1] ? 1 : 0) != 0);
        }
        rs.close();
        stm.close();
    }

    public void testRunTimeStatistics() throws SQLException {
        Statement stm = this.createStatement();
        stm.executeUpdate("call syscs_util.set_runtimestatistics(1)");
        this.queryAndCheck(stm, "select a,b from t1 order by a offset 2 rows", new String[][]{{"1", "3"}, {"1", "4"}, {"1", "5"}});
        stm.executeUpdate("call syscs_util.set_runtimestatistics(0)");
        ResultSet rs = stm.executeQuery("values syscs_util.get_runtimestatistics()");
        rs.next();
        String plan = rs.getString(1);
        OffsetFetchNextTest.assertTrue((String)plan, (plan.indexOf("Row Count (1):\nNumber of opens = 1\nRows seen = 3\nRows filtered = 2") != -1 ? 1 : 0) != 0);
        rs.close();
        stm.close();
    }

    public void testBigTable() throws SQLException {
        Statement stm = this.createStatement();
        this.setAutoCommit(false);
        stm.executeUpdate("declare global temporary table session.t (i int) on commit preserve rows not logged");
        PreparedStatement ps = this.prepareStatement("insert into session.t values ?");
        for (int i = 1; i <= 100000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
            if (i % 10000 != 0) continue;
            this.commit();
        }
        this.queryAndCheck(stm, "select count(*) from session.t", new String[][]{{"100000"}});
        this.queryAndCheck(stm, "select i from session.t order by i offset 99999 rows", new String[][]{{"100000"}});
        stm.executeUpdate("drop table session.t");
        stm.close();
    }

    public void testRepeatedExecution() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from t1 order by b offset 2 rows fetch next 2 rows only");
        String[][] expected = new String[][]{{"1", "3"}, {"1", "4"}};
        for (int i = 0; i < 10; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
    }

    public void testDynamicArgs() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from t1 offset ? rows");
        ps = this.prepareStatement("select * from t1 order by b offset ? rows fetch next ? rows only");
        ps.setInt(1, 0);
        OffsetFetchNextTest.assertPreparedStatementError(LANG_MISSING_PARMS, ps);
        ps.setInt(1, -1);
        ps.setInt(2, 2);
        OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_OFFSET, ps);
        ps.setInt(1, 0);
        ps.setInt(2, 0);
        OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_FIRST, ps);
        try {
            ps.setString(1, "aaa");
        }
        catch (SQLException e) {
            OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, e);
        }
        try {
            ps.setString(2, "aaa");
        }
        catch (SQLException e) {
            OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, e);
        }
        String[][] expected = new String[][]{{"1", "3"}, {"1", "4"}};
        for (int i = 0; i < 2; ++i) {
            ps.setInt(1, 2);
            ps.setInt(2, 2);
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
        ps.setLong(1, 1L);
        ps.setInt(2, 3);
        expected = new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}};
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        ps.setLong(1, 0xFFFFFFFEL);
        ps.setInt(2, 5);
        JDBC.assertEmpty(ps.executeQuery());
        ps = this.prepareStatement("select * from t1 order by b offset ? rows fetch next 3 rows only");
        ps.setLong(1, 1L);
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        ps = this.prepareStatement("select * from t1 order by b offset 4 rows fetch next ? rows only");
        ps.setLong(1, 1L);
        JDBC.assertFullResultSet(ps.executeQuery(), new String[][]{{"1", "5"}});
        ps = this.prepareStatement("select * from t1 where a = ? order by b offset ? rows fetch next 3 rows only");
        ps.setInt(1, 1);
        ps.setLong(2, 1L);
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        ps = this.prepareStatement("select * from t1 where a = ? order by b offset 1 rows fetch next ? rows only");
        ps.setInt(1, 1);
        ps.setLong(2, 2L);
        expected = new String[][]{{"1", "2"}, {"1", "3"}};
        JDBC.assertFullResultSet(ps.executeQuery(), expected);
        ps = this.prepareStatement("select * from t1 order by b offset ? rows fetch next ? rows only");
        ps.setNull(1, -5);
        ps.setInt(2, 2);
        OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, ps);
        ps.setInt(1, 1);
        ps.setNull(2, -5);
        OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, ps);
        ps.close();
    }

    public void testDynamicArgsMetaData() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        PreparedStatement ps = this.prepareStatement("select * from t1 where a = ? order by b offset ? rows fetch next ? rows only");
        ParameterMetaData pmd = ps.getParameterMetaData();
        int[] expectedTypes = new int[]{4, -5, -5};
        for (int i = 0; i < 3; ++i) {
            OffsetFetchNextTest.assertEquals((String)"Unexpected parameter type", (int)expectedTypes[i], (int)pmd.getParameterType(i + 1));
            OffsetFetchNextTest.assertEquals((String)"Derby ? args are nullable", (int)1, (int)pmd.isNullable(i + 1));
        }
        ps.close();
    }

    private void queryAndCheck(Statement stm, String queryText, String[][] expectedRows) throws SQLException {
        ResultSet rs = stm.executeQuery(queryText);
        JDBC.assertFullResultSet(rs, expectedRows);
    }
}

