/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OLAPTest
extends BaseJDBCTestCase {
    public OLAPTest(String name) {
        super(name);
    }

    public void testBasicOperations() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1 (a int, b int)");
        s.executeUpdate("create table t2 (x int)");
        s.executeUpdate("create table t3 (y int)");
        s.executeUpdate("create table t4 (a int, b int)");
        s.executeUpdate("insert into t1 values (10,100),(20,200),(30,300),(40,400),(50,500)");
        s.executeUpdate("insert into t2 values (1),(2),(3),(4),(5)");
        s.executeUpdate("insert into t3 values (4),(5),(6),(7),(8)");
        s.executeUpdate("insert into t4 values (10,100),(20,200)");
        ResultSet rs = s.executeQuery("select row_number() over (), t1.* from t1 order by a");
        String[][] expectedRows = new String[][]{{"1", "10", "100"}, {"2", "20", "200"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over (), t1.* from t1 where a > 30 order by a");
        expectedRows = new String[][]{{"1", "40", "400"}, {"2", "50", "500"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over (), a from t1 where b > 300 order by a");
        expectedRows = new String[][]{{"1", "40"}, {"2", "50"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over () as r, a from t1 where b > 300 order by a");
        expectedRows = new String[][]{{"1", "40"}, {"2", "50"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over (), row_number() over (), b from t1 where b <= 300 order by a");
        expectedRows = new String[][]{{"1", "1", "100"}, {"2", "2", "200"}, {"3", "3", "300"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over (), b, row_number() over (), a from t1 where b < 300 order by a");
        expectedRows = new String[][]{{"1", "100", "1", "10"}, {"2", "200", "2", "20"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over(),x from t2,t3 where x=y order by x");
        expectedRows = new String[][]{{"1", "4"}, {"2", "5"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over () as r, t1.* from t1 order by b desc");
        expectedRows = new String[][]{{"1", "50", "500"}, {"2", "40", "400"}, {"3", "30", "300"}, {"4", "20", "200"}, {"5", "10", "100"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over () as r, t1.a from t1 order by b desc");
        expectedRows = new String[][]{{"1", "50"}, {"2", "40"}, {"3", "30"}, {"4", "20"}, {"5", "10"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        rs = s.executeQuery("select row_number() over (), row_number() over (), 2*t1.a from t1 order by a");
        expectedRows = new String[][]{{"1", "1", "20"}, {"2", "2", "40"}, {"3", "3", "60"}, {"4", "4", "80"}, {"5", "5", "100"}};
        JDBC.assertUnorderedResultSet(rs, expectedRows);
        OLAPTest.assertStatementError("42X01", s, "select row_number() as r, * from t1 where t1.a > 2");
        OLAPTest.assertStatementError("42X04", s, "select row_number() over () as r, a from t1 where r < 3");
        OLAPTest.assertStatementError("42X01", s, "select row_number() over () as r, * from t1 where t1.a > 2");
        s.executeUpdate("drop table t1");
        s.executeUpdate("drop table t2");
        s.executeUpdate("drop table t3");
        s.close();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(OLAPTest.class);
    }
}

