/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullableUniqueConstraintTest
extends BaseJDBCTestCase {
    public NullableUniqueConstraintTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NullableUniqueConstraintTest");
        suite.addTest(TestConfiguration.defaultSuite(NullableUniqueConstraintTest.class));
        return suite;
    }

    protected void setUp() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("create table constraintest (val1 varchar (20), val2 varchar (20), val3 varchar (20), val4 varchar (20))");
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
        Connection con = this.getConnection();
        con.commit();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("drop table constraintest");
        stmt.close();
        con.commit();
        super.tearDown();
    }

    public void testSingleKeyPartUniqueConstraint() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        ps.setString(1, "test");
        ps.setString(2, "should pass");
        ps.execute();
        try {
            ps.setString(1, "test");
            ps.setString(2, "should fail");
            ps.execute();
            NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
        }
        catch (SQLException e) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", e);
        }
        ps.setNull(1, 12);
        ps.setString(2, "should pass");
        ps.execute();
        ps.setNull(1, 12);
        ps.setString(2, "should pass");
        ps.execute();
        ResultSet rs = stmt.executeQuery("select count (*) from constraintest where val1 is null");
        rs.next();
        NullableUniqueConstraintTest.assertEquals((String)"expected 2 rows", (int)2, (int)rs.getInt(1));
        stmt.execute("alter table constraintest drop constraint u_con");
        stmt.execute("delete from constraintest where val1 is null");
        con.commit();
        ps.setString(1, "test");
        ps.setString(2, "removeit");
        ps.execute();
        try {
            stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
            NullableUniqueConstraintTest.fail((String)"create unique constraint with duplicate key in table should fail");
        }
        catch (SQLException e) {
            NullableUniqueConstraintTest.assertSQLState("creating unique constraint when duplicate keys are present  duplicate", "23505", e);
        }
        stmt.execute("delete from constraintest where val2 = 'removeit'");
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        con.commit();
        stmt.close();
        ps.close();
    }

    public void testMultipartKeyUniqueConstraint() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1, val2, val3, val4) values (?, ?, ?, ?)");
        ps.setString(1, "part1");
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        try {
            ps.setString(1, "part1");
            ps.setString(2, "part2");
            ps.setString(3, "part3");
            ps.setString(4, "should fail");
            ps.execute();
            NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
        }
        catch (SQLException e) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", e);
        }
        ps.setNull(1, 12);
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        ps.setNull(1, 12);
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        ps.setString(1, "part1");
        ps.setNull(2, 12);
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        ResultSet rs = stmt.executeQuery("select count (*) from constraintest where val1 is null");
        rs.next();
        NullableUniqueConstraintTest.assertEquals((String)"expected 2 rows", (int)2, (int)rs.getInt(1));
        stmt.execute("alter table constraintest drop constraint u_con");
        con.commit();
        ps.setString(1, "part1");
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "removeit");
        ps.execute();
        try {
            stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
            NullableUniqueConstraintTest.fail((String)"create unique constraint with duplicate key in table should fail");
        }
        catch (SQLException e) {
            NullableUniqueConstraintTest.assertSQLState("creating unique constraint when duplicate keys are present  duplicate", "23505", e);
        }
        stmt.execute("delete from constraintest where val4 = 'removeit'");
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        con.commit();
        stmt.close();
        ps.close();
    }

    public void testWithDeletedKey() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1, val2, val3, val4) values (?, ?, ?, ?)");
        ps.setString(1, "part1");
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        con.setAutoCommit(false);
        stmt.executeUpdate("delete from constraintest where val1 = 'part1' and val2 = 'part2' and val3 = 'part3'");
        ps.setString(1, "part1");
        ps.setString(2, "part2");
        ps.setString(3, "part3");
        ps.setString(4, "should pass");
        ps.execute();
        stmt.close();
        ps.close();
        con.commit();
    }

    public void testDistinctQuery() throws SQLException {
        int i;
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1) values (?)");
        for (i = 0; i < 5; ++i) {
            ps.setNull(1, 12);
            ps.executeUpdate();
        }
        for (i = 0; i < 5; ++i) {
            ps.setString(1, String.valueOf(i));
            ps.executeUpdate();
        }
        ResultSet rs = stmt.executeQuery("select count (*) from constraintest");
        rs.next();
        NullableUniqueConstraintTest.assertEquals((int)10, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count (distinct (val1)) from constraintest");
        rs.next();
        NullableUniqueConstraintTest.assertEquals((int)5, (int)rs.getInt(1));
        rs.close();
    }

    public void testNullOrdering() throws SQLException {
        int i;
        int i2;
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1) values (?)");
        for (i2 = 0; i2 < 5; ++i2) {
            ps.setNull(1, 12);
            ps.executeUpdate();
        }
        for (i2 = 0; i2 < 5; ++i2) {
            ps.setString(1, String.valueOf(i2));
            ps.executeUpdate();
        }
        ResultSet rs = stmt.executeQuery("select val1 from constraintest order by val1 nulls last");
        for (i = 0; i < 5; ++i) {
            rs.next();
            NullableUniqueConstraintTest.assertEquals((String)String.valueOf(i), (String)rs.getString(1));
        }
        for (i = 0; i < 5; ++i) {
            rs.next();
            NullableUniqueConstraintTest.assertEquals(null, (String)rs.getString(1));
        }
        rs.close();
        rs = stmt.executeQuery("select val1 from constraintest order by val1 nulls first");
        for (i = 0; i < 5; ++i) {
            rs.next();
            NullableUniqueConstraintTest.assertEquals(null, (String)rs.getString(1));
        }
        for (i = 0; i < 5; ++i) {
            rs.next();
            NullableUniqueConstraintTest.assertEquals((String)String.valueOf(i), (String)rs.getString(1));
        }
        rs.close();
    }

    public void testComparisonAcrossPages() throws SQLException {
        int i;
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        for (i = 0; i < 500; ++i) {
            ps.setString(1, "" + i);
            ps.setString(2, "" + i);
            ps.execute();
        }
        for (i = 0; i < 500; ++i) {
            ps.setString(1, "" + i);
            ps.setString(2, "" + i);
            try {
                ps.execute();
                NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
                continue;
            }
            catch (SQLException e) {
                NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", e);
            }
        }
        con.setAutoCommit(false);
        NullableUniqueConstraintTest.assertEquals((int)499, (int)stmt.executeUpdate("delete from constraintest where val1 != '0'"));
        Savepoint deleted = con.setSavepoint("deleted");
        ps.setString(1, "0");
        ps.setString(2, "test");
        try {
            ps.execute();
            NullableUniqueConstraintTest.fail((String)"managed to insert a duplicate");
        }
        catch (SQLException e) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", e);
        }
        con.rollback(deleted);
        ps.setString(1, "250");
        ps.setString(2, "test");
        ps.execute();
        con.rollback(deleted);
        ps.setString(1, "499");
        ps.setString(2, "test");
        ps.execute();
        ResultSet rs = stmt.executeQuery("select count (*) from constraintest");
        rs.next();
        NullableUniqueConstraintTest.assertEquals((int)2, (int)rs.getInt(1));
        con.rollback();
        ps.close();
        stmt.close();
        ps.close();
    }

    public void testDefferedInsert() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2)");
        PreparedStatement ps = con.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                ps.setString(1, String.valueOf(i));
                ps.setString(2, String.valueOf(j));
                ps.executeUpdate();
            }
        }
        NullableUniqueConstraintTest.assertEquals((String)"updating 25 records", (int)25, (int)stmt.executeUpdate("update constraintest set val1 = val2, val2 = val1"));
    }

    public static void main(String[] args) {
        TestResult tr = new TestResult();
        Test t = NullableUniqueConstraintTest.suite();
        t.run(tr);
        System.out.println(tr.errorCount());
        Enumeration e = tr.failures();
        while (e.hasMoreElements()) {
            ((TestFailure)e.nextElement()).thrownException().printStackTrace();
        }
        System.out.println(tr.failureCount());
    }
}

