/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LazyDefaultSchemaCreationTest
extends BaseJDBCTestCase {
    private static final String LOCK_TIMEOUT = "40XL1";
    private static final String LOCK_TIMEOUT_LOG = "40XL2";

    public LazyDefaultSchemaCreationTest(String name) {
        super(name);
    }

    public void testDerby48testNewSchemaHang() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        c1.setTransactionIsolation(2);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("create table t1(i int)");
        s1.close();
        Connection c2 = null;
        try {
            c2 = this.openUserConnection("newuser");
        }
        catch (SQLException e) {
            if (e.getSQLState().equals(LOCK_TIMEOUT)) {
                c1.rollback();
                c1.close();
                LazyDefaultSchemaCreationTest.fail("DERBY-48 still seen", e);
            }
            throw e;
        }
        c1.rollback();
        JDBC.assertSingleValueResultSet(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        c1.rollback();
        c1.close();
        c2.close();
    }

    public void testDerby48SelfLockingRecovery() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        c1.setTransactionIsolation(8);
        Statement s1 = c1.createStatement();
        s1.executeQuery("select count(*) from sys.sysschemas");
        s1.executeUpdate("create table t1(i int)");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        c1.rollback();
        JDBC.assertEmpty(s1.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        c1.rollback();
    }

    public void testDerby48SelfLockingRecoveryDeadlockDetectionOn() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        c1.setTransactionIsolation(8);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.locks.deadlockTrace', 'true')");
        s1.executeQuery("select count(*) from sys.sysschemas");
        try {
            s1.executeUpdate("create table t1(i int)");
            LazyDefaultSchemaCreationTest.fail((String)"Expected exception 40XL2");
        }
        catch (SQLException e) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", LOCK_TIMEOUT_LOG, e);
        }
        JDBC.assertEmpty(s1.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        c1.rollback();
    }

    public void testOtherImplicitSchemaCreation() throws SQLException {
        Connection c1 = this.openUserConnection("newuser");
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.executeUpdate("create table otherschema.t1(i int)");
        s1.close();
        JDBC.assertSingleValueResultSet(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"), "OTHERSCHEMA");
        c1.rollback();
        JDBC.assertEmpty(c1.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"));
        c1.rollback();
        c1.close();
    }

    @Override
    protected void tearDown() throws Exception {
        BaseJDBCTestCase.preTearDown();
        try {
            this.createStatement().executeUpdate("drop schema newuser restrict");
        }
        catch (SQLException e) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", "42Y07", e);
        }
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("LazyDefaultSchemaCreationTest");
        TestSuite[] suites = new TestSuite[]{new TestSuite("LazyDefaultSchemaCreationTest:embedded"), new TestSuite("LazyDefaultSchemaCreationTest:clientServer")};
        for (int i = 0; i < 2; ++i) {
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48testNewSchemaHang"), 2, 1));
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecovery"), 2, 1));
            Properties p = new Properties();
            p.setProperty("gemfirexd.locks.deadlockTrace", "true");
            suites[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new DatabasePropertyTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecoveryDeadlockDetectionOn"), p, false), 2, 1));
            if (i == 0) {
                suite.addTest((Test)suites[i]);
                continue;
            }
            suite.addTest(TestConfiguration.clientServerDecorator((Test)suites[i]));
        }
        return suite;
    }
}

