/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class GrantRevokeDDLTest
extends BaseJDBCTestCase {
    private static String[] users = new String[]{"TEST_DBO", "george", "sam", "monica", "swiper", "sam", "satheesh", "bar", "mamta4", "mamta3", "mamta2", "mamta1", "sammy", "user5", "user4", "user3", "user2", "user1"};

    public GrantRevokeDDLTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("GrantRevokeDDLTest");
        }
        TestSuite suite = new TestSuite(GrantRevokeDDLTest.class, "GrantRevokeDDL Test");
        TestSetup test = new SupportFilesSetup((Test)suite);
        test = new CleanDatabaseTestSetup((Test)test);
        test = DatabasePropertyTestSetup.builtinAuthentication((Test)test, users, "grantrevokeddl");
        test = TestConfiguration.sqlAuthorizationDecorator((Test)test);
        return test;
    }

    public void testGrantRevokeDDL() throws Exception {
        ResultSet rs = null;
        SQLWarning sqlWarn = null;
        Statement st = this.createStatement();
        Connection satConnection = this.openUserConnection("satheesh");
        Statement st_satConnection = satConnection.createStatement();
        st = this.createStatement();
        st_satConnection.executeUpdate("create table satheesh.tsat(i int not null primary key, j int)");
        st_satConnection.executeUpdate(" create index tsat_ind on satheesh.tsat(j)");
        st_satConnection.executeUpdate(" create table satheesh.table1 (a int, b int, c char(10))");
        st_satConnection.executeUpdate(" grant select on satheesh.tsat to public");
        st_satConnection.executeUpdate(" grant insert on satheesh.tsat to foo");
        st_satConnection.executeUpdate(" grant delete on satheesh.tsat to foo");
        st_satConnection.executeUpdate(" grant update on satheesh.tsat to foo");
        st_satConnection.executeUpdate(" grant update(i) on satheesh.tsat to bar");
        rs = st_satConnection.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms");
        String[] expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"PUBLIC", "SATHEESH", "y", "N", "N", "N", "N", "N"}, {"FOO", "SATHEESH", "N", "y", "y", "y", "N", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        Connection barConnection = this.openUserConnection("bar");
        Statement st_barConnection = barConnection.createStatement();
        GrantRevokeDDLTest.assertStatementError("42506", st_barConnection, "revoke select on satheesh.tsat from public");
        GrantRevokeDDLTest.assertStatementError("42506", st_barConnection, " revoke insert on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", st_barConnection, " revoke update(i) on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", st_barConnection, " revoke update on satheesh.tsat from foo");
        GrantRevokeDDLTest.assertStatementError("42506", st_barConnection, " revoke delete on satheesh.tsat from foo");
        st_satConnection.executeUpdate("revoke trigger on satheesh.tsat from foo");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_satConnection.executeUpdate(" revoke references on satheesh.tsat from foo");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_satConnection.executeUpdate("revoke insert on satheesh.tsat from foo, bar");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_satConnection.executeUpdate("revoke insert on satheesh.tsat from foo, bar");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_satConnection.executeUpdate(" grant insert on satheesh.tsat to foo");
        st_satConnection.executeUpdate("revoke update on satheesh.tsat from foo");
        st_satConnection.executeUpdate(" revoke delete on satheesh.tsat from foo");
        rs = st_satConnection.executeQuery("select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"PUBLIC", "SATHEESH", "y", "N", "N", "N", "N", "N"}, {"FOO", "SATHEESH", "N", "N", "y", "N", "N", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_satConnection.executeUpdate(" revoke insert on satheesh.tsat from foo");
        st_satConnection.executeUpdate(" revoke select on satheesh.tsat from public");
        rs = st_satConnection.executeQuery("select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_satConnection.executeUpdate("CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_satConnection.executeUpdate("revoke execute on function F_ABS(int) from bar RESTRICT");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_satConnection != null) {
                sqlWarn = st_satConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = satConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_satConnection.executeUpdate(" grant execute on function F_ABS to foo");
        st_satConnection.executeUpdate(" grant execute on function F_ABS(int) to bar");
        st_satConnection.executeUpdate(" revoke execute on function F_ABS(int) from bar RESTRICT");
        st_satConnection.executeUpdate(" drop function f_abs");
        st_satConnection.executeUpdate("create view v1 as select * from tsat");
        st_satConnection.executeUpdate(" grant select on v1 to bar");
        GrantRevokeDDLTest.assertStatementError("42509", st_satConnection, " grant insert on v1 to foo");
        GrantRevokeDDLTest.assertStatementError("42509", st_satConnection, " grant update on v1 to public");
        st_satConnection.executeUpdate("create synonym mySym for satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError("42X05", st_satConnection, "grant select on mySym to bar");
        GrantRevokeDDLTest.assertStatementError("42X05", st_satConnection, " grant insert on mySym to foo");
        st_satConnection.executeUpdate(" CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        rs = st_satConnection.executeQuery(" values f_abs(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        this.getConnection().createStatement().executeUpdate("CREATE SCHEMA MYDODO AUTHORIZATION DODO");
        this.getConnection().createStatement().executeUpdate(" CREATE SCHEMA AUTHORIZATION DERBY");
        rs = st_satConnection.executeQuery(" select SCHEMANAME, AUTHORIZATIONID from sys.sysschemas where schemaname not like 'SYS%'");
        expColNames = new String[]{"SCHEMANAME", "AUTHORIZATIONID"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"NULLID", "TEST_DBO"}, {"SQLJ", "TEST_DBO"}, {"APP", "APP"}, {"SATHEESH", "SATHEESH"}, {"MYDODO", "DODO"}, {"DERBY", "DERBY"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        Connection swiperConnection = this.openUserConnection("swiper");
        Statement st_swiperConnection = swiperConnection.createStatement();
        st_swiperConnection.executeUpdate(" create table swiperTab (i int, j int)");
        st_swiperConnection.executeUpdate(" insert into swiperTab values (1,1)");
        st_swiperConnection.executeUpdate(" set schema satheesh");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, "create table NotMyTable (i int, j int)");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, " drop table tsat");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, " drop index tsat_ind");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, " create view myview as select * from satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, " CREATE FUNCTION FuncNotMySchema(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        GrantRevokeDDLTest.assertStatementError("42507", st_swiperConnection, " alter table tsat add column k int");
        st_swiperConnection.executeUpdate(" create table swiper.mytab ( i int, j int)");
        st_swiperConnection.executeUpdate(" set schema swiper");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, "select * from satheesh.tsat");
        GrantRevokeDDLTest.assertStatementError("42500", st_swiperConnection, " insert into satheesh.tsat values (1, 2)");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " update satheesh.tsat set i=j");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " create table my_tsat (i int not null, c char(10), constraint fk foreign key(i) references satheesh.tsat)");
        st_satConnection.executeUpdate(" grant select(i), update(j) on tsat to swiper");
        st_satConnection.executeUpdate(" grant all privileges on table1 to swiper");
        st_satConnection.executeUpdate(" grant references on tsat to swiper");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, "select * from satheesh.tsat");
        rs = st_swiperConnection.executeQuery(" select i from satheesh.tsat");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " select i from satheesh.tsat where j=2");
        rs = st_swiperConnection.executeQuery(" select i from satheesh.tsat where 2 > (select count(i) from satheesh.tsat)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " select i from satheesh.tsat where 2 > (select count(j) from satheesh.tsat)");
        rs = st_swiperConnection.executeQuery(" select i from satheesh.tsat where 2 > (select count(*) from satheesh.tsat)");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertUpdateCount(st_swiperConnection, 0, " update satheesh.tsat set j=j+1");
        GrantRevokeDDLTest.assertUpdateCount(st_swiperConnection, 0, " update satheesh.tsat set j=2 where i=2");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " update satheesh.tsat set j=2 where j=1");
        rs = st_swiperConnection.executeQuery(" select * from satheesh.table1");
        expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_swiperConnection.executeQuery(" select c from satheesh.table1 t1, satheesh.tsat t2 where t1.a = t2.i");
        expColNames = new String[]{"C"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " select b from satheesh.table1 t1, satheesh.tsat t2 where t1.a = t2.j");
        rs = st_swiperConnection.executeQuery(" select * from satheesh.table1, (select i from satheesh.tsat) table2");
        expColNames = new String[]{"A", "B", "C", "I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, " select * from satheesh.table1, (select j from satheesh.tsat) table2");
        GrantRevokeDDLTest.assertStatementError("42502", st_swiperConnection, "update satheesh.tsat set j=i");
        st_swiperConnection.executeUpdate(" create table my_tsat (i int not null, c char(10), constraint fk foreign key(i) references satheesh.tsat)");
        GrantRevokeDDLTest.assertStatementError("42500", st_swiperConnection, "create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        GrantRevokeDDLTest.assertStatementError("42500", st_swiperConnection, " create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        st_satConnection.executeUpdate(" grant trigger on tsat to swiper");
        st_swiperConnection.executeUpdate(" create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        st_swiperConnection.executeUpdate(" create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        st_swiperConnection.executeUpdate(" drop trigger trig_sat1");
        st_swiperConnection.executeUpdate(" drop trigger trig_sat2");
        st_satConnection.executeUpdate(" revoke trigger on tsat from swiper");
        GrantRevokeDDLTest.assertStatementError("42500", st_swiperConnection, " create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        GrantRevokeDDLTest.assertStatementError("42500", st_swiperConnection, " create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        st_satConnection.executeUpdate(" grant trigger on tsat to public");
        st_swiperConnection.executeUpdate(" create trigger trig_sat1 after update on satheesh.tsat for each statement values 1");
        st_swiperConnection.executeUpdate(" create trigger trig_sat2 no cascade before delete on satheesh.tsat for each statement values 1");
        st_swiperConnection.executeUpdate(" drop trigger trig_sat1");
        st_swiperConnection.executeUpdate(" drop trigger trig_sat2");
        st_satConnection.executeUpdate(" drop view v1");
        st_satConnection.executeUpdate(" drop table tsat");
        st_satConnection.executeUpdate(" drop table table1");
        rs = st_satConnection.executeQuery(" values f_abs(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_satConnection.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_swiperConnection.executeUpdate(" set schema satheesh");
        GrantRevokeDDLTest.assertStatementError("42504", st_swiperConnection, " values f_abs(-5)");
        GrantRevokeDDLTest.assertStatementError("42504", st_swiperConnection, " select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        st_satConnection.executeUpdate(" grant execute on function f_abs to swiper");
        rs = st_swiperConnection.executeQuery("values f_abs(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_swiperConnection.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_satConnection.executeUpdate(" revoke execute on function f_abs from swiper RESTRICT");
        GrantRevokeDDLTest.assertStatementError("42504", st_swiperConnection, " values f_abs(-5)");
        GrantRevokeDDLTest.assertStatementError("42504", st_swiperConnection, " select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        st_satConnection.executeUpdate(" grant execute on function f_abs to public");
        rs = st_swiperConnection.executeQuery("values f_abs(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_swiperConnection.executeQuery(" select f_abs(-4) from sys.systables where tablename like 'SYSTAB%'");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_satConnection.executeUpdate("drop synonym satheesh.mySym");
        st_satConnection.executeUpdate("drop function satheesh.f_abs");
        GrantRevokeDDLTest.assertStatementError("42508", st_swiperConnection, "create schema myFriend");
        GrantRevokeDDLTest.assertStatementError("42508", st_swiperConnection, " create schema mySchema authorization me");
        GrantRevokeDDLTest.assertStatementError("42508", st_swiperConnection, " create schema myschema authorization swiper");
        Connection CONNECTION0 = this.openUserConnection("sam");
        Statement st_CONNECTION0 = CONNECTION0.createStatement();
        GrantRevokeDDLTest.assertStatementError("42508", st_CONNECTION0, " create schema sam authorization swiper");
        st_CONNECTION0.executeUpdate("create schema authorization sam");
        Connection CONNECTION1 = this.openUserConnection("george");
        Statement st_CONNECTION1 = CONNECTION1.createStatement();
        st_CONNECTION1.executeUpdate(" create schema george");
        st.executeUpdate(" create schema myFriend");
        st.executeUpdate(" create schema mySchema authorization me");
        st.executeUpdate(" create schema authorization testSchema");
        rs = st.executeQuery(" select SCHEMANAME, AUTHORIZATIONID from sys.sysschemas");
        expColNames = new String[]{"SCHEMANAME", "AUTHORIZATIONID"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SYSIBM", "TEST_DBO"}, {"SYS", "TEST_DBO"}, {"SYSCAT", "TEST_DBO"}, {"SYSFUN", "TEST_DBO"}, {"SYSPROC", "TEST_DBO"}, {"SYSSTAT", "TEST_DBO"}, {"NULLID", "TEST_DBO"}, {"SQLJ", "TEST_DBO"}, {"SYSCS_DIAG", "TEST_DBO"}, {"SYSCS_UTIL", "TEST_DBO"}, {"APP", "APP"}, {"SATHEESH", "SATHEESH"}, {"MYDODO", "DODO"}, {"DERBY", "DERBY"}, {"SWIPER", "SWIPER"}, {"SAM", "SAM"}, {"GEORGE", "GEORGE"}, {"MYFRIEND", "TEST_DBO"}, {"MYSCHEMA", "ME"}, {"TESTSCHEMA", "TESTSCHEMA"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate("drop schema satheesh restrict");
        GrantRevokeDDLTest.assertStatementError("42508", st_swiperConnection, " create table mywork.t1(i int)");
        GrantRevokeDDLTest.assertStatementError("42508", st_swiperConnection, " create view mywork.v1 as select * from swiper.swiperTab");
        Connection monicaConnection = this.openUserConnection("monica");
        Statement st_monicaConnection = monicaConnection.createStatement();
        GrantRevokeDDLTest.assertStatementError("42508", st_monicaConnection, " create table mywork.t1 ( i int)");
        st_monicaConnection.executeUpdate(" create table monica.shouldPass(c char(10))");
        st_swiperConnection.executeUpdate(" set schema swiper");
        st_swiperConnection.executeUpdate(" revoke select on swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_swiperConnection != null) {
                sqlWarn = st_swiperConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = swiperConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_swiperConnection.executeUpdate(" revoke insert on swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_swiperConnection != null) {
                sqlWarn = st_swiperConnection.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = swiperConnection.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        rs = st.executeQuery("select * from swiper.swiperTab");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" insert into swiper.swiperTab values (2,2)");
        rs = st.executeQuery(" select * from swiper.swiperTab");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" grant select on swiper.swiperTab to sam");
        st.executeUpdate(" revoke insert on swiper.swiperTab from satheesh");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st != null) {
                sqlWarn = st.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = this.getConnection().getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42509", st, "grant select on sys.systables to sam");
        GrantRevokeDDLTest.assertStatementError("42509", st, " grant delete on sys.syscolumns to sam");
        GrantRevokeDDLTest.assertStatementError("42509", st, " grant update(alias) on sys.sysaliases to swiper");
        GrantRevokeDDLTest.assertStatementError("42509", st, " revoke all privileges on sys.systableperms from public");
        GrantRevokeDDLTest.assertStatementError("42509", st, " revoke trigger on sys.sysroutineperms from sam");
        GrantRevokeDDLTest.assertStatementError("42509", st, "grant execute on procedure sysibm.sqlprocedures to sam");
        GrantRevokeDDLTest.assertStatementError("42509", st, " revoke execute on procedure sysibm.sqlcamessage from public restrict");
        Connection samConnection = this.openUserConnection("sam");
        Statement st_samConnection = samConnection.createStatement();
        st_samConnection.executeUpdate(" create table samTable(i int)");
        st_samConnection.executeUpdate(" insert into samTable values 1,2,3,4,5,6,7");
        CallableStatement cSt = samConnection.prepareCall("call SYSCS_UTIL.SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        rs = st_samConnection.executeQuery(" values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 1);
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.COMPRESS_TABLE('SAM', 'SAMTABLE', 1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        cSt.close();
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.INPLACE_COMPRESS_TABLE('SAM', 'SAMTABLE', 1, 1, 1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        cSt.close();
        cSt = samConnection.prepareCall("call SYSCS_UTIL.COMPRESS_TABLE('SWIPER', 'MYTAB', 1)");
        GrantRevokeDDLTest.assertStatementError("38000", cSt);
        cSt.close();
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.INPLACE_COMPRESS_TABLE('SWIPER', 'MYTAB', 1, 1, 1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        cSt.close();
        cSt = samConnection.prepareCall("call SYSCS_UTIL.EXPORT_TABLE('SAM', 'SAMTABLE' , 'extinout/table.dat', null, null, null)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt);
        cSt.close();
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '4096')");
        GrantRevokeDDLTest.assertStatementError("42504", cSt);
        cSt.close();
        GrantRevokeDDLTest.assertStatementError("42504", st_samConnection, " values SYSCS_UTIL.GET_DATABASE_PROPERTY('gemfirexd.storage.pageSize')");
        PreparedStatement psgua = samConnection.prepareStatement("VALUES SYSCS_UTIL.GET_USER_ACCESS(CURRENT_USER)");
        GrantRevokeDDLTest.assertStatementError("42504", psgua);
        psgua.close();
        cSt = samConnection.prepareCall("CALL SYSCS_UTIL.SET_USER_ACCESS(CURRENT_USER, NULL)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt);
        cSt.close();
        cSt = samConnection.prepareCall("CALL SYSCS_UTIL.EMPTY_STATEMENT_CACHE()");
        GrantRevokeDDLTest.assertStatementError("42504", cSt);
        cSt.close();
        st.executeUpdate(" grant execute on procedure SYSCS_UTIL.EXPORT_TABLE to public");
        st.executeUpdate(" grant execute on procedure SYSCS_UTIL.SET_DATABASE_PROPERTY to sam");
        st.executeUpdate(" grant execute on function SYSCS_UTIL.GET_DATABASE_PROPERTY to sam");
        cSt = samConnection.prepareCall("call SYSCS_UTIL.EXPORT_TABLE('SAM', 'SAMTABLE' , 'extinout/table.dat', null, null, null)");
        cSt = samConnection.prepareCall(" call SYSCS_UTIL.SET_DATABASE_PROPERTY('gemfirexd.storage.pageSize', '4096')");
        GrantRevokeDDLTest.assertUpdateCount(cSt, 0);
        rs = st_samConnection.executeQuery(" values SYSCS_UTIL.GET_DATABASE_PROPERTY('gemfirexd.storage.pageSize')");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4096"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" revoke execute on procedure SYSCS_UTIL.EXPORT_TABLE from public restrict");
        st.executeUpdate(" revoke execute on procedure SYSCS_UTIL.SET_DATABASE_PROPERTY from sam restrict");
        st.executeUpdate(" revoke execute on function SYSCS_UTIL.GET_DATABASE_PROPERTY from sam restrict");
        Connection mamta1 = this.openUserConnection("mamta1");
        Statement st_mamta1 = mamta1.createStatement();
        st_mamta1.executeUpdate(" create table t11 (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11 values(1)");
        st_mamta1.executeUpdate(" grant select on t11 to mamta2");
        st_mamta1.executeUpdate(" grant insert on t11 to mamta3");
        st_mamta1.executeUpdate(" grant insert on t11 to mamta2, mamta3, mamta4");
        Connection mamta2 = this.openUserConnection("mamta2");
        Statement st_mamta2 = mamta2.createStatement();
        rs = st_mamta2.executeQuery(" select * from mamta1.t11");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" insert into mamta1.t11 values(2)");
        rs = st_mamta2.executeQuery(" select * from mamta1.t11");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        Connection mamta3 = this.openUserConnection("mamta3");
        Statement st_mamta3 = mamta3.createStatement();
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta1.t11");
        st_mamta3.executeUpdate(" insert into mamta1.t11 values(3)");
        Connection mamta4 = this.openUserConnection("mamta4");
        Statement st_mamta4 = mamta4.createStatement();
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta4, "select * from mamta1.t11");
        st_mamta4.executeUpdate(" insert into mamta1.t11 values(4)");
        st_mamta1.executeUpdate(" revoke all privileges on t11 from PUBLIC");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        rs = st_mamta1.executeQuery(" select * from mamta1.t11");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop table t11");
        st_mamta1.executeUpdate(" create table t11 (c111 int not null primary key, c112 int, c113 int, c114 int)");
        st_mamta1.executeUpdate(" insert into t11 values(1,1,1,1)");
        st_mamta1.executeUpdate(" grant select(c111) on t11 to mamta2");
        st_mamta1.executeUpdate(" grant select(c112) on t11 to mamta2, mamta3");
        st_mamta1.executeUpdate(" grant update(c112) on t11 to mamta2, mamta3, mamta4");
        st_mamta1.executeUpdate(" grant update on t11 to mamta2");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta2, 1, " update mamta1.t11 set c113 = 2 where c111=1");
        rs = st_mamta2.executeQuery(" select c111,c112 from mamta1.t11");
        expColNames = new String[]{"C111", "C112"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta2, "select * from mamta1.t11");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "update mamta1.t11 set c113=3");
        rs = st_mamta3.executeQuery(" select c112 from mamta1.t11");
        expColNames = new String[]{"C112"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta4, "select c112 from mamta1.t11");
        rs = st_mamta1.executeQuery(" select * from mamta1.t11");
        expColNames = new String[]{"C111", "C112", "C113", "C114"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "2", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" revoke select on t11 from mamta2, mamta3, mamta4");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_mamta1.executeUpdate(" revoke update(c111, c112) on t11 from mamta2, mamta3, mamta4");
        st_mamta1.executeUpdate(" drop table t11");
        st_mamta1.executeUpdate(" create table t11 (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11 values(1)");
        st_mamta1.executeUpdate(" insert into t11 values(2)");
        rs = st_mamta1.executeQuery(" select * from t11");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" create table t12 (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12 values (1,'1')");
        rs = st_mamta1.executeQuery(" select * from t12");
        expColNames = new String[]{"C121", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" create table t13 (c131 int, c132 char)");
        st_mamta1.executeUpdate(" insert into t13 values (1,'1')");
        rs = st_mamta1.executeQuery(" select * from t13");
        expColNames = new String[]{"C131", "C132"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" grant select on t12 to mamta2");
        st_mamta1.executeUpdate(" grant select on t11 to public");
        st_mamta2.executeUpdate("create view v21 as select t1.c111, t2.c122 from mamta1.t11 as t1, mamta1.t12 as t2");
        st_mamta2.executeUpdate(" create view v22 as select * from mamta1.t11");
        st_mamta2.executeUpdate(" create view v23 as select * from mamta1.t12");
        st_mamta1.executeUpdate("create view v23 as select * from mamta1.t12");
        st.executeUpdate("create view v11 as select * from mamta2.v22");
        st_mamta3.executeUpdate(" create table t31(c311 int)");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v31 as select * from mamta2.v22");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v32 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v33 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11, mamta2.v21");
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, "grant select on v22 to mamta3");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v31 as select * from mamta2.v22");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v32 as select v22.c111 as a, t11.c111 as b from mamta2.v22 v22, mamta1.t11 t11");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v33 as select v22.c111 as a, t12.c121 as b from mamta2.v22 v22, mamta1.t12 t12");
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, " grant select on v23 to mamta3");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create view v34 as select * from mamta2.v23");
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, "create view v35 as select * from v34");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop function f_abs1");
        st_mamta1.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        rs = st_mamta1.executeQuery(" values f_abs1(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta1, " drop view v11");
        st_mamta1.executeUpdate(" create view v11(c111) as values mamta1.f_abs1(-5)");
        st_mamta1.executeUpdate(" grant select on v11 to mamta2");
        rs = st_mamta1.executeQuery(" select * from v11");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v24");
        st_mamta2.executeUpdate(" create view v24 as select * from mamta1.v11");
        rs = st_mamta2.executeQuery(" select * from v24");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v25");
        GrantRevokeDDLTest.assertStatementError("42504", st_mamta2, "create view v25(c251) as (values mamta1.f_abs1(-1))");
        st_mamta1.executeUpdate(" grant execute on function f_abs1 to mamta2");
        st_mamta2.executeUpdate("create view v25(c251) as (values mamta1.f_abs1(-1))");
        rs = st_mamta2.executeQuery(" select * from v25");
        expColNames = new String[]{"C251"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("X0Y23", st_mamta1, "revoke execute on function f_abs1 from mamta2 restrict");
        st_mamta2.executeUpdate(" drop view v25");
        st_mamta1.executeUpdate("revoke execute on function f_abs1 from mamta2 restrict");
        rs = st_mamta2.executeQuery("select * from v24");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate("drop view v24");
        st_mamta1.executeUpdate(" drop view v11");
        st_mamta1.executeUpdate(" drop function f_abs1");
        st_mamta1.executeUpdate(" create table t14(c141 int, c142 int)");
        st_mamta1.executeUpdate(" insert into t14 values (1,1), (2,2)");
        st_mamta1.executeUpdate(" grant select(c141) on t14 to mamta2");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta2, "create view v26 as (select * from mamta1.t14 where c142=1)");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta2, "create view v26 as (select c141 from mamta1.t14 where c142=1)");
        st_mamta2.executeUpdate("create view v27 as (select c141 from mamta1.t14)");
        rs = st_mamta2.executeQuery(" select * from v27");
        expColNames = new String[]{"C141"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("grant select on t14 to mamta2");
        st_mamta2.executeUpdate("create view v26 as (select c141 from mamta1.t14 where c142=1)");
        rs = st_mamta2.executeQuery(" select * from v26");
        expColNames = new String[]{"C141"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" create table t15(c151 int, c152 int)");
        st_mamta1.executeUpdate(" insert into t15 values(1,1),(2,2)");
        st_mamta1.executeUpdate(" grant select(c151) on t15 to mamta2");
        st_mamta1.executeUpdate(" grant select(c152) on t15 to public");
        st_mamta2.executeUpdate(" create view v28 as (select c152 from mamta1.t15 where c151=1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12ViewTest");
        st_mamta1.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12ViewTest values (1,'1')");
        st_mamta1.executeUpdate("grant select on t12ViewTest to mamta2");
        st_mamta1.executeUpdate(" grant select on t11ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate("create view v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        rs = st_mamta2.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select on t11ViewTest from public");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta1.executeUpdate("revoke select on t12ViewTest from mamta2");
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, " select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        st_mamta1.executeUpdate(" drop table t12ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, "drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12ViewTest");
        st_mamta1.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12ViewTest values (1,'1')");
        st.executeUpdate("create view mamta2.v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        rs = st.executeQuery("select * from mamta2.v21ViewTest");
        expColNames = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta2.executeQuery("select * from v21ViewTest");
        expColNames = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, "grant select on v21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta2.v21ViewTest");
        st.executeUpdate("revoke select on mamta2.v21ViewTest from mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st != null) {
                sqlWarn = st.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = this.getConnection().getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta2.v21ViewTest");
        st_mamta2.executeUpdate(" drop view v21ViewTest");
        st_mamta1.executeUpdate(" drop table t12ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12ViewTest");
        st_mamta1.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12ViewTest values (1,'1')");
        st_mamta1.executeUpdate(" grant select (c111) on t11ViewTest to mamta3");
        st_mamta1.executeUpdate(" grant select (c121, c122) on t12ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ViewTest");
        st_mamta2.executeUpdate(" create table t21ViewTest (c211 int)");
        st_mamta2.executeUpdate(" insert into t21ViewTest values(1)");
        st_mamta2.executeUpdate(" grant select on t21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta3, " drop view v31ViewTest");
        st_mamta3.executeUpdate(" create view v31ViewTest as select t2.c122, t1.*, t3.* from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2,mamta2.t21ViewTest as t3 where t1.c111 = t3.c211");
        rs = st_mamta3.executeQuery(" select * from v31ViewTest");
        expColNames = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select(c122) on t12ViewTest from public");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, "select * from v31ViewTest");
        st_mamta2.executeUpdate(" drop table t21ViewTest");
        st_mamta1.executeUpdate(" drop table t12ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12ViewTest");
        st_mamta1.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12ViewTest values (1,'1')");
        st_mamta1.executeUpdate(" grant select (c111) on t11ViewTest to mamta3, public");
        st_mamta1.executeUpdate(" grant select (c121, c122) on t12ViewTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ViewTest");
        st_mamta2.executeUpdate(" create table t21ViewTest (c211 int)");
        st_mamta2.executeUpdate(" insert into t21ViewTest values(1)");
        st_mamta2.executeUpdate(" grant select on t21ViewTest to mamta3, mamta5");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta3, " drop view v31ViewTest");
        st_mamta3.executeUpdate(" create view v31ViewTest as select t2.c122, t1.*, t3.* from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2,mamta2.t21ViewTest as t3 where t1.c111 = t3.c211");
        rs = st_mamta3.executeQuery(" select * from v31ViewTest");
        expColNames = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select(c111) on t11ViewTest from public");
        rs = st_mamta3.executeQuery("select * from v31ViewTest");
        expColNames = new String[]{"C122", "C111", "C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select(c111) on t11ViewTest from mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, "select * from v31ViewTest");
        st_mamta2.executeUpdate(" drop table t21ViewTest");
        st_mamta1.executeUpdate(" drop table t12ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key, c112 int)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1,1)");
        st_mamta1.executeUpdate(" grant select (c111, c112) on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate(" create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        st_mamta1.executeUpdate("revoke select (c111) on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, " select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerTest");
        st_mamta1.executeUpdate(" create table t11TriggerTest (c111 int not null primary key, c112 int)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(1,1)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(2,2)");
        st_mamta1.executeUpdate(" grant select on t11TriggerTest to mamta2");
        st_mamta2.executeUpdate(" create view v21ViewTest as select * from mamta1.t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, "grant select on v21ViewTest to mamta3");
        rs = st_mamta2.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C111", "C112"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31TriggerTest");
        st_mamta3.executeUpdate(" create table t31TriggerTest (c311 int)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t32TriggerTest");
        st_mamta3.executeUpdate(" create table t32TriggerTest (c321 int)");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "create trigger tr31t31TriggerTest after insert on t31TriggerTest for each statement insert into t32TriggerTest values (select c111 from mamta2.v21ViewTest where c112=1)");
        st_mamta3.executeUpdate(" insert into t31TriggerTest values(1)");
        rs = st_mamta3.executeQuery(" select * from t31TriggerTest");
        expColNames = new String[]{"C311"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta3.executeQuery(" select * from t32TriggerTest");
        expColNames = new String[]{"C321"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("revoke select on t11TriggerTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, " select * from v21ViewTest");
        st_mamta3.executeUpdate("insert into t31TriggerTest values(1)");
        rs = st_mamta3.executeQuery(" select * from t31TriggerTest");
        expColNames = new String[]{"C311"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta3.executeQuery(" select * from t32TriggerTest");
        expColNames = new String[]{"C321"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta3.executeUpdate(" drop table t31TriggerTest");
        st_mamta3.executeUpdate(" drop table t32TriggerTest");
        st_mamta1.executeUpdate(" drop table t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        st_mamta1.executeUpdate(" grant select on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate(" create view v21ViewTest as select * from mamta1.t11ViewTest");
        rs = st_mamta2.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("grant select on t11ViewTest to PUBLIC");
        st_mamta1.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta2.executeUpdate("create view v21ViewTest as select * from mamta1.t11ViewTest");
        rs = st_mamta2.executeQuery("select * from v21ViewTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select on t11ViewTest from PUBLIC");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        st_mamta1.executeUpdate(" grant select(c111) on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate(" create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        st_mamta1.executeUpdate("grant select on t11ViewTest to mamta2");
        st_mamta1.executeUpdate("revoke select(c111) on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta2.executeUpdate("create view v21ViewTest as select * from mamta1.t11ViewTest");
        rs = st_mamta2.executeQuery("select * from v21ViewTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        st_mamta1.executeUpdate(" grant select(c111) on t11ViewTest to mamta2");
        st_mamta1.executeUpdate(" grant select on t11ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate("create view v21ViewTest as select c111 from mamta1.t11ViewTest");
        st_mamta1.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ViewTest");
        st_mamta1.executeUpdate(" create table t11ViewTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ViewTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12ViewTest");
        st_mamta1.executeUpdate(" create table t12ViewTest (c121 int, c122 char)");
        st_mamta1.executeUpdate(" insert into t12ViewTest values (1,'1')");
        st_mamta1.executeUpdate("grant select on t11ViewTest to mamta2");
        st_mamta1.executeUpdate(" grant select on t12ViewTest to mamta2");
        st_mamta2.executeUpdate(" create view v21ViewTest as select t1.c111, t2.c122 from mamta1.t11ViewTest as t1, mamta1.t12ViewTest as t2");
        rs = st_mamta2.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C111", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}, {"2", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, "grant select on v21ViewTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, " create view v31ViewTest as select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, " select * from v31ViewTest");
        st_mamta1.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta3, "drop view v31ViewTest");
        st_mamta1.executeUpdate("revoke select on t11ViewTest from mamta2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21ViewTest");
        st_mamta1.executeUpdate(" drop table t12ViewTest");
        st_mamta1.executeUpdate(" drop table t11ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c211 int references mamta1.t11ConstraintTest, c212 int)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into t21ConstraintTest values(3,1)");
        st_mamta1.executeUpdate(" revoke references on t11ConstraintTest from mamta2");
        st_mamta2.executeUpdate("insert into t21ConstraintTest values(3,1)");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        st_mamta2.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31ConstraintTest");
        st_mamta3.executeUpdate(" create table t31ConstraintTest (c311 int references mamta1.t11ConstraintTest, c312 int references mamta2.t21ConstraintTest)");
        rs = st_mamta3.executeQuery(" select * from t31ConstraintTest");
        expColNames = new String[]{"C311", "C312"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta3.executeUpdate(" insert into t31ConstraintTest values(1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values(1,3)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values(3,1)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values(3,4)");
        st_mamta2.executeUpdate("revoke references on t21ConstraintTest from mamta3");
        st_mamta3.executeUpdate("insert into t31ConstraintTest values(1,3)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values(3,1)");
        st_mamta1.executeUpdate("revoke references on t11ConstraintTest from mamta3");
        st_mamta3.executeUpdate("insert into t31ConstraintTest values(3,1)");
        st_mamta3.executeUpdate("insert into t31ConstraintTest values(3,3)");
        st_mamta3.executeUpdate("drop table t31ConstraintTest");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key references mamta1.t11ConstraintTest)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into t21ConstraintTest values(3)");
        st_mamta2.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31ConstraintTest");
        st_mamta3.executeUpdate(" create table t31ConstraintTest (c311 int references mamta2.t21ConstraintTest)");
        rs = st_mamta3.executeQuery(" select * from t31ConstraintTest");
        expColNames = new String[]{"C311"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta3.executeUpdate(" insert into t31ConstraintTest values (1)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values (4)");
        st_mamta1.executeUpdate("revoke references on t11ConstraintTest from mamta2");
        st_mamta2.executeUpdate("insert into t21ConstraintTest values(3)");
        st_mamta3.executeUpdate("insert into t31ConstraintTest values(3)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta3, "insert into t31ConstraintTest values(4)");
        st_mamta3.executeUpdate(" drop table t31ConstraintTest");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111) references mamta1.t11ConstraintTest)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into t21ConstraintTest values(3)");
        st_mamta1.executeUpdate("grant references on t11ConstraintTest to mamta2");
        st_mamta1.executeUpdate("revoke references on t11ConstraintTest from PUBLIC");
        st_mamta2.executeUpdate("insert into t21ConstraintTest values(3)");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to PUBLIC");
        st_mamta1.executeUpdate(" grant select on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111)   references mamta1.t11ConstraintTest)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into t21ConstraintTest values(3)");
        st_mamta1.executeUpdate("revoke select on t11ConstraintTest from PUBLIC");
        st_mamta2.executeUpdate("insert into t21ConstraintTest values(3)");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key, c112 int not null unique, c113 int)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1,1,1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2,2,1)");
        st_mamta1.executeUpdate(" grant references(c111, c112) on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key, constraint fk foreign key(c111)   references mamta1.t11ConstraintTest(c112))");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into t21ConstraintTest values(3)");
        st_mamta1.executeUpdate("revoke references(c111) on t11ConstraintTest from PUBLIC");
        st_mamta2.executeUpdate("insert into t21ConstraintTest values(3)");
        st_mamta2.executeUpdate(" drop table t21ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11MiscTest");
        st_mamta1.executeUpdate(" create table t11MiscTest (c111 int, c112 int, c113 int)");
        st_mamta1.executeUpdate(" grant select, update, trigger on t11MiscTest to mamta2, mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12MiscTest");
        st_mamta1.executeUpdate(" create table t12MiscTest (c121 int, c122 int)");
        st_mamta1.executeUpdate(" grant select on t12MiscTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21MiscTest");
        st_mamta2.executeUpdate(" create view v21MiscTest as select * from mamta1.t11MiscTest, mamta1.t12MiscTest where c111=c121");
        rs = st_mamta2.executeQuery(" select * from v21MiscTest");
        expColNames = new String[]{"C111", "C112", "C113", "C121", "C122"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta3, " drop view v31MiscTest");
        st_mamta3.executeUpdate(" create view v31MiscTest as select c111 from mamta1.t11MiscTest");
        rs = st_mamta3.executeQuery(" select * from v31MiscTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("revoke select, update on t11MiscTest from mamta2, mamta3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_mamta1 != null) {
                sqlWarn = st_mamta1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = mamta1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01501", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta2, "select * from v21MiscTest");
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, "select * from v31MiscTest");
        st_mamta1.executeUpdate(" drop table t11MiscTest");
        st_mamta1.executeUpdate(" drop table t12MiscTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerTest");
        st_mamta1.executeUpdate(" create table t11TriggerTest (c111 int not null primary key, c112 int)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(1,1)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(2,2)");
        st_mamta1.executeUpdate(" grant select(c111) on t11TriggerTest to mamta2");
        st_mamta1.executeUpdate(" grant select(c112) on t11TriggerTest to public");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21TriggerTest");
        st_mamta2.executeUpdate(" create table t21TriggerTest (c211 int)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t22TriggerTest");
        st_mamta2.executeUpdate(" create table t22TriggerTest (c221 int)");
        st_mamta2.executeUpdate("create trigger tr21t21TriggerTest after insert on t21TriggerTest for each statement insert into t22TriggerTest values (select c111 from mamta1.t11TriggerTest where c112=1)");
        st_mamta2.executeUpdate(" insert into t21TriggerTest values(1)");
        rs = st_mamta2.executeQuery(" select * from t21TriggerTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta2.executeQuery(" select * from t22TriggerTest");
        expColNames = new String[]{"C221"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" drop table t21TriggerTest");
        st_mamta2.executeUpdate(" drop table t22TriggerTest");
        st_mamta1.executeUpdate(" drop table t11TriggerTest");
        st_mamta1.executeUpdate(" create table t11TriggerTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(1)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12RoutineTest");
        st_mamta1.executeUpdate(" create table t12RoutineTest (c121 int)");
        st_mamta1.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        st_mamta1.executeUpdate(" grant select on t11TriggerTest to mamta2");
        st_mamta1.executeUpdate(" grant insert on t12RoutineTest to mamta2");
        rs = st_mamta1.executeQuery(" select * from t11TriggerTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12RoutineTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" create table t21TriggerTest (c211 int)");
        st_mamta2.executeUpdate("create trigger tr21t21TriggerTest after insert on t21TriggerTest for each statement insert into mamta1.t12RoutineTest values (select c111 from mamta1.t11TriggerTest where c111=1)");
        st_mamta2.executeUpdate("insert into t21TriggerTest values(1)");
        rs = st_mamta2.executeQuery(" select * from t21TriggerTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t11TriggerTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12RoutineTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42500", st_mamta2, "create trigger tr11t11TriggerTest after insert on mamta1.t11TriggerTest for each statement insert into mamta1.t12RoutineTest values (1)");
        st_mamta1.executeUpdate(" grant trigger on t11TriggerTest to mamta2");
        st_mamta2.executeUpdate("create trigger tr11t11TriggerTest after insert on mamta1.t11TriggerTest for each statement insert into mamta1.t12RoutineTest values (1)");
        GrantRevokeDDLTest.assertStatementError("42500", st_mamta2, "insert into mamta1.t11TriggerTest values(3)");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 2, " delete from t11TriggerTest");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 3, " delete from t12RoutineTest");
        st_mamta1.executeUpdate(" insert into mamta1.t11TriggerTest values(3)");
        rs = st_mamta1.executeQuery(" select * from t11TriggerTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12RoutineTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop table t11TriggerTest");
        st_mamta1.executeUpdate(" drop table t12RoutineTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12RoutineTest");
        st_mamta1.executeUpdate(" create table t12RoutineTest (c121 int)");
        st_mamta1.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t13TriggerTest");
        st_mamta1.executeUpdate(" create table t13TriggerTest (c131 int)");
        st_mamta1.executeUpdate(" insert into t13TriggerTest values (1),(2)");
        st_mamta1.executeUpdate(" grant select on t12RoutineTest to mamta3");
        st_mamta1.executeUpdate(" grant insert on t13TriggerTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop function selectFromSpecificSchema");
        st_mamta1.executeUpdate(" CREATE FUNCTION selectFromSpecificSchema (P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_mamta1.executeUpdate(" grant execute on function selectFromSpecificSchema to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31TriggerTest");
        st_mamta3.executeUpdate(" create table t31TriggerTest(c11 int)");
        st_mamta3.executeUpdate("create trigger tr31t31 after insert on t31TriggerTest for each statement insert into mamta1.t13TriggerTest values (values mamta1.selectFromSpecificSchema(1))");
        st_mamta3.executeUpdate("insert into t31TriggerTest values(1)");
        rs = st_mamta3.executeQuery(" select * from t31TriggerTest");
        expColNames = new String[]{"C11"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12RoutineTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t13TriggerTest");
        expColNames = new String[]{"C131"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42500", st_mamta2, "insert into mamta3.t31TriggerTest values(1)");
        st_mamta3.executeUpdate(" grant insert on t31TriggerTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("38000", st_mamta2, "insert into mamta3.t31TriggerTest values(1)");
        st_mamta1.executeUpdate(" grant select on t12RoutineTest to mamta2");
        st_mamta2.executeUpdate("insert into mamta3.t31TriggerTest values(1)");
        rs = st_mamta3.executeQuery(" select * from t31TriggerTest");
        expColNames = new String[]{"C11"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12RoutineTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t13TriggerTest");
        expColNames = new String[]{"C131"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"1"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 4, " delete from t13TriggerTest");
        GrantRevokeDDLTest.assertStatementError("X0Y25", st_mamta1, "revoke execute on function selectFromSpecificSchema from mamta3 restrict");
        st_mamta2.executeUpdate(" insert into mamta3.t31TriggerTest values(1)");
        rs = st_mamta1.executeQuery("select * from t13TriggerTest");
        expColNames = new String[]{"C131"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta3.executeUpdate("drop trigger tr31t31");
        st_mamta1.executeUpdate("revoke execute on function selectFromSpecificSchema from mamta3 restrict");
        st_mamta3.executeUpdate("drop table t31TriggerTest");
        st_mamta1.executeUpdate("drop table t12RoutineTest");
        st_mamta1.executeUpdate(" drop table t13TriggerTest");
        st_mamta1.executeUpdate(" drop function selectFromSpecificSchema");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12RoutineTest");
        st_mamta1.executeUpdate(" create table t12RoutineTest (c121 int)");
        st_mamta1.executeUpdate(" insert into t12RoutineTest values (1),(2)");
        st_mamta1.executeUpdate(" grant select on t12RoutineTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop function selectFromSpecificSchema");
        st_mamta1.executeUpdate(" CREATE FUNCTION selectFromSpecificSchema (P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_mamta1.executeUpdate(" grant execute on function selectFromSpecificSchema to mamta3");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta3, " drop view v21ViewTest");
        st_mamta3.executeUpdate("create view v21ViewTest(c211) as values mamta1.selectFromSpecificSchema(1)");
        rs = st_mamta3.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta3, " grant select on v21ViewTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta2, "select * from mamta3.v21ViewTest");
        st_mamta1.executeUpdate(" grant select  on t12RoutineTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta2, "select * from mamta3.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerTest");
        st_mamta1.executeUpdate(" create table t11TriggerTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(1)");
        st_mamta1.executeUpdate(" insert into t11TriggerTest values(2)");
        st_mamta1.executeUpdate(" grant select on t11TriggerTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_mamta2, " drop view v21ViewTest");
        st_mamta2.executeUpdate(" create view v21ViewTest as select * from mamta1.t11TriggerTest");
        GrantRevokeDDLTest.assertStatementError("4250A", st_mamta2, " grant select on v21ViewTest to mamta4");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31TriggerTest");
        st_mamta3.executeUpdate(" create table t31TriggerTest (c311 int)");
        st_mamta3.executeUpdate(" grant insert on t31TriggerTest to mamta4");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_mamta4, " drop table t41TriggerTest");
        st_mamta4.executeUpdate(" create table t41TriggerTest (c411 int)");
        GrantRevokeDDLTest.assertStatementError("42X94", st_mamta4, " drop trigger tr41t41");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta4, " create trigger tr41t41 after insert on t41TriggerTest for each statement insert into mamta3.t31TriggerTest (select * from mamta2.v21ViewTest)");
        st_mamta4.executeUpdate(" insert into t41TriggerTest values(1)");
        st_mamta4.executeUpdate(" insert into t41TriggerTest values(2)");
        rs = st_mamta4.executeQuery(" select * from t41TriggerTest");
        expColNames = new String[]{"C411"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t11TriggerTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta2.executeQuery(" select * from v21ViewTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta3.executeQuery(" select * from t31TriggerTest");
        expColNames = new String[]{"C311"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        GrantRevokeDDLTest.assertStatementError("42500", st_mamta3, "insert into mamta4.t41TriggerTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta2.v21ViewTest");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select * from mamta1.t11TriggerTest");
        st_mamta4.executeUpdate(" grant insert on t41TriggerTest to mamta3");
        st_mamta3.executeUpdate("insert into mamta4.t41TriggerTest values(1)");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(1)");
        st_mamta1.executeUpdate(" insert into t11ConstraintTest values(2)");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21ConstraintTest");
        st_mamta2.executeUpdate(" create table t21ConstraintTest (c111 int not null primary key)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(1)");
        st_mamta2.executeUpdate(" insert into t21ConstraintTest values(2)");
        st_mamta2.executeUpdate(" grant references on t21ConstraintTest to mamta3");
        st_mamta3.executeUpdate(" create table t31ConstraintTest (c311 int references mamta1.t11ConstraintTest, c312 int references mamta2.t21ConstraintTest)");
        st_mamta3.executeUpdate(" drop table t31ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        st_mamta1.executeUpdate(" grant references on t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31ConstraintTest");
        st_mamta3.executeUpdate(" create table t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.t11ConstraintTest)");
        st_mamta3.executeUpdate(" drop table t31ConstraintTest");
        st_mamta1.executeUpdate(" drop table t11ConstraintTest");
        st_mamta1.executeUpdate(" create table t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        st_mamta1.executeUpdate(" grant references(c111) on t11ConstraintTest to mamta3");
        st_mamta1.executeUpdate(" grant references(c112) on t11ConstraintTest to PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table t31ConstraintTest");
        st_mamta3.executeUpdate(" create table t31ConstraintTest (c311 int,  c312 int, foreign key(c311, c312) references mamta1.t11ConstraintTest)");
        st_mamta3.executeUpdate(" drop table t31ConstraintTest");
        st_mamta3.executeUpdate("create table t31constrainttest(c311 int, c312 int)");
        st_mamta3.executeUpdate(" alter table t31constrainttest add foreign key (c311, c312) references mamta1.t11constrainttest");
        st_mamta3.executeUpdate(" drop table t31ConstraintTest");
        st_mamta3.executeUpdate("create table t31constrainttest(c311 int, c312 int, c313 int references mamta2.t21ConstraintTest)");
        st_mamta3.executeUpdate(" alter table t31constrainttest add foreign key (c311, c312) references mamta1.t11constrainttest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerRevokeTest");
        st_mamta1.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        st_mamta1.executeUpdate("grant TRIGGER on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21TriggerRevokeTest");
        st_mamta2.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        st_mamta2.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(3)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(4)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42500", st_mamta2, "create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        st_mamta1.executeUpdate(" grant trigger on t11TriggerRevokeTest to mamta2");
        st_mamta2.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        rs = st_mamta2.executeQuery(" select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(5)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}, {"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" drop table t21TriggerRevokeTest");
        st_mamta1.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(6)");
        st_mamta1.executeUpdate("drop table t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerRevokeTest");
        st_mamta1.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key)");
        st_mamta1.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        st_mamta1.executeUpdate(" grant SELECT on t11TriggerRevokeTest to mamta2");
        st_mamta1.executeUpdate("grant TRIGGER on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21TriggerRevokeTest");
        st_mamta2.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        st_mamta2.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(3)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke SELECT on t11TriggerRevokeTest from mamta2");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(4)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate("create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement insert into t21TriggerRevokeTest values(99)");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(5)");
        rs = st_mamta2.executeQuery("select * from t21TriggerRevokeTest");
        expColNames = new String[]{"C211"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}, {"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" drop table t21TriggerRevokeTest");
        st_mamta1.executeUpdate("revoke trigger on t11TriggerRevokeTest from mamta2");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(6)");
        st_mamta1.executeUpdate("drop table t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t11TriggerRevokeTest");
        st_mamta1.executeUpdate(" create table t11TriggerRevokeTest (c111 int)");
        st_mamta1.executeUpdate(" insert into t11TriggerRevokeTest values(1),(2)");
        st_mamta1.executeUpdate(" grant INSERT on t11TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta1, " drop table t12TriggerRevokeTest");
        st_mamta1.executeUpdate(" create table t12TriggerRevokeTest (c121 int)");
        st_mamta1.executeUpdate(" insert into t12TriggerRevokeTest values(1),(2)");
        st_mamta1.executeUpdate(" grant INSERT on t12TriggerRevokeTest to mamta2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta2, " drop table t21TriggerRevokeTest");
        st_mamta2.executeUpdate(" create table t21TriggerRevokeTest (c211 int)");
        st_mamta2.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        st_mamta2.executeUpdate("create trigger tr211t21 after insert on t21TriggerRevokeTest for each statement insert into mamta1.t11TriggerRevokeTest values(99)");
        st_mamta2.executeUpdate("create trigger tr212t21 after insert on t21TriggerRevokeTest for each statement insert into mamta1.t12TriggerRevokeTest values(99)");
        st_mamta2.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        rs = st_mamta1.executeQuery("select * from t11TriggerRevokeTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12TriggerRevokeTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 3, " delete from t11TriggerRevokeTest");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 3, " delete from t12TriggerRevokeTest");
        st_mamta1.executeUpdate("revoke insert on t11TriggerRevokeTest from mamta2");
        st_mamta2.executeUpdate(" insert into t21TriggerRevokeTest values(1)");
        rs = st_mamta1.executeQuery("select * from t11TriggerRevokeTest");
        expColNames = new String[]{"C111"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_mamta1.executeQuery("select * from t12TriggerRevokeTest");
        expColNames = new String[]{"C121"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"99"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta2.executeUpdate(" drop table t21TriggerRevokeTest");
        st_mamta1.executeUpdate(" drop table t12TriggerRevokeTest");
        st_mamta1.executeUpdate(" drop table t11TriggerRevokeTest");
        st_mamta1.executeUpdate("create table newTable(i int, j int, k int)");
        st_mamta1.executeUpdate(" grant select, update(j) on newTable to sammy");
        st_mamta1.executeUpdate(" grant references, delete on newTable to user1");
        st_mamta1.executeUpdate("create view myView as select * from newTable");
        st_mamta1.executeUpdate(" grant select on myView to sammy");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"USER1", "MAMTA1", "N", "y", "N", "N", "y", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY' or grantee='USER1'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "u", "{1}"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop view myView");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "y", "N", "N", "N", "N", "N"}, {"USER1", "MAMTA1", "N", "y", "N", "N", "y", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop table newTable");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY' or grantee='USER1'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY' or grantee='USER1'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("CREATE FUNCTION newFunction(P1 INT) RETURNS INT RETURNS NULL ON NULL INPUT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.selectFromSpecificSchema'LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_mamta1.executeUpdate(" grant execute on function newFunction to sammy");
        st_mamta1.executeUpdate(" grant execute on function newFunction(INT) to user3");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY' or grantee='USER3'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "N"}, {"USER3", "MAMTA1", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop function newFunction");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY' or grantee='USER3'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta1.executeUpdate("create table newTable(i int, j int, k int)");
        st_mamta1.executeUpdate(" grant select(i,j), delete on newTable to sammy");
        st_mamta1.executeUpdate(" CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_mamta1.executeUpdate(" grant execute on function f_abs to sammy");
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "s", "{0, 1}"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SAMMY", "MAMTA1", "N", "y", "N", "N", "N", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        Connection sammyConnection = this.openUserConnection("sammy");
        Statement st_sammyConnection = sammyConnection.createStatement();
        st_sammyConnection.executeUpdate(" set schema mamta1");
        rs = st_sammyConnection.executeQuery(" select i,j from newTable");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_sammyConnection.executeQuery(" values f_abs(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" drop table newTable");
        st_mamta1.executeUpdate(" drop function f_abs");
        rs = st_mamta1.executeQuery("select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, TYPE, COLUMNS from sys.syscolperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_mamta1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms where grantee='SAMMY'");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        rs = st_mamta1.executeQuery("VALUES { fn ACOS(0.0707) }");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1.5000372950430991"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" VALUES ACOS(0.0707)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1.5000372950430991"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" VALUES PI()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3.141592653589793"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" create table SYSFUN_MATH_TEST (d double)");
        st_mamta1.executeUpdate(" insert into SYSFUN_MATH_TEST values null");
        st_mamta1.executeUpdate(" insert into SYSFUN_MATH_TEST values 0.67");
        st_mamta1.executeUpdate(" insert into SYSFUN_MATH_TEST values 1.34");
        rs = st_mamta1.executeQuery(" select cast (ATAN(d) as DECIMAL(6,3)) AS ATAN FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"ATAN"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0.590"}, {"0.929"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select cast (COS(d) as DECIMAL(6,3)) AS COS FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"COS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0.783"}, {"0.228"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select cast (SIN(d) as DECIMAL(6,3)) AS SIN FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"SIN"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0.620"}, {"0.973"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select cast (TAN(d) as DECIMAL(6,3)) AS TAN FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"TAN"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0.792"}, {"4.255"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select cast (DEGREES(d) as DECIMAL(6,3)) AS DEGREES FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"DEGREES"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"38.388"}, {"76.776"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select cast (RADIANS(d) as DECIMAL(6,3)) AS RADIANS FROM SYSFUN_MATH_TEST");
        expColNames = new String[]{"RADIANS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null}, {"0.011"}, {"0.023"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("CREATE FUNCTION F_ABS(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_mamta1.executeUpdate(" create table mamta1Table ( i int, j int)");
        GrantRevokeDDLTest.assertStatementError("42509", st_mamta1, "grant select on mamta1Table to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st_mamta1, " revoke select on mamta1Table from mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st_mamta1, " grant execute on function f_abs to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st_mamta1, " revoke execute on function f_abs from mamta1 restrict");
        st.executeUpdate(" set schema mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st, " grant select on mamta1Table to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st, " revoke select on mamta1Table from mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st, " grant execute on function f_abs to mamta1");
        GrantRevokeDDLTest.assertStatementError("42509", st, " revoke execute on function f_abs from mamta1 restrict");
        st.executeUpdate("grant select on mamta1Table to randy");
        st.executeUpdate(" revoke select on mamta1Table from randy");
        st.executeUpdate(" grant execute on function f_abs to randy");
        st.executeUpdate(" revoke execute on function f_abs from randy restrict");
        st_mamta1.executeUpdate(" drop table mamta1Table");
        st_mamta1.executeUpdate(" drop function f_abs");
        Connection user1 = this.openUserConnection("user1");
        Statement st_user1 = user1.createStatement();
        st_user1.executeUpdate(" create table t100 (i int)");
        Connection user2 = this.openUserConnection("user2");
        Statement st_user2 = user2.createStatement();
        user2.setAutoCommit(false);
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "lock table user1.t100 in exclusive mode");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, " lock table user1.t100 in share mode");
        user1.commit();
        st_user1.executeUpdate(" grant select on t100 to user2");
        st_user2.executeUpdate("lock table user1.t100 in exclusive mode");
        st_user2.executeUpdate(" lock table user1.t100 in share mode");
        user1.commit();
        st_user1.executeUpdate(" revoke select on t100 from user2");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "lock table user1.t100 in exclusive mode");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, " lock table user1.t100 in share mode");
        user2.commit();
        user2.setAutoCommit(true);
        st_user1.executeUpdate(" create table t1 (i int)");
        st_user1.executeUpdate(" insert into t1 values 1,2,3");
        st_user1.executeUpdate(" grant select on t1 to user2");
        st_user2.executeUpdate(" create view v1 as select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError("42506", st_user2, "grant select on user1.t1 to user3");
        GrantRevokeDDLTest.assertStatementError("4250A", st_user2, "grant select on v1 to user3");
        st_user2.executeUpdate(" drop view v1");
        st_user1.executeUpdate(" drop table t1");
        user2.setAutoCommit(true);
        user2.setAutoCommit(true);
        st_mamta1.executeUpdate(" create table t11TriggerRevokeTest (c111 int not null primary key, c12 int)");
        st_mamta1.executeUpdate(" insert into t11TriggerRevokeTest values (1, 101), (2, 202), (3, 303)");
        st_mamta1.executeUpdate(" grant TRIGGER on t11TriggerRevokeTest to mamta2");
        st_mamta1.executeUpdate(" create table t12TriggerRevokeTest (c121 int, c122 int, c123 int)");
        st_mamta1.executeUpdate(" insert into t12TriggerRevokeTest values (10, 1010, 2010),(20,1020,2020)");
        st_mamta1.executeUpdate(" grant UPDATE(c122, c121) on t12TriggerRevokeTest to mamta2");
        st_mamta2.executeUpdate(" create trigger tr11t11 after insert on mamta1.t11TriggerRevokeTest for each statement update mamta1.t12TriggerRevokeTest set c122 = 99");
        rs = st_mamta1.executeQuery(" select * from t11TriggerRevokeTest");
        expColNames = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12TriggerRevokeTest");
        expColNames = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10", "1010", "2010"}, {"20", "1020", "2020"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values(4, 404)");
        rs = st_mamta1.executeQuery(" select * from t11TriggerRevokeTest");
        expColNames = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}, {"4", "404"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12TriggerRevokeTest");
        expColNames = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10", "99", "2010"}, {"20", "99", "2020"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate("revoke TRIGGER on t11TriggerRevokeTest from mamta2");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 2, " update t12TriggerRevokeTest set c122 = 42");
        st_mamta1.executeUpdate("insert into t11TriggerRevokeTest values (5,505)");
        rs = st_mamta1.executeQuery(" select * from t11TriggerRevokeTest");
        expColNames = new String[]{"C111", "C12"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "101"}, {"2", "202"}, {"3", "303"}, {"4", "404"}, {"5", "505"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_mamta1.executeQuery(" select * from t12TriggerRevokeTest");
        expColNames = new String[]{"C121", "C122", "C123"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10", "42", "2010"}, {"20", "42", "2020"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" create table t1001 (c varchar(1))");
        st_mamta1.executeUpdate(" insert into t1001 values 'a', 'b', 'c'");
        mamta1.setAutoCommit(false);
        st_mamta1.executeUpdate(" grant select on t1001 to mamta3");
        st_mamta2.executeUpdate(" create table ttt1 (i int)");
        st_mamta2.executeUpdate(" insert into ttt1 values 1");
        st_mamta2.executeUpdate(" grant all privileges on ttt1 to mamta1");
        rs = st_mamta1.executeQuery(" select * from mamta2.ttt1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_mamta1.executeUpdate(" insert into mamta2.ttt1 values 2");
        GrantRevokeDDLTest.assertUpdateCount(st_mamta1, 2, " update mamta2.ttt1 set i = 888");
        mamta1.commit();
        mamta1.setAutoCommit(true);
        st_mamta1.executeUpdate(" create table d1589t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        st_mamta1.executeUpdate(" grant references on d1589t11ConstraintTest to mamta3");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_mamta3, " drop table d1589t31ConstraintTest");
        st_mamta3.executeUpdate(" create table d1589t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.d1589t11ConstraintTest)");
        st_mamta3.executeUpdate(" drop table d1589t31ConstraintTest");
        st_mamta1.executeUpdate(" drop table d1589t11ConstraintTest");
        st_mamta1.executeUpdate(" create table d1589t11ConstraintTest (c111 int not null, c112 int not null, primary key (c111, c112))");
        st_mamta1.executeUpdate(" grant references(c111) on d1589t11ConstraintTest to mamta3");
        st_mamta1.executeUpdate(" grant references(c112) on d1589t11ConstraintTest to PUBLIC");
        st_mamta3.executeUpdate(" create table d1589t31ConstraintTest (c311 int, c312 int, foreign key(c311, c312) references mamta1.d1589t11ConstraintTest)");
        st_mamta2.executeUpdate(" create table t1Derby1847 (c1 int, c2 int)");
        st_mamta2.executeUpdate(" grant select(c1,c2) on t1Derby1847 to mamta3");
        st_mamta2.executeUpdate(" alter table t1Derby1847 add c3 int");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select c3 from mamta2.t1Derby1847");
        st_mamta2.executeUpdate(" grant select on t1Derby1847 to mamta3");
        rs = st_mamta3.executeQuery("select c3 from mamta2.t1Derby1847");
        expColNames = new String[]{"C3"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta2.executeUpdate(" revoke select on t1Derby1847 from mamta3");
        GrantRevokeDDLTest.assertStatementError("42502", st_mamta3, "select c3 from mamta2.t1Derby1847");
        st_mamta2.executeUpdate(" grant select(c3) on t1Derby1847 to mamta3");
        rs = st_mamta3.executeQuery("select c3 from mamta2.t1Derby1847");
        expColNames = new String[]{"C3"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertEmpty(rs);
        st_mamta2.executeUpdate(" drop table t1Derby1847");
        GrantRevokeDDLTest.assertStatementError("42X05", st_mamta3, " select c3 from mamta2.t1Derby1847");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table t1");
        st_user1.executeUpdate(" create table t1 (c varchar(1))");
        st_user1.executeUpdate(" insert into t1 values 'a', 'b', 'c'");
        st_user1.executeUpdate(" grant select on t1 to user2");
        user2.setAutoCommit(false);
        st_user1.executeUpdate(" grant select on t1 to user2");
        user2.setAutoCommit(false);
        PreparedStatement ps_crs1 = user2.prepareStatement("select * from user1.t1");
        ResultSet crs1 = ps_crs1.executeQuery();
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"a", (String)crs1.getString(1));
        st_user1.executeUpdate("revoke select on t1 from user2");
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"b", (String)crs1.getString(1));
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"c", (String)crs1.getString(1));
        crs1.close();
        ps_crs1.close();
        user2.commit();
        PreparedStatement ps_crs2 = user2.prepareStatement("select * from user1.t1");
        try {
            ResultSet resultSet = ps_crs2.executeQuery();
        }
        catch (SQLException e) {
            GrantRevokeDDLTest.assertSQLState("42502", e);
        }
        user2.setAutoCommit(true);
        st_user1.executeUpdate(" grant select on t1 to user2");
        user2.setAutoCommit(false);
        ps_crs1 = user2.prepareStatement("select * from user1.t1");
        crs1 = ps_crs1.executeQuery();
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"a", (String)crs1.getString(1));
        st_user1.executeUpdate("revoke select on t1 from user2");
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"b", (String)crs1.getString(1));
        crs1.next();
        GrantRevokeDDLTest.assertEquals((String)"c", (String)crs1.getString(1));
        crs1.close();
        ps_crs1.close();
        user2.commit();
        ps_crs2 = user2.prepareStatement("select * from user1.t1");
        try {
            ResultSet e = ps_crs2.executeQuery();
        }
        catch (SQLException e) {
            GrantRevokeDDLTest.assertSQLState("42502", e);
        }
        user1.setAutoCommit(true);
        st_user1.executeUpdate("create table d1847_c (a int, b int, c int)");
        st_user1.executeUpdate(" grant select (a) on d1847_c to first_user");
        st_user1.executeUpdate(" grant update (b) on d1847_c to second_user");
        st_user1.executeUpdate(" grant select (c) on d1847_c to third_user");
        rs = st_user1.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1847_C'");
        expColNames = new String[]{"GRANTEE", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"FIRST_USER", "s", "{0}"}, {"SECOND_USER", "u", "{1}"}, {"THIRD_USER", "s", "{2}"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" alter table d1847_c add column d int");
        rs = st_user1.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1847_C'");
        expColNames = new String[]{"GRANTEE", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"FIRST_USER", "s", "{0}"}, {"SECOND_USER", "u", "{1}"}, {"THIRD_USER", "s", "{2}"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate("DROP VIEW TEST_DBO.V11");
        st.executeUpdate("DROP VIEW MAMTA1.V23");
        st.executeUpdate("DROP VIEW MAMTA2.V21");
        st.executeUpdate("DROP VIEW MAMTA2.V21VIEWTEST");
        st.executeUpdate("DROP VIEW MAMTA2.V22");
        st.executeUpdate("DROP VIEW MAMTA2.V23");
        st.executeUpdate("DROP VIEW MAMTA2.V26");
        st.executeUpdate("DROP VIEW MAMTA2.V27");
        st.executeUpdate("DROP VIEW MAMTA2.V28");
        st.executeUpdate("DROP VIEW MAMTA3.V21VIEWTEST");
        st.executeUpdate("DROP FUNCTION MAMTA1.SELECTFROMSPECIFICSCHEMA");
        st.executeUpdate("DROP TRIGGER MAMTA2.TR21T21TRIGGERTEST");
        st.executeUpdate("DROP TABLE MAMTA4.T41TRIGGERTEST");
        st.executeUpdate("DROP TABLE MAMTA3.D1589T31CONSTRAINTTEST");
        st.executeUpdate("DROP TABLE MAMTA3.T31");
        st.executeUpdate("DROP TABLE MAMTA3.T31CONSTRAINTTEST");
        st.executeUpdate("DROP TABLE MAMTA3.T31TRIGGERTEST");
        st.executeUpdate("DROP TABLE MAMTA2.T21CONSTRAINTTEST");
        st.executeUpdate("DROP TABLE MAMTA2.T21TRIGGERTEST");
        st.executeUpdate("DROP TABLE MAMTA2.TTT1");
        st.executeUpdate("DROP TABLE MAMTA1.SYSFUN_MATH_TEST");
        st.executeUpdate("DROP TABLE MAMTA1.D1589T11CONSTRAINTTEST");
        st.executeUpdate("DROP TABLE MAMTA1.T11CONSTRAINTTEST");
        st.executeUpdate("DROP TABLE MAMTA1.T11TRIGGERREVOKETEST");
        st.executeUpdate("DROP TABLE MAMTA1.T11TRIGGERTEST");
        st.executeUpdate("DROP TABLE MAMTA1.T11");
        st.executeUpdate("DROP TABLE MAMTA1.T12");
        st.executeUpdate("DROP TABLE MAMTA1.T12ROUTINETEST");
        st.executeUpdate("DROP TABLE MAMTA1.T12TRIGGERREVOKETEST");
        st.executeUpdate("DROP TABLE MAMTA1.T13");
        st.executeUpdate("DROP TABLE MAMTA1.T14");
        st.executeUpdate("DROP TABLE MAMTA1.T15");
        st.executeUpdate("DROP TABLE MAMTA1.T1001");
        st.executeUpdate("DROP TABLE MONICA.SHOULDPASS");
        st.executeUpdate("DROP TABLE SAM.SAMTABLE");
        st.executeUpdate("DROP TABLE SWIPER.MYTAB");
        st.executeUpdate("DROP TABLE SWIPER.MY_TSAT");
        st.executeUpdate("DROP TABLE SWIPER.SWIPERTAB");
        st.executeUpdate("DROP TABLE USER1.D1847_C");
        st.executeUpdate("DROP TABLE USER1.T1");
        st.executeUpdate("DROP TABLE USER1.T100");
        st.executeUpdate("DROP SCHEMA DERBY RESTRICT");
        st.executeUpdate("DROP SCHEMA GEORGE RESTRICT");
        st.executeUpdate("DROP SCHEMA MAMTA1 RESTRICT");
        st.executeUpdate("DROP SCHEMA MAMTA2 RESTRICT");
        st.executeUpdate("DROP SCHEMA MAMTA3 RESTRICT");
        st.executeUpdate("DROP SCHEMA MAMTA4 RESTRICT");
        st.executeUpdate("DROP SCHEMA MONICA RESTRICT");
        st.executeUpdate("DROP SCHEMA MYDODO RESTRICT");
        st.executeUpdate("DROP SCHEMA MYFRIEND RESTRICT");
        st.executeUpdate("DROP SCHEMA MYSCHEMA RESTRICT");
        st.executeUpdate("DROP SCHEMA SAM RESTRICT");
        st.executeUpdate("DROP SCHEMA SWIPER RESTRICT");
        st.executeUpdate("DROP SCHEMA TESTSCHEMA RESTRICT");
        st.executeUpdate("DROP SCHEMA TEST_DBO RESTRICT");
        st.executeUpdate("DROP SCHEMA USER1 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER2 RESTRICT");
        st_barConnection.close();
        st_CONNECTION0.close();
        st_CONNECTION1.close();
        st_mamta1.close();
        st_mamta2.close();
        st_mamta3.close();
        st_mamta4.close();
        st_monicaConnection.close();
        st_samConnection.close();
        st_swiperConnection.close();
        st_satConnection.close();
        st_sammyConnection.close();
        st_user1.close();
        st_user2.close();
        st.close();
        barConnection.close();
        CONNECTION0.close();
        CONNECTION1.close();
        mamta1.close();
        mamta2.close();
        mamta3.close();
        mamta4.close();
        monicaConnection.close();
        samConnection.close();
        sammyConnection.close();
        satConnection.close();
        swiperConnection.close();
        user1.close();
        user2.close();
    }

    public void testGrantRevokeDDL2() throws SQLException {
        ResultSet rs = null;
        SQLWarning sqlWarn = null;
        Statement st = this.createStatement();
        st.executeUpdate("CREATE SCHEMA AUTHORIZATION USER1");
        st.executeUpdate("CREATE SCHEMA AUTHORIZATION USER2");
        Connection user1 = this.openUserConnection("user1");
        Statement st_user1 = user1.createStatement();
        Connection user2 = this.openUserConnection("user2");
        Statement st_user2 = user2.createStatement();
        Connection user3 = this.openUserConnection("user3");
        Statement st_user3 = user3.createStatement();
        Connection user4 = this.openUserConnection("user4");
        Statement st_user4 = user4.createStatement();
        Connection user5 = this.openUserConnection("user5");
        Statement st_user5 = user5.createStatement();
        st_user1.executeUpdate(" create table t1 (i int primary key, b char(15))");
        st_user1.executeUpdate(" insert into t1 values (1, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (2, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (3, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (4, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (5, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (6, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (7, 'XYZ')");
        st_user1.executeUpdate(" insert into t1 values (8, 'XYZ')");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, "drop table t2");
        st_user1.executeUpdate(" create table t2 (x integer, y integer)");
        st_user1.executeUpdate(" create procedure grant_select_proc1() parameter style java dynamic result sets 0 language java NO SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        st_user1.executeUpdate(" create procedure grant_select_proc2() parameter style java dynamic result sets 0 language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        st_user1.executeUpdate(" create procedure grant_select_proc3() parameter style java dynamic result sets 0 language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        st_user1.executeUpdate(" create procedure grant_select_proc4() parameter style java dynamic result sets 0 language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.grantSelect'");
        st_user1.executeUpdate(" create procedure revoke_select_proc1() parameter style java dynamic result sets 0 language java NO SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        st_user1.executeUpdate(" create procedure revoke_select_proc2() parameter style java dynamic result sets 0 language java CONTAINS SQL external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        st_user1.executeUpdate(" create procedure revoke_select_proc3() parameter style java dynamic result sets 0 language java READS SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        st_user1.executeUpdate(" create procedure revoke_select_proc4() parameter style java dynamic result sets 0 language java MODIFIES SQL DATA external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.revokeSelect'");
        st_user1.executeUpdate("create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc1()");
        GrantRevokeDDLTest.assertStatementError("38001", st_user1, "delete from t1 where i = 1");
        rs = st_user1.executeQuery("select * from t1 where i = 1");
        String[] expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t1 where i = 1");
        st_user1.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc2()");
        GrantRevokeDDLTest.assertStatementError("38002", st_user1, "delete from t1 where i = 2");
        rs = st_user1.executeQuery("select * from t1 where i = 2");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t1 where i = 1");
        st_user1.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc3()");
        GrantRevokeDDLTest.assertStatementError("38002", st_user1, "delete from t1 where i = 3");
        rs = st_user1.executeQuery("select * from t1 where i = 3");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger grant_select_trig");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t1 where i = 1");
        st_user1.executeUpdate(" create trigger grant_select_trig AFTER delete on t1 for each STATEMENT call grant_select_proc4()");
        GrantRevokeDDLTest.assertUpdateCount(st_user1, 1, "delete from t1 where i = 4");
        rs = st_user1.executeQuery("select * from t1 where i = 4");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user1.executeUpdate(" drop trigger grant_select_trig");
        rs = st_user2.executeQuery("select * from user1.t1 where i = 1");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc1()");
        GrantRevokeDDLTest.assertStatementError("38001", st_user1, "delete from t1 where i = 5");
        rs = st_user1.executeQuery("select * from t1 where i = 5");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger revoke_select_trig");
        rs = st_user2.executeQuery("select * from user1.t1 where i = 1");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc2()");
        GrantRevokeDDLTest.assertStatementError("38002", st_user1, "delete from t1 where i = 6");
        rs = st_user1.executeQuery("select * from t1 where i = 6");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger revoke_select_trig");
        rs = st_user2.executeQuery("select * from user1.t1 where i = 1");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc3()");
        GrantRevokeDDLTest.assertStatementError("38002", st_user1, "delete from t1 where i = 7");
        rs = st_user1.executeQuery("select * from t1 where i = 7");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"7", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" drop trigger revoke_select_trig");
        rs = st_user2.executeQuery("select * from user1.t1 where i = 1");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create trigger revoke_select_trig AFTER delete on t1 for each STATEMENT call revoke_select_proc4()");
        GrantRevokeDDLTest.assertUpdateCount(st_user1, 1, "delete from t1 where i = 8");
        rs = st_user1.executeQuery("select * from t1 where i = 8");
        expColNames = new String[]{"I", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user1.executeUpdate(" drop trigger revoke_select_trig");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t1 where i = 1");
        st_user1.executeUpdate(" drop table t2");
        st_user1.executeUpdate(" drop table t1");
        st_user1.executeUpdate(" create table t1 (c1 int primary key not null, c2 varchar(10))");
        st_user1.executeUpdate(" create table t2 (c1 int primary key not null, c2 varchar(10), c3 int)");
        st_user1.executeUpdate(" create index idx1 on t1(c2)");
        st_user1.executeUpdate(" insert into t1 values (1, 'a'), (2, 'b'), (3, 'c')");
        st_user1.executeUpdate(" insert into t2 values (1, 'Yip', 10)");
        rs = st_user1.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        rs = st_user1.executeQuery(" values f_abs1(-5)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, "grant select on table t0 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, "revoke select on table t0 from user2");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "grant select on t0, t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "revoke select on t0, t1 from user2");
        st_user1.executeUpdate("revoke select,insert,update,delete,trigger,references on t1 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "grant select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, " revoke select on t1 to user2");
        st_user1.executeUpdate("grant select, select on t1 to user2");
        st_user1.executeUpdate(" revoke select, select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "insert into user1.t1(c1) values 4");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "update user1.t1 set c1=10");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "delete from user1.t1");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "create table t2 (c1 int primary key not null, c2 int references user1.t1)");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "create trigger trigger1 after update on user1.t1 for each statement values integer('123')");
        GrantRevokeDDLTest.assertStatementError("42507", st_user2, "drop index user1.idx1");
        GrantRevokeDDLTest.assertStatementError("42507", st_user2, "drop table user1.t1");
        GrantRevokeDDLTest.assertStatementError("42506", st_user2, "grant select,insert,delete,update,references,trigger on user1.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42506", st_user2, "grant select,insert,delete,update,references,trigger on user1.t1 to public");
        GrantRevokeDDLTest.assertStatementError("42506", st_user2, "grant ALL PRIVILEGES on user1.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42506", st_user2, "grant ALL PRIVILEGES on user1.t1 to public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "revoke select,insert,delete,update,references,trigger on user1.t1 from user1");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "revoke ALL PRIVILEGES on user1.t1 from user1");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "revoke execute on function user1.f1 from user1 restrict");
        st_user2.executeUpdate(" create table t2 (c1 int)");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "revoke select on t2 from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "grant select on t2 to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "grant insert on t2 to user2,user2,user2");
        GrantRevokeDDLTest.assertStatementError("42504", st_user2, "values user1.F_ABS1(-9)");
        rs = st_user1.executeQuery(" select * from sys.systableperms");
        expColNames = new String[]{"TABLEPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st_user1.executeQuery(" select * from sys.syscolperms");
        expColNames = new String[]{"COLPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st_user1.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" grant select,update on table t1 to user2, user3");
        st_user1.executeUpdate(" grant execute on function F_ABS1 to user2");
        rs = st_user1.executeQuery(" select GRANTEE, GRANTOR, SELECTPRIV, DELETEPRIV, INSERTPRIV, UPDATEPRIV, REFERENCESPRIV, TRIGGERPRIV from sys.systableperms");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "SELECTPRIV", "DELETEPRIV", "INSERTPRIV", "UPDATEPRIV", "REFERENCESPRIV", "TRIGGERPRIV"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"USER2", "USER1", "y", "N", "N", "y", "N", "N"}, {"USER3", "USER1", "y", "N", "N", "y", "N", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user1.executeQuery(" select * from sys.syscolperms");
        expColNames = new String[]{"COLPERMSID", "GRANTEE", "GRANTOR", "TABLEID", "TYPE", "COLUMNS"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st_user1.executeQuery(" select GRANTEE, GRANTOR, GRANTOPTION from sys.sysroutineperms");
        expColNames = new String[]{"GRANTEE", "GRANTOR", "GRANTOPTION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"PUBLIC", "TEST_DBO", "N"}, {"USER2", "USER1", "N"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user2.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "a"}, {"2", "b"}, {"3", "c"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "insert into user1.t1 values (5, 'e')");
        rs = st_user2.executeQuery("values user1.F_ABS1(-8)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"8"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 3, "update user1.t1 set c2 = 'user2'");
        st_user1.executeUpdate("alter table t1 add column c3 varchar(10)");
        rs = st_user2.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "user2", null}, {"2", "user2", null}, {"3", "user2", null}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "insert into user1.t1 values (2, 'abc', 'ABC')");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 3, "update user1.t1 set c3 = 'XYZ'");
        rs = st_user3.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "user2", "XYZ"}, {"2", "user2", "XYZ"}, {"3", "user2", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42504", st_user3, "values user1.F_ABS1(-8)");
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, "update user1.t1 set c2 = 'user3'");
        st_user1.executeUpdate("revoke update(c2) on t1 from user3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_user1.executeUpdate(" revoke select(c2) on t1 from user3");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 3, "update user1.t1 set c2 = 'user2'");
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, "update user1.t1 set c2 = 'user3'");
        rs = st_user3.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user3.executeQuery("select c2 from user1.t1");
        expColNames = new String[]{"C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"user3"}, {"user3"}, {"user3"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" grant select, update on t1 to PUBLIC");
        rs = st_user3.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, "update user1.t1 set c2 = 'user3'");
        st_user1.executeUpdate(" grant select on t1 to user3");
        st_user1.executeUpdate("revoke select on t1 from PUBLIC");
        rs = st_user3.executeQuery("select * from user1.t1");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "user3", "XYZ"}, {"2", "user3", "XYZ"}, {"3", "user3", "XYZ"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, "update user1.t1 set c2 = 'user3'");
        st_user1.executeUpdate(" revoke select, update on t1 from user3");
        st_user1.executeUpdate(" revoke update on t1 from PUBLIC");
        GrantRevokeDDLTest.assertStatementError("42502", st_user3, "select * from user1.t1");
        GrantRevokeDDLTest.assertStatementError("42502", st_user3, "update user1.t1 set c2 = 'user3'");
        GrantRevokeDDLTest.assertUpdateCount(st, 0, " declare global temporary table SESSION.t1(c1 int) not logged");
        GrantRevokeDDLTest.assertStatementError("XCL51", st, "grant select on session.t1 to user2");
        GrantRevokeDDLTest.assertStatementError("XCL51", st, " revoke select on session.t1 from user2");
        st_user1.executeUpdate(" create table t3 (c1 int, c2 varchar(10), c3 int)");
        st_user1.executeUpdate(" create table t4 (c1 int, c2 varchar(10), c3 int)");
        st_user1.executeUpdate("grant select, update on t3 to user2");
        st_user1.executeUpdate("revoke select(c1) on t3 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        st_user1.executeUpdate(" revoke update(c2) on t3 from user2");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01006", sqlWarn);
            sqlWarn = null;
        }
        rs = st_user2.executeQuery(" select * from user1.t3");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user1.executeUpdate(" grant select (c2, c3), update (c2), insert on t4 to user2");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select * from user1.t4");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select c1 from user1.t4");
        rs = st_user2.executeQuery("select c2, c3 from user1.t4");
        expColNames = new String[]{"C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "update user1.t4 set c1=10, c3=100");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 0, "update user1.t4 set c2='XYZ'");
        st_user1.executeUpdate("revoke select, update on t4 from user2");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select c2 from user1.t4");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "update user1.t4 set c2='ABC'");
        GrantRevokeDDLTest.assertStatementError("42508", st_user2, "create table myschema.t5 (i int)");
        st_user2.executeUpdate("create table user2.t5 (i int)");
        GrantRevokeDDLTest.assertStatementError("42508", st_user2, "CREATE SCHEMA w3 AUTHORIZATION user2");
        GrantRevokeDDLTest.assertStatementError("42508", st_user2, " create table w3.t1 (i int)");
        GrantRevokeDDLTest.assertStatementError("X0Y68", st_user2, "CREATE SCHEMA AUTHORIZATION user2");
        GrantRevokeDDLTest.assertStatementError("42508", st_user2, "CREATE SCHEMA myschema");
        GrantRevokeDDLTest.assertStatementError("X0Y68", st_user2, "CREATE SCHEMA user2");
        st.executeUpdate("CREATE SCHEMA w3 AUTHORIZATION user2");
        st.executeUpdate(" CREATE SCHEMA AUTHORIZATION user6");
        st.executeUpdate(" CREATE SCHEMA myschema");
        GrantRevokeDDLTest.assertStatementError("42507", st_user5, "DROP SCHEMA w3 RESTRICT");
        st.executeUpdate("create view user1.sv1 as select * from sys.systables");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "select tablename from user1.sv1");
        st.executeUpdate(" grant select on user1.sv1 to user2");
        rs = st_user2.executeQuery("select tablename from user1.sv1");
        expColNames = new String[]{"TABLENAME"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"SYSCONGLOMERATES"}, {"SYSTABLES"}, {"SYSCOLUMNS"}, {"SYSSCHEMAS"}, {"SYSCONSTRAINTS"}, {"SYSKEYS"}, {"SYSDEPENDS"}, {"SYSALIASES"}, {"SYSVIEWS"}, {"SYSCHECKS"}, {"SYSFOREIGNKEYS"}, {"SYSSTATEMENTS"}, {"SYSFILES"}, {"SYSTRIGGERS"}, {"SYSSTATISTICS"}, {"SYSDUMMY1"}, {"SYSTABLEPERMS"}, {"SYSCOLPERMS"}, {"SYSROUTINEPERMS"}, {"SYSROLES"}, {"T1"}, {"T2"}, {"T2"}, {"T3"}, {"T4"}, {"T5"}, {"SV1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create table ta (i int)");
        st_user1.executeUpdate(" insert into ta values 1,2,3");
        st_user1.executeUpdate(" create view sva as select * from ta");
        st_user1.executeUpdate(" create table tb (j int)");
        st_user1.executeUpdate(" insert into tb values 2,3,4");
        st_user1.executeUpdate(" create view svb as select * from tb");
        st_user1.executeUpdate(" grant select on sva to user2");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "create view svc (i) as select * from user1.sva union select * from user1.svb");
        st_user1.executeUpdate(" grant select on svb to user2");
        st_user2.executeUpdate("create view svc (i) as select * from user1.sva union select * from user1.svb");
        rs = st_user2.executeQuery(" select * from svc");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" create table t01ap (i int)");
        st_user1.executeUpdate(" insert into t01ap values 1");
        st_user1.executeUpdate(" grant all privileges on t01ap to user2");
        st_user2.executeUpdate("create view v02ap as select * from user1.t01ap");
        rs = st_user2.executeQuery("select * from v02ap");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("4250A", st_user2, "grant select on user2.v02ap to user3");
        GrantRevokeDDLTest.assertStatementError("42502", st_user3, "create view v03ap as select * from user2.v02ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user3, " select * from v03ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user3, "grant all privileges on v03ap to user4");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user4, "create view v04ap as select * from user3.v03ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user4, " select * from v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user4, "grant select on v04ap to user2");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user2, " select * from user4.v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user4, "revoke select on v04ap from user2");
        GrantRevokeDDLTest.assertStatementError("42Y07", st_user2, "select * from user4.v04ap");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table user1.rt1");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table user2.rt2");
        st_user1.executeUpdate(" create table rt1 (c1 int not null primary key, c2 int not null)");
        st_user1.executeUpdate(" insert into rt1 values (1, 10)");
        st_user1.executeUpdate(" insert into rt1 values (2, 20)");
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "create table rt2 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt2fk foreign key(c1) references user1.rt1)");
        st_user1.executeUpdate(" grant references on rt1 to user2");
        st_user2.executeUpdate("create table rt2 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt2fk foreign key(c2) references user1.rt1)");
        st_user2.executeUpdate(" insert into rt2 values (1,1,1)");
        GrantRevokeDDLTest.assertStatementError("23503", st_user2, "insert into rt2 values (3,3,3)");
        st_user1.executeUpdate(" revoke references on rt1 from user2");
        st_user2.executeUpdate("insert into rt2 values (3,3,3)");
        rs = st_user2.executeQuery(" select * from rt2");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1", "1"}, {"3", "3", "3"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, "create table rt3 (c1 int primary key not null, c2 int not null, c3 int not null, constraint rt3fk foreign key(c1) references user1.rt1)");
        GrantRevokeDDLTest.assertStatementError("42Y07", st, " drop table user3.rt3");
        st.executeUpdate(" drop table user2.rt2");
        st.executeUpdate(" drop table user1.rt1");
        st_user1.executeUpdate(" create table rt1 (c1 int primary key not null, c2 int)");
        st_user1.executeUpdate(" insert into rt1 values (1,1), (2,2)");
        st_user1.executeUpdate(" grant references on rt1 to PUBLIC, user2, user3");
        st_user2.executeUpdate(" create table rt2 (c1 int primary key not null, constraint rt2fk foreign key(c1) references user1.rt1)");
        st_user2.executeUpdate(" insert into rt2 values (1), (2)");
        st_user3.executeUpdate(" create table rt3 (c1 int primary key not null, constraint rt3fk foreign key(c1) references user1.rt1)");
        st_user3.executeUpdate(" insert into rt3 values (1), (2)");
        st_user1.executeUpdate("revoke references on rt1 from PUBLIC");
        st_user1.executeUpdate("revoke references on rt1 from user3");
        GrantRevokeDDLTest.assertStatementError("23503", st_user2, "insert into rt2 values (3)");
        st_user3.executeUpdate("insert into rt3 values (3)");
        st_user1.executeUpdate(" CREATE FUNCTION F_ABS2(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "grant execute on F_ABS2 to user2");
        GrantRevokeDDLTest.assertStatementError("42Y03", st_user1, "grant execute on procedure F_ABS2 to user2");
        GrantRevokeDDLTest.assertStatementError("42504", st_user2, "values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        st_user1.executeUpdate("grant execute on function F_ABS2 to user2");
        rs = st_user2.executeQuery("values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"20"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, "revoke execute on function ABS from user2 restrict");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user2, " revoke execute on function AVG from user2 restrict");
        GrantRevokeDDLTest.assertStatementError("42509", st_user2, " revoke execute on function LENGTH from user2 restrict");
        st_user1.executeUpdate("revoke execute on function F_ABS2 from user2 restrict");
        st_user1.executeUpdate(" revoke execute on function F_ABS1 from user2 restrict");
        GrantRevokeDDLTest.assertStatementError("42504", st_user2, "values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        st_user1.executeUpdate("grant execute on function F_ABS1 to PUBLIC");
        st_user1.executeUpdate(" grant execute on function F_ABS2 to PUBLIC");
        rs = st_user2.executeQuery("values user1.F_ABS1(10) + user1.F_ABS2(-10)");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"20"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, "grant ALL PRIVILEGES on sys.sysaliases to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.syschecks to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.syscolperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.syscolumns to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysconglomerates to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysconstraints to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysdepends to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysfiles to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysforeignkeys to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.syskeys to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysroutineperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysschemas to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysstatistics to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysstatements to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.systableperms to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.systables to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.systriggers to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on sys.sysviews to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant ALL PRIVILEGES on syscs_diag.lock_table to user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysaliases to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.syschecks to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.syscolperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.syscolumns to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysconglomerates to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysconstraints to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysdepends to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysfiles to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysforeignkeys to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.syskeys to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysroutineperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysschemas to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysstatistics to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysstatements to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.systableperms to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.systables to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.systriggers to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on sys.sysviews to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " grant select on syscs_diag.lock_table to user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysaliases from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.syschecks from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.syscolperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.syscolumns from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysconglomerates from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysconstraints from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysdepends from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysfiles from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysforeignkeys from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.syskeys from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysroutineperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysschemas from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysstatistics from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysstatements from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.systableperms from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.systables from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.systriggers from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on sys.sysviews from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke ALL PRIVILEGES on syscs_diag.lock_table from user2");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysaliases from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.syschecks from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.syscolperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.syscolumns from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysconglomerates from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysconstraints from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysdepends from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysfiles from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysforeignkeys from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.syskeys from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysroutineperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysschemas from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysstatistics from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysstatements from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.systableperms from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.systables from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.systriggers from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on sys.sysviews from user2, public");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, " revoke select on syscs_diag.lock_table from user2, public");
        CallableStatement cSt3 = user3.prepareCall("CALL SQLJ.INSTALL_JAR ('bogus.jar','user2.bogus',0)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SQLJ.REPLACE_JAR ('bogus1.jar', 'user2.bogus')");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SQLJ.REMOVE_JAR  ('user2.bogus', 0)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall("CALL SYSCS_UTIL.BACKUP_DATABASE('backup1')");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE('backup3', 1)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT('backup4', 1)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall("CALL SYSCS_UTIL.FREEZE_DATABASE()");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.UNFREEZE_DATABASE()");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.DISABLE_LOG_ARCHIVE_MODE(1)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.CHECKPOINT_DATABASE()");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        CallableStatement cSt2 = user2.prepareCall("CALL SYSCS_UTIL.SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt2, 0);
        cSt2 = user2.prepareCall(" CALL SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt2, 0);
        rs = st_user2.executeQuery(" values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"Statement Name:"}, {"null"}, {"Statement Text:"}, {"CALL SYSCS_UTIL.SET_STATISTICS_TIMING(1)"}, {"Parse Time: 0"}, {"Bind Time: 0"}, {"Optimize Tim&"}};
        JDBC.assertDrainResults(rs, 1);
        cSt2 = user2.prepareCall(" CALL SYSCS_UTIL.SET_RUNTIMESTATISTICS(0)");
        GrantRevokeDDLTest.assertUpdateCount(cSt2, 0);
        cSt2 = user2.prepareCall(" CALL SYSCS_UTIL.SET_STATISTICS_TIMING(0)");
        GrantRevokeDDLTest.assertUpdateCount(cSt2, 0);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.SET_RUNTIMESTATISTICS(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        rs = st_user3.executeQuery(" values SYSCS_UTIL.GET_RUNTIMESTATISTICS()");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"Statement Name:"}, {"null"}, {"Statement Text:"}, {"CALL SYSCS_UTIL.SET_STATISTICS_TIMING(1)"}, {"Parse Time: 0"}, {"Bind Time: 0"}, {"Optimize Tim&"}};
        JDBC.assertDrainResults(rs, 1);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.SET_RUNTIMESTATISTICS(0)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.SET_STATISTICS_TIMING(0)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        st_user3.executeUpdate("create table TABLEIMP1 (i int)");
        st_user3.executeUpdate(" create table TABLEEXP1 (i int)");
        st_user3.executeUpdate(" insert into TABLEEXP1 values 1,2,3,4,5");
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.EXPORT_TABLE ('USER3', 'TABLEEXP1', 'myfile.del', null, null, null)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.IMPORT_TABLE ('USER3', 'TABLEIMP1', 'myfile.del', null, null, null, 0)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.EXPORT_QUERY('select * from user3.TABLEEXP1','myfile.del', null, null, null)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall(" CALL SYSCS_UTIL.IMPORT_DATA ('USER3', 'TABLEIMP1', null, '1,3,4', 'myfile.del', null, null, null,0)");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        cSt3 = user3.prepareCall("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY ('gemfirexd.locks.deadlockTimeout', '10')");
        GrantRevokeDDLTest.assertStatementError("42504", cSt3);
        GrantRevokeDDLTest.assertStatementError("42504", st_user3, " VALUES SYSCS_UTIL.GET_DATABASE_PROPERTY('gemfirexd.locks.deadlockTimeout')");
        cSt3 = user3.prepareCall("CALL SYSCS_UTIL.COMPRESS_TABLE('USER3', 'TABLEEXP1', 1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        cSt3 = user3.prepareCall(" call SYSCS_UTIL.INPLACE_COMPRESS_TABLE('USER3', 'TABLEEXP1', 1, 1, 1)");
        GrantRevokeDDLTest.assertUpdateCount(cSt3, 0);
        GrantRevokeDDLTest.assertStatementError("42504", st_user3, "VALUES SYSCS_UTIL.CHECK_TABLE('USER3', 'TABLEEXP1')");
        st_user1.executeUpdate(" create synonym s1 for user1.t1");
        st_user1.executeUpdate(" create index ii1 on user1.t1(c2)");
        if (GrantRevokeDDLTest.usingEmbedded()) {
            if (sqlWarn == null && st_user1 != null) {
                sqlWarn = st_user1.getWarnings();
            }
            if (sqlWarn == null) {
                sqlWarn = user1.getWarnings();
            }
            GrantRevokeDDLTest.assertNotNull((String)"Expected warning but found none", (Object)sqlWarn);
            GrantRevokeDDLTest.assertSQLState("01504", sqlWarn);
            sqlWarn = null;
        }
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, "grant select on s1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, " grant insert on s1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, " revoke select on s1 from user2");
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, " revoke insert on s1 from user2");
        GrantRevokeDDLTest.assertStatementError("42507", st_user2, "drop synonym user1.s1");
        GrantRevokeDDLTest.assertStatementError("42X65", st_user2, " drop index user1.ii1");
        st_user1.executeUpdate(" create table t1000 (i int)");
        user1.setAutoCommit(false);
        st_user1.executeUpdate(" grant select on t1000 to user2");
        user1.commit();
        rs = st_user2.executeQuery("select * from user1.t1000");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user1.executeUpdate(" revoke select on t1000 from user2");
        user1.commit();
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, " select * from user1.t1000");
        user2.setAutoCommit(false);
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "lock table user1.t1000 in share mode");
        GrantRevokeDDLTest.assertStatementError("42500", st_user2, "lock table user1.t1000 in exclusive mode");
        user2.commit();
        user2.setAutoCommit(true);
        st_user1.executeUpdate(" grant select on t1000 to user2");
        user1.rollback();
        GrantRevokeDDLTest.assertStatementError("42502", st_user2, " select * from user1.t1000");
        st_user1.executeUpdate(" grant select on t1000 to user2");
        user1.commit();
        st_user1.executeUpdate(" revoke select on t1000 from user2");
        user1.rollback();
        rs = st_user2.executeQuery(" select * from user1.t1000");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        user1.setAutoCommit(true);
        st_user1.executeUpdate(" drop table t1000");
        st_user1.executeUpdate(" create table t1000 (c varchar(1))");
        st_user1.executeUpdate(" insert into t1000 values 'a', 'b', 'c'");
        st_user1.executeUpdate(" grant select on t1000 to user3");
        st_user2.executeUpdate(" create table t1001 (i int)");
        st_user2.executeUpdate(" insert into t1001 values 1");
        rs = st.executeQuery(" select * from user2.t1001");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" insert into user2.t1001 values 2");
        GrantRevokeDDLTest.assertUpdateCount(st, 2, " update user2.t1001 set i = 888");
        st.executeUpdate(" drop table user1.t1000");
        st.executeUpdate(" drop table user2.t1001");
        user1.commit();
        user1.setAutoCommit(true);
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table user1.rta");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table user2.rtb");
        st_user1.executeUpdate(" create table rta (i int)");
        st_user1.executeUpdate(" grant select on rta to user2");
        rs = st_user2.executeQuery(" select * from user1.rta");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user1.executeUpdate(" rename table rta to rtb");
        GrantRevokeDDLTest.assertStatementError("42X05", st_user1, "select * from user1.rta");
        rs = st_user1.executeQuery("select * from user1.rtb");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        GrantRevokeDDLTest.assertStatementError("42X05", st_user2, "select * from user1.rta");
        rs = st_user2.executeQuery("select * from user1.rtb");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user2.executeUpdate(" create table ttt1 (i int)");
        st_user2.executeUpdate(" insert into ttt1 values 1");
        st_user3.executeUpdate(" create table ttt1 (i int)");
        st_user3.executeUpdate(" insert into ttt1 values 10");
        rs = st.executeQuery("select * from user2.ttt1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" insert into user2.ttt1 values 2");
        GrantRevokeDDLTest.assertUpdateCount(st, 2, " update user2.ttt1 set i = 888");
        GrantRevokeDDLTest.assertUpdateCount(st, 2, " delete from user2.ttt1");
        st.executeUpdate(" drop table user2.ttt1");
        rs = st.executeQuery(" select * from user3.ttt1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate(" insert into user3.ttt1 values 20");
        GrantRevokeDDLTest.assertUpdateCount(st, 2, " update user3.ttt1 set i = 999");
        GrantRevokeDDLTest.assertUpdateCount(st, 2, " delete from user3.ttt1");
        st.executeUpdate(" drop table user3.ttt1");
        st_user4.executeUpdate(" create table ttt1 (i int)");
        st.executeUpdate(" drop table user4.ttt1");
        GrantRevokeDDLTest.assertStatementError("42507", st_user2, "drop schema user4 restrict");
        st.executeUpdate("drop schema user4 restrict");
        st_user1.executeUpdate(" create table ttt2 (i int)");
        st_user1.executeUpdate(" insert into ttt2 values 8");
        PreparedStatement pSt2 = user2.prepareStatement("select * from user1.ttt2");
        GrantRevokeDDLTest.assertStatementError("42502", pSt2);
        st_user1.executeUpdate(" grant select on ttt2 to user2");
        pSt2 = user2.prepareStatement("select * from user1.ttt2");
        rs = pSt2.executeQuery();
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"8"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" revoke select on ttt2 from user2");
        GrantRevokeDDLTest.assertStatementError("42502", pSt2);
        st_user1.executeUpdate(" grant select(i) on ttt2 to user2");
        pSt2 = user2.prepareStatement("select * from user1.ttt2");
        rs = pSt2.executeQuery();
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"8"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" revoke select(i) on ttt2 from user2");
        GrantRevokeDDLTest.assertStatementError("42502", pSt2);
        st_user2.executeUpdate(" create table tshared0 (i int)");
        GrantRevokeDDLTest.assertStatementError("42509", st_user1, "revoke select on user2.tshared0 from user2");
        rs = st_user2.executeQuery(" select * from user2.tshared0");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st_user2.executeUpdate(" create table tshared1 (i int)");
        st_user2.executeUpdate(" grant select, insert, delete, update on tshared1 to user3, user4, user5");
        st_user3.executeUpdate(" create table tshared1 (i int)");
        st_user3.executeUpdate(" grant select, insert, delete, update on tshared1 to user2, user4, user5");
        st_user2.executeUpdate(" insert into user3.tshared1 values 1,2,3");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 3, " update user3.tshared1 set i = 888");
        rs = st_user2.executeQuery(" select * from user3.tshared1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"888"}, {"888"}, {"888"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 3, " delete from user3.tshared1");
        st_user2.executeUpdate(" insert into user3.tshared1 values 1,2,3");
        st_user3.executeUpdate(" insert into user2.tshared1 values 3,2,1");
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, " update user2.tshared1 set i = 999");
        rs = st_user3.executeQuery(" select * from user2.tshared1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"999"}, {"999"}, {"999"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertUpdateCount(st_user3, 3, " delete from user2.tshared1");
        st_user3.executeUpdate(" insert into user2.tshared1 values 3,2,1");
        GrantRevokeDDLTest.assertUpdateCount(st, 3, " update user2.tshared1 set i = 1000");
        GrantRevokeDDLTest.assertUpdateCount(st, 3, " update user3.tshared1 set i = 1001");
        GrantRevokeDDLTest.assertUpdateCount(st, 3, " delete from user2.tshared1");
        GrantRevokeDDLTest.assertUpdateCount(st, 3, " delete from user3.tshared1");
        st.executeUpdate(" insert into user2.tshared1 values 0,1,2,3");
        st.executeUpdate(" insert into user3.tshared1 values 4,3,2,1");
        rs = st_user4.executeQuery(" select * from user2.tshared1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user4.executeQuery(" select * from user3.tshared1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"4"}, {"3"}, {"2"}, {"1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user4.executeUpdate(" create view vshared1 as select * from user2.tshared1 union select * from user3.tshared1");
        st_user4.executeUpdate(" create view vshared2 as select * from user2.tshared1 intersect select * from user3.tshared1");
        st_user4.executeUpdate(" create view vshared3 as select * from user2.tshared1 except select * from user3.tshared1");
        st_user4.executeUpdate(" create view vshared4(i) as select * from user3.tshared1 union values 0");
        st_user4.executeUpdate(" insert into user2.tshared1 select * from user3.tshared1");
        rs = st_user4.executeQuery(" select * from vshared1");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user4.executeQuery(" select * from vshared2");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user4.executeQuery(" select * from vshared3");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user4.executeQuery(" select * from vshared4");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("4250A", st_user4, "grant select on vshared1 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", st_user4, " grant select on vshared2 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", st_user4, " grant select on vshared3 to user5");
        GrantRevokeDDLTest.assertStatementError("4250A", st_user4, " grant select on vshared4 to user5");
        GrantRevokeDDLTest.assertStatementError("42502", st_user5, " select * from user4.vshared1");
        GrantRevokeDDLTest.assertStatementError("42502", st_user5, " select * from user4.vshared2");
        GrantRevokeDDLTest.assertStatementError("42502", st_user5, " select * from user4.vshared3");
        GrantRevokeDDLTest.assertStatementError("42502", st_user5, " select * from user4.vshared4");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "create trigger tt0a after insert on t1 for each statement grant select on t1 to user2");
        GrantRevokeDDLTest.assertStatementError("42X01", st_user1, "create trigger tt0b after insert on t1 for each statement revoke select on t1 from user2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, "drop table t6");
        st_user1.executeUpdate(" create table t6 (c1 int not null primary key, c2 int)");
        st_user1.executeUpdate(" grant trigger on t6 to user2");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user2, " drop table t7");
        st_user2.executeUpdate(" create table t7 (c1 int, c2 int, c3 int)");
        st_user2.executeUpdate(" insert into t7 values (1,1,1)");
        st_user2.executeUpdate(" create trigger tt1 after insert on user1.t6 for each statement update user2.t7 set c2 = 888");
        st_user2.executeUpdate(" create trigger tt2 after insert on user1.t6 for each statement insert into user2.t7 values (2,2,2)");
        st_user1.executeUpdate(" insert into t6 values (1, 10)");
        rs = st.executeQuery(" select * from user2.t7");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "888", "1"}, {"2", "2", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table t8");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table t9");
        st_user1.executeUpdate(" create table t8 (c1 int not null primary key, c2 int)");
        st_user1.executeUpdate(" create table t9 (c1 int, c2 int, c3 int)");
        st_user1.executeUpdate(" insert into user1.t8 values (1,1)");
        st_user1.executeUpdate(" insert into user1.t9 values (10,10,10)");
        st_user1.executeUpdate(" grant trigger on t8 to user2");
        st_user1.executeUpdate(" grant update(c2, c1), insert on t9 to user2");
        st_user2.executeUpdate(" create trigger tt3 after insert on user1.t8 for each statement update user1.t9 set c2 = 888");
        st_user2.executeUpdate(" create trigger tt4 after insert on user1.t8 for each statement insert into user1.t9 values (2,2,2)");
        GrantRevokeDDLTest.assertStatementError("23505", st_user1, "insert into user1.t8 values (1, 10)");
        st_user1.executeUpdate("insert into user1.t8 values (2, 20)");
        rs = st_user1.executeQuery(" select * from user1.t9");
        expColNames = new String[]{"C1", "C2", "C3"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10", "888", "10"}, {"2", "2", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, "drop table t10");
        GrantRevokeDDLTest.assertStatementError("42Y55", st_user1, " drop table t11");
        st_user1.executeUpdate(" create table t10 (i int, j int)");
        st_user1.executeUpdate(" insert into t10 values (1,1), (2,2)");
        st_user1.executeUpdate(" create table t11 (i int)");
        st_user1.executeUpdate(" grant all privileges on t10 to user2");
        st_user1.executeUpdate(" grant all privileges on t11 to user2");
        st_user2.executeUpdate("create trigger tt5 after update on user1.t10 for each statement insert into user1.t11 values 1");
        st_user2.executeUpdate(" create trigger tt6 after update of i on user1.t10 for each statement insert into user1.t11 values 2");
        st_user2.executeUpdate(" create trigger tt7 after update of j on user1.t10 for each statement insert into user1.t11 values 3");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 2, " update user1.t10 set i=10");
        rs = st_user2.executeQuery(" select * from user1.t10");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10", "1"}, {"10", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user2.executeQuery(" select * from user1.t11");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate("revoke trigger on t10 from user2");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 2, " update user1.t10 set i=20");
        rs = st_user2.executeQuery(" select * from user1.t10");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"20", "1"}, {"20", "2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user2.executeQuery(" select * from user1.t11");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st_user1.executeUpdate(" grant trigger on t10 to user2");
        st_user2.executeUpdate(" create trigger tt8 after update of j on user1.t10 for each statement delete from user1.t11");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 2, " update user1.t10 set j=100");
        rs = st_user2.executeQuery(" select * from user1.t10");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"20", "100"}, {"20", "100"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user2.executeQuery(" select * from user1.t11");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 2, " delete from user1.t10");
        GrantRevokeDDLTest.assertUpdateCount(st_user2, 0, " delete from user1.t11");
        st_user1.executeUpdate(" drop function F_ABS1");
        st_user1.executeUpdate(" CREATE FUNCTION F_ABS1(P1 INT) RETURNS INT NO SQL RETURNS NULL ON NULL INPUT EXTERNAL NAME 'java.lang.Math.abs' LANGUAGE JAVA PARAMETER STYLE JAVA");
        st_user1.executeUpdate(" grant execute on function F_ABS1 to user5");
        st_user1.executeUpdate(" grant trigger,insert,update,delete,select on t10 to user5");
        st_user1.executeUpdate(" grant trigger,insert,update,delete,select on t11 to user5");
        GrantRevokeDDLTest.assertStatementError("X0X05", st_user1, " drop view v");
        st_user1.executeUpdate(" create view v(i) as values 888");
        st_user1.executeUpdate(" grant select on v to user5");
        st_user5.executeUpdate(" create trigger tt9 after insert on user1.t10 for each statement insert into user1.t11 values (user1.F_ABS1(-5))");
        st_user5.executeUpdate(" create trigger tt10 after insert on user1.t10 for each statement insert into user1.t11 select * from user1.v");
        st_user5.executeUpdate(" insert into user1.t10 values (1,1)");
        rs = st_user5.executeQuery(" select * from user1.t10");
        expColNames = new String[]{"I", "J"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        rs = st_user5.executeQuery(" select * from user1.t11");
        expColNames = new String[]{"I"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}, {"888"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        st.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC1");
        st.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC2");
        st.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC3");
        st.executeUpdate("DROP PROCEDURE USER1.GRANT_SELECT_PROC4");
        st.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC1");
        st.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC2");
        st.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC3");
        st.executeUpdate("DROP PROCEDURE USER1.REVOKE_SELECT_PROC4");
        st.executeUpdate("DROP FUNCTION USER1.F_ABS1");
        st.executeUpdate("DROP FUNCTION USER1.F_ABS2");
        st.executeUpdate("DROP TRIGGER USER2.TT1");
        st.executeUpdate("DROP TRIGGER USER2.TT2");
        st.executeUpdate("DROP TRIGGER USER2.TT3");
        st.executeUpdate("DROP TRIGGER USER2.TT4");
        st.executeUpdate("DROP TRIGGER USER2.TT8");
        st.executeUpdate("DROP TRIGGER USER5.TT9");
        st.executeUpdate("DROP TRIGGER USER5.TT10");
        st.executeUpdate("DROP VIEW USER4.VSHARED4");
        st.executeUpdate("DROP VIEW USER4.VSHARED3");
        st.executeUpdate("DROP VIEW USER4.VSHARED2");
        st.executeUpdate("DROP VIEW USER4.VSHARED1");
        st.executeUpdate("DROP VIEW USER2.V02AP");
        st.executeUpdate("DROP VIEW USER2.SVC");
        st.executeUpdate("DROP VIEW USER1.SVB");
        st.executeUpdate("DROP VIEW USER1.SVA");
        st.executeUpdate("DROP VIEW USER1.SV1");
        st.executeUpdate("DROP VIEW USER1.V");
        st.executeUpdate("DROP SYNONYM USER1.S1");
        st.executeUpdate("DROP TABLE USER3.RT3");
        st.executeUpdate("DROP TABLE USER3.TSHARED1");
        st.executeUpdate("DROP TABLE USER3.TABLEEXP1");
        st.executeUpdate("DROP TABLE USER3.TABLEIMP1");
        st.executeUpdate("DROP TABLE USER2.T5");
        st.executeUpdate("DROP TABLE USER2.T2");
        st.executeUpdate("DROP TABLE USER2.TSHARED0");
        st.executeUpdate("DROP TABLE USER2.T7");
        st.executeUpdate("DROP TABLE USER2.TSHARED1");
        st.executeUpdate("DROP TABLE USER2.RT2");
        st.executeUpdate("DROP TABLE USER1.T4");
        st.executeUpdate("DROP TABLE USER1.RTB");
        st.executeUpdate("DROP TABLE USER1.TA ");
        st.executeUpdate("DROP TABLE USER1.T10");
        st.executeUpdate("DROP TABLE USER1.T2");
        st.executeUpdate("DROP TABLE USER1.TB");
        st.executeUpdate("DROP TABLE USER1.T6");
        st.executeUpdate("DROP TABLE USER1.T8");
        st.executeUpdate("DROP TABLE USER1.TTT2");
        st.executeUpdate("DROP TABLE USER1.T11");
        st.executeUpdate("DROP TABLE USER1.T9");
        st.executeUpdate("DROP TABLE USER1.T01AP");
        st.executeUpdate("DROP TABLE USER1.T1 ");
        st.executeUpdate("DROP TABLE USER1.T3");
        st.executeUpdate("DROP TABLE USER1.RT1");
        st.executeUpdate("DROP SCHEMA USER1 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER2 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER3 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER4 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER5 RESTRICT");
        st.executeUpdate("DROP SCHEMA USER6 RESTRICT");
        st.executeUpdate("DROP SCHEMA MYSCHEMA RESTRICT");
        st.executeUpdate("DROP SCHEMA W3 RESTRICT");
        st_user5.close();
        st_user4.close();
        st_user3.close();
        st_user2.close();
        st_user1.close();
        st.close();
        user5.close();
        user4.close();
        user3.close();
        user2.close();
        user1.close();
    }

    public void testRevokeDropsFKWithSharedConglom() throws SQLException {
        Connection mamta1 = this.openUserConnection("mamta1");
        Statement st_mamta1 = mamta1.createStatement();
        st_mamta1.execute("create table pkt1 (i int not null, j int not null)");
        st_mamta1.execute("alter table pkt1 add constraint pkOne primary key (i, j)");
        st_mamta1.execute("insert into pkt1 values (1, 2), (3, 4)");
        st_mamta1.execute("grant references on pkt1 to mamta2");
        st_mamta1.execute("create table pkt2 (i int not null, j int not null)");
        st_mamta1.execute("alter table pkt2 add constraint pkTwo primary key (i, j)");
        st_mamta1.execute("insert into pkt2 values (1, 2), (2, 3)");
        st_mamta1.execute("grant references on pkt2 to mamta2");
        Connection mamta2 = this.openUserConnection("mamta2");
        Statement st_mamta2 = mamta2.createStatement();
        st_mamta2.execute("create table fkt2 (i int, j int)");
        st_mamta2.execute("alter table fkt2 add constraint fkOne foreign key (i, j) references mamta1.pkt1");
        st_mamta2.execute("alter table fkt2 add constraint fkDup foreign key (i, j) references mamta1.pkt2");
        st_mamta2.execute("insert into fkt2 values(1, 2)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into fkt2 values (2, 3)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into fkt2 values (3, 4)");
        st_mamta1.execute("revoke references on pkt1 from mamta2");
        st_mamta2.execute("insert into fkt2 values (2, 3)");
        GrantRevokeDDLTest.assertStatementError("23503", st_mamta2, "insert into fkt2 values (3, 4)");
        JDBC.assertUnorderedResultSet(st_mamta2.executeQuery("select * from fkt2 --GEMFIREXD-PROPERTIES constraint=FKDUP"), new String[][]{{"1", "2"}, {"2", "3"}});
        st_mamta2.execute("drop table fkt2");
        st_mamta1.execute("drop table pkt2");
        st_mamta1.execute("drop table pkt1");
        st_mamta2.close();
        st_mamta1.close();
        mamta2.close();
        mamta1.close();
    }
}

