/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class GeneratedColumnsHelper
extends BaseJDBCTestCase {
    protected static final String OBJECT_DOES_NOT_EXIST = "42X94";
    protected static final String NONEXISTENT_OBJECT = "42Y55";
    protected static final String REDUNDANT_CLAUSE = "42613";
    protected static final String CANT_CONTAIN_NULLS = "42831";
    protected static final String ILLEGAL_AGGREGATE = "42XA1";
    protected static final String UNSTABLE_RESULTS = "42XA2";
    protected static final String CANT_OVERRIDE_GENERATION_CLAUSE = "42XA3";
    protected static final String CANT_REFERENCE_GENERATED_COLUMN = "42XA4";
    protected static final String ROUTINE_CANT_ISSUE_SQL = "42XA5";
    protected static final String BAD_FOREIGN_KEY_ACTION = "42XA6";
    protected static final String ILLEGAL_ADD_DEFAULT = "42XA7";
    protected static final String ILLEGAL_RENAME = "42XA8";
    protected static final String NEED_EXPLICIT_DATATYPE = "42XA9";
    protected static final String BAD_BEFORE_TRIGGER = "42XAA";
    protected static final String NOT_NULL_NEEDS_DATATYPE = "42XAB";
    protected static final String NOT_NULL_VIOLATION = "23502";
    protected static final String CONSTRAINT_VIOLATION = "23513";
    protected static final String FOREIGN_KEY_VIOLATION = "23503";
    protected static final String ILLEGAL_DUPLICATE = "23505";
    protected static final String SYNTAX_ERROR = "42X01";
    protected static final String COLUMN_OUT_OF_SCOPE = "42X04";
    protected static final String OPERATION_FORBIDDEN = "X0Y25";
    protected static final String LACK_TABLE_PRIV = "42500";
    protected static final String LACK_COLUMN_PRIV = "42502";
    protected static final String LACK_EXECUTE_PRIV = "42504";
    protected static final String LACK_USAGE_PRIV = "42504";
    protected static final String CANT_ADD_IDENTITY = "42601";
    protected static final String CANT_MODIFY_IDENTITY = "42Z23";
    protected static final String CASCADED_COLUMN_DROP_WARNING = "01009";
    protected static final String CONSTRAINT_DROPPED_WARNING = "01500";
    protected static final String TRIGGER_DROPPED_WARNING = "01502";
    protected static final String LANG_INVALID_USE_OF_DEFAULT = "42Y85";
    protected static final String GRANT_REVOKE_NOT_ALLOWED = "42509";
    protected static final String ROUTINE_DEPENDS_ON_TYPE = "X0Y30";
    protected static final String TABLE_DEPENDS_ON_TYPE = "X0Y29";
    protected static final String VIEW_DEPENDENCY = "X0Y23";
    protected static final String NON_EMPTY_SCHEMA = "X0Y54";
    protected static final String JAVA_EXCEPTION = "XJ001";
    protected static final String ILLEGAL_UDT_CLASS = "42Z10";
    protected static final String FORBIDDEN_ORDERING_OPERATION = "X0X67";
    protected static final String ILLEGAL_AGG = "42Y22";
    protected static final String ILLEGAL_COMPARISON = "42818";
    protected static final String ILLEGAL_STORAGE = "42821";
    protected static final String BAD_CAST = "42846";
    protected static final String DUPLICATE_CLAUSE = "42XAJ";
    protected static final String FORBIDDEN_DROP_TRIGGER = "X0Y24";

    public GeneratedColumnsHelper(String name) {
        super(name);
    }

    protected void goodStatement(Connection conn, String ddl) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, ddl);
        ps.execute();
        ps.close();
    }

    protected static ResultSet executeQuery(Statement stmt, String text) throws SQLException {
        GeneratedColumnsHelper.println("Executing '" + text + "'");
        return stmt.executeQuery(text);
    }

    protected PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        GeneratedColumnsHelper.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }

    protected CallableStatement chattyPrepareCall(Connection conn, String text) throws SQLException {
        GeneratedColumnsHelper.println("Preparing callable statement:\n\t" + text);
        return conn.prepareCall(text);
    }

    protected void expectCompilationError(String sqlState, String query) {
        GeneratedColumnsHelper.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        this.assertCompileError(sqlState, query);
    }

    protected void expectCompilationError(Connection conn, String sqlState, String query) {
        GeneratedColumnsHelper.println("\nExpecting " + sqlState + " when preparing:\n\t" + query);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(query);
        }
        catch (SQLException se) {
            GeneratedColumnsHelper.assertSQLState(sqlState, se);
            return;
        }
        GeneratedColumnsHelper.fail((String)("Expected SQL state: " + sqlState));
    }

    protected void expectExecutionError(Connection conn, String sqlState, String query) throws Exception {
        GeneratedColumnsHelper.println("\nExpecting " + sqlState + " when executing:\n\t");
        PreparedStatement ps = this.chattyPrepare(conn, query);
        GeneratedColumnsHelper.assertStatementError(sqlState, ps);
        ps.close();
    }

    protected void expectUpdateRowError(ResultSet rs, String sqlState) throws Exception {
        GeneratedColumnsHelper.println("\nExpecting " + sqlState + " when updating row");
        try {
            rs.updateRow();
            GeneratedColumnsHelper.fail((String)("Expected error: " + sqlState));
        }
        catch (SQLException se) {
            GeneratedColumnsHelper.assertSQLState(sqlState, se);
        }
    }

    protected void expectInsertRowError(ResultSet rs, String sqlState) throws Exception {
        GeneratedColumnsHelper.println("\nExpecting " + sqlState + " when inserting row");
        try {
            rs.insertRow();
            GeneratedColumnsHelper.fail((String)("Expected error: " + sqlState));
        }
        catch (SQLException se) {
            GeneratedColumnsHelper.assertSQLState(sqlState, se);
        }
    }

    protected void expectExecutionWarning(Connection conn, String sqlState, String query) throws Exception {
        this.expectExecutionWarnings(conn, new String[]{sqlState}, query);
    }

    protected void expectExecutionWarnings(Connection conn, String[] sqlStates, String query) throws Exception {
        GeneratedColumnsHelper.println("\nExpecting warnings " + this.fill(sqlStates).toString() + " when executing:\n\t");
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ps.execute();
        int idx = 0;
        for (SQLWarning sqlWarning = ps.getWarnings(); sqlWarning != null; sqlWarning = sqlWarning.getNextWarning()) {
            String actualSQLState = sqlWarning.getSQLState();
            if (idx >= sqlStates.length) {
                GeneratedColumnsHelper.fail((String)"Got more warnings than we expected.");
            }
            String expectedSqlState = sqlStates[idx++];
            GeneratedColumnsHelper.assertEquals((String)expectedSqlState, (String)actualSQLState);
        }
        GeneratedColumnsHelper.assertEquals((int)idx, (int)sqlStates.length);
        ps.close();
    }

    public void assertDeterministic(Connection conn, String routineName, boolean isDeterministic) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select a.aliasinfo\nfrom sys.sysaliases a\nwhere alias =  ?");
        ps.setString(1, routineName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        RoutineAliasInfo rai = (RoutineAliasInfo)rs.getObject(1);
        rs.close();
        ps.close();
    }

    protected void assertColumnTypes(Connection conn, String tableName, String[][] columnTypes) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select c.columnname, c.columndatatype\nfrom sys.syscolumns c, sys.systables t\nwhere t.tablename = ?\nand t.tableid = c.referenceid\norder by c.columnname\n");
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, columnTypes, true);
        rs.close();
        ps.close();
    }

    protected void assertResults(Connection conn, String query, String[][] rows, boolean trimResults) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, query);
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, rows, trimResults);
        rs.close();
        ps.close();
    }

    protected void assertResults(ResultSet rs, String[][] rows, boolean trimResults) throws Exception {
        for (String[] row : rows) {
            int columnCount = row.length;
            GeneratedColumnsHelper.assertTrue((boolean)rs.next());
            for (int j = 0; j < columnCount; ++j) {
                String expectedValue = row[j];
                String actualValue = null;
                int column = j + 1;
                actualValue = rs.getString(column);
                if (rs.wasNull()) {
                    actualValue = null;
                }
                if (actualValue != null && trimResults) {
                    actualValue = actualValue.trim();
                }
                GeneratedColumnsHelper.assertEquals((expectedValue == null ? 1 : 0) != 0, (boolean)rs.wasNull());
                if (expectedValue == null) {
                    GeneratedColumnsHelper.assertNull((Object)actualValue);
                    continue;
                }
                GeneratedColumnsHelper.assertEquals((String)expectedValue, (String)actualValue);
            }
        }
        GeneratedColumnsHelper.assertFalse((boolean)rs.next());
    }

    protected void verifyRevokePrivilege(Connection grantorConnection, Connection granteeConnection, String grantStatement, String revokeStatement, String createStatement, String dropStatement, String badRevokeSQLState) throws Exception {
        this.expectExecutionError(granteeConnection, "42504", createStatement);
        this.goodStatement(grantorConnection, grantStatement);
        this.goodStatement(granteeConnection, createStatement);
        this.expectExecutionError(grantorConnection, badRevokeSQLState, revokeStatement);
        this.goodStatement(granteeConnection, dropStatement);
        this.goodStatement(grantorConnection, revokeStatement);
    }

    protected void verifyRestrictedDrop(Connection conn, String createDependentObject, String dropDependentObject, String createStatement, String dropStatement, String badDropState) throws Exception {
        this.goodStatement(conn, createStatement);
        this.goodStatement(conn, createDependentObject);
        this.expectExecutionError(conn, badDropState, dropStatement);
        this.goodStatement(conn, dropDependentObject);
        this.goodStatement(conn, dropStatement);
    }

    protected ArrayList fill(Object[] raw) {
        ArrayList<Object> result = new ArrayList<Object>();
        int count = raw.length;
        for (int i = 0; i < count; ++i) {
            result.add(raw[i]);
        }
        return result;
    }
}

