/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ConglomerateSharingTest
extends BaseJDBCTestCase {
    private final String COUNT_TABLE_CONGLOMS = "select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)";
    private final String GET_CONSTRAINT_NAMES = "select constraintname from sys.sysconstraints where tableid = (select tableid from sys.systables where tablename = ?)";

    public ConglomerateSharingTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(ConglomerateSharingTest.class));
    }

    public void testConversionToNonUnique() throws SQLException {
        PreparedStatement countCongloms = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        Statement st = this.createStatement();
        st.execute("create table orders (no_w_id int not null, no_d_id int not null, no_o_id int not null, info varchar(20), constraint orders_pk primary key (no_w_id, no_d_id, no_o_id))");
        st.execute("insert into orders values (1, 2, 3, 'info # one')");
        st.execute("insert into orders values (1, 2, 4, 'info # two')");
        st.execute("insert into orders values (1, 2, 5, 'info # 3')");
        st.execute("create table neworders (no_w_id int not null, no_d_id int not null, no_o_id int not null, lname varchar(50))");
        st.execute("alter table neworders add constraint neworders_pk primary key (no_w_id, no_d_id, no_o_id)");
        st.execute("alter table neworders add constraint no_o_fk foreign key (no_w_id, no_d_id, no_o_id) references orders");
        st.execute("insert into neworders values (1, 2, 3, 'Inigo')");
        st.execute("insert into neworders values (1, 2, 4, 'Montoya')");
        st.execute("insert into neworders values (1, 2, 5, 'Tortuga')");
        this.countConglomerates("NEWORDERS", countCongloms, 2);
        this.checkStatementError("23503", st, "insert into neworders values (1, 3, 5, 'SHOULD FAIL')", "NO_O_FK");
        this.checkStatementError("23505", st, "insert into neworders values (1, 2, 4, 'SHOULD FAIL')", "NEWORDERS_PK");
        st.execute("alter table neworders drop constraint neworders_pk");
        this.countConglomerates("NEWORDERS", countCongloms, 2);
        this.checkStatementError("23503", st, "insert into neworders values (1, 3, 5, 'SHOULD FAIL')", "NO_O_FK");
        st.execute("insert into neworders values (1, 2, 4, 'SHOULD SUCCEED')");
        JDBC.assertUnorderedResultSet(st.executeQuery("select * from neworders"), new String[][]{{"1", "2", "3", "Inigo"}, {"1", "2", "4", "Montoya"}, {"1", "2", "5", "Tortuga"}, {"1", "2", "4", "SHOULD SUCCEED"}});
        JDBC.assertUnorderedResultSet(st.executeQuery("select * from neworders --GEMFIREXD-PROPERTIES constraint=NO_O_FK"), new String[][]{{"1", "2", "3", "Inigo"}, {"1", "2", "4", "Montoya"}, {"1", "2", "5", "Tortuga"}, {"1", "2", "4", "SHOULD SUCCEED"}});
        st.execute("drop table neworders");
        st.execute("drop table orders");
        this.countConglomerates("NEWORDERS", countCongloms, 0);
        countCongloms.close();
        st.close();
    }

    public void testConstraintDrops() throws SQLException {
        PreparedStatement countCongloms = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        PreparedStatement getConstraintNames = this.prepareStatement("select constraintname from sys.sysconstraints where tableid = (select tableid from sys.systables where tablename = ?)");
        Statement st = this.createStatement();
        st.execute("create table dropc_t0 (i int not null, j int not null)");
        st.execute("alter table dropc_t0 add constraint dropc_pk0 primary key (i,j)");
        this.countConglomerates("DROPC_T0", countCongloms, 2);
        st.execute("create table dropc_t1 (i int, j int not null)");
        st.execute("alter table dropc_t1 add constraint dropc_pk1 primary key (j)");
        this.countConglomerates("DROPC_T1", countCongloms, 2);
        st.execute("create table dropc_t2 (a int, b int not null, c int not null)");
        st.execute("create index dropc_ix1 on dropc_t2 (a,b)");
        st.execute("create unique index dropc_uix2 on dropc_t2 (c)");
        st.execute("alter table dropc_t2 add constraint dropc_uc1 unique (c)");
        st.execute("alter table dropc_t2 add constraint dropc_fk0 foreign key (a,b) references dropc_t0");
        st.execute("alter table dropc_t2 add constraint dropc_fk1 foreign key (a,b) references dropc_t0");
        st.execute("alter table dropc_t2 add constraint dropc_fk2 foreign key (c) references dropc_t1");
        this.countConglomerates("DROPC_T2", countCongloms, 3);
        st.execute("insert into dropc_t0 values (1, 2)");
        st.execute("insert into dropc_t1 values (3, 4)");
        st.execute("insert into dropc_t2 values (1, 2, 4)");
        st.execute("alter table DROPC_T2 drop constraint DROPC_FK0");
        this.countConglomerates("DROPC_T2", countCongloms, 3);
        this.verifyConstraints(st, getConstraintNames, "DROPC_T2", "DROPC_FK0", new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}, {"DROPC_UC1"}}, 1);
        this.checkStatementError("23505", st, "insert into dropc_t2 values (1, 2, 4)", "DROPC_UIX2");
        this.checkStatementError("23503", st, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", st, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        st.execute("alter table DROPC_T2 drop constraint DROPC_UC1");
        this.countConglomerates("DROPC_T2", countCongloms, 3);
        this.verifyConstraints(st, getConstraintNames, "DROPC_T2", "DROPC_UC1", new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}}, 1);
        this.checkStatementError("23505", st, "insert into dropc_t2 values (1, 2, 4)", "DROPC_UIX2");
        this.checkStatementError("23503", st, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", st, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        st.execute("drop index dropc_uix2");
        this.countConglomerates("DROPC_T2", countCongloms, 3);
        this.verifyConstraints(st, getConstraintNames, "DROPC_T2", null, new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}}, 1);
        this.checkStatementError("23503", st, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", st, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        st.execute("insert into dropc_t2 values (1, 2, 4)");
        JDBC.assertUnorderedResultSet(st.executeQuery("select * from dropc_t2"), new String[][]{{"1", "2", "4"}, {"1", "2", "4"}});
        st.execute("delete from dropc_t2");
        st.execute("insert into dropc_t2 values (1, 2, 4)");
        st.execute("alter table dropc_t2 drop constraint dropc_fk2");
        this.countConglomerates("DROPC_T2", countCongloms, 2);
        st.execute("alter table dropc_t2 add constraint dropc_uc1 unique (c)");
        st.execute("alter table dropc_t2 add constraint dropc_fk2 foreign key (c) references dropc_t1");
        st.execute("create unique index dropc_uix3 on dropc_t2 (a, c)");
        this.countConglomerates("DROPC_T2", countCongloms, 4);
        st.execute("alter table dropc_t2 drop column c");
        this.countConglomerates("DROPC_T2", countCongloms, 2);
        this.verifyConstraints(st, getConstraintNames, "DROPC_T2", "DROPC_FK2", new String[][]{{"DROPC_FK1"}}, 1);
        this.checkStatementError("23503", st, "insert into dropc_t2 values (2, 2)", "DROPC_FK1");
        st.execute("delete from dropc_t2");
        st.execute("alter table dropc_t2 add constraint dropc_uc2 unique (b)");
        st.execute("alter table dropc_t2 add constraint dropc_fk3 foreign key (b) references dropc_t1");
        this.countConglomerates("DROPC_T2", countCongloms, 3);
        st.execute("drop table dropc_t2");
        this.countConglomerates("DROPC_T2", countCongloms, 0);
        ConglomerateSharingTest.assertStatementError("42X05", st, "select * from dropc_t2");
        st.execute("drop table dropc_t1");
        st.execute("drop table dropc_t0");
        getConstraintNames.close();
        countCongloms.close();
        st.close();
    }

    public void testUniqueConstraintWithNullsBackingIndex() throws SQLException {
        PreparedStatement countCongloms = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        Statement stmt = this.createStatement();
        stmt.execute("create table t1 (i int, j int not null, k int)");
        stmt.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        stmt.executeUpdate("create index nuix on t1(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", countCongloms, 3);
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        ConglomerateSharingTest.assertStatementError("23505", stmt, "insert into t1 values (1, -1, 1)");
        stmt.executeUpdate("delete from t1");
        stmt.executeUpdate("drop index nuix");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", countCongloms, 1);
        stmt.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        stmt.executeUpdate("create unique index uix on t1(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        ConglomerateSharingTest.assertStatementError("23505", stmt, "insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("drop index uix");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("alter table t1 drop constraint uc");
        stmt.executeUpdate("delete from t1");
        this.countConglomerates("T1", countCongloms, 1);
        stmt.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        stmt.executeUpdate("insert into t1 values (null, 1, -1)");
        stmt.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("create table t2 (a int not null, b int not null)");
        stmt.executeUpdate("alter table t2 add constraint pkt2 primary key(a,b)");
        this.countConglomerates("T2", countCongloms, 2);
        stmt.executeUpdate("insert into t2 values (1, -1), (2, -2), (4, -4), (3, -3)");
        stmt.executeUpdate("alter table t1 add constraint fkt1 foreign key (i,j) references t2");
        this.countConglomerates("T1", countCongloms, 2);
        ConglomerateSharingTest.assertStatementError("23505", stmt, "insert into t1(i,j) values (1, -1)");
        stmt.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1(i,j) values (1, -1)");
        stmt.executeUpdate("alter table t1 drop constraint fkt1");
        stmt.executeUpdate("alter table t2 drop constraint pkt2");
        stmt.executeUpdate("delete from t1");
        stmt.executeUpdate("delete from t2");
        this.countConglomerates("T1", countCongloms, 1);
        this.countConglomerates("T2", countCongloms, 1);
        stmt.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        stmt.executeUpdate("alter table t2 add constraint pkt2 primary key(a,b)");
        this.countConglomerates("T2", countCongloms, 2);
        stmt.executeUpdate("insert into t2 values (1, -1), (2, -2),(4, -4), (3, -3)");
        stmt.executeUpdate("create unique index uix on t1(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("alter table t1 add constraint fkt1 foreign key (i,j) references t2");
        this.countConglomerates("T1", countCongloms, 2);
        ConglomerateSharingTest.assertStatementError("23505", stmt, "insert into t1(i,j) values (1, -1)");
        stmt.executeUpdate("drop index uix");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1(i,j) values (null, 2)");
        stmt.executeUpdate("insert into t1(i,j) values (null, 2)");
        ConglomerateSharingTest.assertStatementError("23505", stmt, "insert into t1 values (1, -1, 1)");
        stmt.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", countCongloms, 2);
        stmt.executeUpdate("insert into t1 values (1, -1, 1)");
        stmt.executeUpdate("drop table t1");
        stmt.executeUpdate("drop table t2");
        stmt.close();
        countCongloms.close();
    }

    private void countConglomerates(String tableName, PreparedStatement countCongloms, int expected) throws SQLException {
        countCongloms.setString(1, tableName);
        JDBC.assertSingleValueResultSet(countCongloms.executeQuery(), String.valueOf(expected));
    }

    private void checkStatementError(String sqlState, Statement st, String query, String ixOrConstraint) throws SQLException {
        block2: {
            try {
                st.execute(query);
                ConglomerateSharingTest.fail((String)("Expected error '" + sqlState + "' when executing a " + "statement, but no error was thrown."));
            }
            catch (SQLException se) {
                ConglomerateSharingTest.assertSQLState(sqlState, se);
                if (se.getMessage().indexOf(ixOrConstraint) != -1) break block2;
                ConglomerateSharingTest.fail((String)("Error " + sqlState + " should have been caused " + "by index/constraint '" + ixOrConstraint + "' but " + "'" + ixOrConstraint + "' did not appear in the " + "following error message: \"" + se.getMessage() + "\""));
            }
        }
    }

    private void verifyConstraints(Statement st, PreparedStatement constraintNames, String tName, String constraintName, String[][] remainingConstraints, int numRowsExpected) throws SQLException {
        constraintNames.setString(1, tName);
        ResultSet constraints = constraintNames.executeQuery();
        if (remainingConstraints == null) {
            JDBC.assertEmpty(constraints);
        } else {
            JDBC.assertUnorderedResultSet(constraints, remainingConstraints);
        }
        String select = "select * from " + tName + " --GEMFIREXD-PROPERTIES constraint=";
        if (constraintName != null) {
            ConglomerateSharingTest.assertStatementError("42Y48", st, select + constraintName);
        }
        JDBC.assertDrainResults(st.executeQuery("select * from " + tName), numRowsExpected);
        if (remainingConstraints == null) {
            return;
        }
        for (int i = 0; i < remainingConstraints.length; ++i) {
            JDBC.assertDrainResults(st.executeQuery(select + remainingConstraints[i][0]), numRowsExpected);
        }
    }
}

