/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class CollationTest2
extends BaseJDBCTestCase {
    private static final boolean verbose_debug = false;
    private static final int TEST_DEFAULT = 0;
    private static final int TEST_ENGLISH = 1;
    private static final int TEST_POLISH = 2;
    private static final int TEST_NORWAY = 3;
    private static final String[] NAMES = new String[]{"Smith", "Zebra", "\u0104corn", "\u017bebra", "Acorn", "\u015amith", "aacorn"};
    private static final int[] DEFAULT_NAME_ORDER = new int[]{4, 0, 1, 6, 2, 5, 3};
    private static final int[] ENGLISH_NAME_ORDER = new int[]{6, 4, 2, 0, 5, 1, 3};
    private static final int[] POLISH_NAME_ORDER = new int[]{6, 4, 2, 0, 5, 1, 3};
    private static final int[] NORWAY_NAME_ORDER = new int[]{4, 2, 0, 5, 1, 3, 6};
    private static final int[][] EXPECTED_NAME_ORDER = new int[][]{DEFAULT_NAME_ORDER, ENGLISH_NAME_ORDER, POLISH_NAME_ORDER, NORWAY_NAME_ORDER};
    private static final String[] LIKE_NAMES = new String[]{"Waagan", "Smith", "Zebra", "xcorn", "aBebra", "Acorn", "Amith", "aacorn", "xxxaa", "aaxxx", "yyyaa y"};
    private static final String[] LIKE_TEST_CASES = new String[]{"Waagan", "W_gan", "aaxxx", "_xxx", "xxxaa", "xxx_", "xxx_%", "yyy_%"};
    private static final String[] LIKE_CHAR_TEST_CASES = new String[]{"Waagan    ", "W_gan    ", "aaxxx%", "_xxx%", "xxx%", "xxx_ %", "xxx%", "yyy_%"};
    private static final int[] DEFAULT_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] ENGLISH_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] POLISH_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[] NORWAY_LIKE_RESULT = new int[]{0, -1, 9, -1, 8, -1, 8, 10};
    private static final int[][] EXPECTED_LIKE_RESULTS = new int[][]{DEFAULT_LIKE_RESULT, ENGLISH_LIKE_RESULT, POLISH_LIKE_RESULT, NORWAY_LIKE_RESULT};
    private static final String[] derby2670_pattern = new String[]{"%", "a%", "b%", "c%", "%a%", "%b%", "%c%", "%a", "%b", "%c"};
    private static final String[][][] derby2670_pattern_result = new String[][][]{{{"a"}, {"A"}, {" a"}, {"-a"}, {"\u00ada"}, {"b"}, {"B"}, {" b"}, {"-b"}, {"\u00adb"}, {"C"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}, {"Wanvik"}, {"W\u00e5gan"}, {"Waagan"}, {"W\u00e5han"}}, {{"a"}}, {{"b"}}, null, {{"a"}, {" a"}, {"-a"}, {"\u00ada"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}, {"Wanvik"}, {"W\u00e5gan"}, {"Waagan"}, {"W\u00e5han"}}, {{"b"}, {" b"}, {"-b"}, {"\u00adb"}, {"ekstra\u00adarbeid"}, {"ekstrabetaling"}, {"ekstraarbeid"}}, null, {{"a"}, {" a"}, {"-a"}, {"\u00ada"}}, {{"b"}, {" b"}, {"-b"}, {"\u00adb"}}, null};

    public CollationTest2(String name) {
        super(name);
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    private static final void printRuleBasedCollator() {
        RuleBasedCollator en_USCollator = (RuleBasedCollator)Collator.getInstance(Locale.US);
        String en_rules = en_USCollator.getRules();
        System.out.println("ENGLISH RULES: " + en_rules);
        System.out.println("ENGLISH RULES: " + CollationTest2.formatString(en_rules, true));
        System.out.println("ENGLISH RULES: " + CollationTest2.formatString(en_rules, false));
    }

    private static final String formatString(String str, boolean all) {
        String ret_val = "";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            ret_val = !all && ch <= '\u0080' ? ret_val + Character.toString(ch) : ret_val + "\\u" + Integer.toString(ch, 16) + "(" + Character.toString(ch) + ")";
        }
        return ret_val;
    }

    private final void formatLikeResults(Connection conn, String query) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery(query);
        String txt_str = null;
        String ucode_str = null;
        String mixed_str = null;
        int count = 0;
        while (rs.next()) {
            if (++count == 1) {
                txt_str = "{";
                ucode_str = "{";
                mixed_str = "{";
            } else {
                txt_str = txt_str + ", ";
                ucode_str = ucode_str + ", ";
                mixed_str = mixed_str + ", ";
            }
            String ret_val = rs.getString(1);
            txt_str = txt_str + "\"" + ret_val + "\"";
            ucode_str = ucode_str + CollationTest2.formatString(ret_val, true);
            mixed_str = mixed_str + "{\"" + CollationTest2.formatString(ret_val, false) + "\"}";
        }
        if (count != 0) {
            txt_str = txt_str + "}";
            ucode_str = ucode_str + "}";
            mixed_str = mixed_str + "}";
        }
        System.out.println("Query: " + query + "\nnumber rows  :" + count + "\nString Result:" + txt_str + "\nUcode  Result:" + ucode_str + "\nmixed  Result:" + mixed_str);
        rs.close();
        s.close();
    }

    private final void printLikeResults(Connection conn) throws SQLException {
    }

    private void checkLangBasedQuery(String query, String[][] expectedResult, boolean ordered) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery(query);
        if (expectedResult == null) {
            JDBC.assertEmpty(rs);
        } else if (ordered) {
            JDBC.assertFullResultSet(rs, expectedResult);
        } else {
            JDBC.assertUnorderedResultSet(rs, expectedResult);
        }
    }

    private void checkParamQuery(String query, String[] param, int paramNumber, String[][] expectedResult, boolean ordered) throws SQLException {
        PreparedStatement ps = this.prepareStatement(query);
        for (int i = 0; i < paramNumber; ++i) {
            ps.setString(i + 1, param[i]);
        }
        ResultSet rs = ps.executeQuery();
        if (expectedResult == null) {
            JDBC.assertEmpty(rs);
        } else if (ordered) {
            JDBC.assertFullResultSet(rs, expectedResult);
        } else {
            JDBC.assertUnorderedResultSet(rs, expectedResult);
        }
        for (int i = 0; i < paramNumber; ++i) {
            ps.setString(i + 1, param[i]);
        }
        rs = ps.executeQuery();
        if (expectedResult == null) {
            JDBC.assertEmpty(rs);
        } else if (ordered) {
            JDBC.assertFullResultSet(rs, expectedResult);
        } else {
            JDBC.assertUnorderedResultSet(rs, expectedResult);
        }
        this.commit();
    }

    protected void doExportTable(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset) throws SQLException {
        SupportFilesSetup.deleteFile(fileName);
        CallableStatement ps = this.prepareCall("call SYSCS_UTIL.EXPORT_TABLE (? , ? , ? , ?, ? , ?)");
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.executeUpdate();
        ps.close();
    }

    protected void doImportTable(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset, int replace) throws SQLException {
        CallableStatement ps = this.prepareCall("call SYSCS_UTIL.IMPORT_TABLE (?, ?, ?, ?, ?, ?, ?)");
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.executeUpdate();
        ps.close();
    }

    private String[][] full_row_set(int[] expected_order, int start_offset, int stop_offset, boolean ascending_order) {
        String[][] ret_order;
        block4: {
            ret_order = null;
            int num_vals = stop_offset - start_offset + 1;
            if (num_vals <= 0) break block4;
            ret_order = new String[num_vals][2];
            if (ascending_order) {
                int dest = 0;
                for (int src = start_offset; src <= stop_offset; ++src) {
                    ret_order[dest][0] = String.valueOf(expected_order[src]);
                    ret_order[dest][1] = NAMES[expected_order[src]];
                    ++dest;
                }
            } else {
                int dest = 0;
                for (int src = stop_offset; src >= start_offset; --src) {
                    ret_order[dest][0] = String.valueOf(expected_order[src]);
                    ret_order[dest][1] = NAMES[expected_order[src]];
                    ++dest;
                }
            }
        }
        return ret_order;
    }

    private String[][] full_row_single_value(int expected_row, String[] ret_list) {
        String[][] ret_order = null;
        if (expected_row != -1) {
            ret_order = new String[1][2];
            ret_order[0][0] = String.valueOf(expected_row);
            ret_order[0][1] = ret_list[expected_row];
        }
        return ret_order;
    }

    private boolean isDatabaseBasicCollation() throws SQLException {
        return "UCS_BASIC".equals(this.getDatabaseProperty("gemfirexd.distributedsystem.collation"));
    }

    private void setUpTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE CUSTOMER(D1 CHAR(200), D2 CHAR(200), D3 CHAR(200), D4 INT, ID INT, NAME VARCHAR(40), NAME2 VARCHAR(40))");
        PreparedStatement ps = this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?,?,?)");
        for (int i = 0; i < NAMES.length; ++i) {
            ps.setString(1, NAMES[i]);
            ps.setString(2, NAMES[i]);
            ps.setString(3, NAMES[i]);
            ps.setInt(4, i);
            ps.setInt(5, i);
            ps.setString(6, NAMES[i]);
            ps.setString(7, NAMES[i]);
            ps.executeUpdate();
        }
        this.commit();
    }

    private void setUpLikeTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE CUSTOMER (NAME_CHAR          CHAR(10), NAME_VARCHAR       VARCHAR(40),NAME_LONGVARCHAR   LONG VARCHAR,NAME_CLOB          CLOB,ID                 INT)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO CUSTOMER VALUES(?,?,?,?,?)");
        for (int i = 0; i < LIKE_NAMES.length; ++i) {
            ps.setString(1, LIKE_NAMES[i]);
            ps.setString(2, LIKE_NAMES[i]);
            ps.setString(3, LIKE_NAMES[i]);
            ps.setString(4, LIKE_NAMES[i]);
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        ps.close();
        s.close();
        this.commit();
    }

    private void setUpALLVALS(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("CREATE TABLE ALLVALS (STR_CHAR          CHAR(3), STR_VARCHAR       VARCHAR(40),STR_LONGVARCHAR   LONG VARCHAR,STR_CLOB          CLOB,ID                INT)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO ALLVALS VALUES(?,?,?,?,?)");
        char[] single_char = new char[1];
        char[] leading_b = new char[2];
        char[] trailing_b = new char[2];
        char[] middle_b = new char[3];
        leading_b[0] = 98;
        trailing_b[trailing_b.length - 1] = 98;
        middle_b[1] = 98;
        int max_char = 65535;
        long before_load_ms = System.currentTimeMillis();
        for (int i = 0; i <= max_char; ++i) {
            single_char[0] = (char)i;
            String str_val = String.valueOf(single_char);
            ps.setString(1, str_val);
            ps.setString(2, str_val);
            ps.setString(3, str_val);
            ps.setString(4, str_val);
            ps.setInt(5, i);
            ps.executeUpdate();
            leading_b[1] = (char)i;
            str_val = String.valueOf(leading_b);
            ps.setString(1, str_val);
            ps.setString(2, str_val);
            ps.setString(3, str_val);
            ps.setString(4, str_val);
            ps.setInt(5, i);
            ps.executeUpdate();
            trailing_b[0] = (char)i;
            str_val = String.valueOf(trailing_b);
            ps.setString(1, str_val);
            ps.setString(2, str_val);
            ps.setString(3, str_val);
            ps.setString(4, str_val);
            ps.setInt(5, i);
            ps.executeUpdate();
            middle_b[0] = (char)i;
            middle_b[2] = (char)i;
            str_val = String.valueOf(middle_b);
            ps.setString(1, str_val);
            ps.setString(2, str_val);
            ps.setString(3, str_val);
            ps.setString(4, str_val);
            ps.setInt(5, i);
            ps.executeUpdate();
        }
        long after_load_ms = System.currentTimeMillis();
        conn.commit();
        long after_commit_ms = System.currentTimeMillis();
        ps.close();
        s.close();
    }

    private void runDERBY_2703(int db_index) throws SQLException {
        this.setUpTable();
        ResultSet rs = this.getConnection().getMetaData().getColumns(null, "APP", "CUSTOMER", "%");
        int rowCount = JDBC.assertDrainResults(rs);
        Assert.assertTrue((String)"catch bug where no rows are returned.", (rowCount > 0 ? 1 : 0) != 0);
        this.dropTable();
    }

    private void checkSimpleCompare(int[] expected_order) throws SQLException {
        for (int i = 0; i < expected_order.length; ++i) {
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME < '" + NAMES[expected_order[i]] + "' ORDER BY NAME", this.full_row_set(expected_order, 0, i - 1, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME <= '" + NAMES[expected_order[i]] + "' ORDER BY NAME", this.full_row_set(expected_order, 0, i, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME = '" + NAMES[expected_order[i]] + "' ORDER BY NAME", this.full_row_set(expected_order, i, i, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME >= '" + NAMES[expected_order[i]] + "' ORDER BY NAME", this.full_row_set(expected_order, i, expected_order.length - 1, true), true);
            this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER where NAME > '" + NAMES[expected_order[i]] + "' ORDER BY NAME", this.full_row_set(expected_order, i + 1, expected_order.length - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME < ? ORDER BY NAME", new String[]{NAMES[expected_order[i]]}, 1, this.full_row_set(expected_order, 0, i - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME <= ? ORDER BY NAME", new String[]{NAMES[expected_order[i]]}, 1, this.full_row_set(expected_order, 0, i, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME = ? ORDER BY NAME", new String[]{NAMES[expected_order[i]]}, 1, this.full_row_set(expected_order, i, i, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME >= ? ORDER BY NAME", new String[]{NAMES[expected_order[i]]}, 1, this.full_row_set(expected_order, i, expected_order.length - 1, true), true);
            this.checkParamQuery("SELECT ID, NAME FROM CUSTOMER where NAME > ? ORDER BY NAME", new String[]{NAMES[expected_order[i]]}, 1, this.full_row_set(expected_order, i + 1, expected_order.length - 1, true), true);
        }
    }

    private void checkTwoPersistentCompare(int[] expected_order) throws SQLException {
        Statement s = this.createStatement();
        this.commit();
        s.execute("ALTER TABLE CUSTOMER ADD COLUMN TWO_CHECK_CHAR CHAR(40)");
        s.execute("ALTER TABLE CUSTOMER ADD COLUMN TWO_CHECK_VARCHAR VARCHAR(400)");
        PreparedStatement ps = this.prepareStatement("UPDATE CUSTOMER SET TWO_CHECK_CHAR = ?");
        ps.setString(1, NAMES[expected_order[3]]);
        ps.executeUpdate();
        ps = this.prepareStatement("UPDATE CUSTOMER SET TWO_CHECK_VARCHAR = ?");
        ps.setString(1, NAMES[expected_order[3]]);
        ps.executeUpdate();
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE NAME > TWO_CHECK_CHAR ORDER BY NAME", this.full_row_set(expected_order, 4, expected_order.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE TWO_CHECK_CHAR < NAME ORDER BY NAME", this.full_row_set(expected_order, 4, expected_order.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE NAME > TWO_CHECK_VARCHAR ORDER BY NAME", this.full_row_set(expected_order, 4, expected_order.length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER WHERE D3 > TWO_CHECK_CHAR ORDER BY NAME", this.full_row_set(expected_order, 4, expected_order.length - 1, true), true);
        this.rollback();
    }

    private void dropTable() throws SQLException {
        this.dropTable("CUSTOMER");
    }

    private void runQueries(int db_index, String create_idx_qry, String idx_name) throws SQLException {
        Statement s = this.createStatement();
        if (create_idx_qry != null) {
            s.execute(create_idx_qry);
            this.commit();
        }
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME", this.full_row_set(EXPECTED_NAME_ORDER[db_index], 0, EXPECTED_NAME_ORDER[db_index].length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME, ID", this.full_row_set(EXPECTED_NAME_ORDER[db_index], 0, EXPECTED_NAME_ORDER[db_index].length - 1, true), true);
        this.checkLangBasedQuery("SELECT ID, NAME FROM CUSTOMER ORDER BY NAME DESC", this.full_row_set(EXPECTED_NAME_ORDER[db_index], 0, EXPECTED_NAME_ORDER[db_index].length - 1, false), true);
        this.checkSimpleCompare(EXPECTED_NAME_ORDER[db_index]);
        this.checkTwoPersistentCompare(EXPECTED_NAME_ORDER[db_index]);
        if (create_idx_qry != null) {
            s.execute("DROP INDEX " + idx_name);
        }
        this.commit();
    }

    private void runLikeTests(int db_index) throws SQLException {
        this.setUpLikeTable();
        for (int i = 0; i < LIKE_TEST_CASES.length; ++i) {
            this.checkLangBasedQuery("SELECT ID, NAME_VARCHAR FROM CUSTOMER WHERE NAME_VARCHAR LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_VARCHAR FROM CUSTOMER WHERE NAME_VARCHAR LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_LONGVARCHAR FROM CUSTOMER WHERE NAME_LONGVARCHAR LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_LONGVARCHAR FROM CUSTOMER WHERE NAME_LONGVARCHAR LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_CLOB FROM CUSTOMER WHERE NAME_CLOB LIKE '" + LIKE_TEST_CASES[i] + "'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_CLOB FROM CUSTOMER WHERE NAME_CLOB LIKE ?", new String[]{LIKE_TEST_CASES[i]}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkLangBasedQuery("SELECT ID, NAME_CHAR FROM CUSTOMER WHERE NAME_CHAR LIKE '" + LIKE_CHAR_TEST_CASES[i] + "%'", this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
            this.checkParamQuery("SELECT ID, NAME_CHAR FROM CUSTOMER WHERE NAME_CHAR LIKE ?", new String[]{LIKE_CHAR_TEST_CASES[i] + "%"}, 1, this.full_row_single_value(EXPECTED_LIKE_RESULTS[db_index][i], LIKE_NAMES), true);
        }
        String zero_row_syscat_query1 = "SELECT * from SYS.SYSCOLUMNS where COLUMNNAME like 'nonmatchiing'";
        String zero_row_syscat_query2 = "SELECT * from SYS.SYSCOLUMNS where 'nonmatchiing' like COLUMNNAME";
        String zero_row_syscat_query_param1 = "SELECT * from SYS.SYSCOLUMNS where COLUMNNAME like ?";
        String zero_row_syscat_query_param2 = "SELECT * from SYS.SYSCOLUMNS where ? like COLUMNNAME";
        String zero_row_syscat_query_param3 = "SELECT count(*) from SYS.SYSCOLUMNS where ? like ?";
        if (!this.isDatabaseBasicCollation()) {
            this.assertCompileError("42ZA2", zero_row_syscat_query1);
            this.assertCompileError("42ZA2", zero_row_syscat_query2);
            this.checkParamQuery(zero_row_syscat_query_param1, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(zero_row_syscat_query_param2, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(zero_row_syscat_query_param3, new String[]{"nonmatching", "matching"}, 2, new String[][]{{"0"}}, true);
        } else {
            this.checkLangBasedQuery(zero_row_syscat_query1, null, true);
            this.checkLangBasedQuery(zero_row_syscat_query2, null, true);
            this.checkParamQuery(zero_row_syscat_query_param1, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(zero_row_syscat_query_param2, new String[]{"nonmatchiing"}, 1, null, true);
            this.checkParamQuery(zero_row_syscat_query_param3, new String[]{"nonmatching", "123"}, 2, new String[][]{{"0"}}, true);
        }
        this.dropTable();
    }

    private void runAlterTableCompress(int db_index) throws SQLException {
        Statement s = this.createStatement();
        this.setUpTable();
        s.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        s.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        s.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        s.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        s.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.commit();
        CallableStatement call_stmt = this.prepareCall(" call SYSCS_UTIL.COMPRESS_TABLE('APP', 'CUSTOMER', 1)");
        CollationTest2.assertUpdateCount(call_stmt, 0);
        this.commit();
        this.runQueries(db_index, null, null);
        s.execute("DROP INDEX IDX1 ");
        s.execute("DROP INDEX IDX2 ");
        s.execute("DROP INDEX IDX3 ");
        s.execute("DROP INDEX IDX4 ");
        s.execute("DROP INDEX IDX5 ");
        this.rollback();
        this.runQueries(db_index, null, null);
        this.dropTable();
        this.commit();
    }

    private void runAlterTableDropColumn(Connection conn, int db_index) throws SQLException {
        Statement s = conn.createStatement();
        this.setUpTable();
        s.execute("ALTER TABLE CUSTOMER DROP COLUMN D1");
        this.runQueries(db_index, null, null);
        s.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        s.execute("ALTER TABLE CUSTOMER DROP COLUMN D2");
        this.runQueries(db_index, null, null);
        conn.rollback();
        this.dropTable();
        this.commit();
    }

    private void runAlterTableAddColumn(int db_index) throws SQLException {
        Statement s = this.createStatement();
        this.setUpTable();
        s.execute("ALTER TABLE CUSTOMER DROP COLUMN NAME");
        s.execute("ALTER TABLE CUSTOMER ADD COLUMN NAME CHAR(40)");
        s.execute("UPDATE CUSTOMER SET NAME = D1");
        this.runQueries(db_index, null, null);
        s.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        this.runQueries(db_index, null, null);
        this.dropTable();
        this.commit();
    }

    private void runBulkInsert(int db_index) throws SQLException {
        Statement s = this.createStatement();
        this.setUpTable();
        String fileName = SupportFilesSetup.getReadWrite("names.dat").getPath();
        this.doExportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16");
        this.commit();
        s.execute("DELETE FROM CUSTOMER");
        this.commit();
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 0);
        this.runQueries(db_index, null, null);
        s.execute("DELETE FROM CUSTOMER");
        s.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        s.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        s.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        s.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        s.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 0);
        this.runQueries(db_index, null, null);
        s.execute("DROP INDEX IDX1 ");
        s.execute("DROP INDEX IDX2 ");
        s.execute("DROP INDEX IDX3 ");
        s.execute("DROP INDEX IDX4 ");
        s.execute("DROP INDEX IDX5 ");
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 0);
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 1);
        this.runQueries(db_index, null, null);
        s.execute("CREATE INDEX IDX1 ON CUSTOMER (NAME)");
        s.execute("CREATE INDEX IDX2 ON CUSTOMER (NAME, ID)");
        s.execute("CREATE INDEX IDX3 ON CUSTOMER (ID,   NAME)");
        s.execute("CREATE INDEX IDX4 ON CUSTOMER (ID)");
        s.execute("CREATE INDEX IDX5 ON CUSTOMER (ID, NAME, D1, D2, D3)");
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 0);
        this.doImportTable("APP", "CUSTOMER", fileName, null, null, "UTF-16", 1);
        this.runQueries(db_index, null, null);
        s.execute("DROP INDEX IDX1 ");
        s.execute("DROP INDEX IDX2 ");
        s.execute("DROP INDEX IDX3 ");
        s.execute("DROP INDEX IDX4 ");
        s.execute("DROP INDEX IDX5 ");
        this.dropTable();
        this.commit();
    }

    private void runDerby2670() throws SQLException {
        ResultSet rs;
        String qry;
        int i;
        Statement s = this.createStatement();
        String[] rows = new String[]{"Waagan", "W\u00e5han", "Wanvik", "W\u00e5gan", "ekstrabetaling", "ekstraarbeid", "ekstra\u00adarbeid", "\u00ada", "a", "\u00adb", "b", "-a", "-b", " a", " b", "A", "B", "C"};
        s.executeUpdate("create table t (x varchar(20))");
        PreparedStatement ps = this.prepareStatement("insert into t values ?");
        for (int i2 = 0; i2 < rows.length; ++i2) {
            ps.setString(1, rows[i2]);
            ps.executeUpdate();
        }
        ps.close();
        Assert.assertEquals((String)"source and result arrays do not match for derby2670", (int)derby2670_pattern_result.length, (int)derby2670_pattern.length);
        String like_qry = "select * from t where x like ";
        PreparedStatement ps_like = this.prepareStatement("select * from t where x like ?");
        PreparedStatement ps_like_orderby = this.prepareStatement("select * from t where x like ? order by x");
        for (i = 0; i < derby2670_pattern.length; ++i) {
            qry = like_qry + "'" + derby2670_pattern[i] + "'";
            this.checkLangBasedQuery(qry, derby2670_pattern_result[i], false);
            qry = qry + " order by x";
            this.checkLangBasedQuery(qry, derby2670_pattern_result[i], false);
            ps_like.setString(1, derby2670_pattern[i]);
            rs = ps_like.executeQuery();
            if (derby2670_pattern_result[i] == null) {
                JDBC.assertEmpty(rs);
            } else {
                JDBC.assertUnorderedResultSet(rs, derby2670_pattern_result[i]);
            }
            rs.close();
            rs = null;
            ps_like_orderby.setString(1, derby2670_pattern[i]);
            rs = ps_like_orderby.executeQuery();
            if (derby2670_pattern_result[i] == null) {
                JDBC.assertEmpty(rs);
            } else {
                JDBC.assertFullResultSet(rs, derby2670_pattern_result[i]);
            }
            rs.close();
            rs = null;
        }
        s.executeUpdate("create index t_idx on t (x)");
        like_qry = "select * from t where x like ";
        for (i = 0; i < derby2670_pattern.length; ++i) {
            qry = like_qry + "'" + derby2670_pattern[i] + "'";
            this.checkLangBasedQuery(qry, derby2670_pattern_result[i], false);
            qry = qry + " order by x";
            this.checkLangBasedQuery(qry, derby2670_pattern_result[i], false);
            ps_like.setString(1, derby2670_pattern[i]);
            rs = ps_like.executeQuery();
            if (derby2670_pattern_result[i] == null) {
                JDBC.assertEmpty(rs);
            } else {
                JDBC.assertUnorderedResultSet(rs, derby2670_pattern_result[i]);
            }
            rs.close();
            rs = null;
            ps_like_orderby.setString(1, derby2670_pattern[i]);
            rs = ps_like_orderby.executeQuery();
            if (derby2670_pattern_result[i] == null) {
                JDBC.assertEmpty(rs);
            } else {
                JDBC.assertFullResultSet(rs, derby2670_pattern_result[i]);
            }
            rs.close();
            rs = null;
        }
        s.executeUpdate("drop table t");
        this.commit();
        ps_like_orderby.close();
        ps_like.close();
        s.close();
    }

    private void runTestIter(int db_index) throws SQLException {
        this.setUpTable();
        this.runQueries(db_index, null, null);
        this.runQueries(db_index, "CREATE INDEX NAME_IDX ON CUSTOMER (NAME)", "NAME_IDX");
        this.runQueries(db_index, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME)", "IDX");
        this.runQueries(db_index, "CREATE INDEX NAME_IDX ON CUSTOMER (NAME DESC)", "NAME_IDX");
        this.runQueries(db_index, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME DESC)", "IDX");
        this.runQueries(db_index, "CREATE UNIQUE INDEX IDX ON CUSTOMER (NAME, ID)", "IDX");
        this.dropTable();
        this.runDERBY_2703(db_index);
        this.runAlterTableAddColumn(db_index);
        this.runAlterTableCompress(db_index);
        if (JDBC.vmSupportsJDBC3()) {
            this.runBulkInsert(db_index);
        }
        this.runLikeTests(db_index);
        this.commit();
    }

    public void testDefaultCollation() throws SQLException {
        CollationTest2.assertTrue((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(0);
    }

    public void testEnglishCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(1);
    }

    public void testPolishCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runTestIter(2);
    }

    public void testNorwayCollation() throws SQLException {
        CollationTest2.assertFalse((boolean)this.isDatabaseBasicCollation());
        this.runDerby2670();
        this.runTestIter(3);
    }

    public void testDefaultJVMTerritoryCollation() throws SQLException {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals("en")) {
            this.testEnglishCollation();
        } else if (locale.getLanguage().equals("no")) {
            this.testNorwayCollation();
        } else if (locale.getLanguage().equals("po")) {
            this.testPolishCollation();
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CollationTest2");
        suite.addTest((Test)new CollationTest2("testDefaultCollation"));
        suite.addTest(CollationTest2.collatedTest("en", "testEnglishCollation"));
        Locale[] availableLocales = Collator.getAvailableLocales();
        boolean norwegian = false;
        boolean polish = false;
        for (int i = 0; i < availableLocales.length; ++i) {
            if ("no".equals(availableLocales[i].getLanguage())) {
                norwegian = true;
            }
            if (!"pl".equals(availableLocales[i].getLanguage())) continue;
            polish = true;
        }
        if (norwegian) {
            suite.addTest(CollationTest2.collatedTest("no_NO", "testNorwayCollation"));
        }
        if (polish) {
            suite.addTest(CollationTest2.collatedTest("pl", "testPolishCollation"));
        }
        suite.addTest(CollationTest2.collatedTest(null, "testDefaultJVMTerritoryCollation"));
        SupportFilesSetup test = new SupportFilesSetup((Test)suite);
        return test;
    }

    private static Test collatedTest(String locale, String fixture) {
        return Decorator.territoryCollatedDatabase((Test)new CollationTest2(fixture), locale);
    }
}

