/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CastingTest
extends BaseJDBCTestCase {
    public static String VALID_DATE_STRING = "'2000-01-01'";
    public static String VALID_TIME_STRING = "'15:30:20'";
    public static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    public static String NULL_VALUE = "NULL";
    public static String ILLEGAL_CAST_EXCEPTION_SQLSTATE = "42846";
    public static String LANG_NOT_STORABLE_SQLSTATE = "42821";
    public static String LANG_NOT_COMPARABLE_SQLSTATE = "42818";
    public static String METHOD_NOT_FOUND_SQLSTATE = "42884";
    public static String LANG_FORMAT_EXCEPTION_SQLSTATE = "22018";
    public static int SQLTYPE_ARRAY_SIZE = 17;
    public static int SMALLINT_OFFSET = 0;
    public static int INTEGER_OFFSET = 1;
    public static int BIGINT_OFFSET = 2;
    public static int DECIMAL_OFFSET = 3;
    public static int REAL_OFFSET = 4;
    public static int DOUBLE_OFFSET = 5;
    public static int CHAR_OFFSET = 6;
    public static int VARCHAR_OFFSET = 7;
    public static int LONGVARCHAR_OFFSET = 8;
    public static int CHAR_FOR_BIT_OFFSET = 9;
    public static int VARCHAR_FOR_BIT_OFFSET = 10;
    public static int LONGVARCHAR_FOR_BIT_OFFSET = 11;
    public static int CLOB_OFFSET = 12;
    public static int DATE_OFFSET = 13;
    public static int TIME_OFFSET = 14;
    public static int TIMESTAMP_OFFSET = 15;
    public static int BLOB_OFFSET = 16;
    public static int[] jdbcTypes = new int[]{5, 4, -5, 3, 7, 8, 1, 12, -1, -2, -3, -4, 2005, 91, 92, 93, 2004};
    public static int NULL_DATA_OFFSET = 0;
    public static int VALID_DATA_OFFSET = 1;
    public static String[][] SQLData = new String[][]{{NULL_VALUE, "0"}, {NULL_VALUE, "11"}, {NULL_VALUE, "22"}, {NULL_VALUE, "3.3"}, {NULL_VALUE, "4.4"}, {NULL_VALUE, "5.5"}, {NULL_VALUE, "'7'"}, {NULL_VALUE, "'8'"}, {NULL_VALUE, "'9'"}, {NULL_VALUE, "X'10aa'"}, {NULL_VALUE, "X'10bb'"}, {NULL_VALUE, "X'10cc'"}, {NULL_VALUE, "'13'"}, {NULL_VALUE, VALID_DATE_STRING}, {NULL_VALUE, VALID_TIME_STRING}, {NULL_VALUE, VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'01dd'"}};
    public static final boolean __ = false;
    public static final boolean XX = true;
    public static final boolean[][] T_146 = new boolean[][]{{true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {true, true, true, true, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, true}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147a = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, true, true, true, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true}};
    public static final boolean[][] T_147b = new boolean[][]{{true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    private static final String[][] explicitCastValues = new String[][]{{"0", "0", "0", "0.00000", "0.0", "0.0", "0                                                           ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"11", "11", "11", "11.00000", "11.0", "11.0", "11                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"22", "22", "22", "22.00000", "22.0", "22.0", "22                                                          ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"3", "3", "3", "3.30000", "3.3", "3.3", "3.30000                                                     ", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"4", "4", "4", "4.40000", "4.4", "4.400000095367432", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"5", "5", "5", "5.50000", "5.5", "5.5", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8                                                           ", "9                                                           ", "Exception", "Exception", "Exception", "13                                                          ", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"0", "11", "22", "3.30000", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "7                                                           ", "8", "9", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10cc20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "Exception", "Exception", "Exception", "Exception", "01dd20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", "10bb", "10cc", "Exception", "Exception", "Exception", "Exception", "01dd"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "13                                                          ", "13", "13", "Exception", "Exception", "Exception", "13", "Exception", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01                                                  ", "2000-01-01", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "Exception", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20                                                    ", "15:30:20", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "15:30:20", "Exception", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01 15:30:20.0                                       ", "2000-01-01 15:30:20.0", "Exception", "Exception", "Exception", "Exception", "Exception", "2000-01-01", "15:30:20", "2000-01-01 15:30:20.0", "Exception"}, {"Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "Exception", "01dd"}};

    public CastingTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        String tableName;
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            String typeName = SQLUtilities.SQLTypes[type];
            tableName = CastingTest.getTableName(type);
            String createSQL = "create table " + tableName + " (c " + typeName + " )";
            scb.executeUpdate(createSQL);
        }
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
                try {
                    tableName = CastingTest.getTableName(type);
                    String insertSQL = "insert into " + tableName + " values( " + SQLData[type][dataOffset] + ")";
                    scb.executeUpdate(insertSQL);
                    continue;
                }
                catch (SQLException se) {
                    if (type == BLOB_OFFSET) continue;
                    throw se;
                }
            }
        }
        scb.close();
        this.commit();
    }

    public void testAssignments() throws SQLException {
        Statement scb = this.createStatement();
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
                String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        String targetTableName = CastingTest.getTableName(targetType);
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        String insertValuesString = " VALUES CAST(" + convertString + " AS " + sourceTypeName + ")";
                        String insertSQL = "INSERT INTO " + targetTableName + insertValuesString;
                        scb.executeUpdate(insertSQL);
                        CastingTest.checkSupportedAssignment(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        String sqlState = se.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedAssignment(sourceType, targetType) && CastingTest.isNotStorableException(se) || CastingTest.isCastException(se) ? 1 : 0) != 0);
                    }
                }
            }
        }
        scb.close();
        this.commit();
    }

    public void testExplicitCasts() throws SQLException {
        Statement s = this.createStatement();
        for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
            String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
            for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        String targetTypeName = SQLUtilities.SQLTypes[targetType];
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        String query = "VALUES CAST (CAST (" + convertString + " AS " + SQLUtilities.SQLTypes[sourceType] + ") AS " + SQLUtilities.SQLTypes[targetType] + " )";
                        ResultSet rs = s.executeQuery(query);
                        rs.next();
                        String val = rs.getString(1);
                        ResultSetMetaData rsmd = rs.getMetaData();
                        CastingTest.assertEquals((int)rsmd.getColumnType(1), (int)jdbcTypes[targetType]);
                        rs.close();
                        if (dataOffset == 0) {
                            CastingTest.assertNull((Object)val);
                        } else {
                            CastingTest.assertEquals((String)val, (String)explicitCastValues[sourceType][targetType]);
                        }
                        CastingTest.checkSupportedCast(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        if (dataOffset != 0) {
                            // empty if block
                        }
                        String sqlState = se.getSQLState();
                        if (!CastingTest.isSupportedCast(sourceType, targetType)) {
                            CastingTest.assertTrue((boolean)CastingTest.isCastException(se));
                            continue;
                        }
                        throw se;
                    }
                }
            }
        }
        this.commit();
    }

    public void testComparisons() throws SQLException {
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            try {
                int dataOffset = 1;
                String tableName = CastingTest.getTableName(type);
                String compareSQL = "SELECT distinct c FROM " + tableName + " WHERE c = " + SQLData[type][dataOffset];
                ResultSet rs = scb.executeQuery(compareSQL);
                CastingTest.assertTrue((boolean)rs.next());
                rs.close();
                continue;
            }
            catch (SQLException se) {
                CastingTest.assertTrue((boolean)CastingTest.isLongType(type));
            }
        }
        for (int dataOffset = 0; dataOffset < SQLData[0].length; ++dataOffset) {
            for (int sourceType = 0; sourceType < SQLUtilities.SQLTypes.length; ++sourceType) {
                String sourceTypeName = SQLUtilities.SQLTypes[sourceType];
                for (int targetType = 0; targetType < SQLUtilities.SQLTypes.length; ++targetType) {
                    try {
                        String targetTableName = CastingTest.getTableName(targetType);
                        String convertString = CastingTest.getCompatibleString(sourceType, targetType, dataOffset);
                        scb.executeUpdate("DELETE FROM " + targetTableName);
                        String insertValuesString = " VALUES CAST(" + convertString + " AS " + sourceTypeName + ")";
                        String insertSQL = "INSERT INTO " + targetTableName + insertValuesString;
                        String compareSQL = "select c from " + targetTableName + " WHERE c = CAST(" + convertString + " AS " + sourceTypeName + ")";
                        ResultSet rs = scb.executeQuery(compareSQL);
                        JDBC.assertDrainResults(rs);
                        CastingTest.checkSupportedComparison(sourceType, targetType);
                        continue;
                    }
                    catch (SQLException se) {
                        String sqlState = se.getSQLState();
                        CastingTest.assertTrue((!CastingTest.isSupportedComparison(sourceType, targetType) && CastingTest.isNotComparableException(se) || CastingTest.isCastException(se) ? 1 : 0) != 0);
                    }
                }
            }
        }
        scb.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws SQLException, Exception {
        BaseJDBCTestCase.preTearDown();
        Statement scb = this.createStatement();
        for (int type = 0; type < SQLUtilities.SQLTypes.length; ++type) {
            String typeName = SQLUtilities.SQLTypes[type];
            String tableName = CastingTest.getTableName(type);
            String dropSQL = "drop table " + tableName;
            scb.executeUpdate(dropSQL);
        }
        scb.close();
        this.commit();
        super.tearDown();
    }

    private static String getTableName(int type) {
        return CastingTest.getShortTypeName(type).replace(' ', '_') + "_TAB";
    }

    private static String getShortTypeName(int type) {
        String typeName;
        String shortName = typeName = SQLUtilities.SQLTypes[type];
        int parenIndex = typeName.indexOf(40);
        if (parenIndex >= 0) {
            shortName = typeName.substring(0, parenIndex);
            int endParenIndex = typeName.indexOf(41);
            shortName = shortName + typeName.substring(endParenIndex + 1, typeName.length());
        }
        return shortName;
    }

    private static String getCompatibleString(int sourceType, int targetType, int dataOffset) {
        String convertString = null;
        convertString = (CastingTest.isCharacterType(sourceType) || CastingTest.isBinaryType(sourceType)) && !CastingTest.isLob(sourceType) ? CastingTest.formatString(SQLData[targetType][dataOffset]) : SQLData[sourceType][dataOffset];
        return convertString;
    }

    private static boolean isSupportedCast(int sourceType, int targetType) {
        return T_146[sourceType][targetType];
    }

    private static boolean isSupportedAssignment(int sourceType, int targetType) {
        return T_147a[sourceType][targetType];
    }

    private static boolean isSupportedComparison(int sourceType, int targetType) {
        return T_147b[sourceType][targetType];
    }

    private static boolean isCastException(SQLException se) {
        return CastingTest.sqlStateMatches(se, ILLEGAL_CAST_EXCEPTION_SQLSTATE);
    }

    private static boolean isMethodNotFoundException(SQLException se) {
        return CastingTest.sqlStateMatches(se, METHOD_NOT_FOUND_SQLSTATE);
    }

    private static boolean sqlStateMatches(SQLException se, String expectedValue) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(expectedValue);
    }

    private static boolean isNotStorableException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(LANG_NOT_STORABLE_SQLSTATE);
    }

    private static boolean isNotComparableException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.equals(LANG_NOT_COMPARABLE_SQLSTATE);
    }

    private static void checkSupportedCast(int sourceType, int targetType) {
        String description = " Cast from " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedCast(sourceType, targetType)) {
            CastingTest.fail((String)(description + "should not succeed"));
        }
    }

    private static void checkSupportedAssignment(int sourceType, int targetType) {
        String description = " Assignment from " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedAssignment(sourceType, targetType)) {
            CastingTest.fail((String)(description + "should not succeed"));
        }
    }

    private static void checkSupportedComparison(int sourceType, int targetType) {
        String description = " Comparison of " + SQLUtilities.SQLTypes[sourceType] + " to " + SQLUtilities.SQLTypes[targetType];
        if (!CastingTest.isSupportedComparison(sourceType, targetType)) {
            CastingTest.fail((String)("FAIL: unsupported comparison:" + description));
        }
    }

    private static boolean isLongType(int typeOffset) {
        return typeOffset == LONGVARCHAR_OFFSET || typeOffset == LONGVARCHAR_FOR_BIT_OFFSET || typeOffset == CLOB_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static boolean isCharacterType(int typeOffset) {
        return typeOffset == CHAR_OFFSET || typeOffset == VARCHAR_OFFSET || typeOffset == LONGVARCHAR_OFFSET || typeOffset == CLOB_OFFSET;
    }

    private static boolean isBinaryType(int typeOffset) {
        return typeOffset == CHAR_FOR_BIT_OFFSET || typeOffset == VARCHAR_FOR_BIT_OFFSET || typeOffset == LONGVARCHAR_FOR_BIT_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static boolean isDateTimeTimestamp(int typeOffset) {
        return typeOffset == DATE_OFFSET || typeOffset == TIME_OFFSET || typeOffset == TIMESTAMP_OFFSET;
    }

    private static boolean isClob(int typeOffset) {
        return typeOffset == CLOB_OFFSET;
    }

    private static boolean isLob(int typeOffset) {
        return typeOffset == CLOB_OFFSET || typeOffset == BLOB_OFFSET;
    }

    private static String formatString(String str) {
        if (str != null && (str.startsWith("X") || str.startsWith("'") || str == NULL_VALUE)) {
            return str;
        }
        return "'" + str + "'";
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(CastingTest.class);
    }
}

