/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CaseExpressionTest
extends BaseJDBCTestCase {
    private static String[][] columnReferenceResults = new String[][]{{null, "0", "1", "2"}, {null, "0", "1", "21"}, {null, "0", "1", "22"}, {null, "0.00000", "1.00000", "23.00000"}, {null, "0.0", "1.0", "24.0"}, {null, "0.0", "1.0", "25.0"}, {null, "0                                                           ", "aa                                                          ", "2.0                                                         "}, {null, "0", "aa", "15:30:20"}, {null, "0", "aa", "2000-01-01 15:30:20"}, {null, "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", null, "10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"}, {null, "10aa", null, "10aaba"}, {null, "10aa", null, "10aaca"}, {null, "13", "14", null}, {null, "2000-01-01", "2000-01-01", null}, {null, "15:30:20", "15:30:20", "15:30:20"}, {null, "2000-01-01 15:30:20.0", "2000-01-01 15:30:20.0", "2000-01-01 15:30:20.0"}, {null, null, null, null}};
    private static String[][] nullValueResults = new String[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}};

    public CaseExpressionTest(String name) {
        super(name);
    }

    public void testWhenNonBoolean() {
        String[] unaryOperators = new String[]{"SQRT(?)", "SQRT(9)", "UPPER(?)", "UPPER('haight')", "LOWER(?)", "LOWER('HAIGHT')"};
        for (int i = 0; i < unaryOperators.length; ++i) {
            this.assertCompileError("42X88", "VALUES CASE WHEN " + unaryOperators[i] + " THEN 3 ELSE 4 END");
        }
    }

    public void testAllDatatypesCombinationsForCaseExpressions() throws SQLException {
        Statement s = this.createStatement();
        this.testCaseExpressionQuery(s, columnReferenceResults, "SELECT CASE WHEN 1 = 1 THEN ", " ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(s, columnReferenceResults, "SELECT CASE WHEN 1 = 1 THEN (CASE WHEN 1 = 1 THEN ", " ELSE NULL END) ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(s, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE ", " END from AllDataTypesTable");
        this.testCaseExpressionQuery(s, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN (CASE WHEN 1 = 1 THEN NULL ELSE ", " END) ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(s, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE (CASE WHEN 1 = 1 THEN ", " ELSE NULL END) END from AllDataTypesTable");
        this.testCaseExpressionQuery(s, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE (CASE WHEN 1 = 1 THEN NULL ELSE ", " END) END from AllDataTypesTable");
        s.close();
    }

    public void testMultipleWhens() throws SQLException {
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("values CASE WHEN 10 = 1 THEN 'a' WHEN 10 = 2 THEN 'b' WHEN 10 = 3 THEN 'c' WHEN 10 = 4 THEN 'd' WHEN 10 = 5 THEN 'e' WHEN 10 = 6 THEN 'f' WHEN 10 = 7 THEN 'g' WHEN 10 = 8 THEN 'h' WHEN 10 = 11 THEN 'i' WHEN 10 = 12 THEN 'j' WHEN 10 = 15 THEN 'k' WHEN 10 = 16 THEN 'l' WHEN 10 = 23 THEN 'm' WHEN 10 = 24 THEN 'n' WHEN 10 = 27 THEN 'o' WHEN 10 = 31 THEN 'p' WHEN 10 = 41 THEN 'q' WHEN 10 = 42 THEN 'r' WHEN 10 = 50 THEN 's' ELSE '*' END"), new String[][]{{"*"}});
        s.close();
    }

    public static Test suite() {
        TestSuite suite = (TestSuite)TestConfiguration.embeddedSuite(CaseExpressionTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                SQLUtilities.createAndPopulateAllDataTypesTable(s);
            }
        };
    }

    private void testCaseExpressionQuery(Statement st, String[][] expRS, String caseExprBegin, String caseExprEnd) throws SQLException {
        for (int colType = 0; colType < SQLUtilities.SQLTypes.length; ++colType) {
            ResultSet rs = st.executeQuery(caseExprBegin + SQLUtilities.allDataTypesColumnNames[colType] + caseExprEnd);
            ArrayList<String> expected = new ArrayList<String>(Arrays.asList(expRS[colType]));
            ArrayList<String> actual = new ArrayList<String>();
            while (rs.next()) {
                actual.add(rs.getString(1));
            }
            rs.close();
            Assert.assertEquals((String)"Unexpected row count", (int)expected.size(), (int)actual.size());
            Assert.assertTrue((String)"Missing rows in ResultSet", (boolean)actual.containsAll(expected));
            actual.removeAll(expected);
            Assert.assertTrue((String)"Extra rows in ResultSet", (boolean)actual.isEmpty());
        }
    }

    public void testDerby3032() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("create table t (d date, vc varchar(30))");
            s.executeUpdate("insert into t values(CURRENT_DATE, 'hello')");
            ResultSet rs = s.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 1 THEN CURRENT_DATE ELSE NULL END from t)");
            JDBC.assertDrainResults(rs, 1);
            rs = s.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 1 THEN NULL  ELSE CURRENT_DATE  END from t)");
            JDBC.assertEmpty(rs);
            rs = s.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE  ELSE NULL END from t)");
            JDBC.assertEmpty(rs);
            rs = s.executeQuery("SELECT CASE WHEN 1 = 1 THEN NULL  ELSE CURRENT_DATE  END from t");
            ResultSetMetaData rsmd = rs.getMetaData();
            CaseExpressionTest.assertEquals((int)91, (int)rsmd.getColumnType(1));
            CaseExpressionTest.assertEquals((int)1, (int)rsmd.isNullable(1));
            JDBC.assertSingleValueResultSet(rs, null);
            rs = s.executeQuery("SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE ELSE NULL END from t");
            rsmd = rs.getMetaData();
            CaseExpressionTest.assertEquals((int)91, (int)rsmd.getColumnType(1));
            CaseExpressionTest.assertEquals((int)1, (int)rsmd.isNullable(1));
            JDBC.assertSingleValueResultSet(rs, null);
            rs = s.executeQuery("SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE END from t");
            rsmd = rs.getMetaData();
            CaseExpressionTest.assertEquals((int)91, (int)rsmd.getColumnType(1));
            CaseExpressionTest.assertEquals((int)1, (int)rsmd.isNullable(1));
            JDBC.assertSingleValueResultSet(rs, null);
            rs = s.executeQuery("SELECT CASE WHEN 1 = 0 THEN 6 ELSE 4 END from t");
            rsmd = rs.getMetaData();
            CaseExpressionTest.assertEquals((int)4, (int)rsmd.getColumnType(1));
            CaseExpressionTest.assertEquals((int)0, (int)rsmd.isNullable(1));
            JDBC.assertSingleValueResultSet(rs, "4");
            rs = s.executeQuery("SELECT CASE WHEN 1 = 1 THEN 6 ELSE 4 END from t");
            rsmd = rs.getMetaData();
            CaseExpressionTest.assertEquals((int)4, (int)rsmd.getColumnType(1));
            CaseExpressionTest.assertEquals((int)0, (int)rsmd.isNullable(1));
            JDBC.assertSingleValueResultSet(rs, "6");
        }
        catch (SQLException sqle) {
            s.execute("drop table if exists t");
            throw sqle;
        }
    }
}

