/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class testRelative {
    static final String NO_CURRENT_ROW_SQL_STATE = TestUtil.isNetFramework() ? "XJ121" : "24000";

    public static void main(String[] args) {
        System.out.println("Test testRelative starting");
        Connection con = null;
        try {
            ij.getPropertyArg((String[])args);
            con = ij.startJBMS();
            testRelative.test1(con);
        }
        catch (Exception e) {
            testRelative.unexpectedException(e);
        }
    }

    public static void test1(Connection con) {
        Object rs = null;
        PreparedStatement pStmt = null;
        Object stmt1 = null;
        Object returnValue = null;
        try {
            con.setAutoCommit(false);
            pStmt = con.prepareStatement("create table testRelative(name varchar(10), i int)");
            pStmt.executeUpdate();
            con.commit();
            pStmt = con.prepareStatement("insert into testRelative values (?,?)");
            pStmt.setString(1, "work1");
            pStmt.setNull(2, 1);
            pStmt.addBatch();
            pStmt.setString(1, "work2");
            pStmt.setNull(2, 2);
            pStmt.addBatch();
            pStmt.setString(1, "work3");
            pStmt.setNull(2, 3);
            pStmt.addBatch();
            pStmt.setString(1, "work4");
            pStmt.setNull(2, 4);
            pStmt.addBatch();
            pStmt.executeBatch();
            con.commit();
        }
        catch (SQLException se) {
            testRelative.unexpectedSQLException(se);
        }
        catch (Throwable t) {
            System.out.println("FAIL--unexpected exception: " + t.getMessage());
            t.printStackTrace(System.out);
        }
        try {
            testRelative.testScrolling(1007, con);
            testRelative.testScrolling(1008, con);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    private static void testScrolling(int concurrency, Connection con) throws SQLException {
        Statement stmt1 = con.createStatement(1004, concurrency);
        ResultSet rs = stmt1.executeQuery("select * from testRelative");
        rs.next();
        System.out.println("Value = " + rs.getString("name"));
        rs.relative(2);
        System.out.println("Value = " + rs.getString("name"));
        System.out.println("isFirst = " + rs.isFirst() + " isLast = " + rs.isLast() + " isAfterLast = " + rs.isAfterLast());
        rs.relative(-2);
        System.out.println("Value = " + rs.getString("name"));
        try {
            rs.relative(10);
            System.out.println("Value = " + rs.getString("name"));
            System.out.println("isFirst = " + rs.isFirst() + " isLast = " + rs.isLast() + " isAfterLast = " + rs.isAfterLast());
        }
        catch (SQLException sqle) {
            testRelative.expectedException(sqle, NO_CURRENT_ROW_SQL_STATE);
        }
    }

    private static void expectedException(SQLException se, String expectedSQLState) {
        if (se.getSQLState() != null && se.getSQLState().equals(expectedSQLState)) {
            System.out.println("PASS -- expected exception");
        } else {
            System.out.println("FAIL--Unexpected SQLException: SQLSTATE(" + se.getSQLState() + ")" + se.getMessage());
            while (se != null) {
                System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se.getMessage());
                se.printStackTrace(System.out);
                se = se.getNextException();
            }
        }
    }

    private static void unexpectedSQLException(SQLException se) {
        System.out.println("FAIL -- Unexpected Exception: SQLSTATE(" + se.getSQLState() + ")" + se.getMessage());
        se.printStackTrace(System.out);
    }

    private static void unexpectedException(Exception e) {
        System.out.println("FAIL -- Unexpected Exception: " + e.getMessage());
    }
}

