/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class savepointJdbc30_JSR169 {
    private static boolean isDerbyNet = false;
    private static String[] testObjects = new String[]{"table t1", "table t2", "table savepoint"};

    public static void main(String[] args) {
        Connection con = null;
        Connection con2 = null;
        System.out.println("Test savepointJdbc30 starting");
        try {
            ij.getPropertyArg((String[])args);
            con = ij.startJBMS();
            con2 = ij.startJBMS();
            savepointJdbc30_JSR169.runTests("regular connections", con, con2);
            con.close();
            con2.close();
        }
        catch (SQLException e) {
            savepointJdbc30_JSR169.dumpSQLExceptions(e);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception:");
            e.printStackTrace(System.out);
        }
    }

    public static void runTests(String tag, Connection con, Connection con2) throws SQLException {
        System.out.println("Test savepointJdbc30 starting for " + tag);
        isDerbyNet = TestUtil.isNetFramework();
        con.setAutoCommit(true);
        con2.setAutoCommit(false);
        Statement s = con.createStatement();
        savepointJdbc30_JSR169.setUpTest(s);
        System.out.println("Tests common to DRDA and embedded Cloudscape");
        savepointJdbc30_JSR169.genericTests(con, con2, s);
        System.out.println("Next try non-DRDA tests");
        if (!isDerbyNet) {
            savepointJdbc30_JSR169.nonDRDATests(con, s);
        }
        con.setAutoCommit(true);
        TestUtil.cleanUpTest(s, testObjects);
        s.close();
    }

    static void nonDRDATests(Connection con, Statement s) throws SQLException {
        con.setAutoCommit(false);
        System.out.println("Test40 - named savepoint can't conflict with internally generated name for unnamed savepoints");
        Savepoint savepoint1 = con.setSavepoint();
        Savepoint savepoint2 = con.setSavepoint("i.SAVEPT0");
        con.rollback();
        System.out.println("Test41a - Rollback to a savepoint, then try to release savepoint created after that savepoint");
        savepoint1 = con.setSavepoint();
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        savepoint2 = con.setSavepoint("s1");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        Savepoint savepoint3 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        con.rollback(savepoint2);
        ResultSet rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        if (rs1.getInt(1) != 1) {
            System.out.println("ERROR: There should have been 1 row in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        try {
            con.releaseSavepoint(savepoint3);
            System.out.println("FAIL 41a release of rolled back savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        System.out.println("Test41b - Rollback to a savepoint, then try to rollback savepoint created after that savepoint");
        try {
            con.rollback(savepoint3);
            System.out.println("FAIL 41b release of rolled back savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback(savepoint1);
        rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        if (rs1.getInt(1) != 0) {
            System.out.println("ERROR: There should have been no rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        con.rollback();
        System.out.println("Test42 - Rollback/commit the transaction, then try to use savepoint from that transaction");
        savepoint1 = con.setSavepoint();
        savepoint2 = con.setSavepoint("s1");
        con.rollback();
        try {
            con.rollback(savepoint1);
            System.out.println("FAIL 42 release of rolled back savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        savepoint1 = con.setSavepoint();
        savepoint2 = con.setSavepoint("s1");
        con.commit();
        try {
            con.rollback(savepoint1);
            System.out.println("FAIL 42 rollback of rolled back savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        System.out.println("Test43 - Release and reuse a savepoint name");
        savepoint1 = con.setSavepoint("s1");
        try {
            savepoint2 = con.setSavepoint("s1");
            System.out.println("FAIL 43");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.releaseSavepoint(savepoint1);
        savepoint2 = con.setSavepoint("s1");
        con.rollback();
        System.out.println("Test 45 reuse savepoint name after rollback - should not work");
        savepoint1 = con.setSavepoint("MyName");
        con.rollback(savepoint1);
        try {
            savepoint2 = con.setSavepoint("MyName");
            System.out.println("FAIL 45 reuse of savepoint name after rollback should fail");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 46 Cursors declared before and within the savepoint unit will be closed when rolling back the savepoint");
        Statement sWithHold = con.createStatement(1003, 1007, 1);
        con.setAutoCommit(false);
        s.executeUpdate("DELETE FROM T1");
        s.executeUpdate("INSERT INTO T1 VALUES(19,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(19,2)");
        s.executeUpdate("INSERT INTO T1 VALUES(19,3)");
        rs1 = s.executeQuery("select * from t1");
        rs1.next();
        ResultSet rs1WithHold = sWithHold.executeQuery("select * from t1");
        rs1WithHold.next();
        savepoint1 = con.setSavepoint();
        ResultSet rs2 = s.executeQuery("select * from t1");
        rs2.next();
        ResultSet rs2WithHold = sWithHold.executeQuery("select * from t1");
        rs2WithHold.next();
        con.rollback(savepoint1);
        try {
            rs1.next();
            System.out.println("FAIL 46 shouldn't be able to use a resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            rs1WithHold.next();
            System.out.println("FAIL 46 shouldn't be able to use a holdable resultset (declared before the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            rs2.next();
            System.out.println("FAIL 46 shouldn't be able to use a resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            rs2WithHold.next();
            System.out.println("FAIL 46 shouldn't be able to use a holdable resultset (declared within the savepoint unit) after the rollback to savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 47 multiple tests for getSavepointId()");
        savepoint1 = con.setSavepoint();
        savepoint2 = con.setSavepoint();
        System.out.println(savepoint1.getSavepointId());
        System.out.println(savepoint2.getSavepointId());
        con.releaseSavepoint(savepoint2);
        savepoint2 = con.setSavepoint();
        System.out.println(savepoint2.getSavepointId());
        con.commit();
        savepoint2 = con.setSavepoint();
        System.out.println(savepoint2.getSavepointId());
        con.rollback();
        savepoint2 = con.setSavepoint();
        System.out.println(savepoint2.getSavepointId());
        con.rollback();
        System.out.println("Test 48 No nested SQL savepoints allowed.");
        savepoint1 = con.setSavepoint();
        savepoint2 = con.setSavepoint();
        System.out.println("Following SQL savepoint will fail because we are trying to nest it inside JDBC savepoint");
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 48 shouldn't be able set SQL savepoint nested inside JDBC/SQL savepoints");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.releaseSavepoint(savepoint2);
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 48 Should have gotten exception for nested SQL savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.releaseSavepoint(savepoint1);
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
    }

    static void genericTests(Connection con, Connection con2, Statement s) throws SQLException {
        con.setAutoCommit(true);
        try {
            System.out.println("Test1 - no unnamed savepoints allowed if autocommit is true");
            con.setSavepoint();
            System.out.println("FAIL 1 - auto commit on");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            System.out.println("Test1a - no named savepoints allowed if autocommit is true");
            con.setSavepoint("notallowed");
            System.out.println("FAIL 1a - auto commit on");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.setAutoCommit(false);
        System.out.println("Test2 - Release and reuse a savepoint name");
        Savepoint savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        Savepoint savepoint2 = con.setSavepoint("s1");
        con.rollback();
        try {
            System.out.println("Test3 - null name not allowed for named savepoints");
            con.setSavepoint(null);
            System.out.println("FAIL 3 null savepoint ");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test4 - Verify names/ids of named/unnamed savepoints");
        try {
            savepoint1 = con.setSavepoint();
            savepoint1.getSavepointId();
            savepoint1.getSavepointName();
            System.out.println("FAIL 4 getSavepointName on id savepoint ");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        try {
            savepoint1 = con.setSavepoint("s1");
            savepoint1.getSavepointName();
            savepoint1.getSavepointId();
            System.out.println("FAIL 4 getSavepointId on named savepoint ");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test5a - create two savepoints in two different transactions and release the first one in the subsequent transaction");
        savepoint1 = con.setSavepoint("s1");
        con.commit();
        savepoint2 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.releaseSavepoint(savepoint1);
            System.out.println("FAIL 5a - release savepoint from a different transaction did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        System.out.println("Test5b - create two savepoints in two different transactions and rollback the first one in the subsequent transaction");
        savepoint1 = con.setSavepoint("s1");
        con.commit();
        savepoint2 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.rollback(savepoint1);
            System.out.println("FAIL 5b - rollback savepoint from a different transaction did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        System.out.println("Test6a - create a savepoint, release it, create another with same name and release the first one");
        savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        savepoint2 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.releaseSavepoint(savepoint1);
            System.out.println("FAIL 6a - releasing a released savepoint did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        System.out.println("Test6b - create a savepoint, release it, create another with same name and rollback the first one");
        savepoint1 = con.setSavepoint("s1");
        con.releaseSavepoint(savepoint1);
        savepoint2 = con.setSavepoint("s2");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con.rollback(savepoint1);
            System.out.println("FAIL 6b - rollback a released savepoint did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        System.out.println("Test6c - Try to use a savepoint from another connection for release");
        savepoint1 = con.setSavepoint("s1");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        try {
            con2.releaseSavepoint(savepoint1);
            System.out.println("FAIL 6c - releasing another transaction's savepoint did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        con2.commit();
        System.out.println("Test7a - swap savepoints across connections with release");
        savepoint1 = con2.setSavepoint("s1");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        savepoint2 = con.setSavepoint("s1");
        try {
            con.releaseSavepoint(savepoint1);
            System.out.println("FAIL 7a - releasing a another transaction's savepoint did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        con2.commit();
        System.out.println("Test7b - swap savepoints across connections with rollback");
        savepoint1 = con2.setSavepoint("s1");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        savepoint2 = con.setSavepoint("s1");
        try {
            con.rollback(savepoint1);
            System.out.println("FAIL 7b - rolling back a another transaction's savepoint did not raise error");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.commit();
        con2.commit();
        System.out.println("Test 9 test savepoint name");
        savepoint1 = con.setSavepoint("myname");
        String savepointName = savepoint1.getSavepointName();
        if (!savepointName.equals("myname")) {
            System.out.println("fail - savepoint name mismatch");
        }
        con.rollback();
        System.out.println("Test 10 test savepoint name case sensitivity");
        savepoint1 = con.setSavepoint("MyName");
        savepointName = savepoint1.getSavepointName();
        if (!savepointName.equals("MyName")) {
            System.out.println("fail - savepoint name mismatch");
        }
        con.rollback();
        System.out.println("Test 11 rolling back a savepoint multiple times - should work");
        savepoint1 = con.setSavepoint("MyName");
        con.rollback(savepoint1);
        try {
            con.rollback(savepoint1);
        }
        catch (SQLException se) {
            System.out.println("FAIL 11 second rollback failed");
            System.out.println("Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 12 releasing a savepoint multiple times - should not work");
        savepoint1 = con.setSavepoint("MyName");
        con.releaseSavepoint(savepoint1);
        try {
            con.releaseSavepoint(savepoint1);
            System.out.println("FAIL 12 releasing a savepoint multiple times should fail");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 13 shouldn't be able to use a savepoint from earlier transaction after setting autocommit on and off");
        savepoint1 = con.setSavepoint("MyName");
        con.setAutoCommit(true);
        con.setAutoCommit(false);
        savepoint2 = con.setSavepoint("MyName1");
        try {
            con.releaseSavepoint(savepoint1);
            System.out.println("FAIL 13 shouldn't be able to use a savepoint from earlier transaction after setting autocommit on and off");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.releaseSavepoint(savepoint2);
        con.rollback();
        System.out.println("Test 14 A non-user initiated transaction rollback should release the internal savepoint array");
        Statement s1 = con.createStatement();
        s1.executeUpdate("insert into t1 values(1,1)");
        s1.executeUpdate("insert into t1 values(2,0)");
        con.commit();
        s1.executeUpdate("update t1 set c11=c11+1 where c12 > 0");
        Statement s2 = con2.createStatement();
        savepoint1 = con2.setSavepoint("MyName");
        try {
            s2.executeUpdate("update t1 set c11=c11+1 where c12 < 1");
            System.out.println("FAIL 14 should have gotten lock time out");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            con2.releaseSavepoint(savepoint1);
            System.out.println("FAIL 14 A non-user initiated transaction rollback should release the internal savepoint array");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        con2.rollback();
        s.execute("delete from t1");
        con.commit();
        System.out.println("Test 15 check savepoints in batch");
        s.execute("delete from t1");
        s.addBatch("insert into t1 values(1,1)");
        s.addBatch("insert into t1 values(1,1)");
        savepoint1 = con.setSavepoint();
        s.addBatch("insert into t1 values(1,1)");
        s.executeBatch();
        con.rollback(savepoint1);
        int val = savepointJdbc30_JSR169.count(con, s);
        if (val != 0) {
            System.out.println("FAIL 15 savepoint should have been set before batch");
        }
        con.rollback();
        System.out.println("Test 16 grammar check for savepoint sq1");
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS");
            System.out.println("FAIL 16 Should have gotten exception for missing ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            s.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN CURSORS");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN LOCKS");
            System.out.println("FAIL 16 Should have gotten exception for multiple ON ROLLBACK RETAIN LOCKS");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        try {
            s.executeUpdate("SAVEPOINT s1 UNIQUE UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 16 Should have gotten exception for multiple UNIQUE keywords");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN LOCKS");
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        con.rollback();
        System.out.println("Test 17 No nested savepoints allowed when using SQL to set savepoints.");
        System.out.println("Test 17a Test with UNIQUE clause.");
        s.executeUpdate("SAVEPOINT s1 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            s.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 17a Should have gotten exception for nested savepoints");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        s.executeUpdate("SAVEPOINT s2 UNIQUE ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
        System.out.println("Test 17b Test without UNIQUE clause.");
        System.out.println("Since no nesting is allowed, skipping UNIQUE still gives error for trying to define another savepoint");
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 17b Should have gotten exception for nested savepoints");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 18 No nested SQL savepoints allowed inside JDBC savepoint.");
        savepoint1 = con.setSavepoint();
        System.out.println("Following SQL savepoint will fail because we are trying to nest it inside JDBC savepoint");
        try {
            s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 18 shouldn't be able set SQL savepoint nested inside JDBC savepoints");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.releaseSavepoint(savepoint1);
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
        System.out.println("Test 19 No nested SQL savepoints allowed inside SQL savepoint.");
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        System.out.println("Following SQL savepoint will fail because we are trying to nest it inside SQL savepoint");
        try {
            s.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 19 shouldn't be able set SQL savepoint nested inside SQL savepoint");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        s.executeUpdate("SAVEPOINT s2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        con.rollback();
        System.out.println("Test 20 Rollback of SQL savepoint works same as rollback of JDBC savepoint.");
        s.executeUpdate("DELETE FROM T1");
        con.commit();
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        s.executeUpdate("ROLLBACK TO SAVEPOINT s1");
        ResultSet rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        if (rs1.getInt(1) != 0) {
            System.out.println("ERROR: There should have been 0 rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        con.rollback();
        System.out.println("Test 21 After releasing the SQL savepoint, rollback the transaction and should see everything undone.");
        s.executeUpdate("SAVEPOINT s1 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO T1 VALUES(1,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(2,1)");
        s.executeUpdate("INSERT INTO T1 VALUES(3,1)");
        s.executeUpdate("RELEASE TO SAVEPOINT s1");
        con.rollback();
        rs1 = s.executeQuery("select count(*) from t1");
        rs1.next();
        if (rs1.getInt(1) != 0) {
            System.out.println("ERROR: There should have been 0 rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        con.rollback();
        System.out.println("Test 22 Should not be able to create a SQL savepoint starting with name SYS");
        try {
            s.executeUpdate("SAVEPOINT SYSs2 ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
            System.out.println("FAIL 22 shouldn't be able to create a SQL savepoint starting with name SYS");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 23 Should be able to use non-reserved keywords savepoint and release as identifiers");
        System.out.println("Create table with savepoint and release as identifiers");
        s.execute("create table savepoint (savepoint int, release int)");
        rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        if (rs1.getInt(1) != 0) {
            System.out.println("ERROR: There should have been 0 rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        System.out.println("Create a savepoint with name savepoint");
        s.execute("SAVEPOINT savepoint ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO savepoint VALUES(1,1)");
        System.out.println("Release the savepoint with name savepoint");
        s.execute("RELEASE SAVEPOINT savepoint");
        rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        if (rs1.getInt(1) != 1) {
            System.out.println("ERROR: There should have been 1 rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        System.out.println("Create a savepoint with name release");
        s.execute("SAVEPOINT release ON ROLLBACK RETAIN LOCKS ON ROLLBACK RETAIN CURSORS");
        s.executeUpdate("INSERT INTO savepoint VALUES(2,1)");
        System.out.println("Rollback to the savepoint with name release");
        s.execute("ROLLBACK TO SAVEPOINT release");
        rs1 = s.executeQuery("select count(*) from savepoint");
        rs1.next();
        if (rs1.getInt(1) != 1) {
            System.out.println("ERROR: There should have been 1 rows in the table, but found " + rs1.getInt(1) + " rows");
            return;
        }
        System.out.println("Release the savepoint with name release");
        s.execute("RELEASE SAVEPOINT release");
        con.rollback();
        System.out.println("Test 24 Savepoint name can't exceed 128 characters");
        try {
            savepoint1 = con.setSavepoint("MyName1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
            System.out.println("FAIL 24 shouldn't be able to create a SQL savepoint with name exceeding 128 characters");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        System.out.println("Test 25 Should not be able to create a SQL savepoint starting with name SYS through jdbc");
        try {
            savepoint1 = con.setSavepoint("SYSs2");
            System.out.println("FAIL 25 shouldn't be able to create a SQL savepoint starting with name SYS through jdbc");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        con.rollback();
        s1.close();
        s2.close();
        System.out.println("Test 26a rollback of null savepoint");
        try {
            con.rollback(null);
            System.out.println("FAIL 26a rollback of null savepoint did not raise error ");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
        System.out.println("Test 26b release  of null savepoint");
        try {
            con.releaseSavepoint(null);
            System.out.println("FAIL 26b release of null savepoint did not raise error ");
        }
        catch (SQLException se) {
            System.out.println("Expected Exception is " + se.getMessage());
        }
    }

    static void setUpTest(Statement s) throws SQLException {
        try {
            s.execute("drop table t1");
            s.execute("drop table t2");
            s.execute("drop table savepoint");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.execute("create table t1 (c11 int, c12 smallint)");
        s.execute("create table t2 (c11 int)");
    }

    private static int count(Connection con, Statement s) throws SQLException {
        int count = 0;
        ResultSet rs = s.executeQuery("select count(*) from t1");
        rs.next();
        count = rs.getInt(1);
        rs.close();
        return count;
    }

    public static void doConnectionSetSavepointUnnamed() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Savepoint s1 = conn.setSavepoint();
        Statement s = conn.createStatement();
        s.executeUpdate("insert into t2 values(1)");
        conn.rollback(s1);
    }

    public static void doConnectionSetSavepointNamed() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Savepoint s1 = conn.setSavepoint("s1");
        Statement s = conn.createStatement();
        s.executeUpdate("insert into t2 values(1)");
        conn.rollback(s1);
    }

    public static void doConnectionRollbackSavepoint() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.rollback(null);
        Statement s = conn.createStatement();
        s.executeUpdate("insert into t2 values(1)");
    }

    public static void doConnectionReleaseSavepoint() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.releaseSavepoint(null);
        Statement s = conn.createStatement();
        s.executeUpdate("insert into t2 values(1)");
    }

    public static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception");
        while (se != null) {
            System.out.print("SQLSTATE(" + se.getSQLState() + "):");
            se.printStackTrace(System.out);
            se = se.getNextException();
        }
    }
}

