/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class metadataMultiConn {
    public static Connection getConnection(String[] args, boolean autoCommit) throws Exception {
        ij.getPropertyArg((String[])args);
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(autoCommit);
        return conn;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Test metadataMultiConn starting");
        Connection conn1 = metadataMultiConn.getConnection(args, false);
        metadataMultiConn.metadataCalls(conn1);
        Connection conn2 = metadataMultiConn.getConnection(args, false);
        metadataMultiConn.metadataCalls(conn2);
        Connection conn3 = metadataMultiConn.getConnection(args, false);
        metadataMultiConn.metadataCalls(conn3);
        conn1.commit();
        conn2.commit();
        metadataMultiConn.checkConsistencyOfAllTables(conn3);
        System.out.println("Test metadataMultiConn finishes.");
    }

    public static void metadataCalls(Connection conn) throws Exception {
        System.out.println("A new connection is doing metadata calls, but never commit...");
        DatabaseMetaData dmd = conn.getMetaData();
        metadataMultiConn.getTypeInfo(dmd, System.out);
        metadataMultiConn.getTables(dmd, System.out);
        metadataMultiConn.getColumnInfo(dmd, "%", System.out);
        metadataMultiConn.getPrimaryKeys(dmd, "%", System.out);
        metadataMultiConn.getExportedKeys(dmd, "%", System.out);
    }

    public static void getTypeInfo(DatabaseMetaData dmd, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getTypeInfo();
        out.println("Submitted getTypeInfo request");
        while (rs.next()) {
            String typeName = rs.getString(1);
            short dataType = rs.getShort(2);
            int precision = rs.getInt(3);
            String literalPrefix = rs.getString(4);
            String literalSuffix = rs.getString(5);
            String createParams = rs.getString(6);
            short nullable = rs.getShort(7);
            boolean caseSensitive = rs.getBoolean(8);
            short searchable = rs.getShort(9);
            boolean unsignedAttribute = rs.getBoolean(10);
            boolean fixedPrecScale = rs.getBoolean(11);
            boolean autoIncrement = rs.getBoolean(12);
            String localTypeName = rs.getString(13);
            short minimumScale = rs.getShort(14);
            short s = rs.getShort(15);
        }
        rs.close();
    }

    public static void getTables(DatabaseMetaData dmd, PrintStream out) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = dmd.getTables(null, null, null, types);
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String tableType = rs.getString(4);
            String string = rs.getString(5);
        }
        rs.close();
    }

    public static void getColumnInfo(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        out.println("Getting column info for " + tablePattern);
        ResultSet rs = dmd.getColumns(null, null, tablePattern, "%");
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String columnName = rs.getString(4);
            short dataType = rs.getShort(5);
            String typeName = rs.getString(6);
            int columnSize = rs.getInt(7);
            int decimalDigits = rs.getInt(9);
            int numPrecRadix = rs.getInt(10);
            int nullable = rs.getInt(11);
            String remarks = rs.getString(12);
            String columnDef = rs.getString(13);
            int n = rs.getInt(16);
        }
        rs.close();
    }

    public static void getPrimaryKeys(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getPrimaryKeys(null, null, tablePattern);
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String columnName = rs.getString(4);
            short keySeq = rs.getShort(5);
            String string = rs.getString(6);
        }
        rs.close();
    }

    public static void getExportedKeys(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getExportedKeys(null, null, tablePattern);
        while (rs.next()) {
            String pkTableCat = rs.getString(1);
            String pkTableSchem = rs.getString(2);
            String pkTableName = rs.getString(3);
            String pkColumnName = rs.getString(4);
            String fkTableCat = rs.getString(5);
            String fkTableSchem = rs.getString(6);
            String fkTableName = rs.getString(7);
            String fkColumnName = rs.getString(8);
            short keySeq = rs.getShort(9);
            short updateRule = rs.getShort(10);
            short deleteRule = rs.getShort(11);
            String fkName = rs.getString(12);
            String pkName = rs.getString(13);
            short s = rs.getShort(14);
        }
        rs.close();
    }

    public static void checkConsistencyOfAllTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT schemaname, tablename, SYSCS_UTIL.CHECK_TABLE(schemaname, tablename) FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid");
        boolean consistent = true;
        boolean allconsistent = true;
        while (rs.next()) {
            consistent = rs.getBoolean(3);
            if (consistent) continue;
            allconsistent = false;
            System.out.println(rs.getString(1) + "." + rs.getString(2) + " is not consistent.");
        }
        rs.close();
        if (allconsistent) {
            System.out.println("All tables are consistent.");
        }
        s.close();
    }
}

