/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.connectionJdbc20;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class maxfieldsize {
    static final int START_SECOND_HALF = 5;
    static final int NUM_EXECUTIONS = 10;
    static final String c1_value = "C1XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c2_value = "C2XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c3_value = "C3XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c4_value = "C4XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c5_value = "C5XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    static final String c6_value = "C6XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
    private static boolean isDerbyNet = false;

    public static void main(String[] args) {
        String[] testObjects = new String[]{"table tab1", "table tab2"};
        System.out.println("Test MaxFieldSize  starting");
        isDerbyNet = TestUtil.isNetFramework();
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            Statement stmt = conn.createStatement();
            stmt.execute("create table tab1(c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
            maxfieldsize.load_data(conn);
            for (int loop = 0; loop < 10; ++loop) {
                if (loop == 5) {
                    stmt.setMaxFieldSize(24);
                }
                System.out.println("Iteration #: " + loop);
                System.out.println("Max Field Size = " + stmt.getMaxFieldSize());
                ResultSet rs = stmt.executeQuery("select * from tab1");
                while (rs.next()) {
                    block14: for (int i = 1; i < 7; ++i) {
                        System.out.println("Column #: " + i);
                        switch (loop % 5) {
                            case 0: {
                                connectionJdbc20.get_using_object(rs, i);
                                continue block14;
                            }
                            case 1: {
                                if (isDerbyNet) {
                                    System.out.println("beetle 5350 - JCC returns incorrect result for maxfieldsize()");
                                }
                                connectionJdbc20.get_using_string(rs, i);
                                continue block14;
                            }
                            case 2: {
                                connectionJdbc20.get_using_ascii_stream(rs, i);
                                continue block14;
                            }
                            case 3: {
                                if (i < 4) {
                                    connectionJdbc20.get_using_binary_stream(rs, i);
                                    continue block14;
                                }
                                System.out.println("SKIPPING");
                                continue block14;
                            }
                            case 4: {
                                if (i < 4) {
                                    connectionJdbc20.get_using_bytes(rs, i);
                                    continue block14;
                                }
                                System.out.println("SKIPPING");
                            }
                        }
                    }
                }
                rs.close();
            }
            try {
                stmt.setMaxFieldSize(-200);
            }
            catch (SQLException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("Invalid maxFieldSize value") >= 0 || e.getSQLState() != null && e.getSQLState().equals("XJ066")) {
                    System.out.println("Expected Exception - Invalid maxFieldsize");
                }
                System.out.println("Unexpected FAILURE at " + e);
            }
            stmt.setMaxFieldSize(0);
            System.out.println("Doing external sort");
            maxfieldsize.testSort(conn, stmt);
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            maxfieldsize.dumpSQLExceptions(e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception: " + e);
            e.printStackTrace();
        }
        System.out.println("Test maxfieldsize  finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load_data(Connection conn) throws Exception {
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement("insert into tab1 values(?,?,?,?,?,?)");
            pstmt.setBytes(1, c1_value.getBytes("US-ASCII"));
            pstmt.setBytes(2, c2_value.getBytes("US-ASCII"));
            pstmt.setBytes(3, c3_value.getBytes("US-ASCII"));
            pstmt.setString(4, c4_value);
            pstmt.setString(5, c5_value);
            pstmt.setString(6, c6_value);
            pstmt.execute();
        }
    }

    private static void testSort(Connection conn, Statement stmt) throws SQLException, UnsupportedEncodingException {
        stmt.execute("create table tab2(c0 int, c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
        PreparedStatement insertPStmt = conn.prepareStatement("insert into tab2 values (?, ?, ?, ?, ?, ?, ?)");
        for (int index = 0; index < 5000; ++index) {
            insertPStmt.setInt(1, index);
            insertPStmt.setBytes(2, c1_value.getBytes("US-ASCII"));
            insertPStmt.setBytes(3, c2_value.getBytes("US-ASCII"));
            insertPStmt.setBytes(4, c3_value.getBytes("US-ASCII"));
            insertPStmt.setString(5, c4_value);
            insertPStmt.setString(6, c5_value);
            insertPStmt.setString(7, c6_value);
            insertPStmt.executeUpdate();
        }
        insertPStmt.close();
        maxfieldsize.doSort(stmt);
        stmt.setMaxFieldSize(24);
        maxfieldsize.doSort(stmt);
    }

    private static void doSort(Statement stmt) throws SQLException {
        System.out.println("Max Field Size = " + stmt.getMaxFieldSize());
        try {
            ResultSet rs = stmt.executeQuery("select * from tab2 order by c0 desc");
            for (int index = 0; index < 5000; ++index) {
                rs.next();
                if (index >= 5 && index < 4995) continue;
                System.out.println("Iteration #: " + index);
                System.out.println("Column #1: " + rs.getInt(1));
                System.out.println("Column #2:");
                connectionJdbc20.get_using_binary_stream(rs, 2);
                System.out.println("Column #3:");
                connectionJdbc20.get_using_binary_stream(rs, 3);
                System.out.println("Column #4:");
                connectionJdbc20.get_using_binary_stream(rs, 4);
                System.out.println("Column #5:");
                connectionJdbc20.get_using_ascii_stream(rs, 5);
                System.out.println("Column #6:");
                connectionJdbc20.get_using_ascii_stream(rs, 6);
                System.out.println("Column #7:");
                connectionJdbc20.get_using_ascii_stream(rs, 7);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception: " + e);
            e.printStackTrace();
        }
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception");
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se);
            se = se.getNextException();
        }
    }

    private static void dumpExpectedSQLExceptions(SQLException se) {
        System.out.println("PASS -- expected exception");
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se);
            se = se.getNextException();
        }
    }

    private static void cleanUp(Connection conn) throws SQLException {
    }
}

