/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.tools.ij;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class derbyStress {
    private static int numConn = 1;
    private static int numRows = 100;
    private static int numPreparedStmts = 2000;

    public static void main(String[] args) {
        try {
            System.out.println("Test derbyStress starting");
            ij.getPropertyArg((String[])args);
            Connection conn = null;
            for (int i = 0; i < numConn; ++i) {
                conn = ij.startJBMS();
                System.out.println("Testing with " + numPreparedStmts + " prepared statements");
                derbyStress.prepStmtTest(conn, numRows, numPreparedStmts);
                System.out.println("PASS -- Prepared statement test");
                conn.close();
            }
            derbyStress.reExecuteStatementTest();
            derbyStress.testDerby3316();
            System.out.println("Test derbyStress finished.");
        }
        catch (SQLException se) {
            TestUtil.dumpSQLExceptions(se);
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception caught in main():\n");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void createTables(Connection conn, int numRows) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (lvc  LONG VARCHAR)");
        stmt.close();
        String insertTabSql = "insert into t1 values(?)";
        PreparedStatement ps = conn.prepareStatement(insertTabSql);
        for (int i = 0; i < numRows; ++i) {
            ps.setString(1, "Hello" + i);
            ps.executeUpdate();
        }
        ps.close();
    }

    private static void prepStmtTest(Connection conn, int numRows, int numPreparedStmts) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn.setAutoCommit(false);
        try {
            derbyStress.createTables(conn, numRows);
            String selTabSql = "select * from t1";
            for (int i = 0; i < numPreparedStmts; ++i) {
                ps = conn.prepareStatement(selTabSql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    rs.getString(1);
                }
                rs.close();
            }
            conn.commit();
        }
        catch (SQLException e) {
            TestUtil.dumpSQLExceptions(e);
            conn.rollback();
        }
    }

    private static void reExecuteStatementTest() throws Exception {
        System.out.print("DERBY-557: reExecuteStatementTest() ");
        Connection conn = ij.startJBMS();
        Statement stmt = conn.createStatement();
        for (int i = 0; i < 50000; ++i) {
            ResultSet resultSet = stmt.executeQuery("values(1)");
        }
        conn.commit();
        stmt.close();
        conn.close();
        System.out.println("PASSED");
    }

    public static void testDerby3316() throws Exception {
        System.out.println("DERBY-3316: Multiple statement executions ");
        Connection conn = ij.startJBMS();
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE TAB (col1 varchar(32672))");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TAB VALUES(?)");
        ps.setString(1, "hello");
        ps.executeUpdate();
        ps.setString(1, "hello");
        ps.executeUpdate();
        ps.close();
        for (int i = 0; i < 2000; ++i) {
            s = conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT * from tab");
            while (rs.next()) {
            }
        }
        conn.close();
        conn = ij.startJBMS();
        s = conn.createStatement();
        s.executeUpdate("DROP TABLE TAB");
        s.close();
        conn.close();
    }
}

