/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import com.pivotal.gemfirexd.internal.client.ClientXid;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XATransactionTest
extends BaseJDBCTestCase {
    public void testGlobalXIDinTransactionTable() throws Exception {
        Statement stm = this.getConnection().createStatement();
        stm.execute("create table XATT2 (i int, text char(10))");
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection xaConn = xaDataSource.getXAConnection();
        XAResource xaRes = xaConn.getXAResource();
        Connection conn = xaConn.getConnection();
        byte[] gid = new byte[64];
        byte[] bid = new byte[64];
        for (int i = 0; i < 64; ++i) {
            gid[i] = (byte)i;
            bid[i] = (byte)(64 - i);
        }
        ClientXid xid = new ClientXid(4660, gid, bid);
        xaConn = xaDataSource.getXAConnection();
        xaRes = xaConn.getXAResource();
        conn = xaConn.getConnection();
        xaRes.start((Xid)xid, 0);
        stm = conn.createStatement();
        stm.execute("insert into XATT2 values (1234, 'Test_Entry')");
        stm.close();
        xaRes.end((Xid)xid, 0x4000000);
        ResultSet rs = null;
        stm = null;
        try {
            stm = this.getConnection().createStatement();
            String query = "select global_xid from syscs_diag.transaction_table where global_xid is not null";
            rs = stm.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Xid rXid = XATransactionTest.parseXid(rs.getString(1));
            Assert.assertEquals((Object)xid, (Object)rXid);
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                xaRes.rollback((Xid)xid);
                xaConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        rs.close();
        stm.close();
        xaRes.rollback((Xid)xid);
        xaConn.close();
    }

    public void testXATransactionTimeout() throws Exception {
        Xid xid;
        int timeoutStatementsToExecute = 1000;
        int timeoutCommitEveryStatement = 3;
        int timeoutStatementsCommitted = (timeoutStatementsToExecute + timeoutCommitEveryStatement - 1) / timeoutCommitEveryStatement;
        Statement stm = this.getConnection().createStatement();
        stm.execute("create table XATT (i int, text char(10))");
        XADataSource xaDataSource = J2EEDataSource.getXADataSource();
        XAConnection xaConn = null;
        XAResource xaRes = null;
        Connection conn = null;
        for (int i = 0; i < timeoutStatementsToExecute; ++i) {
            xaConn = xaDataSource.getXAConnection();
            xaRes = xaConn.getXAResource();
            conn = xaConn.getConnection();
            xid = XATransactionTest.createXid(123, i);
            xaRes.setTransactionTimeout(5);
            xaRes.start(xid, 0);
            stm = conn.createStatement();
            stm.execute("insert into XATT values (" + i + ", 'Test_Entry')");
            if (i % timeoutCommitEveryStatement == 0) {
                stm.close();
                xaRes.end(xid, 0x4000000);
                xaRes.prepare(xid);
                xaRes.commit(xid, false);
                xaConn.close();
                continue;
            }
            if (i % 11 != 0) {
                block7: {
                    try {
                        xaRes.end(xid, 0x20000000);
                        Assert.fail();
                    }
                    catch (XAException ex) {
                        if (ex.errorCode >= 100 && ex.errorCode <= 107) break block7;
                        throw ex;
                    }
                }
                stm.close();
                xaConn.close();
                continue;
            }
            if (i % 2 != 0) continue;
            xaRes.end(xid, 0x4000000);
            stm.close();
            xaConn.close();
        }
        stm = this.getConnection().createStatement();
        ResultSet rs = stm.executeQuery("select count(*) from XATT");
        rs.next();
        Assert.assertTrue((rs.getInt(1) == timeoutStatementsCommitted ? 1 : 0) != 0);
        xaConn = xaDataSource.getXAConnection();
        xaRes = xaConn.getXAResource();
        conn = xaConn.getConnection();
        xid = XATransactionTest.createXid(124, 100);
        xaRes.setTransactionTimeout(10);
        xaRes.start(xid, 0);
        stm = conn.createStatement();
        boolean exceptionThrown = false;
        try {
            rs = stm.executeQuery("select * from XATT a, XATT b, XATT c, XATT d, XATT e order by a.i");
        }
        catch (SQLException ex) {
            XATransactionTest.assertSQLState("XCL52.S".substring(0, 5), ex);
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        stm = this.getConnection().createStatement();
        rs = stm.executeQuery("select count(*) from XATT");
        rs.next();
        Assert.assertTrue((rs.getInt(1) == timeoutStatementsCommitted ? 1 : 0) != 0);
    }

    static Xid createXid(int gtrid, int bqual) throws XAException {
        byte[] gid = new byte[]{(byte)(gtrid % 256), (byte)(gtrid / 256)};
        byte[] bid = new byte[]{(byte)(bqual % 256), (byte)(bqual / 256)};
        ClientXid xid = new ClientXid(4660, gid, bid);
        return xid;
    }

    private static Xid parseXid(String str) {
        int i;
        Assert.assertNotNull((Object)str);
        Assert.assertTrue((boolean)str.matches("\\(\\p{Digit}+,\\p{XDigit}+,\\p{XDigit}+\\)"));
        String formatIdS = str.substring(1, str.indexOf(44));
        String gtidS = str.substring(str.indexOf(44) + 1, str.lastIndexOf(44));
        String bqualS = str.substring(str.lastIndexOf(44) + 1, str.length() - 1);
        Assert.assertTrue((gtidS.length() % 2 == 0 ? 1 : 0) != 0);
        Assert.assertTrue((bqualS.length() % 2 == 0 ? 1 : 0) != 0);
        int fmtid = Integer.parseInt(formatIdS);
        byte[] gtid = new byte[gtidS.length() / 2];
        byte[] bqual = new byte[bqualS.length() / 2];
        for (i = 0; i < gtid.length; ++i) {
            gtid[i] = (byte)Integer.parseInt(gtidS.substring(2 * i, 2 * i + 2), 16);
        }
        for (i = 0; i < bqual.length; ++i) {
            bqual[i] = (byte)Integer.parseInt(bqualS.substring(2 * i, 2 * i + 2), 16);
        }
        return new ClientXid(fmtid, gtid, bqual);
    }

    public XATransactionTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            return TestConfiguration.defaultSuite(XATransactionTest.class);
        }
        return new TestSuite("XATransactionTest cannot run without XA support");
    }
}

