/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SetTransactionIsolationTest
extends BaseJDBCTestCase {
    public static int[] isoLevels = new int[]{1, 4, 2, 8};

    public SetTransactionIsolationTest(String name) {
        super(name);
    }

    public void testIsolation() throws SQLException {
        Connection conn = this.getConnection();
        Connection conn2 = this.openDefaultConnection();
        conn.setAutoCommit(false);
        for (int i = 0; i < isoLevels.length; ++i) {
            this.checkIsolationLevelNoTimeout(conn, isoLevels[i]);
        }
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("insert into t1 values(4,'Fourth Hello')");
        for (int i = 0; i < isoLevels.length; ++i) {
            this.checkIsolationLevelTimeout(conn2, isoLevels[i]);
        }
        stmt.close();
        conn.rollback();
    }

    private void checkIsolationLevelTimeout(Connection conn, int isoLevel) throws SQLException {
        block5: {
            RuntimeStatisticsParser rsp;
            block4: {
                rsp = null;
                conn.setTransactionIsolation(isoLevel);
                try {
                    rsp = SQLUtilities.executeAndGetRuntimeStatistics(conn, "select * from t1");
                    SetTransactionIsolationTest.assertEquals((int)1, (int)rsp.getIsolationLevel());
                }
                catch (SQLException se) {
                    if (isoLevel == 1) break block4;
                    SetTransactionIsolationTest.assertSQLState("expected lock timeout", "40XL1", se);
                }
            }
            try {
                rsp = SQLUtilities.executeAndGetRuntimeStatistics(conn, "insert into t1copy (select * from t1)");
                SetTransactionIsolationTest.assertEquals((int)1, (int)rsp.getIsolationLevel());
            }
            catch (SQLException se) {
                if (isoLevel == 1) break block5;
                SetTransactionIsolationTest.assertSQLState("expected lock timeout", "40XL1", se);
            }
        }
    }

    private void checkIsolationLevelNoTimeout(Connection conn, int isoLevel) throws SQLException {
        conn.setTransactionIsolation(isoLevel);
        RuntimeStatisticsParser rsp = SQLUtilities.executeAndGetRuntimeStatistics(conn, "select * from t1");
        SetTransactionIsolationTest.assertEquals((int)isoLevel, (int)rsp.getIsolationLevel());
        rsp = SQLUtilities.executeAndGetRuntimeStatistics(conn, "insert into t1copy (select * from t1)");
        SetTransactionIsolationTest.assertEquals((int)isoLevel, (int)rsp.getIsolationLevel());
    }

    public void testSetTransactionIsolationCommitRollback() throws SQLException {
        Connection conn = this.getConnection();
        conn.rollback();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(8);
        Statement s = conn.createStatement();
        s.executeUpdate("delete from t3");
        s.executeUpdate("insert into t3 values(1)");
        conn.commit();
        s.executeUpdate("insert into t3 values(2)");
        conn.setTransactionIsolation(8);
        conn.rollback();
        ResultSet rs = s.executeQuery("select count(*) from t3");
        rs.next();
        int count = rs.getInt(1);
        SetTransactionIsolationTest.assertEquals((int)1, (int)count);
        rs.close();
        s.close();
    }

    public void testSetTransactionIsolationInHoldCursor() throws SQLException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT * from TAB1");
            ResultSet rs = ps.executeQuery();
            rs.next();
            conn.setTransactionIsolation(8);
            rs.next();
        }
        catch (SQLException se) {
            SetTransactionIsolationTest.assertSQLState("Expected Exception if held cursor is open", "X0X03", se);
            return;
        }
        SetTransactionIsolationTest.fail((String)"FAIL: setTransactionIsolation() did not throw exception with open hold cursor");
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(SetTransactionIsolationTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                Connection conn = this.getConnection();
                int stringLength = 400;
                s.executeUpdate("CREATE TABLE TAB1 (c11 int, c12 varchar(400))");
                PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO TAB1 VALUES(?,?)");
                int rows = 100;
                StringBuilder buff = new StringBuilder(400);
                for (i = 0; i < 400; ++i) {
                    buff.append(" ");
                }
                for (i = 1; i <= 100; ++i) {
                    insertStmt.setInt(1, i);
                    insertStmt.setString(2, buff.toString());
                    insertStmt.executeUpdate();
                }
                insertStmt.close();
                s.execute("create table t1(I int, B char(15))");
                s.execute("create table t1copy(I int, B char(15))");
                s.executeUpdate("INSERT INTO T1 VALUES(1,'First Hello')");
                s.executeUpdate("INSERT INTO T1 VALUES(2,'Second Hello')");
                s.executeUpdate("INSERT INTO T1 VALUES(3,'Third Hello')");
                s.executeUpdate("create table t3 (i integer)");
                CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY (?, ?)");
                cs.setString(1, "gemfirexd.locks.waitTimeout");
                cs.setString(2, "3");
                cs.execute();
                cs.setString(1, "gemfirexd.locks.deadlockTimeout");
                cs.setString(2, "3");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SetTransactionIsolation");
        suite.addTest(SetTransactionIsolationTest.baseSuite("SetTransactionIsolation:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(SetTransactionIsolationTest.baseSuite("SetTransactionIsolation:client")));
        return suite;
    }
}

