/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;

public class SURDataModelSetup
extends BaseJDBCTestSetup {
    private final SURDataModel model;
    static final int recordCount = 10;

    public SURDataModelSetup(Test test, SURDataModel model) {
        super(test);
        this.model = model;
    }

    public static void createDataModel(SURDataModel model, Connection con, int records) throws SQLException {
        BaseJDBCTestCase.dropTable(con, "T1");
        Statement statement = con.createStatement();
        statement.execute(model.getCreateTableStatement());
        BaseTestCase.println(model.getCreateTableStatement());
        if (model.hasSecondaryKey()) {
            statement.execute("create index a_on_t on t1(a)");
            BaseTestCase.println("create index a_on_t on t1(a)");
        }
        PreparedStatement ps = con.prepareStatement("insert into t1 values (?,?,?,?)");
        for (int i = 0; i < records; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i * 2 + 17);
            ps.setString(4, "Tuple " + i);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        statement.close();
        con.commit();
    }

    public static void createDataModel(SURDataModel model, Connection con) throws SQLException {
        SURDataModelSetup.createDataModel(model, con, 10);
    }

    protected void setUp() throws Exception {
        this.println("Setting up datamodel: " + this.model);
        try {
            Connection con = this.getConnection();
            con.setAutoCommit(false);
            SURDataModelSetup.createDataModel(this.model, con);
        }
        catch (SQLException e) {
            SURDataModelSetup.printStackTrace(e);
            throw e;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.preTearDown();
        try {
            Connection con = this.getConnection();
            con.rollback();
            con.createStatement().execute("drop table t1");
            con.commit();
        }
        catch (SQLException e) {
            SURDataModelSetup.printStackTrace(e);
        }
        super.tearDown();
    }

    public String toString() {
        return "SURDataModel tests with model: " + this.model;
    }

    static void printStackTrace(Throwable t) {
        BaseJDBCTestCase.printStackTrace(t);
    }

    public static final class SURDataModel {
        public static final SURDataModel MODEL_WITH_NO_KEYS = new SURDataModel("NO_KEYS");
        public static final SURDataModel MODEL_WITH_PK = new SURDataModel("PK");
        public static final SURDataModel MODEL_WITH_SECONDARY_KEY = new SURDataModel("SECONDARY_KEY");
        public static final SURDataModel MODEL_WITH_PK_AND_SECONDARY_KEY = new SURDataModel("PK_AND_SECONDARY_KEY");
        private static final Set values = Collections.unmodifiableSet(new HashSet<SURDataModel>(Arrays.asList(MODEL_WITH_NO_KEYS, MODEL_WITH_PK, MODEL_WITH_SECONDARY_KEY, MODEL_WITH_PK_AND_SECONDARY_KEY)));
        private final String name;

        public static final Set values() {
            return values;
        }

        public boolean hasPrimaryKey() {
            return this == MODEL_WITH_PK || this == MODEL_WITH_PK_AND_SECONDARY_KEY;
        }

        public boolean hasSecondaryKey() {
            return this == MODEL_WITH_SECONDARY_KEY || this == MODEL_WITH_PK_AND_SECONDARY_KEY;
        }

        public String getCreateTableStatement() {
            return this.hasPrimaryKey() ? "create table t1 (id int primary key, a int, b int, c varchar(5000))" : "create table t1 (id int, a int, b int, c varchar(5000))";
        }

        public String toString() {
            return this.name;
        }

        private SURDataModel(String name) {
            this.name = name;
        }
    }
}

