/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetJDBC30Test
extends BaseJDBCTestCase {
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String UPDATABLE_RESULTSET_API_DISALLOWED = "XJ083";

    public ResultSetJDBC30Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2))");
        stmt.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.07'),'eight','nine', 11.1)");
        stmt.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("DROP TABLE t");
        this.commit();
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ResultSetJDBC30Test.class);
    }

    public void testNotImplementedMethods() throws Exception {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from t");
        ResultSetJDBC30Test.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        try {
            rs.getURL(8);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        try {
            rs.getURL("c");
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        try {
            rs.updateRef(8, null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        catch (NoSuchMethodError nsme) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateRef not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            rs.updateRef("c", null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        catch (NoSuchMethodError nsme) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateRef not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            rs.updateBlob(8, (Blob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, se);
        }
        try {
            rs.updateBlob("c", (Blob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, se);
        }
        try {
            rs.updateClob(8, (Clob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, se);
        }
        try {
            rs.updateClob("c", (Clob)null);
            if (ResultSetJDBC30Test.usingEmbedded()) {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method is being invoked on a read only resultset.");
            } else {
                ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
            }
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(UPDATABLE_RESULTSET_API_DISALLOWED, se);
        }
        try {
            rs.updateArray(8, null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        catch (NoSuchMethodError nsme) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateArray not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        try {
            rs.updateArray("c", null);
            ResultSetJDBC30Test.fail((String)"FAIL - Shouldn't reach here. Method not implemented yet.");
        }
        catch (SQLException se) {
            ResultSetJDBC30Test.assertSQLState(NOT_IMPLEMENTED, se);
        }
        catch (NoSuchMethodError nsme) {
            ResultSetJDBC30Test.assertTrue((String)"FAIL - ResultSet.updateArray not present - correct for JSR169", (boolean)JDBC.vmSupportsJSR169());
        }
        rs.close();
        stmt.close();
        this.commit();
    }

    public void DISABLED_testCloseResultSetAutoCommit() throws Exception {
        this.getConnection().setAutoCommit(true);
        this.getConnection().setHoldability(1);
        Statement stmt = this.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("select * from t");
        rs.next();
        this.checkForCloseOnException(rs, true);
        rs.close();
        stmt.close();
        this.getConnection().setHoldability(2);
        stmt = this.createStatement(1004, 1007);
        rs = stmt.executeQuery("select * from t");
        rs.next();
        this.checkForCloseOnException(rs, false);
        rs.close();
        stmt.close();
        this.commit();
    }

    private void checkForCloseOnException(ResultSet rs, boolean holdable) throws Exception {
        try {
            rs.updateBlob("c", (Blob)null);
            ResultSetJDBC30Test.fail((String)"FAIL - rs.updateBlob() on a read-only result setshould not have succeeded");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs.beforeFirst();
    }
}

