/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetCloseTest
extends BaseJDBCTestCase {
    public void setUp() throws SQLException {
        Connection con = this.getConnection();
        con.setAutoCommit(false);
        Statement s = con.createStatement();
        s.execute("create table t1 (a int)");
        s.execute("insert into t1 values(1)");
        s.execute("insert into t1 values(0)");
        s.execute("insert into t1 values(2)");
        s.execute("insert into t1 values(3)");
        s.close();
        con.commit();
    }

    public void testResultSetDoesNotClose() throws SQLException {
        PreparedStatement ps1 = this.prepareStatement("select * from t1");
        PreparedStatement ps2 = this.prepareStatement("select 10/a from t1");
        ResultSet rs1 = ps1.executeQuery();
        try {
            ResultSet rs2 = ps2.executeQuery();
            while (rs2.next()) {
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        while (rs1.next()) {
        }
        this.commit();
        rs1.close();
        ps1.close();
        ps2.close();
    }

    public ResultSetCloseTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (ResultSetCloseTest.usingDB2Client()) {
            return new TestSuite("empty");
        }
        return TestConfiguration.defaultSuite(ResultSetCloseTest.class);
    }
}

