/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class LargeDataLocksTest
extends BaseJDBCTestCase {
    public LargeDataLocksTest(String name) {
        super(name);
    }

    public void testGetCharacterStream() throws SQLException, IOException {
        int numChars = 0;
        Statement stmt = this.createStatement();
        String sql = "SELECT bc from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        Reader characterStream = rs.getCharacterStream(1);
        int read = characterStream.read();
        while (read != -1) {
            read = characterStream.read();
            ++numChars;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)numChars);
        rs.close();
        LargeDataLocksTest.assertEquals((int)0, (int)this.countLocks());
        this.commit();
    }

    public void testGetBytes() throws SQLException {
        Statement stmt = this.createStatement();
        String sql = "SELECT bincol from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        byte[] value = rs.getBytes(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)value.length);
        rs.close();
        LargeDataLocksTest.assertEquals((int)0, (int)this.countLocks());
        this.commit();
    }

    public void testGetBinaryStream() throws SQLException, IOException {
        int numBytes = 0;
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        String sql = "SELECT bincol from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        InputStream stream = rs.getBinaryStream(1);
        int read = stream.read();
        while (read != -1) {
            read = stream.read();
            ++numBytes;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)numBytes);
        rs.close();
        LargeDataLocksTest.assertEquals((int)0, (int)this.countLocks());
        this.commit();
    }

    public void testGetString() throws SQLException, IOException {
        Statement stmt = this.createStatement();
        String sql = "SELECT bc from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        String value = rs.getString(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)value.length());
        rs.close();
        LargeDataLocksTest.assertEquals((int)0, (int)this.countLocks());
        this.commit();
    }

    public int countLocks() throws SQLException {
        Connection conn = this.openDefaultConnection();
        Statement stmt = conn.createStatement();
        String sql = "Select count(*) from new com.pivotal.gemfirexd.internal.diag.LockTable() as LT";
        ResultSet lockrs = stmt.executeQuery(sql);
        lockrs.next();
        int count = lockrs.getInt(1);
        lockrs.close();
        stmt.close();
        conn.close();
        return count;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(LargeDataLocksTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = this.getConnection();
                conn.setAutoCommit(false);
                PreparedStatement ps = null;
                String sql = "CREATE TABLE t1 (bc CLOB(1M), bincol BLOB(1M), datalen int)";
                s.executeUpdate(sql);
                sql = "INSERT into t1 values(?,?,?)";
                ps = conn.prepareStatement(sql);
                ps.setCharacterStream(1, (Reader)new StringReader(Utilities.repeatChar("a", 38000)), 38000);
                ps.setBytes(2, Utilities.repeatChar("a", 38000).getBytes());
                ps.setInt(3, 38000);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("LargeDataLocksTest");
        suite.addTest(LargeDataLocksTest.baseSuite("LargeDataLocksTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(LargeDataLocksTest.baseSuite("LargeDataLocksTest:client")));
        return suite;
    }
}

