/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverTest
extends BaseJDBCTestCase {
    private static String DB_NAME_WITH_SPACES = "db name with spaces";
    static final String[] ADDITIONAL_DBS = new String[]{DB_NAME_WITH_SPACES, "testcreatedb1", "testcreatedb2", "testcreatedb3", "'wombat'"};

    public DriverTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("DriverTest tests java.sql.Driver, not supported with JSR169");
        }
        TestSuite suite = new TestSuite("DriverTest");
        suite.addTest(DriverTest.baseSuite("DriverTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(DriverTest.baseSuite("DriverTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite("DriverTest");
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testDriverCompliantVersion"));
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testAcceptsURL"));
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testEmbeddedAttributes"));
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testClientAttributes"));
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testClientURL"));
        DriverTest.setBaseProps(suite, (Test)new DriverTest("testDbNameWithSpaces"));
        return suite;
    }

    private static void setBaseProps(TestSuite suite, Test test) {
        Properties dbprops = new Properties();
        dbprops.setProperty("gemfirexd.infolog.append", "true");
        dbprops.setProperty("gemfirexd.debug.true", "AuthenticationTrace");
        dbprops.setProperty("gemfirexd.user.APP", "xxxx");
        dbprops.setProperty("gemfirexd.user.testuser", "testpass");
        test = new DatabasePropertyTestSetup((Test)test, dbprops, true);
        suite.addTest(test);
    }

    @Override
    public void tearDown() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < 2; ++i) {
                    String traceFileName = "trace" + (i + 1) + ".out";
                    File traceFile = new File(traceFileName);
                    if (!traceFile.exists()) continue;
                    traceFile.delete();
                }
                this.removeDatabases();
                return null;
            }

            void removeDatabases() {
                for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
                    String dbName = ADDITIONAL_DBS[i];
                    dbName = dbName.replace('/', File.separatorChar);
                    String dsh = DriverTest.getSystemProperty("gemfirexd.system.home");
                    if (dsh == null) {
                        TestCase.fail((String)"not implemented");
                    } else {
                        dbName = dsh + File.separator + dbName;
                    }
                    this.removeDirectory(dbName);
                }
            }

            void removeDirectory(String path) {
                File dir = new File(path);
                this.removeDir(dir);
            }

            private void removeDir(File dir) {
                if (!dir.exists()) {
                    return;
                }
                String[] list = dir.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(dir, list[i]);
                        if (entry.isDirectory()) {
                            this.removeDir(entry);
                            continue;
                        }
                        entry.delete();
                    }
                }
                dir.delete();
            }
        });
        super.tearDown();
    }

    public void testDriverCompliantVersion() throws Exception {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        DriverTest.loadDriver();
        String defaultdburl = url + ";create=true";
        Driver driver = DriverManager.getDriver(defaultdburl);
        Properties props = new Properties();
        props.put("user", "testuser");
        props.put("password", "testpass");
        Connection conn = DriverManager.getConnection(defaultdburl, props);
        DriverTest.assertTrue((boolean)driver.jdbcCompliant());
        DatabaseMetaData dbmd = conn.getMetaData();
        DriverTest.assertEquals((int)dbmd.getDriverMajorVersion(), (int)driver.getMajorVersion());
        DriverTest.assertEquals((int)dbmd.getDriverMinorVersion(), (int)driver.getMinorVersion());
        conn.close();
    }

    public void testAcceptsURL() throws SQLException, Exception {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String orgurl = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        DriverTest.loadDriver();
        String defaultdburl = orgurl + ";create=true";
        Driver driver = DriverManager.getDriver(defaultdburl);
        int EMBEDDED_OFFSET = 0;
        int DERBYNETCLIENT_OFFSET = 1;
        int frameworkOffset = DriverTest.usingDerbyNetClient() ? DERBYNETCLIENT_OFFSET : EMBEDDED_OFFSET;
        String EMBEDDED_URL = "jdbc:gemfirexd:";
        String INVALID_URL = "jdbc:db2j:";
        String hostName = TestConfiguration.getCurrent().getHostName();
        int port = TestConfiguration.getCurrent().getPort();
        String CLIENT_URL = "jdbc:derby://" + hostName + ":" + port + "/" + dbName + ";create=true";
        String[] urls = new String[]{EMBEDDED_URL, CLIENT_URL, INVALID_URL};
        boolean[][] acceptsURLTable = new boolean[][]{{true, false}, {false, true}, {false, false}};
        for (int u = 0; u < urls.length; ++u) {
            String url = urls[u];
            boolean expectedAcceptance = acceptsURLTable[u][frameworkOffset];
            boolean actualAcceptance = driver.acceptsURL(url);
            DriverTest.assertEquals((boolean)expectedAcceptance, (boolean)actualAcceptance);
        }
    }

    public void testEmbeddedAttributes() throws SQLException {
        if (DriverTest.usingDB2Client()) {
            return;
        }
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String protocol = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            protocol = protocol + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        Properties info = new Properties();
        info.setProperty("create", "true");
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(true, protocol + "testcreatedb1", info);
        } else {
            DriverTest.assertConnect(false, protocol + "testcreatedb1", info);
        }
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(false, protocol + "testcreatedb2;create=true", null);
        } else {
            DriverTest.assertConnect(true, protocol + "testcreatedb2;create=true", null);
        }
        info.clear();
        info.setProperty("user", "APP");
        info.setProperty("password", "xxxx");
        if (DriverTest.usingEmbedded()) {
            DriverTest.assertConnect(true, url, info);
        } else {
            DriverTest.assertConnect(false, url, info);
        }
        DriverTest.assertConnect(false, url + ";user=testuser;password=testpass", null);
        info.clear();
        info.setProperty("password", "testpass");
        DriverTest.assertConnect(false, url + ";user=testusr", info);
        info.clear();
        info.setProperty("user", "APP");
        info.setProperty("password", "xxxx");
        DriverTest.assertConnect(false, url + ";user=testuser;password=testpass", null);
        info.clear();
        info.setProperty("shutdown", "true");
        try {
            DriverTest.assertConnect(false, protocol + "testcreatedb1", info);
        }
        catch (SQLException se) {
            DriverTest.assertSQLState("08006", se);
        }
        try {
            DriverTest.assertConnect(false, protocol + "testcreatedb2;shutdown=true", null);
        }
        catch (SQLException se) {
            DriverTest.assertSQLState("08006", se);
        }
    }

    public void testClientAttributes() throws SQLException {
        if (!DriverTest.usingDerbyNetClient()) {
            return;
        }
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        Properties info = new Properties();
        String traceFile = "trace1.out";
        DriverTest.assertConnect(true, url + ";traceFile=" + traceFile, info);
        traceFile = "trace2.out";
        info.setProperty("traceFile", traceFile);
        DriverTest.assertConnect(false, url, info);
        DriverTest.assertTraceFilesExist();
        DriverTest.shutdownDB(url + ";shutdown=true", null);
        info.setProperty("create", "true");
        Properties infoWithDefaults = new Properties(info);
        url = TestConfiguration.getCurrent().getJDBCUrl("testcreatedb3");
        DriverTest.assertConnect(false, url, infoWithDefaults);
        DriverTest.shutdownDB(url + ";shutdown=true", null);
    }

    private static void assertTraceFilesExist() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < 2; ++i) {
                    String traceFileName = "trace" + (i + 1) + ".out";
                    File traceFile = new File(traceFileName);
                    TestCase.assertTrue((boolean)traceFile.exists());
                }
                return null;
            }
        });
    }

    public void testClientURL() throws SQLException {
        if (!DriverTest.usingDerbyNetClient()) {
            return;
        }
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String protocol = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            protocol = protocol + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        Properties info = null;
        String CLIENT_CREATE_URL_WITH_COLON1 = protocol + dbName + ":create=true";
        String CLIENT_CREATE_URL_WITH_SINGLE_QUOTES2 = protocol + "'" + dbName + "';create=true";
        String CLIENT_SHUT_URL_WITH_SINGLE_QUOTES2 = protocol + "'" + dbName + "';shutdown=true";
        String[] clientCreateUrls = new String[]{CLIENT_CREATE_URL_WITH_COLON1, CLIENT_CREATE_URL_WITH_SINGLE_QUOTES2};
        for (int i = 0; i < clientCreateUrls.length; ++i) {
            String url = clientCreateUrls[i];
            try {
                if (url.equals(CLIENT_CREATE_URL_WITH_COLON1)) {
                    Driver driver = DriverManager.getDriver(url);
                    DriverTest.assertNull((Object)driver.connect(url, info));
                    continue;
                }
                DriverTest.assertConnect(true, url, info);
                continue;
            }
            catch (SQLException se) {
                DriverTest.fail((String)"did not expect an exception");
            }
        }
        DriverTest.shutdownDB(CLIENT_SHUT_URL_WITH_SINGLE_QUOTES2 + ";shutdown=true", null);
    }

    public void testDbNameWithSpaces() throws SQLException {
        Object info = null;
        String url = null;
        String protocol = TestConfiguration.getCurrent().getJDBCClient().getUrlBase();
        if (DriverTest.usingDerbyNetClient()) {
            protocol = protocol + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        } else if (DriverTest.usingDB2Client()) {
            protocol = protocol + "net:" + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/";
        }
        url = protocol + DB_NAME_WITH_SPACES + ";create=true";
        String shuturl = protocol + DB_NAME_WITH_SPACES + ";shutdown=true";
        DriverTest.assertConnect(false, url, null);
        DriverTest.shutdownDB(shuturl, null);
    }

    private static void assertConnect(boolean expectUrlEqualsGetUrl, String url, Properties info) throws SQLException {
        Driver driver = DriverManager.getDriver(url);
        Connection conn = driver.connect(url, info);
        DriverTest.assertNotNull((Object)conn);
        if (expectUrlEqualsGetUrl) {
            DriverTest.assertEquals((String)url, (String)conn.getMetaData().getURL());
        } else {
            DriverTest.assertNotSame((Object)url, (Object)conn.getMetaData().getURL());
        }
        ResultSet rs = conn.createStatement().executeQuery("VALUES(CURRENT SCHEMA)");
        rs.next();
        DriverTest.assertEquals((String)rs.getString(1), (String)conn.getMetaData().getUserName().toUpperCase());
        rs.close();
        conn.close();
    }

    private static void shutdownDB(String url, Properties info) throws SQLException {
        Driver driver = DriverManager.getDriver(url);
        try {
            driver.connect(url, info);
        }
        catch (SQLException se) {
            DriverTest.assertSQLState("08006", se);
        }
    }

    private static void loadDriver() {
        String driverClass = TestConfiguration.getCurrent().getJDBCClient().getJDBCDriverName();
        try {
            Class.forName(driverClass).newInstance();
        }
        catch (Exception e) {
            DriverTest.fail((String)"could not instantiate driver");
        }
    }
}

