/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DriverMgrAuthenticationTest
extends AuthenticationTest {
    public DriverMgrAuthenticationTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("DriverManager not available with JSR169;empty DriverMgrAuthenticationTest");
        }
        TestSuite suite = new TestSuite("DriverMgrAuthenticationTest");
        suite.addTest(DriverMgrAuthenticationTest.baseSuite("DriverMgrAuthenticationTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(DriverMgrAuthenticationTest.baseSuite("DriverMgrAuthenticationTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite("DriverMgrAuthenticationTest");
        DriverMgrAuthenticationTest test = new DriverMgrAuthenticationTest("testConnectShutdownAuthentication");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new DriverMgrAuthenticationTest("testUserFunctions");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new DriverMgrAuthenticationTest("testNotFullAccessUsers");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new DriverMgrAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new DriverMgrAuthenticationTest("testGreekCharacters");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new DriverMgrAuthenticationTest("testSystemShutdown");
        DriverMgrAuthenticationTest.setBaseProps(suite, (Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    @Override
    protected void assertConnectionOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        DriverManager.getConnection(url, user, password).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        String url2 = url + ";user=" + user + ";password=" + password;
        DriverManager.getConnection(url2).close();
    }

    @Override
    protected void assertConnectionFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        try {
            DriverManager.getConnection(url, user, password);
            DriverMgrAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        String url2 = url + ";user=" + user + ";password=" + password;
        try {
            DriverManager.getConnection(url2);
            DriverMgrAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName) + ";shutdown=true";
        try {
            DriverManager.getConnection(url, user, password);
            DriverMgrAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        url = url + ";shutdown=true;user=" + user + ";password=" + password;
        try {
            DriverManager.getConnection(url, null);
            DriverMgrAuthenticationTest.fail((String)"expected a error after shutdown connection");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName) + ";shutdown=true";
        try {
            DriverManager.getConnection(url, user, password);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        String url2 = url + ";user=" + user + ";password=" + password + ";shutdown=true";
        try {
            DriverManager.getConnection(url2);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        if (DriverMgrAuthenticationTest.usingDerbyNetClient() && dbName == "") {
            return;
        }
        String url2 = url + ";user=" + user + ";password=" + password + ";shutdown=true";
        try {
            DriverManager.getConnection(url2);
            DriverMgrAuthenticationTest.fail((String)"expected successful shutdown");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState("XJ015", e);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        if (DriverMgrAuthenticationTest.usingDerbyNetClient() && dbName == "") {
            return;
        }
        String url2 = url + ";user=" + user + ";password=" + password + ";shutdown=true";
        try {
            DriverManager.getConnection(url2);
            DriverMgrAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    public void assertConnectionFail(String dbName) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        try {
            DriverManager.getConnection(url);
            DriverMgrAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException e) {
            DriverMgrAuthenticationTest.assertSQLState("08004", e);
        }
    }
}

