/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class DataSourceSerializationTest
extends BaseJDBCTestCase {
    private static final String VERSION_10_0_2_1 = "10_0_2_1";
    private static final String VERSION_10_1_3_1 = "10_1_3_1";
    private static final String VERSION_10_2_2_0 = "10_2_2_0";
    private static final String VERSION_10_3_2_1 = "10_3_2_1";

    public DataSourceSerializationTest(String name) {
        super(name);
    }

    public void serTestEmbeddedDataSource() throws Exception {
        String EMBEDDED_CLASS = "EmbeddedDataSource";
        this.deSerializeDs("EmbeddedDataSource", VERSION_10_0_2_1);
        this.deSerializeDs("EmbeddedDataSource", VERSION_10_1_3_1);
        this.deSerializeDs("EmbeddedDataSource", VERSION_10_2_2_0);
        this.deSerializeDs("EmbeddedDataSource", VERSION_10_3_2_1);
    }

    public void serTestEmbeddedConnectionPoolDataSource() throws Exception {
        String EMBEDDED_CLASS = "EmbeddedConnectionPoolDataSource";
        this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_0_2_1);
        this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_1_3_1);
        this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_2_2_0);
        this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_3_2_1);
    }

    public void serTestEmbeddedXADataSource() throws Exception {
        String EMBEDDED_CLASS = "EmbeddedXADataSource";
        this.deSerializeDs("EmbeddedXADataSource", VERSION_10_0_2_1);
        this.deSerializeDs("EmbeddedXADataSource", VERSION_10_1_3_1);
        this.deSerializeDs("EmbeddedXADataSource", VERSION_10_2_2_0);
        this.deSerializeDs("EmbeddedXADataSource", VERSION_10_3_2_1);
    }

    public void serTestClientDataSource() throws Exception {
        String CLIENT_CLASS = "ClientDataSource";
        this.deSerializeDs("ClientDataSource", VERSION_10_1_3_1);
        this.deSerializeDs("ClientDataSource", VERSION_10_2_2_0);
        this.deSerializeDs("ClientDataSource", VERSION_10_3_2_1);
    }

    public void serTestClientConnectionPoolDataSource() throws Exception {
        String CLIENT_CLASS = "ClientConnectionPoolDataSource";
        this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_1_3_1);
        this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_2_2_0);
        this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_3_2_1);
    }

    public void serTestClientXADataSource() throws Exception {
        String CLIENT_CLASS = "ClientXADataSource";
        this.deSerializeDs("ClientXADataSource", VERSION_10_1_3_1);
        this.deSerializeDs("ClientXADataSource", VERSION_10_2_2_0);
        this.deSerializeDs("ClientXADataSource", VERSION_10_3_2_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deSerializeDs(String className, String version) throws Exception {
        FileInputStream is;
        final StringBuilder fname = new StringBuilder(className);
        fname.append('-');
        fname.append(version);
        fname.append(".ser");
        try {
            is = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(SupportFilesSetup.getReadOnly(fname.toString()));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        DataSourceSerializationTest.assertNotNull((String)"FileInputStream is null", (Object)is);
        Object dsObj = null;
        DataSource ds = null;
        Reference dsRef = null;
        boolean testSequencePassed = false;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            String buildVersion = ois.readUTF();
            String buildNumber = ois.readUTF();
            DataSourceSerializationTest.println("Data source " + className + ", version " + buildVersion + ", build " + buildNumber);
            dsObj = ois.readObject();
            DataSourceSerializationTest.assertNotNull((String)"De-serialized data source is null", (Object)dsObj);
            DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated: " + dsObj.getClass().getName()), (dsObj.getClass().getName().indexOf(className) > 0 ? 1 : 0) != 0);
            ds = (DataSource)dsObj;
            int newTimeout = ds.getLoginTimeout() + 9;
            DataSourceSerializationTest.assertFalse((ds.getLoginTimeout() == newTimeout ? 1 : 0) != 0);
            ds.setLoginTimeout(newTimeout);
            DataSourceSerializationTest.assertEquals((int)newTimeout, (int)ds.getLoginTimeout());
            dsRef = (Reference)ois.readObject();
            ois.close();
            testSequencePassed = true;
        }
        finally {
            if (testSequencePassed) {
                ((InputStream)is).close();
            } else {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ois) {}
            }
        }
        String factoryClassName = dsRef.getFactoryClassName();
        ObjectFactory factory = (ObjectFactory)Class.forName(factoryClassName).newInstance();
        Object recreatedDs = factory.getObjectInstance(dsRef, null, null, null);
        ds = (DataSource)recreatedDs;
        DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated by Reference: " + dsObj.getClass().getName()), (dsObj.getClass().getName().indexOf(className) > 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DataSourceSerializationTest");
        String filePrefix = "functionTests/testData/serializedDataSources/";
        if (Derby.hasEmbedded()) {
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedConnectionPoolDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedXADataSource"));
        }
        if (Derby.hasClient()) {
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientConnectionPoolDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientXADataSource"));
        }
        return new SupportFilesSetup((Test)suite, new String[]{filePrefix + "EmbeddedDataSource-10_0_2_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_0_2_1.ser", filePrefix + "EmbeddedXADataSource-10_0_2_1.ser", filePrefix + "EmbeddedDataSource-10_1_3_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_1_3_1.ser", filePrefix + "EmbeddedXADataSource-10_1_3_1.ser", filePrefix + "ClientDataSource-10_1_3_1.ser", filePrefix + "ClientConnectionPoolDataSource-10_1_3_1.ser", filePrefix + "ClientXADataSource-10_1_3_1.ser", filePrefix + "EmbeddedDataSource-10_2_2_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_2_2_0.ser", filePrefix + "EmbeddedXADataSource-10_2_2_0.ser", filePrefix + "ClientDataSource-10_2_2_0.ser", filePrefix + "ClientConnectionPoolDataSource-10_2_2_0.ser", filePrefix + "ClientXADataSource-10_2_2_0.ser", filePrefix + "EmbeddedDataSource-10_3_2_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_3_2_1.ser", filePrefix + "EmbeddedXADataSource-10_3_2_1.ser", filePrefix + "ClientDataSource-10_3_2_1.ser", filePrefix + "ClientConnectionPoolDataSource-10_3_2_1.ser", filePrefix + "ClientXADataSource-10_3_2_1.ser"});
    }
}

