/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DMDBugsTest
extends BaseJDBCTestCase {
    public DMDBugsTest(String name) {
        super(name);
    }

    public void testDerby3000() throws SQLException, IOException {
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE APP.TAB (i int)");
        s.executeUpdate("CREATE VIEW  APP.V  as SELECT * FROM TAB");
        s.executeUpdate("CREATE SYNONYM TSYN FOR APP.TAB");
        String[] withInvalidTableTypes = new String[]{"SYNONYM", "TABLE", "VIEW", "GLOBAL TEMPORARY"};
        ResultSet rs = dmd.getTables("%", "%", "%", withInvalidTableTypes);
        JDBC.assertFullResultSet(rs, new String[][]{{"", "APP", "TSYN", "SYNONYM", "", null, null, null, null, null}, {"", "APP", "TAB", "TABLE", "", null, null, null, null, null}, {"", "APP", "V", "VIEW", "", null, null, null, null, null}});
        rs = dmd.getTables("%", "%", "%", new String[]{"GLOBAL TEMPORARY"});
        JDBC.assertEmpty(rs);
        rs = dmd.getTables("%", "%", "%", new String[]{"VIEW"});
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"", "APP", "V", "VIEW", "", null, null, null, null, null}});
        rs = dmd.getTables("%", "%", "%", new String[]{"TABLE"});
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"", "APP", "TAB", "TABLE", "", null, null, null, null, null}});
        rs = dmd.getTables("%", "%", "%", new String[]{"SYNONYM"});
        JDBC.assertUnorderedResultSet(rs, new String[][]{{"", "APP", "TSYN", "SYNONYM", "", null, null, null, null, null}});
        rs = dmd.getTables("%", "%", "%", new String[]{"SYSTEM TABLE"});
        DMDBugsTest.assertEquals((int)25, (int)JDBC.assertDrainResults(rs));
        s.executeUpdate("DROP VIEW APP.V");
        s.executeUpdate("DROP TABLE APP.TAB");
        s.executeUpdate("DROP SYNONYM APP.TSYN");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DMDBugsTest");
        suite.addTest(TestConfiguration.defaultSuite(DMDBugsTest.class));
        return suite;
    }
}

