/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTest
extends BaseJDBCTestCase {
    private static final int TRANSFER_BUFFER_SIZE = 4096;
    private static final int SET_STRING = 1;
    private static final int SET_ASCII_STREAM = 2;
    private static final int SET_CHARACTER_STREAM = 4;
    private static final String NORWEGIAN_LETTERS = "\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5";
    private ResultSet rs = null;
    private Clob clob = null;

    public ClobTest(String testName) {
        super(testName);
    }

    public void testGetSubString_PosOneTooBig() throws SQLException {
        long length = this.clob.length();
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(length + 1L, 10));
    }

    public void testGetSubString_PosTooBig() {
        try {
            this.clob.getSubString(999L, 10);
            ClobTest.fail((String)"getSubString with pos larger than clob length must fail");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ076", sqle);
        }
    }

    public void testGetSubString_PosNegative() throws SQLException {
        try {
            this.clob.getSubString(-123L, 10);
            ClobTest.fail((String)"getSubString with negative position should fail");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ070", sqle);
        }
    }

    public void testGetSubString_RequestZeroLength_PosValid() throws SQLException {
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 0));
    }

    public void testGetSubString_RequestZeroLength_PosTooBig() throws SQLException {
        try {
            this.clob.getSubString(999L, 0);
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ076", sqle);
        }
    }

    public void testGetSubString_BiggerThanInternalBuffer() throws IOException, SQLException {
        int stringLength = 0x100000;
        this.transferData(new LoopingAlphabetReader(stringLength), this.clob.setCharacterStream(1L), 4096);
        String obtained = this.clob.getSubString(1L, stringLength);
        ClobTest.assertEquals((String)"Incorrect string length", (int)stringLength, (int)obtained.length());
        CharArrayWriter charWriter = new CharArrayWriter();
        this.transferData(new LoopingAlphabetReader(stringLength), charWriter, 4096);
        ClobTest.assertEquals((String)"String do not match", (String)charWriter.toString(), (String)obtained);
    }

    public void testLengthOnEmptyClob() throws SQLException {
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
    }

    public void testInsertStringOnEmptyClob_Singlebyte() throws SQLException {
        String content = "This is the new Clob content.";
        this.clob.setString(1L, content);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)content.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)content, (String)this.clob.getSubString(1L, content.length()));
    }

    public void testInsertStringOnEmptyClob_Multibyte() throws SQLException {
        String content = "A few Norwegian letters: \u00e6, \u00e5, \u00f8.";
        this.clob.setString(1L, content);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)content.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)content, (String)this.clob.getSubString(1L, content.length()));
    }

    public void testInsertStringInMiddle_Multibyte() throws SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] modifiedContent = NORWEGIAN_LETTERS.toCharArray();
        modifiedContent[4] = 97;
        modifiedContent[5] = 98;
        modifiedContent[8] = 99;
        String newContent = String.copyValueOf(modifiedContent);
        ClobTest.assertEquals((int)1, (int)this.clob.setString(9L, "c"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(5L, "a"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(6L, "b"));
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)newContent, (String)this.clob.getSubString(1L, newContent.length()));
    }

    public void testPositionWithString_ASCII_SimplePartialRecurringPattern() throws IOException, SQLException {
        String token = "xxSPOTxx";
        String inserted = "abcdexxSPxabcdexabxxSPxxxSPOTxabcxxSPOTxxabc";
        this.clob.setString(1L, inserted);
        ClobTest.assertEquals((String)"Invalid match position", (long)(inserted.indexOf(token, 0) + 1), (long)this.clob.position(token, 1L));
    }

    public void testPositionWithString_USASCII() throws IOException, SQLException {
        String token = "xxSPOTxx";
        long prefix = 93191L;
        long postfix = 12288L;
        this.insertDataWithToken(token, 93191L, 12288L, 2);
        this.executeTestPositionWithStringToken(token, 93191L);
    }

    public void testPositionWithString_IOS88591() throws IOException, SQLException {
        String token = "xx\u00c6\u00c6\u00c6xx";
        long prefix = 68608L;
        long postfix = 1022L;
        this.insertDataWithToken(token, 68608L, 1022L, 2);
        this.executeTestPositionWithStringToken(token, 68608L);
    }

    public void testPositionWithString_CJK() throws IOException, SQLException {
        long prefix = 11L;
        long postfix = 90L;
        char[] tmpChar = new char[1];
        LoopingAlphabetReader tokenSrc = new LoopingAlphabetReader(1L, CharAlphabet.cjkSubset());
        tokenSrc.read(tmpChar);
        String token = String.copyValueOf(tmpChar);
        this.insertDataWithToken(token, 11L, 90L, 4);
        this.executeTestPositionWithStringToken(token, 11L);
    }

    private void executeTestPositionWithStringToken(String token, long prefixLength) throws IOException, SQLException {
        long TOKEN_POS = prefixLength + 1L;
        ClobTest.assertEquals((long)-1L, (long)this.clob.position(token, TOKEN_POS + 1L));
        ClobTest.assertEquals((long)TOKEN_POS, (long)this.clob.position(token, TOKEN_POS));
        ClobTest.assertEquals((long)TOKEN_POS, (long)this.clob.position(token, 1L));
    }

    protected void setUp() throws Exception {
        Statement stmt = this.createStatement();
        this.rs = stmt.executeQuery("select * from ClobTestData");
        ClobTest.assertTrue((boolean)this.rs.next());
        this.clob = this.rs.getClob(1);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clob = null;
        this.rs.close();
        super.tearDown();
    }

    public static Test suite() {
        return new ClobTestSetup(TestConfiguration.defaultSuite(ClobTest.class, false));
    }

    private int transferData(InputStream source, OutputStream dest, int tz) throws IOException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedInputStream in = new BufferedInputStream(source);
        BufferedOutputStream out = new BufferedOutputStream(dest, tz);
        byte[] bridge = new byte[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            out.write(bridge, 0, read);
            total += read;
        }
        in.close();
        out.flush();
        return total;
    }

    private int transferData(Reader source, Writer dest, int tz) throws IOException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedReader in = new BufferedReader(source);
        BufferedWriter out = new BufferedWriter(dest, tz);
        char[] bridge = new char[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            out.write(bridge, 0, read);
            total += read;
        }
        in.close();
        out.flush();
        return total;
    }

    private int transferData(Reader source, int tz) throws IOException, SQLException {
        int read;
        if (tz < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + tz);
        }
        BufferedReader in = new BufferedReader(source);
        char[] bridge = new char[tz];
        int total = 0;
        while ((read = in.read(bridge, 0, tz)) != -1) {
            this.clob.setString((long)total + 1L, String.copyValueOf(bridge, 0, read));
            total += read;
        }
        in.close();
        return total;
    }

    private void insertDataWithToken(String token, long pre, long post, int mode) throws IOException, SQLException {
        int TRANSFER_BUFFER_SIZE = 4096;
        long total = 0L;
        switch (mode) {
            case 1: {
                LoopingAlphabetReader charIn = new LoopingAlphabetReader(pre);
                total += (long)this.transferData(charIn, TRANSFER_BUFFER_SIZE);
                this.clob.setString(pre + 1L, token);
                total += (long)token.length();
                charIn = new LoopingAlphabetReader(post);
                total += (long)this.transferData(charIn, TRANSFER_BUFFER_SIZE);
                break;
            }
            case 2: {
                OutputStream asciiOut = this.clob.setAsciiStream(1L);
                LoopingAlphabetStream asciiIn = new LoopingAlphabetStream(pre);
                total += (long)this.transferData(asciiIn, asciiOut, TRANSFER_BUFFER_SIZE);
                byte[] tokenBytes = token.getBytes("ISO-8859-1");
                asciiOut.write(tokenBytes, 0, tokenBytes.length);
                total += (long)tokenBytes.length;
                asciiIn = new LoopingAlphabetStream(post);
                total += (long)this.transferData(asciiIn, asciiOut, TRANSFER_BUFFER_SIZE);
                break;
            }
            case 4: {
                Writer charOut = this.clob.setCharacterStream(1L);
                LoopingAlphabetReader charIn = new LoopingAlphabetReader(pre);
                total += (long)this.transferData(charIn, charOut, TRANSFER_BUFFER_SIZE);
                charOut.write(token);
                total += (long)token.length();
                charIn = new LoopingAlphabetReader(post);
                total += (long)this.transferData(charIn, charOut, TRANSFER_BUFFER_SIZE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown insertion mode: " + mode);
            }
        }
        ClobTest.assertEquals((String)"Invalid length after insertion", (long)(pre + post + (long)token.length()), (long)this.clob.length());
    }

    private static class ClobTestSetup
    extends BaseJDBCTestSetup {
        ClobTestSetup(Test test) {
            super(test);
        }

        protected void setUp() throws SQLException {
            Connection con = this.getConnection();
            Statement stmt = con.createStatement();
            stmt.execute("create table ClobTestData (dClob CLOB)");
            stmt.executeUpdate("insert into ClobTestData values ('')");
            stmt.close();
        }

        @Override
        protected void tearDown() throws Exception {
            super.preTearDown();
            Connection con = this.getConnection();
            Statement stmt = con.createStatement();
            stmt.execute("drop table ClobTestData");
            stmt.close();
            super.tearDown();
        }
    }
}

