/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AuthenticationTest
extends BaseJDBCTestCase {
    private static final String PASSWORD_SUFFIX = "suf2ix";
    private static final String[] USERS = new String[]{"APP", "dan", "kreg", "jeff", "ames", "jerry", "francois", "jamie", "howardR", "\"eVe\"", "\"fred@derby.com\"", "\"123\""};
    private static final String zeus = "\u0396\u0395\u03a5\u03a3";
    private static final String apollo = "\u0391\u09a0\u039f\u039b\u039b\u039a\u0390";

    public AuthenticationTest(String name) {
        super(name);
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AuthenticationTest");
        suite.addTest(AuthenticationTest.baseSuite("AuthenticationTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(AuthenticationTest.baseSuite("AuthenticationTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite("AuthenticationTest");
        AuthenticationTest test = new AuthenticationTest("testConnectShutdownAuthentication");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testUserCasing");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testUserFunctions");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testNotFullAccessUsers");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testUserAccessRoutines");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testGreekCharacters");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        test = new AuthenticationTest("testSystemShutdown");
        AuthenticationTest.setBaseProps(suite, (Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    protected static void setBaseProps(TestSuite suite, Test test) {
        Properties props = new Properties();
        props.setProperty("gemfirexd.infolog.append", "true");
        props.setProperty("gemfirexd.debug.true", "TraceAuthentication,TraceSystemProcedures");
        Properties sysprops = new Properties();
        sysprops.put("gemfirexd.user.system", "admin");
        sysprops.put("gemfirexd.user.mickey", "mouse");
        test = DatabasePropertyTestSetup.builtinAuthentication(test, USERS, PASSWORD_SUFFIX);
        test = new DatabasePropertyTestSetup((Test)test, props, true);
        suite.addTest((Test)new SystemPropertyTestSetup((Test)test, sysprops));
    }

    protected void setUp() throws Exception {
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", null, this.getConnection());
        this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", null, this.getConnection());
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", null, this.getConnection());
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        AuthenticationTest.removeSystemProperty("gemfirexd.authentication.required");
        AuthenticationTest.removeSystemProperty("gemfirexd.user.\u0391\u09a0\u039f\u039b\u039b\u039a\u0390");
        super.tearDown();
    }

    public void testUserCasing() throws SQLException {
        for (int i = 0; i < USERS.length; ++i) {
            String jdbcUserName = USERS[i];
            boolean delimited = jdbcUserName.charAt(0) == '\"';
            String normalUserName = delimited ? jdbcUserName.substring(1, jdbcUserName.length() - 1) : jdbcUserName.toUpperCase(Locale.ENGLISH);
            String password = USERS[i] + PASSWORD_SUFFIX;
            this.userCasingTest(jdbcUserName, normalUserName, password);
            if (!delimited && normalUserName.equals(jdbcUserName)) continue;
        }
        PreparedStatement psGetAccess = this.prepareStatement("VALUES SYSCS_UTIL.GET_USER_ACCESS(?)");
        CallableStatement csSetAccess = this.prepareCall("CALL SYSCS_UTIL.SET_USER_ACCESS(?, ?)");
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", USERS[0], this.getConnection());
        this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", null, this.getConnection());
        this.commit();
        for (int i = 1; i < USERS.length; ++i) {
            String jdbcUserName = USERS[i];
            boolean delimited = jdbcUserName.charAt(0) == '\"';
            String normalUserName = delimited ? jdbcUserName.substring(1, jdbcUserName.length() - 1) : jdbcUserName.toUpperCase(Locale.ENGLISH);
            String password = USERS[i] + PASSWORD_SUFFIX;
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", jdbcUserName, this.getConnection());
            this.commit();
            Connection connUser = this.openDefaultConnection(jdbcUserName, password);
            if (AuthenticationTest.usingEmbedded()) {
                AuthenticationTest.assertTrue((String)(jdbcUserName + ":isReadOnly()"), (boolean)connUser.isReadOnly());
            }
            connUser.close();
            psGetAccess.setString(1, normalUserName);
            JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
            this.commit();
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", null, this.getConnection());
            this.commit();
            connUser = this.openDefaultConnection(jdbcUserName, password);
            AuthenticationTest.assertFalse((boolean)connUser.isReadOnly());
            connUser.close();
            psGetAccess.setString(1, normalUserName);
            JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
            this.commit();
            csSetAccess.setString(1, normalUserName);
            csSetAccess.setString(2, "READONLYACCESS");
            csSetAccess.executeUpdate();
            this.commit();
            connUser = this.openDefaultConnection(jdbcUserName, password);
            if (AuthenticationTest.usingEmbedded()) {
                AuthenticationTest.assertTrue((String)(jdbcUserName + ":isReadOnly()"), (boolean)connUser.isReadOnly());
            }
            connUser.close();
            psGetAccess.setString(1, normalUserName);
            JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
            this.commit();
        }
    }

    private void userCasingTest(String jdbcUserName, String normalUserName, String password) throws SQLException {
        this.userCasingTest(jdbcUserName, normalUserName, this.openDefaultConnection(jdbcUserName, password));
        DataSource ds = JDBCDataSource.getDataSource();
        this.userCasingTest(jdbcUserName, normalUserName, ds.getConnection(jdbcUserName, password));
        JDBCDataSource.setBeanProperty(ds, "user", jdbcUserName);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        this.userCasingTest(jdbcUserName, normalUserName, ds.getConnection());
    }

    private void userCasingTest(String jdbcUserName, String normalUserName, Connection connUser) throws SQLException {
        this.assertNormalUserName(normalUserName, connUser);
        AuthenticationTest.assertEquals((String)"DatabaseMetaData.getUserName()", (String)jdbcUserName, (String)connUser.getMetaData().getUserName());
        Statement s = connUser.createStatement();
        s.executeUpdate("CALL SYSCS_UTIL.SET_USER_ACCESS(CURRENT_USER, 'FULLACCESS')");
        s.close();
        JDBC.cleanup(connUser);
    }

    private void assertNormalUserName(String normalUserName, Connection connUser) throws SQLException {
        Statement s = connUser.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("VALUES CURRENT_USER"), normalUserName);
        JDBC.assertSingleValueResultSet(s.executeQuery("VALUES SESSION_USER"), normalUserName);
        JDBC.assertSingleValueResultSet(s.executeQuery("VALUES {fn user()}"), normalUserName);
        s.close();
    }

    public void testConnectShutdownAuthentication() throws SQLException {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        this.assertConnectionFail(dbName);
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertConnectionWOUPOK(dbName, "system", "admin");
        this.assertConnectionOK(dbName, "dan", "dansuf2ix");
        this.assertConnectionWOUPOK(dbName, "dan", "dansuf2ix");
        this.assertShutdownOK(dbName, "dan", "dansuf2ix");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertShutdownWOUPOK(dbName, "dan", "dansuf2ix");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertShutdownOK(dbName, "system", "admin");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertShutdownWOUPOK(dbName, "system", "admin");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertShutdownUsingConnAttrsOK(dbName, "APP", "APPsuf2ix");
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        Statement stmt = conn1.createStatement();
        ResultSet rs = stmt.executeQuery("values SYSCS_UTIL.GET_DATABASE_PROPERTY('gemfirexd.user.dan')");
        rs.next();
        AuthenticationTest.assertNotSame((Object)"dansuf2ix", (Object)rs.getString(1));
        conn1.commit();
        conn1.close();
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "APP,system,nomen,francois,jeff", conn1);
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "NoAccess", conn1);
        conn1.commit();
        conn1.close();
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertConnectionFail("08004", dbName, "nomen", "nescio");
        this.assertConnectionWOUPFail("08004", dbName, "nomen", "nescio");
        this.assertShutdownOK(dbName, "francois", "francoissuf2ix");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertShutdownWOUPOK(dbName, "APP", "APPsuf2ix");
        this.assertConnectionOK(dbName, "jeff", "jeffsuf2ix");
        this.assertConnectionFail("08004", dbName, "dan", "dansuf2ix");
        this.assertShutdownFail("08004", dbName, "dan", "dansuf2ix");
        conn1 = this.openDefaultConnection("francois", "francoissuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "jeff,dan,francois,jamie", conn1);
        conn1.commit();
        conn1.close();
        this.assertConnectionOK(dbName, "dan", "dansuf2ix");
        this.assertShutdownOK(dbName, "dan", "dansuf2ix");
        this.assertConnectionOK(dbName, "dan", "dansuf2ix");
        this.assertShutdownFail("08004", dbName, "APP", "APPsuf2ix");
        conn1 = this.openDefaultConnection("francois", "francoissuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "NoAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "APP,jeff,dan,francois,jamie", conn1);
        conn1.commit();
        conn1.close();
        this.assertConnectionFail("08004", dbName, "badUser", "badPwd");
        this.assertConnectionFail("08004", dbName, "badUser", "badPwd");
        this.assertConnectionFail("08004", dbName, "system", "admin");
        this.assertConnectionFail("08004", dbName, "dan", "badPwd");
        this.assertConnectionFail("08004", dbName, "jamie", "dansuf2ix");
        this.assertShutdownFail("08004", dbName, "system", "admin");
        this.assertShutdownFail("08004", dbName, "badUser", "badPwd");
        this.assertShutdownFail("08004", dbName, "dan", "badPwd");
        this.assertShutdownFail("08004", dbName, "badUser", "dansuf2ix");
        this.assertSystemShutdownOK("", "badUser", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "dan", "jeffsuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "APP", "POO");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "dan", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownOK("", "APP", "APPsuf2ix");
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    public void testUserFunctions() throws SQLException {
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "francois,jeff,ames,jerry,jamie,dan,system", conn1);
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "NoAccess", conn1);
        conn1.commit();
        Statement stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, 0, "create table APP.t1(c1 varchar(30) check (UPPER(c1) <> 'JAMIE'))");
        AuthenticationTest.assertUpdateCount(stmt, 1, "insert into APP.t1 values USER");
        conn1.commit();
        stmt.close();
        conn1.close();
        this.useUserValue(1, "jeff", "insert into APP.t1 values CURRENT_USER");
        this.useUserValue(1, "ames", "insert into APP.t1 values SESSION_USER");
        this.useUserValue(1, "jerry", "insert into APP.t1 values {fn user()}");
        this.assertUserValue(new String[]{"DAN", "JEFF", "AMES", "JERRY"}, "dan", "select * from APP.t1");
        this.useUserValue(1, "dan", "update APP.t1 set c1 = 'edward' where c1 = USER");
        this.assertUserValue(new String[]{"JEFF"}, "jeff", "select * from APP.t1 where c1 like CURRENT_USER");
        this.useUserValue(1, "ames", "update APP.t1 set c1 = 'sema' where SESSION_USER = c1");
        this.useUserValue(1, "jerry", "update APP.t1 set c1 = 'yrrej' where c1 like {fn user()}");
        this.assertUserValue(new String[]{"edward", "JEFF", "sema", "yrrej"}, "dan", "select * from APP.t1");
        this.useUserValue(4, "francois", "update APP.T1 set c1 = USER");
        this.assertUserValue(new String[]{"FRANCOIS", "FRANCOIS", "FRANCOIS", "FRANCOIS"}, "dan", "select * from APP.t1");
        conn1 = this.openDefaultConnection("jamie", "jamiesuf2ix");
        stmt = conn1.createStatement();
        try {
            stmt.execute("insert into APP.t1 values CURRENT_USER");
        }
        catch (SQLException sqle) {
            AuthenticationTest.assertSQLState("23513", sqle);
        }
        stmt.close();
        conn1.rollback();
        conn1.close();
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, 0, "drop table APP.t1");
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    public void testChangePasswordAndDatabasePropertiesOnly() throws SQLException {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,jeff,system", conn1);
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "NoAccess", conn1);
        this.setDatabaseProperty("gemfirexd.distributedsystem.requireAuthentication", "true", conn1);
        conn1.commit();
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertConnectionFail("08004", dbName, "system", "otherSysPwd");
        this.assertConnectionOK(dbName, "jeff", "jeffsuf2ix");
        this.assertConnectionFail("08004", dbName, "jeff", "otherPwd");
        this.setDatabaseProperty("gemfirexd.user.jeff", "otherPwd", conn1);
        conn1.commit();
        this.assertConnectionOK(dbName, "jeff", "otherPwd");
        this.setDatabaseProperty("gemfirexd.distributedsystem.propertiesOnly", "true", conn1);
        conn1.commit();
        this.assertConnectionFail("08004", dbName, "system", "admin");
        this.setDatabaseProperty("gemfirexd.distributedsystem.propertiesOnly", "false", conn1);
        conn1.commit();
        conn1.close();
        this.assertConnectionOK(dbName, "system", "admin");
        AuthenticationTest.setSystemProperty("gemfirexd.user.system", "thrdSysPwd");
        this.assertConnectionOK(dbName, "system", "thrdSysPwd");
        AuthenticationTest.setSystemProperty("gemfirexd.user.system", "admin");
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        this.setDatabaseProperty("gemfirexd.distributedsystem.propertiesOnly", "false", conn1);
        conn1.commit();
        conn1.close();
    }

    public void testNotFullAccessUsers() throws SQLException {
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        try {
            this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,jamie,dan", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-full-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,jamie,DaN", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-full-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,jamie,\"DAN\"", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-full-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-full-access-users", "\"dan\",jamie,\"dan\"", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-full-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", "dan,jamie,dan", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-read-only-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", "dan,jamie,DaN", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-read-only-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", "dan,jamie,\"DAN\"", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-read-only-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        try {
            this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", "\"dan\",jamie,\"dan\"", conn1);
            AuthenticationTest.fail((String)"Duplicate allowed on gemfirexd.authz-read-only-access-users");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("4250D", e);
        }
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,jamie,system", conn1);
        this.assertFailSetDatabaseProperty("gemfirexd.authz-read-only-access-users", "jamie", conn1);
        this.setDatabaseProperty("gemfirexd.authz-read-only-access-users", "ames,mickey", conn1);
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "NoAccess", conn1);
        this.setDatabaseProperty("gemfirexd.distributedsystem.requireAuthentication", "true", conn1);
        conn1.commit();
        PreparedStatement psGetAccess = conn1.prepareStatement("VALUES SYSCS_UTIL.GET_USER_ACCESS(?)");
        psGetAccess.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        psGetAccess.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        psGetAccess.setString(1, "hagrid");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "NOACCESS");
        conn1.commit();
        CallableStatement csSetAccess = conn1.prepareCall("CALL SYSCS_UTIL.SET_USER_ACCESS(?, ?)");
        csSetAccess.setString(1, "AMES");
        csSetAccess.setString(2, "FULLACCESS");
        csSetAccess.execute();
        psGetAccess.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        psGetAccess.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        csSetAccess.setString(1, "AMES");
        csSetAccess.setString(2, "READONLYACCESS");
        csSetAccess.execute();
        psGetAccess.setString(1, "AMES");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        psGetAccess.setString(1, "MICKEY");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        psGetAccess.setString(1, "JAMIE");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "DAN");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "SYSTEM");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        csSetAccess.setString(1, "BOND");
        csSetAccess.setString(2, "FULLACCESS");
        csSetAccess.execute();
        csSetAccess.setString(1, "JAMES");
        csSetAccess.setString(2, "READONLYACCESS");
        csSetAccess.execute();
        conn1.commit();
        psGetAccess.setString(1, "BOND");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        psGetAccess.setString(1, "JAMES");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        conn1.commit();
        csSetAccess.setString(1, "BOND");
        csSetAccess.setString(2, null);
        csSetAccess.execute();
        csSetAccess.setString(1, "JAMES");
        csSetAccess.setString(2, null);
        csSetAccess.execute();
        conn1.commit();
        psGetAccess.setString(1, "BOND");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "NOACCESS");
        psGetAccess.setString(1, "JAMES");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "NOACCESS");
        conn1.commit();
        psGetAccess.close();
        csSetAccess.close();
        Statement stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, 0, "create table APP.t1(c1 varchar(30) check (UPPER(c1) <> 'JAMIE'))");
        AuthenticationTest.assertUpdateCount(stmt, 1, "insert into APP.t1 values USER");
        conn1.commit();
        stmt.close();
        conn1.close();
        conn1 = this.openDefaultConnection("system", "admin");
        stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, 1, "update APP.t1 set c1 = USER");
        conn1.commit();
        stmt.close();
        conn1.close();
        this.assertUserValue(new String[]{"SYSTEM"}, "ames", "select * from APP.t1");
        conn1 = this.openDefaultConnection("ames", "amessuf2ix");
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertTrue((boolean)conn1.isReadOnly());
        }
        stmt = conn1.createStatement();
        AuthenticationTest.assertStatementError("25502", stmt, "delete from APP.t1 where c1 = 'SYSTEM'");
        AuthenticationTest.assertStatementError("25502", stmt, "insert into APP.t1 values USER");
        AuthenticationTest.assertStatementError("25502", stmt, "update APP.t1 set c1 = USER where c1 = 'SYSTEM'");
        AuthenticationTest.assertStatementError("25503", stmt, "create table APP.t2 (c1 int)");
        conn1.commit();
        stmt.close();
        conn1.close();
        conn1 = this.openDefaultConnection("mickey", "mouse");
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertTrue((boolean)conn1.isReadOnly());
        }
        stmt = conn1.createStatement();
        AuthenticationTest.assertStatementError("25502", stmt, "delete from APP.t1 where c1 = 'SYSTEM'");
        conn1.rollback();
        conn1.close();
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, 0, "drop table APP.t1");
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    public void testUserAccessRoutines() throws SQLException {
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        PreparedStatement psGetAccess = conn1.prepareStatement("VALUES SYSCS_UTIL.GET_USER_ACCESS(?)");
        CallableStatement csSetAccess = conn1.prepareCall("CALL SYSCS_UTIL.SET_USER_ACCESS(?, ?)");
        csSetAccess.setString(1, "DAN");
        csSetAccess.setString(2, "FULLACCESS");
        csSetAccess.execute();
        csSetAccess.setString(1, null);
        csSetAccess.setString(2, "FULLACCESS");
        AuthenticationTest.assertStatementError("28502", csSetAccess);
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "READONLYACCESS", conn1);
        conn1.commit();
        psGetAccess.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "READONLYACCESS");
        conn1.commit();
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "FULLACCESS", conn1);
        conn1.commit();
        psGetAccess.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        conn1.commit();
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", null, conn1);
        conn1.commit();
        psGetAccess.setString(1, "TONYBLAIR");
        JDBC.assertSingleValueResultSet(psGetAccess.executeQuery(), "FULLACCESS");
        conn1.commit();
        conn1.close();
    }

    public void testGreekCharacters() throws SQLException {
        Statement stmt;
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        AuthenticationTest.setSystemProperty("gemfirexd.user.\u0391\u09a0\u039f\u039b\u039b\u039a\u0390", zeus);
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.user.\u0396\u0395\u03a5\u03a3", apollo, conn1);
        this.setDatabaseProperty("gemfirexd.authz-full-access-users", "dan,system,APP\u0396\u0395\u03a5\u03a3,\u0391\u09a0\u039f\u039b\u039b\u039a\u0390", conn1);
        conn1.commit();
        conn1.close();
        if (AuthenticationTest.usingDerbyNetClient()) {
            this.assertConnectionFail("22005", dbName, zeus, apollo);
        } else {
            this.assertConnectionOK(dbName, zeus, apollo);
            this.assertConnectionFail("08004", dbName, apollo, apollo);
            this.assertShutdownOK(dbName, zeus, apollo);
            this.assertConnectionOK(dbName, apollo, zeus);
            this.assertShutdownFail("08004", dbName, zeus, zeus);
            this.assertShutdownOK(dbName, apollo, zeus);
            this.assertConnectionOK(dbName, apollo, zeus);
            this.assertShutdownUsingSetShutdownOK(dbName, "APP", "APPsuf2ix");
            conn1 = this.openDefaultConnection(zeus, apollo);
            stmt = conn1.createStatement();
            AuthenticationTest.assertUpdateCount(stmt, 0, "create table APP.t1(c1 varchar(30))");
            AuthenticationTest.assertUpdateCount(stmt, 1, "insert into APP.t1 values USER");
            conn1.commit();
            this.assertUserValue(new String[]{zeus}, zeus, apollo, "select * from APP.t1 where c1 like CURRENT_USER");
            stmt.close();
            conn1.close();
        }
        conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        stmt = conn1.createStatement();
        if (AuthenticationTest.usingEmbedded()) {
            AuthenticationTest.assertUpdateCount(stmt, 0, "drop table APP.t1");
        }
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    public void testSystemShutdown() throws SQLException {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertConnectionOK(dbName, "dan", "dansuf2ix");
        AuthenticationTest.setSystemProperty("gemfirexd.authentication.required", "true");
        this.assertShutdownUsingSetShutdownOK(dbName, "APP", "APPsuf2ix");
        this.assertConnectionOK(dbName, "system", "admin");
        this.assertConnectionOK(dbName, "dan", "dansuf2ix");
        this.assertSystemShutdownOK("", "badUser", "dansuf2ix");
        this.openDefaultConnection("dan", "dansuf2ix").close();
        this.assertSystemShutdownFail("08004", "", "badUser", "dansuf2ix");
        this.assertSystemShutdownFail("08004", "", "dan", "jeffsuf2ix");
        this.assertSystemShutdownFail("08004", "", "APP", "POO");
        this.assertSystemShutdownOK("", "system", "admin");
        Connection conn1 = this.openDefaultConnection("dan", "dansuf2ix");
        this.setDatabaseProperty("gemfirexd.authz-default-connection-mode", "fullAccess", conn1);
        this.setDatabaseProperty("gemfirexd.authentication.required", "false", conn1);
        AuthenticationTest.setSystemProperty("gemfirexd.authentication.required", "false");
        conn1.commit();
        conn1.close();
        this.openDefaultConnection("system", "admin").close();
        this.assertShutdownUsingSetShutdownOK(dbName, "APP", "APPsuf2ix");
        this.assertSystemShutdownOK("", "system", "admin");
        this.openDefaultConnection("system", "admin").close();
    }

    protected void assertFailSetDatabaseProperty(String propertyName, String value, Connection conn) throws SQLException {
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY(?, ?)");
        setDBP.setString(1, propertyName);
        setDBP.setString(2, value);
        AuthenticationTest.assertStatementError("4250C", setDBP);
        setDBP.close();
    }

    protected void setDatabaseProperty(String propertyName, String value, Connection conn) throws SQLException {
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SET_DATABASE_PROPERTY(?, ?)");
        setDBP.setString(1, propertyName);
        setDBP.setString(2, value);
        setDBP.execute();
        setDBP.close();
    }

    protected void useUserValue(int expectedUpdateCount, String user, String sql) throws SQLException {
        Connection conn1 = this.openDefaultConnection(user, user + PASSWORD_SUFFIX);
        Statement stmt = conn1.createStatement();
        AuthenticationTest.assertUpdateCount(stmt, expectedUpdateCount, sql);
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    protected void assertUserValue(String[] expected, String user, String password, String sql) throws SQLException {
        Connection conn1 = this.openDefaultConnection(user, password);
        Statement stmt = conn1.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int i = 0;
        while (rs.next()) {
            AuthenticationTest.assertEquals((String)expected[i], (String)rs.getString(1));
            ++i;
        }
        AuthenticationTest.assertEquals((int)expected.length, (int)i);
        conn1.commit();
        stmt.close();
        conn1.close();
    }

    protected void assertUserValue(String[] expected, String user, String sql) throws SQLException {
        this.assertUserValue(expected, user, user + PASSWORD_SUFFIX, sql);
    }

    protected void assertConnectionOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        Connection conn = ds.getConnection(user, password);
        AuthenticationTest.assertNotNull((Object)conn);
        conn.close();
    }

    protected void assertConnectionWOUPOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        Connection conn = ds.getConnection();
        AuthenticationTest.assertNotNull((Object)conn);
        conn.close();
    }

    protected void assertConnectionFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    protected void assertConnectionWOUPFail(String expectedError, String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            AuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState(expectedError, e);
        }
    }

    protected void assertShutdownUsingSetShutdownOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("08006", e);
        }
    }

    protected void assertShutdownUsingConnAttrsOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "shutdown=true");
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("08006", e);
        }
    }

    protected void assertShutdownWOUPOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("08006", e);
        }
    }

    protected void assertShutdownFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    protected void assertShutdownOK(String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("08006", e);
        }
    }

    protected void assertShutdownWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    protected void assertSystemShutdownOK(String dbName, String user, String password) throws SQLException {
        DataSource ds;
        if (AuthenticationTest.usingEmbedded()) {
            ds = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
        } else {
            ds = JDBCDataSource.getDataSource(dbName);
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(user, password);
            AuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("XJ015", e);
        }
    }

    protected void assertSystemShutdownFail(String expectedError, String dbName, String user, String password) throws SQLException {
        DataSource ds;
        if (AuthenticationTest.usingEmbedded()) {
            ds = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
        } else {
            ds = JDBCDataSource.getDataSource(dbName);
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(ds, "user", user);
        JDBCDataSource.setBeanProperty(ds, "password", password);
        try {
            ds.getConnection();
            AuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState(expectedError, e);
        }
    }

    public void assertConnectionFail(String dbName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        if (AuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(ds, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(ds, "user");
        }
        JDBCDataSource.clearStringBeanProperty(ds, "password");
        try {
            ds.getConnection();
            AuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException e) {
            AuthenticationTest.assertSQLState("08004", e);
        }
    }
}

