/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VerifySignatures
extends BaseTestCase {
    private static final Class[] JDBC_INTERFACES = new Class[]{Array.class, Blob.class, CallableStatement.class, Clob.class, Connection.class, DatabaseMetaData.class, Driver.class, NClob.class, ParameterMetaData.class, PreparedStatement.class, Ref.class, ResultSet.class, ResultSetMetaData.class, RowId.class, Savepoint.class, SQLData.class, SQLInput.class, SQLOutput.class, SQLXML.class, Statement.class, Struct.class, Wrapper.class, CommonDataSource.class, ConnectionEventListener.class, ConnectionPoolDataSource.class, DataSource.class, PooledConnection.class, RowSet.class, RowSetInternal.class, RowSetListener.class, RowSetMetaData.class, RowSetReader.class, RowSetWriter.class, StatementEventListener.class, XAConnection.class, XADataSource.class};

    public VerifySignatures(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(VerifySignatures.class);
    }

    public void testAllJDBCObjects() throws NoSuchMethodException, SQLException {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        VerifySignatures.collectClassesFromDataSource(classes);
        VerifySignatures.collectClassesFromConnectionPoolDataSource(classes);
        VerifySignatures.collectClassesFromXADataSource(classes);
        VerifySignatures.addClass(classes, DriverManager.getDriver(TestConfiguration.getCurrent().getJDBCUrl()).getClass(), Driver.class);
        HashSet<Class> interfaces = new HashSet<Class>();
        for (ClassInfo pair : classes) {
            HashSet<Method> methods = new HashSet<Method>();
            for (Class iface : VerifySignatures.getAllInterfaces(pair.jdbcInterface)) {
                interfaces.add(iface);
                for (Method method : iface.getMethods()) {
                    methods.add(method);
                }
            }
            for (Method method : methods) {
                VerifySignatures.checkImplementationMethod(pair.derbyImplementation, method);
            }
        }
        Set<Class> jdbcInterfaces = VerifySignatures.getInterfacesToCheck();
        jdbcInterfaces.removeAll(interfaces);
        VerifySignatures.assertTrue((String)("Unchecked interfaces: " + jdbcInterfaces), (boolean)jdbcInterfaces.isEmpty());
    }

    private static void collectClassesFromDataSource(Set<ClassInfo> classes) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "create=true");
        VerifySignatures.addClass(classes, ds.getClass(), DataSource.class);
        VerifySignatures.collectClassesFromConnection(ds.getConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword()), classes);
    }

    private static void collectClassesFromConnectionPoolDataSource(Set<ClassInfo> classes) throws SQLException {
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        VerifySignatures.addClass(classes, cpds.getClass(), ConnectionPoolDataSource.class);
        PooledConnection pc = cpds.getPooledConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword());
        VerifySignatures.addClass(classes, pc.getClass(), PooledConnection.class);
        VerifySignatures.collectClassesFromConnection(pc.getConnection(), classes);
        pc.close();
    }

    private static void collectClassesFromXADataSource(Set<ClassInfo> classes) throws SQLException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        VerifySignatures.addClass(classes, xads.getClass(), XADataSource.class);
        XAConnection xaconn = xads.getXAConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword());
        VerifySignatures.addClass(classes, xaconn.getClass(), XAConnection.class);
        VerifySignatures.collectClassesFromConnection(xaconn.getConnection(), classes);
    }

    private static void collectClassesFromConnection(Connection conn, Set<ClassInfo> classes) throws SQLException {
        conn.setAutoCommit(false);
        VerifySignatures.addClass(classes, conn.getClass(), Connection.class);
        Savepoint sp = conn.setSavepoint();
        VerifySignatures.addClass(classes, sp.getClass(), Savepoint.class);
        conn.releaseSavepoint(sp);
        DatabaseMetaData dmd = conn.getMetaData();
        VerifySignatures.addClass(classes, dmd.getClass(), DatabaseMetaData.class);
        VerifySignatures.collectClassesFromStatement(conn, classes);
        VerifySignatures.collectClassesFromPreparedStatement(conn, classes);
        VerifySignatures.collectClassesFromCallableStatement(conn, classes);
        conn.rollback();
        conn.close();
    }

    private static void collectClassesFromStatement(Connection conn, Set<ClassInfo> classes) throws SQLException {
        Statement stmt = conn.createStatement();
        VerifySignatures.addClass(classes, stmt.getClass(), Statement.class);
        stmt.execute("CREATE TABLE t (id INT PRIMARY KEY, b BLOB(10), c CLOB(10))");
        stmt.execute("INSERT INTO t (id, b, c) VALUES (1, CAST (" + TestUtil.stringToHexLiteral("101010001101") + "AS BLOB(10)), CAST ('hello' AS CLOB(10)))");
        ResultSet rs = stmt.executeQuery("SELECT id, b, c FROM t");
        VerifySignatures.addClass(classes, rs.getClass(), ResultSet.class);
        rs.next();
        Blob b = rs.getBlob(2);
        VerifySignatures.addClass(classes, b.getClass(), Blob.class);
        Clob c = rs.getClob(3);
        VerifySignatures.addClass(classes, c.getClass(), Clob.class);
        ResultSetMetaData rsmd = rs.getMetaData();
        VerifySignatures.addClass(classes, rsmd.getClass(), ResultSetMetaData.class);
        rs.close();
        stmt.close();
        conn.rollback();
    }

    private static void collectClassesFromPreparedStatement(Connection conn, Set<ClassInfo> classes) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("VALUES(1)");
        VerifySignatures.addClass(classes, ps.getClass(), PreparedStatement.class);
        ResultSet rs = ps.executeQuery();
        VerifySignatures.addClass(classes, rs.getClass(), ResultSet.class);
        rs.close();
        ParameterMetaData pmd = ps.getParameterMetaData();
        VerifySignatures.addClass(classes, pmd.getClass(), ParameterMetaData.class);
        ps.close();
    }

    private static void collectClassesFromCallableStatement(Connection conn, Set<ClassInfo> classes) throws SQLException {
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SET_RUNTIMESTATISTICS(0)");
        VerifySignatures.addClass(classes, cs.getClass(), CallableStatement.class);
        ParameterMetaData pmd = cs.getParameterMetaData();
        VerifySignatures.addClass(classes, pmd.getClass(), ParameterMetaData.class);
        cs.close();
    }

    private static void addClass(Set<ClassInfo> classes, Class implementation, Class iface) {
        classes.add(new ClassInfo(implementation, iface));
    }

    private static Set<Class> getAllInterfaces(Class iface) {
        HashSet<Class> set = new HashSet<Class>();
        set.add(iface);
        for (Class<?> superIface : iface.getInterfaces()) {
            set.add(superIface);
            set.addAll(VerifySignatures.getAllInterfaces(superIface));
        }
        return set;
    }

    private static void checkImplementationMethod(Class derbyImplementation, Method ifaceMethod) throws NoSuchMethodException {
        VerifySignatures.assertFalse((String)"Implementation class is interface", (boolean)derbyImplementation.isInterface());
        Method impMethod = derbyImplementation.getMethod(ifaceMethod.getName(), ifaceMethod.getParameterTypes());
        VerifySignatures.assertEquals((String)"Incorrect return type", ifaceMethod.getReturnType(), impMethod.getReturnType());
        int modifiers = impMethod.getModifiers();
        VerifySignatures.assertTrue((String)"Non-public method", (boolean)Modifier.isPublic(modifiers));
        VerifySignatures.assertFalse((String)"Abstract method", (boolean)Modifier.isAbstract(modifiers));
        VerifySignatures.assertFalse((String)"Static method", (boolean)Modifier.isStatic(modifiers));
        Class[] declaredExceptions = ifaceMethod.getExceptionTypes();
        for (Class<?> exception : impMethod.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exception)) continue;
            VerifySignatures.assertNotNull((String)"Incompatible throws clause", (Object)VerifySignatures.findCompatibleClass(exception, declaredExceptions));
        }
    }

    private static Class findCompatibleClass(Class exception, Class[] declared) {
        for (Class dec : declared) {
            if (!dec.isAssignableFrom(exception)) continue;
            return dec;
        }
        return null;
    }

    private static Set<Class> getInterfacesToCheck() {
        HashSet<Class> jdbcInterfaces = new HashSet<Class>(Arrays.asList(JDBC_INTERFACES));
        jdbcInterfaces.remove(Array.class);
        jdbcInterfaces.remove(NClob.class);
        jdbcInterfaces.remove(Ref.class);
        jdbcInterfaces.remove(SQLData.class);
        jdbcInterfaces.remove(SQLInput.class);
        jdbcInterfaces.remove(SQLOutput.class);
        jdbcInterfaces.remove(SQLXML.class);
        jdbcInterfaces.remove(Struct.class);
        jdbcInterfaces.remove(RowSet.class);
        jdbcInterfaces.remove(RowSetInternal.class);
        jdbcInterfaces.remove(RowSetListener.class);
        jdbcInterfaces.remove(RowSetMetaData.class);
        jdbcInterfaces.remove(RowSetReader.class);
        jdbcInterfaces.remove(RowSetWriter.class);
        jdbcInterfaces.remove(RowId.class);
        jdbcInterfaces.remove(ConnectionEventListener.class);
        jdbcInterfaces.remove(StatementEventListener.class);
        return jdbcInterfaces;
    }

    private static class ClassInfo {
        Class derbyImplementation;
        Class jdbcInterface;

        ClassInfo(Class imp, Class iface) {
            this.derbyImplementation = imp;
            this.jdbcInterface = iface;
        }

        public boolean equals(Object x) {
            if (x instanceof ClassInfo) {
                ClassInfo ci = (ClassInfo)x;
                return this.derbyImplementation.equals(ci.derbyImplementation) && this.jdbcInterface.equals(ci.jdbcInterface);
            }
            return false;
        }

        public int hashCode() {
            return this.derbyImplementation.hashCode() ^ this.jdbcInterface.hashCode();
        }
    }
}

